## Energy Turret

![](https://i.imgur.com/42CuTMf.png)

A energy turret, which uses OC Energy to fire energy beams at targets! <br>
Be careful, it can also hit you or any other player.

In order to create it you need:
* 4 _Iron Ingot_
* 4 _Microchip (Tier 2)_
* 1 _Diamond_

The Energy Turret also has upgrade slots in it's GUI you can upgrade it's [Damage](UpgradeDamage), [Movement Speed](UpgradeMovement), [Cooldown](UpgradeCooldown) time, and [Energy](UpgradeEnergy) Usage.

### Methods

```lua
turret = require("component").os_energyturret

-- Turns the turret on, it needs to be powered before you can call any other command.
turret.powerOn()

-- Turns the turret off.
turret.powerOff()

-- Returns true if the turret has cooled down from it's previous fire,
-- is armed, and the barrel is valid, otherwise false.
turret.isReady()

-- Returns true if the turret is powered on, otherwise false.
turret.isPowered()

-- Arms and disarms the turret, must be armed to fire.
turret.setArmed(boolean)

-- Valid range (0-2) extends/retracts the rotator shaft, must be at least 1 to fire.
turret.extendShaft(int)

-- Returns the shaft length.
turret.getShaftLength()

-- Moves the turret in radians instead of degrees.
turret.moveToRadians(int, int)

-- Valid ranges: (0-360), (-45,90) 
-- Moves the turret's aim to the provided coords and 
-- tries to use shortest rotation to move to them as quick as possible.
turret.moveTo(int, int)

-- Returns true if the turret has finished moving to it's target, false if not
turret.isOnTarget()

-- Returns true if fired, or false, error if it was unable to fire, not enough energy, or gun hasn't cooled down.
turret.fire()
```

### Example

```lua
--[[
  Minimal example of turret usage

  This script will command turret to shoot exactly once
  pointing towards south with cannon being positioned
  parallel to ground
]]

local component = require "component"
local turret = component.os_energyturret

-- rotation specified in degrees
local horizontalRotation = 180
local verticalRotation = 0

-- prepare turret to fire
turret.powerOn()
turret.setArmed(true)

-- rotate it horizontally and vertically
turret.moveTo(horizontalRotation, verticalRotation)

-- wait while turret is still rotating 
while turret.isOnTarget() == false do
  os.sleep(0.1)
end

-- turret is now on target, try to fire
local fired, error = turret.fire()

-- if was unable to fire, print why
if fired == false then
  print("Unable to fire: " .. error)
end

turret.powerOff()
```
