/*
 * Decompiled with CFR 0.152.
 */
package tech.feldman.betterrecords.helper.nbt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;
import tech.feldman.betterrecords.api.sound.ISoundHolder;
import tech.feldman.betterrecords.api.sound.Sound;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"AUTHOR_TAG", "", "NAME_TAG", "SIZE_TAG", "SONGS_TAG", "URL_TAG", "addSound", "", "stack", "Lnet/minecraft/item/ItemStack;", "sound", "Ltech/feldman/betterrecords/api/sound/Sound;", "getSounds", "", "isFullOfSounds", "", "BetterRecords"})
public final class SoundHolderHelperKt {
    private static final String SONGS_TAG = "songs";
    private static final String NAME_TAG = "name";
    private static final String URL_TAG = "url";
    private static final String SIZE_TAG = "size";
    private static final String AUTHOR_TAG = "author";

    public static final boolean isFullOfSounds(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!(stack.func_77973_b() instanceof ISoundHolder)) {
            return false;
        }
        if (stack.func_77942_o()) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"stack.tagCompound!!");
            NBTTagCompound tagCompound = nBTTagCompound;
            if (tagCompound.func_74764_b(SONGS_TAG)) {
                NBTTagList tagList = tagCompound.func_150295_c(SONGS_TAG, 10);
                Item item = stack.func_77973_b();
                if (item == null) {
                    throw new TypeCastException("null cannot be cast to non-null type tech.feldman.betterrecords.api.sound.ISoundHolder");
                }
                if (tagList.func_74745_c() >= ((ISoundHolder)item).getMaxSounds()) {
                    return true;
                }
            }
        }
        return false;
    }

    public static final void addSound(@NotNull ItemStack stack, @NotNull Sound sound) {
        NBTTagCompound nBTTagCompound;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)sound, (String)"sound");
        if (!(stack.func_77973_b() instanceof ISoundHolder)) {
            return;
        }
        if (stack.func_77942_o()) {
            nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"if (stack.hasTagCompound\u2026   NBTTagCompound()\n    }");
        NBTTagCompound tagCompound = nBTTagCompound;
        NBTTagList songList = tagCompound.func_74764_b(SONGS_TAG) ? tagCompound.func_150295_c(SONGS_TAG, 10) : new NBTTagList();
        NBTTagCompound newSongTag = new NBTTagCompound();
        newSongTag.func_74778_a(NAME_TAG, sound.getName());
        newSongTag.func_74778_a(URL_TAG, sound.getUrl());
        newSongTag.func_74768_a(SIZE_TAG, sound.getSize());
        newSongTag.func_74778_a(AUTHOR_TAG, sound.getAuthor());
        songList.func_74742_a((NBTBase)newSongTag);
        tagCompound.func_74782_a(SONGS_TAG, (NBTBase)songList);
        stack.func_77982_d(tagCompound);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Sound> getSounds(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!(stack.func_77973_b() instanceof ISoundHolder)) {
            return CollectionsKt.emptyList();
        }
        if (stack.func_77942_o()) {
            NBTTagCompound nBTTagCompound = stack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"stack.tagCompound!!");
            NBTTagCompound tagCompound = nBTTagCompound;
            if (tagCompound.func_74764_b(SONGS_TAG)) {
                void $receiver$iv$iv;
                Object object;
                Collection collection;
                void $receiver$iv$iv2;
                Iterable $receiver$iv;
                NBTTagList tagList = tagCompound.func_150295_c(SONGS_TAG, 10);
                Iterable iterable = (Iterable)RangesKt.until((int)0, (int)tagList.func_74745_c());
                Object object2 = tagList;
                void var5_5 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                Iterator iterator = $receiver$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    void p1;
                    int item$iv$iv2;
                    int n = item$iv$iv2 = ((IntIterator)iterator).nextInt();
                    collection = destination$iv$iv;
                    object = object2.func_150305_b((int)p1);
                    collection.add(object);
                }
                $receiver$iv = (List)destination$iv$iv;
                object2 = $receiver$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    String string;
                    String string2;
                    String string3;
                    void it;
                    NBTTagCompound item$iv$iv2 = (NBTTagCompound)item$iv$iv;
                    collection = destination$iv$iv2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)it.func_74779_i(NAME_TAG), (String)"it.getString(NAME_TAG)");
                    Intrinsics.checkExpressionValueIsNotNull((Object)it.func_74779_i(URL_TAG), (String)"it.getString(URL_TAG)");
                    int n = it.func_74762_e(SIZE_TAG);
                    Intrinsics.checkExpressionValueIsNotNull((Object)it.func_74779_i(AUTHOR_TAG), (String)"it.getString(AUTHOR_TAG)");
                    int n2 = n;
                    object = new Sound(string3, string2, n2, string);
                    collection.add(object);
                }
                return (List)destination$iv$iv2;
            }
        }
        return CollectionsKt.emptyList();
    }
}

