/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockScreen;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.item.WDItem;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Multiblock;
import net.montoyo.wd.utilities.Util;
import net.montoyo.wd.utilities.Vector3i;

public class ItemOwnershipThief
extends Item
implements WDItem {
    public ItemOwnershipThief() {
        this.func_77655_b("webdisplays.ownerthief");
        this.setRegistryName("ownerthief");
        this.func_77625_d(1);
        this.func_77637_a(WebDisplays.CREATIVE_TAB);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos_, EnumHand hand, EnumFacing side_, float hitX, float hitY, float hitZ) {
        NBTTagCompound tag;
        if (player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (WebDisplays.INSTANCE.disableOwnershipThief) {
            Util.toast(player, "otDisabled", new Object[0]);
            return EnumActionResult.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("PosX") && tag.func_74764_b("PosY") && tag.func_74764_b("PosZ") && tag.func_74764_b("Side")) {
            BlockPos bp = new BlockPos(tag.func_74762_e("PosX"), tag.func_74762_e("PosY"), tag.func_74762_e("PosZ"));
            BlockSide side = BlockSide.values()[tag.func_74771_c("Side")];
            if (!(world.func_180495_p(bp).func_177230_c() instanceof BlockScreen)) {
                return EnumActionResult.SUCCESS;
            }
            TileEntity te = world.func_175625_s(bp);
            if (te == null || !(te instanceof TileEntityScreen)) {
                return EnumActionResult.SUCCESS;
            }
            TileEntityScreen tes = (TileEntityScreen)te;
            TileEntityScreen.Screen scr = tes.getScreen(side);
            if (scr == null) {
                return EnumActionResult.SUCCESS;
            }
            Log.warning("Owner of screen at %d %d %d, side %s was changed from %s (UUID %s) to %s (UUID %s)", bp.func_177958_n(), bp.func_177956_o(), bp.func_177952_p(), side.toString(), scr.owner.name, scr.owner.uuid.toString(), player.func_70005_c_(), player.func_146103_bH().getId().toString());
            player.func_184611_a(hand, ItemStack.field_190927_a);
            tes.setOwner(side, player);
            Util.toast(player, TextFormatting.AQUA, "newOwner", new Object[0]);
            return EnumActionResult.SUCCESS;
        }
        if (!(world.func_180495_p(pos_).func_177230_c() instanceof BlockScreen)) {
            return EnumActionResult.SUCCESS;
        }
        Vector3i pos = new Vector3i(pos_);
        BlockSide side = BlockSide.values()[side_.ordinal()];
        Multiblock.findOrigin((IBlockAccess)world, pos, side, null);
        TileEntity te = world.func_175625_s(pos.toBlock());
        if (te == null || !(te instanceof TileEntityScreen)) {
            Util.toast(player, "turnOn", new Object[0]);
            return EnumActionResult.SUCCESS;
        }
        if (((TileEntityScreen)te).getScreen(side) == null) {
            Util.toast(player, "turnOn", new Object[0]);
        } else {
            NBTTagCompound tag2 = new NBTTagCompound();
            tag2.func_74768_a("PosX", pos.x);
            tag2.func_74768_a("PosY", pos.y);
            tag2.func_74768_a("PosZ", pos.z);
            tag2.func_74774_a("Side", (byte)side.ordinal());
            stack.func_77982_d(tag2);
            Util.toast(player, TextFormatting.AQUA, "screenSet", new Object[0]);
            Log.warning("Player %s (UUID %s) created an Ownership Thief item for screen at %d %d %d, side %s!", player.func_70005_c_(), player.func_146103_bH().getId().toString(), pos.x, pos.y, pos.z, side.toString());
        }
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tt, ITooltipFlag ttFlags) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("PosX") && tag.func_74764_b("PosY") && tag.func_74764_b("PosZ") && tag.func_74764_b("Side")) {
            tt.add("Screen pos: " + tag.func_74762_e("PosX") + ", " + tag.func_74762_e("PosY") + ", " + tag.func_74762_e("PosZ"));
            tt.add("Screen side: " + BlockSide.values()[tag.func_74771_c("Side")].toString());
            WDItem.addInformation(tt);
            return;
        }
        tt.add("" + TextFormatting.RED + "WARNING: Admin tool");
        tt.add("Right click on screen");
        tt.add("and give to new owner.");
        WDItem.addInformation(tt);
    }

    @Override
    @Nullable
    public String getWikiName(@Nonnull ItemStack is) {
        return "Ownership_Thief";
    }
}

