/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.renderers;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.montoyo.wd.block.BlockScreen;
import net.montoyo.wd.client.renderers.IModelBaker;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Vector3f;
import net.montoyo.wd.utilities.Vector3i;

public class ScreenBaker
implements IModelBaker {
    private static final List<BakedQuad> noQuads = ImmutableList.of();
    private final TextureAtlasSprite[] texs = new TextureAtlasSprite[16];
    private final BlockSide[] blockSides = BlockSide.values();
    private final EnumFacing[] blockFacings = EnumFacing.values();

    @Override
    public void loadTextures(TextureMap texMap) {
        for (int i = 0; i < this.texs.length; ++i) {
            this.texs[i] = texMap.func_174942_a(new ResourceLocation("webdisplays", "blocks/screen" + i));
        }
    }

    private void putVertex(int[] buf, int pos, Vector3f vpos, TextureAtlasSprite tex, Vector3f uv, Vector3i normal) {
        buf[pos * 7 + 0] = Float.floatToRawIntBits(vpos.x);
        buf[pos * 7 + 1] = Float.floatToRawIntBits(vpos.y);
        buf[pos * 7 + 2] = Float.floatToRawIntBits(vpos.z);
        buf[pos * 7 + 3] = -1;
        buf[pos * 7 + 4] = Float.floatToRawIntBits(tex.func_94214_a((double)uv.x));
        buf[pos * 7 + 5] = Float.floatToRawIntBits(tex.func_94207_b((double)uv.y));
        int nx = normal.x * 127 & 0xFF;
        int ny = normal.y * 127 & 0xFF;
        int nz = normal.z * 127 & 0xFF;
        buf[pos * 7 + 6] = nx | ny << 8 | nz << 16;
    }

    private Vector3f rotateVec(Vector3f vec, BlockSide side) {
        switch (side) {
            case BOTTOM: {
                return new Vector3f(vec.x, 1.0f, 1.0f - vec.z);
            }
            case TOP: {
                return new Vector3f(vec.x, 0.0f, vec.z);
            }
            case NORTH: {
                return new Vector3f(vec.x, vec.z, 1.0f);
            }
            case SOUTH: {
                return new Vector3f(vec.x, 1.0f - vec.z, 0.0f);
            }
            case WEST: {
                return new Vector3f(1.0f, vec.x, vec.z);
            }
            case EAST: {
                return new Vector3f(0.0f, 1.0f - vec.x, vec.z);
            }
        }
        throw new RuntimeException("Unknown block side " + (Object)((Object)side));
    }

    private Vector3f rotateTex(BlockSide side, float u, float v) {
        switch (side) {
            case BOTTOM: {
                return new Vector3f(u, 16.0f - v, 0.0f);
            }
            case TOP: {
                return new Vector3f(u, v, 0.0f);
            }
            case NORTH: {
                return new Vector3f(16.0f - u, 16.0f - v, 0.0f);
            }
            case SOUTH: {
                return new Vector3f(u, v, 0.0f);
            }
            case WEST: {
                return new Vector3f(v, 16.0f - u, 0.0f);
            }
            case EAST: {
                return new Vector3f(16.0f - v, u, 0.0f);
            }
        }
        throw new RuntimeException("Unknown block side " + (Object)((Object)side));
    }

    private BakedQuad bakeSide(BlockSide side, TextureAtlasSprite tex) {
        int[] data = new int[28];
        this.putVertex(data, 3, this.rotateVec(new Vector3f(0.0f, 0.0f, 0.0f), side), tex, this.rotateTex(side, 0.0f, 0.0f), side.backward);
        this.putVertex(data, 2, this.rotateVec(new Vector3f(0.0f, 0.0f, 1.0f), side), tex, this.rotateTex(side, 0.0f, 16.0f), side.backward);
        this.putVertex(data, 1, this.rotateVec(new Vector3f(1.0f, 0.0f, 1.0f), side), tex, this.rotateTex(side, 16.0f, 16.0f), side.backward);
        this.putVertex(data, 0, this.rotateVec(new Vector3f(1.0f, 0.0f, 0.0f), side), tex, this.rotateTex(side, 16.0f, 0.0f), side.backward);
        return new BakedQuad(data, -1, this.blockFacings[side.ordinal()], tex, true, DefaultVertexFormats.field_176599_b);
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == null) {
            return noQuads;
        }
        IExtendedBlockState bs = (IExtendedBlockState)state;
        ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
        int sid = BlockSide.reverse(side.ordinal());
        BlockSide s = this.blockSides[sid];
        TextureAtlasSprite tex = this.texs[15];
        if (bs != null) {
            tex = this.texs[(Integer)bs.getValue(BlockScreen.sideFlags[sid])];
        }
        ret.add(this.bakeSide(s, tex));
        return ret;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.texs[15];
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

