/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.loading;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.montoyo.wd.client.gui.loading.JsonAWrapper;

public class JsonOWrapper {
    private static final HashMap<String, Integer> defaultColors = new HashMap();
    private final JsonObject object;
    private final Map<String, Double> variables;
    private static final String OPS = "+*/%&|";
    private static final String[] OPS_PRIORITY;

    public JsonOWrapper(JsonObject obj, Map<String, Double> vars) {
        this.object = obj;
        this.variables = vars;
    }

    public String getString(String key, String def) {
        return this.object.has(key) ? this.object.get(key).getAsString() : def;
    }

    public long getLong(String key, long def) {
        return this.object.has(key) ? this.object.get(key).getAsLong() : def;
    }

    public int getInt(String key, int def) {
        if (!this.object.has(key)) {
            return def;
        }
        JsonPrimitive prim = this.object.get(key).getAsJsonPrimitive();
        if (prim.isNumber()) {
            return prim.getAsInt();
        }
        return (int)JsonOWrapper.evalExpr(prim.getAsString(), this.variables);
    }

    public float getFloat(String key, float def) {
        if (!this.object.has(key)) {
            return def;
        }
        JsonPrimitive prim = this.object.get(key).getAsJsonPrimitive();
        if (prim.isNumber()) {
            return prim.getAsFloat();
        }
        return (float)JsonOWrapper.evalExpr(prim.getAsString(), this.variables);
    }

    public double getDouble(String key, double def) {
        if (!this.object.has(key)) {
            return def;
        }
        JsonPrimitive prim = this.object.get(key).getAsJsonPrimitive();
        if (prim.isNumber()) {
            return prim.getAsDouble();
        }
        return JsonOWrapper.evalExpr(prim.getAsString(), this.variables);
    }

    public boolean getBool(String key, boolean def) {
        if (!this.object.has(key)) {
            return def;
        }
        JsonPrimitive prim = this.object.get(key).getAsJsonPrimitive();
        if (prim.isBoolean()) {
            return prim.getAsBoolean();
        }
        if (prim.isNumber()) {
            return prim.getAsInt() != 0;
        }
        return JsonOWrapper.evalExpr(prim.getAsString(), this.variables) != 0.0;
    }

    public JsonOWrapper getObject(String key) {
        return new JsonOWrapper(this.object.has(key) ? this.object.get(key).getAsJsonObject() : new JsonObject(), this.variables);
    }

    public JsonAWrapper getArray(String key) {
        return new JsonAWrapper(this.object.has(key) ? this.object.get(key).getAsJsonArray() : new JsonArray(), this.variables);
    }

    public JsonObject getObject() {
        return this.object;
    }

    public int getColor(String key, int def) {
        int a;
        int b;
        int g;
        int r;
        if (!this.object.has(key)) {
            return def;
        }
        JsonElement c = this.object.get(key);
        if (c.isJsonPrimitive()) {
            JsonPrimitive prim = c.getAsJsonPrimitive();
            if (prim.isNumber()) {
                return (int)prim.getAsLong();
            }
            if (prim.isString()) {
                String str = prim.getAsString();
                Integer dc = defaultColors.get(str.toLowerCase());
                if (dc != null) {
                    return dc;
                }
                if (!str.isEmpty() && str.charAt(0) == '#') {
                    str = str.substring(1);
                }
                long ret = Long.parseLong(str, 16);
                if (str.length() <= 6) {
                    ret |= 0xFF000000L;
                }
                return (int)ret;
            }
            return def;
        }
        if (c.isJsonArray()) {
            JsonArray array = c.getAsJsonArray();
            r = array.get(0).getAsInt();
            g = array.get(1).getAsInt();
            b = array.get(2).getAsInt();
            a = array.size() >= 4 ? array.get(3).getAsInt() : 255;
        } else if (c.isJsonObject()) {
            JsonObject obj = c.getAsJsonObject();
            r = obj.get("r").getAsInt();
            g = obj.get("g").getAsInt();
            b = obj.get("b").getAsInt();
            a = obj.has("a") ? obj.get("a").getAsInt() : 255;
        } else {
            return def;
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int findPair(List<VarOpPair> list, String ops) {
        for (int i = 0; i < list.size(); ++i) {
            if (ops.indexOf(list.get((int)i).op) < 0) continue;
            return i;
        }
        return -1;
    }

    private static double evalExpr(String expr, Map<String, Double> variables) {
        int pos;
        while ((pos = expr.indexOf(40)) >= 0) {
            int end;
            int lvl = 0;
            for (end = ++pos; end < expr.length(); ++end) {
                char chr = expr.charAt(end);
                if (chr == '(') {
                    ++lvl;
                    continue;
                }
                if (chr != ')') continue;
                if (lvl == 0) break;
                --lvl;
            }
            if (end >= expr.length()) {
                throw new RuntimeException("Unclosed parenthesis in expression \"" + expr + "\"");
            }
            double val = JsonOWrapper.evalExpr(expr.substring(pos, end), variables);
            expr = expr.substring(0, pos - 1) + val + expr.substring(end + 1);
        }
        ArrayList<VarOpPair> ops = new ArrayList<VarOpPair>();
        StringBuilder str = new StringBuilder();
        boolean negIsPartOfStr = true;
        boolean strIsNumber = true;
        for (int i = 0; i < expr.length(); ++i) {
            char chr = expr.charAt(i);
            if (Character.isSpaceChar(chr)) continue;
            if (chr == '-' && !negIsPartOfStr || OPS.indexOf(chr) >= 0) {
                VarOpPair pair = new VarOpPair();
                pair.setVar(str.toString(), strIsNumber, expr, variables);
                pair.setOp(chr);
                ops.add(pair);
                str.setLength(0);
                negIsPartOfStr = true;
                strIsNumber = true;
                continue;
            }
            if (strIsNumber && chr != '-' && chr != '.' && !Character.isDigit(chr)) {
                strIsNumber = false;
            }
            if (negIsPartOfStr) {
                negIsPartOfStr = false;
            }
            str.append(chr);
        }
        if (str.length() > 0) {
            VarOpPair pair = new VarOpPair();
            pair.setVar(str.toString(), strIsNumber, expr, variables);
            pair.setOp('\u0000');
            ops.add(pair);
        }
        while (true) {
            String opList;
            int pairId = -1;
            String[] chr = OPS_PRIORITY;
            int pair = chr.length;
            for (int i = 0; i < pair && (pairId = JsonOWrapper.findPair(ops, opList = chr[i])) < 0; ++i) {
            }
            if (pairId < 0) break;
            VarOpPair a = (VarOpPair)ops.get(pairId);
            VarOpPair b = ops.get(pairId + 1);
            if (a.op == '*') {
                b.var = a.var * b.var;
            } else if (a.op == '/') {
                b.var = a.var / b.var;
            } else if (a.op == '%') {
                b.var = a.var % b.var;
            } else if (a.op == '+') {
                b.var = a.var + b.var;
            } else if (a.op == '-') {
                b.var = a.var - b.var;
            } else if (a.op == '&') {
                if (a.var == 0.0) {
                    b.var = 0.0;
                }
            } else if (a.op == '|' && a.var != 0.0) {
                b.var = a.var;
            }
            ops.remove(pairId);
        }
        if (ops.size() != 1 || ops.get((int)0).op != '\u0000') {
            throw new RuntimeException("Error while parsing evaluating \"" + expr + "\"");
        }
        return ops.get((int)0).var;
    }

    static {
        defaultColors.put("black", -16777216);
        defaultColors.put("white", -1);
        defaultColors.put("red", -65536);
        defaultColors.put("green", -16711936);
        defaultColors.put("blue", -16776961);
        defaultColors.put("magenta", -65281);
        defaultColors.put("cyan", -16711681);
        defaultColors.put("yellow", -256);
        OPS_PRIORITY = new String[]{"*/%", "+-", "&|"};
    }

    private static class VarOpPair {
        double var;
        char op;

        private VarOpPair() {
        }

        void setVar(String str, boolean isNumber, String expr, Map<String, Double> variables) {
            if (isNumber) {
                this.var = Double.parseDouble(str);
            } else {
                boolean neg = str.charAt(0) == '-';
                String varName = neg ? str.substring(1) : str;
                Double d = variables.get(varName);
                if (d == null) {
                    throw new RuntimeException("Unknown variable \"" + varName + "\" in expression \"" + expr + "\"");
                }
                this.var = neg ? -d.doubleValue() : d;
            }
        }

        void setOp(char op) {
            this.op = op;
        }
    }
}

