/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.client.gui.GuiSubscribe;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.client.gui.controls.Button;
import net.montoyo.wd.client.gui.controls.TextField;
import net.montoyo.wd.client.gui.loading.FillControl;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.net.server.SMessagePadCtrl;
import net.montoyo.wd.net.server.SMessageScreenCtrl;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Util;
import net.montoyo.wd.utilities.Vector3i;

public class GuiSetURL2
extends WDScreen {
    private TileEntityScreen tileEntity;
    private BlockSide screenSide;
    private Vector3i remoteLocation;
    private final boolean isPad;
    private final String screenURL;
    @FillControl
    private TextField tfURL;
    @FillControl
    private Button btnShutDown;
    @FillControl
    private Button btnCancel;
    @FillControl
    private Button btnOk;

    public GuiSetURL2(TileEntityScreen tes, BlockSide side, String url, Vector3i rl) {
        this.tileEntity = tes;
        this.screenSide = side;
        this.remoteLocation = rl;
        this.isPad = false;
        this.screenURL = url;
    }

    public GuiSetURL2(String url) {
        this.isPad = true;
        this.screenURL = url;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.loadFrom(new ResourceLocation("webdisplays", "gui/seturl.json"));
        this.tfURL.setText(this.screenURL);
    }

    @Override
    protected void addLoadCustomVariables(Map<String, Double> vars) {
        vars.put("isPad", this.isPad ? 1.0 : 0.0);
    }

    @GuiSubscribe
    public void onButtonClicked(Button.ClickEvent ev) {
        if (ev.getSource() == this.btnCancel) {
            this.field_146297_k.func_147108_a(null);
        } else if (ev.getSource() == this.btnOk) {
            this.validate(this.tfURL.getText());
        } else if (ev.getSource() == this.btnShutDown) {
            if (this.isPad) {
                WebDisplays.NET_HANDLER.sendToServer((IMessage)new SMessagePadCtrl(""));
            }
            this.field_146297_k.func_147108_a(null);
        }
    }

    @GuiSubscribe
    public void onEnterPressed(TextField.EnterPressedEvent ev) {
        this.validate(ev.getText());
    }

    private void validate(String url) {
        if (!url.isEmpty()) {
            url = Util.addProtocol(url);
            url = ((ClientProxy)WebDisplays.PROXY).getMCEF().punycode(url);
            if (this.isPad) {
                ClientProxy.PadData pd;
                WebDisplays.NET_HANDLER.sendToServer((IMessage)new SMessagePadCtrl(url));
                ItemStack held = this.field_146297_k.field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
                if (held.func_77973_b() == WebDisplays.INSTANCE.itemMinePad && held.func_77978_p() != null && held.func_77978_p().func_74764_b("PadID") && (pd = ((ClientProxy)WebDisplays.PROXY).getPadByID(held.func_77978_p().func_74762_e("PadID"))) != null && pd.view != null) {
                    pd.view.loadURL(WebDisplays.applyBlacklist(url));
                }
            } else {
                WebDisplays.NET_HANDLER.sendToServer((IMessage)SMessageScreenCtrl.setURL(this.tileEntity, this.screenSide, url, this.remoteLocation));
            }
        }
        this.field_146297_k.func_147108_a(null);
    }

    @Override
    public boolean isForBlock(BlockPos bp, BlockSide side) {
        return this.remoteLocation != null && this.remoteLocation.equalsBlockPos(bp) || bp.equals((Object)this.tileEntity.func_174877_v()) && side == this.screenSide;
    }
}

