/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.gui.GuiSubscribe;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.client.gui.controls.Button;
import net.montoyo.wd.client.gui.controls.Control;
import net.montoyo.wd.client.gui.controls.Label;
import net.montoyo.wd.client.gui.loading.FillControl;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.net.server.SMessageScreenCtrl;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.TypeData;
import net.montoyo.wd.utilities.Util;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiKeyboard
extends WDScreen {
    private static final String WARNING_FNAME = "wd_keyboard_warning.txt";
    private TileEntityScreen tes;
    private BlockSide side;
    private final ArrayList<TypeData> evStack = new ArrayList();
    private BlockPos kbPos;
    private boolean showWarning = true;
    @FillControl
    private Label lblInfo;
    @FillControl
    private Button btnOk;

    public GuiKeyboard() {
    }

    public GuiKeyboard(TileEntityScreen tes, BlockSide side, BlockPos kbPos) {
        this.tes = tes;
        this.side = side;
        this.kbPos = kbPos;
    }

    @Override
    protected void addLoadCustomVariables(Map<String, Double> vars) {
        vars.put("showWarning", this.showWarning ? 1.0 : 0.0);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.showWarning = this.field_146297_k.func_71387_A() && this.field_146297_k.func_71401_C() != null && !this.field_146297_k.func_71401_C().func_71344_c() ? false : !this.hasUserReadWarning();
        this.loadFrom(new ResourceLocation("webdisplays", "gui/keyboard.json"));
        if (this.showWarning) {
            int maxLabelW = 0;
            int totalH = 0;
            for (Control ctrl : this.controls) {
                if (ctrl == this.lblInfo || !(ctrl instanceof Label)) continue;
                if (ctrl.getWidth() > maxLabelW) {
                    maxLabelW = ctrl.getWidth();
                }
                totalH += ctrl.getHeight();
                ctrl.setPos((this.field_146294_l - ctrl.getWidth()) / 2, 0);
            }
            this.btnOk.setWidth(maxLabelW);
            this.btnOk.setPos((this.field_146294_l - maxLabelW) / 2, 0);
            int y = (this.field_146295_m - (totalH += this.btnOk.getHeight())) / 2;
            for (Control ctrl : this.controls) {
                if (ctrl == this.lblInfo) continue;
                ctrl.setPos(ctrl.getX(), y);
                y += ctrl.getHeight();
            }
        } else {
            this.field_146297_k.field_71415_G = true;
            this.field_146297_k.field_71417_B.func_74372_a();
        }
        this.defaultBackground = this.showWarning;
        this.syncTicks = 5;
    }

    public void func_146269_k() {
        if (this.showWarning) {
            try {
                super.func_146269_k();
            }
            catch (IOException ex) {
                Log.warningEx("Caught exception while handling screen input", ex, new Object[0]);
            }
            return;
        }
        if (Keyboard.isCreated()) {
            while (Keyboard.next()) {
                if (Keyboard.getEventKey() == 1) {
                    this.field_146297_k.func_147108_a(null);
                    continue;
                }
                char chr = Keyboard.getEventCharacter();
                if (Keyboard.getEventKeyState()) {
                    int kc = Keyboard.getEventKey();
                    this.evStack.add(new TypeData(TypeData.Action.PRESS, kc, chr));
                    this.evStack.add(new TypeData(TypeData.Action.RELEASE, kc, chr));
                }
                if (chr == '\u0000') continue;
                this.evStack.add(new TypeData(TypeData.Action.TYPE, 0, chr));
            }
            if (!this.evStack.isEmpty() && !this.syncRequested()) {
                this.requestSync();
            }
        }
    }

    @Override
    protected void sync() {
        if (!this.evStack.isEmpty()) {
            WebDisplays.NET_HANDLER.sendToServer((IMessage)SMessageScreenCtrl.type(this.tes, this.side, WebDisplays.GSON.toJson(this.evStack), this.kbPos));
            this.evStack.clear();
        }
    }

    @GuiSubscribe
    public void onClick(Button.ClickEvent ev) {
        if (this.showWarning && ev.getSource() == this.btnOk) {
            this.writeUserAcknowledge();
            for (Control ctrl : this.controls) {
                Label lbl;
                if (!(ctrl instanceof Label)) continue;
                lbl.setVisible(!(lbl = (Label)ctrl).isVisible());
            }
            this.btnOk.setDisabled(true);
            this.btnOk.setVisible(false);
            this.showWarning = false;
            this.defaultBackground = false;
            this.field_146297_k.field_71415_G = true;
            this.field_146297_k.field_71417_B.func_74372_a();
        }
    }

    private boolean hasUserReadWarning() {
        try {
            File f = new File(this.field_146297_k.field_71412_D, WARNING_FNAME);
            if (f.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(f));
                String str = br.readLine();
                Util.silentClose(br);
                return str != null && str.trim().equalsIgnoreCase("read");
            }
        }
        catch (Throwable t) {
            Log.warningEx("Can't know if user has already read the warning", t, new Object[0]);
        }
        return false;
    }

    private void writeUserAcknowledge() {
        try {
            File f = new File(this.field_146297_k.field_71412_D, WARNING_FNAME);
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            bw.write("read\n");
            Util.silentClose(bw);
        }
        catch (Throwable t) {
            Log.warningEx("Can't write that the user read the warning", t, new Object[0]);
        }
    }

    @Override
    public boolean isForBlock(BlockPos bp, BlockSide side) {
        return bp.equals((Object)this.kbPos) || bp.equals((Object)this.tes.func_174877_v()) && side == this.side;
    }
}

