/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.UUID;
import net.montoyo.mcef.api.IScheme;
import net.montoyo.mcef.api.ISchemeResponseData;
import net.montoyo.mcef.api.ISchemeResponseHeaders;
import net.montoyo.mcef.api.SchemePreResponse;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.miniserv.client.Client;
import net.montoyo.wd.miniserv.client.ClientTaskGetFile;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Util;

public class WDScheme
implements IScheme {
    private static final String ERROR_PAGE = "<!DOCTYPE html><html><head></head><body><h1>%d %s</h1><hr /><i>Miniserv powered by WebDisplays</i></body></html>";
    private ClientTaskGetFile task;
    private boolean isErrorPage;
    private byte[] dataToWrite;
    private int dataOffset;
    private int amountToWrite;

    public SchemePreResponse processRequest(String url) {
        UUID uuid;
        int pos = (url = url.substring("wd://".length())).indexOf(47);
        if (pos < 0) {
            return SchemePreResponse.NOT_HANDLED;
        }
        String uuidStr = url.substring(0, pos);
        String fileStr = url.substring(pos + 1);
        try {
            fileStr = URLDecoder.decode(fileStr, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Log.warningEx("UTF-8 isn't supported... yeah... and I'm a billionaire...", ex, new Object[0]);
        }
        if (uuidStr.isEmpty() || Util.isFileNameInvalid(fileStr)) {
            return SchemePreResponse.NOT_HANDLED;
        }
        try {
            uuid = UUID.fromString(uuidStr);
        }
        catch (IllegalArgumentException ex) {
            return SchemePreResponse.NOT_HANDLED;
        }
        this.task = new ClientTaskGetFile(uuid, fileStr);
        return Client.getInstance().addTask(this.task) ? SchemePreResponse.HANDLED_CONTINUE : SchemePreResponse.NOT_HANDLED;
    }

    public void getResponseHeaders(ISchemeResponseHeaders resp) {
        String errStr;
        int errCode;
        Log.info("Waiting for response...", new Object[0]);
        int status = this.task.waitForResponse();
        Log.info("Got response %d", status);
        if (status == 0) {
            String mime;
            int extPos = this.task.getFileName().lastIndexOf(46);
            if (extPos >= 0 && (mime = ((ClientProxy)WebDisplays.PROXY).getMCEF().mimeTypeFromExtension(this.task.getFileName().substring(extPos + 1))) != null) {
                resp.setMimeType(mime);
            }
            resp.setStatus(200);
            resp.setStatusText("OK");
            resp.setResponseLength(-1);
            return;
        }
        if (status == 2) {
            errCode = 404;
            errStr = "Not Found";
        } else {
            errCode = 500;
            errStr = "Internal Server Error";
        }
        resp.setStatus(errCode);
        resp.setStatusText(errStr);
        try {
            this.dataToWrite = String.format(ERROR_PAGE, errCode, errStr).getBytes("UTF-8");
            this.dataOffset = 0;
            this.amountToWrite = this.dataToWrite.length;
            this.isErrorPage = true;
            resp.setResponseLength(this.amountToWrite);
        }
        catch (UnsupportedEncodingException ex) {
            resp.setResponseLength(0);
        }
    }

    public boolean readResponse(ISchemeResponseData data) {
        int toWrite;
        if (this.dataToWrite == null) {
            if (this.isErrorPage) {
                data.setAmountRead(0);
                return false;
            }
            this.dataToWrite = this.task.waitForData();
            this.dataOffset = 3;
            this.amountToWrite = this.task.getDataLength();
            if (this.amountToWrite <= 0) {
                this.dataToWrite = null;
                data.setAmountRead(0);
                return false;
            }
        }
        if ((toWrite = data.getBytesToRead()) > this.amountToWrite) {
            toWrite = this.amountToWrite;
        }
        System.arraycopy(this.dataToWrite, this.dataOffset, data.getDataArray(), 0, toWrite);
        data.setAmountRead(toWrite);
        this.dataOffset += toWrite;
        this.amountToWrite -= toWrite;
        if (this.amountToWrite <= 0) {
            if (!this.isErrorPage) {
                this.task.nextData();
            }
            this.dataToWrite = null;
        }
        return true;
    }
}

