/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.property;

import net.ilexiconn.llibrary.server.property.IIntProperty;

public interface IIntRangeProperty
extends IIntProperty {
    @Override
    default public boolean isValidInt(int value) {
        return value >= this.getMinIntValue() && value <= this.getMaxIntValue();
    }

    public int getMinIntValue();

    public int getMaxIntValue();

    default public int getIntValueRange() {
        return this.getMaxIntValue() - this.getMinIntValue();
    }

    public static class WithState
    extends IIntProperty.WithState
    implements IIntRangeProperty {
        private final int minIntValue;
        private final int maxIntValue;

        public WithState(int value, int minIntValue, int maxIntValue) {
            super(value);
            this.minIntValue = minIntValue;
            this.maxIntValue = maxIntValue;
        }

        @Override
        public int getMinIntValue() {
            return this.minIntValue;
        }

        @Override
        public int getMaxIntValue() {
            return this.maxIntValue;
        }
    }
}

