/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.remote;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.remote.Mirror;
import net.montoyo.mcef.utilities.Log;

public class MirrorManager {
    private static final Mirror[] defaultMirrors = new Mirror[]{new Mirror("montoyo.net (over HTTPS)", "https://montoyo.net/jcef", 3), new Mirror("montoyo.net (non-secure)", "http://montoyo.net/jcef", 0)};
    public static final MirrorManager INSTANCE = new MirrorManager();
    private final ArrayList<Mirror> mirrors = new ArrayList();
    private final Random r = new Random();
    private Mirror current;

    private MirrorManager() {
        this.markCurrentMirrorAsBroken();
    }

    private void reset() {
        this.mirrors.clear();
        if (MCEF.FORCE_MIRROR != null) {
            this.mirrors.add(new Mirror("user-forced", MCEF.FORCE_MIRROR, 4));
        } else {
            Mirror m;
            ArrayList<Mirror> lst = new ArrayList<Mirror>(Arrays.asList(defaultMirrors));
            while (!lst.isEmpty()) {
                m = lst.remove(this.r.nextInt(lst.size()));
                if (!m.isSecure()) continue;
                this.mirrors.add(m);
            }
            if (!MCEF.SECURE_MIRRORS_ONLY) {
                lst.addAll(Arrays.asList(defaultMirrors));
                while (!lst.isEmpty()) {
                    m = lst.remove(this.r.nextInt(lst.size()));
                    if (m.isSecure()) continue;
                    this.mirrors.add(m);
                }
            }
        }
    }

    public Mirror getCurrent() {
        return this.current;
    }

    public boolean markCurrentMirrorAsBroken() {
        boolean ret = true;
        if (this.mirrors.isEmpty()) {
            this.reset();
            ret = false;
        }
        this.current = this.mirrors.remove(0);
        Log.info(this.current.getInformationString(), new Object[0]);
        return ret;
    }
}

