/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import java.util.Locale;
import minecrafttransportsimulator.baseclasses.EntityInteractResult;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.instances.GUIPanel;
import minecrafttransportsimulator.guis.instances.GUIRadio;
import minecrafttransportsimulator.jsondefs.JSONConfigClient;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityCameraChange;
import minecrafttransportsimulator.packets.instances.PacketEntityInteract;
import minecrafttransportsimulator.packets.instances.PacketEntityInteractGUI;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketPartGun;
import minecrafttransportsimulator.packets.instances.PacketPartSeat;
import minecrafttransportsimulator.packets.instances.PacketVehicleControlNotification;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public final class ControlSystem {
    private static final int NULL_COMPONENT = 999;
    private static boolean joysticksInhibited = false;
    private static IWrapperPlayer clientPlayer;
    private static boolean clickingLeft;
    private static boolean clickingRight;
    private static boolean throttlePressedLastCheck;
    private static boolean parkingBrakePressedLastCheck;
    private static boolean hornPressedLastCheck;
    private static boolean hornReleasedLastCheck;
    private static EntityInteractResult interactResult;

    public static void controlGlobal(IWrapperPlayer player) {
        if (InterfaceManager.inputInterface.isLeftMouseButtonDown()) {
            if (!clickingLeft) {
                clickingLeft = true;
                ControlSystem.handleClick(player);
            }
        } else if (clickingLeft) {
            clickingLeft = false;
            ControlSystem.handleClick(player);
        }
        if (InterfaceManager.inputInterface.isRightMouseButtonDown()) {
            if (!clickingRight) {
                clickingRight = true;
                ControlSystem.handleClick(player);
            }
        } else if (clickingRight) {
            clickingRight = false;
            ControlSystem.handleClick(player);
        }
    }

    private static void handleClick(IWrapperPlayer player) {
        EntityPlayerGun playerGun = EntityPlayerGun.playerClientGuns.get(player.getID());
        if (playerGun != null && playerGun.activeGun != null) {
            if (clickingLeft) {
                InterfaceManager.packetInterface.sendToServer(new PacketPartGun(playerGun.activeGun, PacketPartGun.Request.TRIGGER_ON));
            } else {
                InterfaceManager.packetInterface.sendToServer(new PacketPartGun(playerGun.activeGun, PacketPartGun.Request.TRIGGER_OFF));
            }
            if (clickingRight) {
                InterfaceManager.packetInterface.sendToServer(new PacketPartGun(playerGun.activeGun, PacketPartGun.Request.AIM_ON));
            } else {
                InterfaceManager.packetInterface.sendToServer(new PacketPartGun(playerGun.activeGun, PacketPartGun.Request.AIM_OFF));
            }
        }
        if (clickingLeft || clickingRight) {
            Point3D startPosition = player.getEyePosition();
            Point3D endPosition = player.getLineOfSight(3.5).add(startPosition);
            interactResult = player.getWorld().getMultipartEntityIntersect(startPosition, endPosition);
            if (interactResult != null) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityInteract(ControlSystem.interactResult.entity, player, ControlSystem.interactResult.box, clickingLeft, clickingRight));
            }
        } else if (interactResult != null) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityInteract(ControlSystem.interactResult.entity, player, ControlSystem.interactResult.box, false, false));
            interactResult = null;
        }
    }

    public static void controlMultipart(AEntityF_Multipart<?> multipart, boolean isPlayerController) {
        clientPlayer = InterfaceManager.clientInterface.getClientPlayer();
        if (multipart instanceof EntityVehicleF_Physics) {
            EntityVehicleF_Physics vehicle = (EntityVehicleF_Physics)multipart;
            if (((JSONVehicle)vehicle.definition).motorized.isAircraft) {
                ControlSystem.controlAircraft(vehicle, isPlayerController);
            } else {
                ControlSystem.controlGroundVehicle(vehicle, isPlayerController);
            }
        } else {
            ControlSystem.controlCamera(ControlsKeyboard.CAR_ZOOM_I, ControlsKeyboard.CAR_ZOOM_O, ControlsJoystick.CAR_CHANGEVIEW);
            ControlSystem.rotateCamera(ControlsJoystick.CAR_LOOK_R, ControlsJoystick.CAR_LOOK_L, ControlsJoystick.CAR_LOOK_U, ControlsJoystick.CAR_LOOK_D, ControlsJoystick.CAR_LOOK_A);
            ControlSystem.controlGun(multipart, ControlsKeyboard.CAR_GUN_FIRE, ControlsKeyboard.CAR_GUN_SWITCH);
        }
    }

    private static void controlCamera(ControlsKeyboard zoomIn, ControlsKeyboard zoomOut, ControlsJoystick changeView) {
        AEntityB_Existing riding = clientPlayer.getEntityRiding();
        if (riding instanceof PartSeat) {
            PartSeat sittingSeat = (PartSeat)riding;
            if (zoomIn.isPressed()) {
                InterfaceManager.packetInterface.sendToServer(new PacketPartSeat(sittingSeat, PacketPartSeat.SeatAction.ZOOM_IN));
            }
            if (zoomOut.isPressed()) {
                InterfaceManager.packetInterface.sendToServer(new PacketPartSeat(sittingSeat, PacketPartSeat.SeatAction.ZOOM_OUT));
            }
            if (changeView.isPressed()) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityCameraChange(sittingSeat));
            }
        }
    }

    private static void rotateCamera(ControlsJoystick lookR, ControlsJoystick lookL, ControlsJoystick lookU, ControlsJoystick lookD, ControlsJoystick lookA) {
        float pollData;
        if (lookR.isPressed()) {
            clientPlayer.setYaw(clientPlayer.getYaw() - 3.0f);
        }
        if (lookL.isPressed()) {
            clientPlayer.setYaw(clientPlayer.getYaw() + 3.0f);
        }
        if (lookU.isPressed()) {
            clientPlayer.setPitch(clientPlayer.getPitch() - 3.0f);
        }
        if (lookD.isPressed()) {
            clientPlayer.setPitch(clientPlayer.getPitch() + 3.0f);
        }
        if ((pollData = lookA.getMultistateValue()) != 0.0f) {
            if (pollData >= 0.125f && pollData <= 0.375f) {
                clientPlayer.setPitch(clientPlayer.getPitch() + 3.0f);
            }
            if (pollData >= 0.375f && pollData <= 0.625f) {
                clientPlayer.setYaw(clientPlayer.getYaw() - 3.0f);
            }
            if (pollData >= 0.625f && pollData <= 0.875f) {
                clientPlayer.setPitch(clientPlayer.getPitch() - 3.0f);
            }
            if (pollData >= 0.875f || pollData <= 0.125f) {
                clientPlayer.setYaw(clientPlayer.getYaw() + 3.0f);
            }
        }
    }

    private static void controlBrake(EntityVehicleF_Physics vehicle, ControlsKeyboardDynamic brakeMod, ControlsJoystick brakeJoystick, ControlsJoystick brakeButton, ControlsJoystick pBrake) {
        boolean isParkingBrakePressed;
        boolean bl = InterfaceManager.inputInterface.isJoystickPresent(brakeJoystick.config.joystickName) ? pBrake.isPressed() : (isParkingBrakePressed = brakeMod.isPressed() || pBrake.isPressed());
        if (isParkingBrakePressed) {
            if (!parkingBrakePressedLastCheck) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(vehicle, "p_brake"));
                parkingBrakePressedLastCheck = true;
            }
        } else {
            parkingBrakePressedLastCheck = false;
            double brakeValue = InterfaceManager.inputInterface.isJoystickPresent(brakeJoystick.config.joystickName) ? brakeJoystick.getAxisState(true) : (brakeMod.mainControl.isPressed() || brakeButton.isPressed() ? 1.0 : 0.0);
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(vehicle, "brake", brakeValue));
        }
    }

    private static void controlGun(AEntityF_Multipart<?> multipart, ControlsKeyboard gunTrigger, ControlsKeyboard gunSwitch) {
        boolean gunSwitchPressedThisScan = gunSwitch.isPressed();
        for (APart part : multipart.allParts) {
            if (part instanceof PartGun) {
                PartGun gun = (PartGun)part;
                if (!clientPlayer.equals(gun.getGunController())) continue;
                if (gunTrigger.isPressed()) {
                    InterfaceManager.packetInterface.sendToServer(new PacketPartGun(gun, PacketPartGun.Request.TRIGGER_ON));
                    continue;
                }
                InterfaceManager.packetInterface.sendToServer(new PacketPartGun(gun, PacketPartGun.Request.TRIGGER_OFF));
                continue;
            }
            if (!(part instanceof PartSeat) || !gunSwitchPressedThisScan || !clientPlayer.equals(part.rider)) continue;
            InterfaceManager.packetInterface.sendToServer(new PacketPartSeat((PartSeat)part, PacketPartSeat.SeatAction.CHANGE_GUN));
        }
    }

    private static void controlPanel(EntityVehicleF_Physics vehicle, ControlsKeyboard panel) {
        if (panel.isPressed() && vehicle.canPlayerStartEngines(clientPlayer)) {
            if (AGUIBase.activeInputGUI instanceof GUIPanel && !AGUIBase.activeInputGUI.editingText) {
                AGUIBase.activeInputGUI.close();
            } else if (!InterfaceManager.clientInterface.isGUIOpen()) {
                new GUIPanel(vehicle);
            }
        }
    }

    private static void controlRadio(EntityVehicleF_Physics vehicle, ControlsKeyboard radio) {
        if (radio.isPressed()) {
            if (AGUIBase.activeInputGUI instanceof GUIRadio) {
                AGUIBase.activeInputGUI.close();
            } else if (!InterfaceManager.clientInterface.isGUIOpen()) {
                new GUIRadio(vehicle.radio);
                InterfaceManager.packetInterface.sendToServer(new PacketEntityInteractGUI(vehicle, InterfaceManager.clientInterface.getClientPlayer(), true));
            }
        }
    }

    private static void controlJoystick(EntityVehicleF_Physics vehicle, ControlsKeyboard joystickInhibit) {
        if (joystickInhibit.isPressed()) {
            joysticksInhibited = !joysticksInhibited;
            InterfaceManager.inputInterface.inhibitJoysticks(joysticksInhibited);
        }
    }

    private static void controlControlSurface(EntityVehicleF_Physics vehicle, ControlsJoystick axis, ControlsKeyboard increment, ControlsKeyboard decrement, double rate, double bounds, String variable, double currentValue, double dampenRate) {
        if (InterfaceManager.inputInterface.isJoystickPresent(axis.config.joystickName)) {
            double axisValue = axis.getAxisState(false);
            if (Double.isNaN(axisValue)) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(vehicle, variable, 0.0));
            } else {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(vehicle, variable, bounds * (-1.0 + 2.0 * axisValue)));
            }
        } else if (increment.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(vehicle, variable, rate * (double)(currentValue < 0.0 ? 2 : 1), -bounds, bounds));
            InterfaceManager.packetInterface.sendToServer(new PacketVehicleControlNotification(vehicle, clientPlayer));
        } else if (decrement.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(vehicle, variable, -rate * (double)(currentValue > 0.0 ? 2 : 1), -bounds, bounds));
            InterfaceManager.packetInterface.sendToServer(new PacketVehicleControlNotification(vehicle, clientPlayer));
        } else if (clientPlayer.equals(vehicle.lastController)) {
            if (currentValue > dampenRate) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(vehicle, variable, -dampenRate, 0.0, bounds));
            } else if (currentValue < -dampenRate) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(vehicle, variable, dampenRate, -bounds, 0.0));
            } else if (currentValue != 0.0) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(vehicle, variable, 0.0));
            }
        }
    }

    private static void controlControlTrim(EntityVehicleF_Physics vehicle, ControlsJoystick increment, ControlsJoystick decrement, double bounds, String variable) {
        if (increment.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(vehicle, variable, 0.1, -bounds, bounds));
        } else if (decrement.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(vehicle, variable, -0.1, -bounds, bounds));
        }
    }

    private static void controlAircraft(EntityVehicleF_Physics aircraft, boolean isPlayerController) {
        boolean aircraftIsAutolevel;
        ControlSystem.controlCamera(ControlsKeyboard.AIRCRAFT_ZOOM_I, ControlsKeyboard.AIRCRAFT_ZOOM_O, ControlsJoystick.AIRCRAFT_CHANGEVIEW);
        ControlSystem.rotateCamera(ControlsJoystick.AIRCRAFT_LOOK_R, ControlsJoystick.AIRCRAFT_LOOK_L, ControlsJoystick.AIRCRAFT_LOOK_U, ControlsJoystick.AIRCRAFT_LOOK_D, ControlsJoystick.AIRCRAFT_LOOK_A);
        ControlSystem.controlGun(aircraft, ControlsKeyboard.AIRCRAFT_GUN_FIRE, ControlsKeyboard.AIRCRAFT_GUN_SWITCH);
        ControlSystem.controlRadio(aircraft, ControlsKeyboard.AIRCRAFT_RADIO);
        ControlSystem.controlJoystick(aircraft, ControlsKeyboard.AIRCRAFT_JS_INHIBIT);
        if (!isPlayerController) {
            return;
        }
        ControlSystem.controlPanel(aircraft, ControlsKeyboard.AIRCRAFT_PANEL);
        ControlSystem.controlBrake(aircraft, ControlsKeyboardDynamic.AIRCRAFT_PARK, ControlsJoystick.AIRCRAFT_BRAKE, ControlsJoystick.AIRCRAFT_BRAKE_DIGITAL, ControlsJoystick.AIRCRAFT_PARK);
        if (ControlsJoystick.AIRCRAFT_REVERSE.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(aircraft, "reverser"));
        }
        if (ControlsJoystick.AIRCRAFT_GEAR.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(aircraft, "gear_setpoint"));
        }
        if (InterfaceManager.inputInterface.isJoystickPresent(ControlsJoystick.AIRCRAFT_THROTTLE.config.joystickName)) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(aircraft, "throttle", ControlsJoystick.AIRCRAFT_THROTTLE.getAxisState(true) * 1.0));
        } else {
            if (ControlsKeyboard.AIRCRAFT_THROTTLE_U.isPressed()) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(aircraft, "throttle", 0.01, 0.0, 1.0));
            }
            if (ControlsKeyboard.AIRCRAFT_THROTTLE_D.isPressed()) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(aircraft, "throttle", -0.01, 0.0, 1.0));
            }
        }
        if (((JSONVehicle)aircraft.definition).motorized.flapNotches != null && !((JSONVehicle)aircraft.definition).motorized.flapNotches.isEmpty()) {
            int currentFlapSetting;
            if (ControlsKeyboard.AIRCRAFT_FLAPS_D.isPressed()) {
                currentFlapSetting = ((JSONVehicle)aircraft.definition).motorized.flapNotches.indexOf(Float.valueOf((float)aircraft.flapDesiredAngle));
                if (currentFlapSetting == -1) {
                    for (int i = 0; i < ((JSONVehicle)aircraft.definition).motorized.flapNotches.size(); ++i) {
                        float flapNotch = ((JSONVehicle)aircraft.definition).motorized.flapNotches.get(i).floatValue();
                        if (!((double)flapNotch > aircraft.flapDesiredAngle)) continue;
                        currentFlapSetting = i;
                        break;
                    }
                }
                if (currentFlapSetting != -1 && currentFlapSetting + 1 < ((JSONVehicle)aircraft.definition).motorized.flapNotches.size()) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(aircraft, "flaps_setpoint", ((JSONVehicle)aircraft.definition).motorized.flapNotches.get(currentFlapSetting + 1).floatValue()));
                }
            } else if (ControlsKeyboard.AIRCRAFT_FLAPS_U.isPressed()) {
                currentFlapSetting = ((JSONVehicle)aircraft.definition).motorized.flapNotches.indexOf(Float.valueOf((float)aircraft.flapDesiredAngle));
                if (currentFlapSetting == -1) {
                    for (int i = ((JSONVehicle)aircraft.definition).motorized.flapNotches.size() - 1; i <= 0; --i) {
                        float flapNotch = ((JSONVehicle)aircraft.definition).motorized.flapNotches.get(i).floatValue();
                        if (!((double)flapNotch < aircraft.flapDesiredAngle)) continue;
                        currentFlapSetting = i;
                        break;
                    }
                }
                if (currentFlapSetting > 0) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(aircraft, "flaps_setpoint", ((JSONVehicle)aircraft.definition).motorized.flapNotches.get(currentFlapSetting - 1).floatValue()));
                }
            }
        }
        if (!((JSONVehicle)aircraft.definition).motorized.isBlimp) {
            ControlSystem.controlControlSurface(aircraft, ControlsJoystick.AIRCRAFT_YAW, ControlsKeyboard.AIRCRAFT_YAW_R, ControlsKeyboard.AIRCRAFT_YAW_L, (Double)ConfigSystem.client.controlSettings.steeringControlRate.value, 45.0, "input_rudder", aircraft.rudderInput, 2.0);
            ControlSystem.controlControlTrim(aircraft, ControlsJoystick.AIRCRAFT_TRIM_YAW_R, ControlsJoystick.AIRCRAFT_TRIM_YAW_L, 10.0, "trim_rudder");
        }
        ControlSystem.controlControlSurface(aircraft, ControlsJoystick.AIRCRAFT_PITCH, ControlsKeyboard.AIRCRAFT_PITCH_U, ControlsKeyboard.AIRCRAFT_PITCH_D, (Double)ConfigSystem.client.controlSettings.flightControlRate.value, 25.0, "input_elevator", aircraft.elevatorInput, 0.6);
        ControlSystem.controlControlTrim(aircraft, ControlsJoystick.AIRCRAFT_TRIM_PITCH_U, ControlsJoystick.AIRCRAFT_TRIM_PITCH_D, 10.0, "trim_elevator");
        if (((JSONVehicle)aircraft.definition).motorized.isBlimp) {
            ControlSystem.controlControlSurface(aircraft, ControlsJoystick.AIRCRAFT_ROLL, ControlsKeyboard.AIRCRAFT_ROLL_R, ControlsKeyboard.AIRCRAFT_ROLL_L, (Double)ConfigSystem.client.controlSettings.steeringControlRate.value, 45.0, "input_rudder", aircraft.rudderInput, 2.0);
        } else {
            ControlSystem.controlControlSurface(aircraft, ControlsJoystick.AIRCRAFT_ROLL, ControlsKeyboard.AIRCRAFT_ROLL_R, ControlsKeyboard.AIRCRAFT_ROLL_L, (Double)ConfigSystem.client.controlSettings.flightControlRate.value, 25.0, "input_aileron", aircraft.aileronInput, 0.6);
        }
        ControlSystem.controlControlTrim(aircraft, ControlsJoystick.AIRCRAFT_TRIM_ROLL_R, ControlsJoystick.AIRCRAFT_TRIM_ROLL_L, 10.0, "trim_aileron");
        boolean bl = aircraftIsAutolevel = aircraft.getVariable("auto_level") != 0.0;
        if ((Boolean)ConfigSystem.client.controlSettings.heliAutoLevel.value ^ aircraftIsAutolevel) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(aircraft, "auto_level", (Boolean)ConfigSystem.client.controlSettings.heliAutoLevel.value != false ? 1.0 : 0.0));
        }
    }

    private static void controlGroundVehicle(EntityVehicleF_Physics powered, boolean isPlayerController) {
        double throttleLevel;
        ControlSystem.controlCamera(ControlsKeyboard.CAR_ZOOM_I, ControlsKeyboard.CAR_ZOOM_O, ControlsJoystick.CAR_CHANGEVIEW);
        ControlSystem.rotateCamera(ControlsJoystick.CAR_LOOK_R, ControlsJoystick.CAR_LOOK_L, ControlsJoystick.CAR_LOOK_U, ControlsJoystick.CAR_LOOK_D, ControlsJoystick.CAR_LOOK_A);
        ControlSystem.controlGun(powered, ControlsKeyboard.CAR_GUN_FIRE, ControlsKeyboard.CAR_GUN_SWITCH);
        ControlSystem.controlRadio(powered, ControlsKeyboard.CAR_RADIO);
        ControlSystem.controlJoystick(powered, ControlsKeyboard.CAR_JS_INHIBIT);
        if (!isPlayerController) {
            return;
        }
        ControlSystem.controlPanel(powered, ControlsKeyboard.CAR_PANEL);
        if (((JSONVehicle)powered.definition).motorized.hasIncrementalThrottle) {
            ControlSystem.controlBrake(powered, ControlsKeyboardDynamic.CAR_PARK, ControlsJoystick.CAR_BRAKE, ControlsJoystick.CAR_BRAKE_DIGITAL, ControlsJoystick.CAR_PARK);
            if (InterfaceManager.inputInterface.isJoystickPresent(ControlsJoystick.CAR_GAS.config.joystickName)) {
                throttleLevel = ControlsJoystick.CAR_GAS.getAxisState(true) * 1.0;
                if (powered.autopilotSetting == 0.0 || powered.throttle < throttleLevel) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "throttle", throttleLevel));
                }
            } else {
                if (ControlsKeyboard.CAR_GAS.isPressed()) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(powered, "throttle", 0.01, 0.0, 1.0));
                }
                if (ControlsKeyboard.CAR_BRAKE.isPressed() || ControlsJoystick.CAR_BRAKE_DIGITAL.isPressed()) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(powered, "throttle", -0.01, 0.0, 1.0));
                }
            }
        } else if (((Boolean)ConfigSystem.client.controlSettings.simpleThrottle.value).booleanValue()) {
            if (!powered.engines.isEmpty()) {
                double brakeValue = InterfaceManager.inputInterface.isJoystickPresent(ControlsJoystick.CAR_BRAKE.config.joystickName) ? ControlsJoystick.CAR_BRAKE.getAxisState(true) : (ControlsKeyboard.CAR_BRAKE.isPressed() || ControlsJoystick.CAR_BRAKE_DIGITAL.isPressed() ? 1.0 : 0.0);
                double throttleValue = InterfaceManager.inputInterface.isJoystickPresent(ControlsJoystick.CAR_GAS.config.joystickName) ? ControlsJoystick.CAR_GAS.getAxisState(true) * 1.0 : (ControlsKeyboardDynamic.CAR_SLOW.isPressed() ? ((Boolean)ConfigSystem.client.controlSettings.halfThrottle.value != false ? 1.0 : 0.5) : (ControlsKeyboard.CAR_GAS.isPressed() ? ((Boolean)ConfigSystem.client.controlSettings.halfThrottle.value != false ? 0.5 : 1.0) : 0.0));
                if (throttleValue == 0.0 && brakeValue == 0.0 && powered.axialVelocity < (double)0.35f) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "throttle", throttleValue));
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "brake", 1.0));
                } else if (((PartEngine)powered.engines.get((int)0)).currentGear >= 0 || ((Boolean)ConfigSystem.client.controlSettings.useShifter.value).booleanValue()) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "brake", brakeValue));
                    if (powered.autopilotSetting == 0.0 || throttleValue > 0.0 || throttlePressedLastCheck) {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "throttle", throttleValue));
                        throttlePressedLastCheck = throttleValue > 0.0;
                    }
                } else {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "brake", throttleValue));
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "throttle", brakeValue));
                }
                if (!((Boolean)ConfigSystem.client.controlSettings.useShifter.value).booleanValue()) {
                    powered.engines.forEach(engine -> {
                        if (brakeValue > 0.25 && engine.currentGear >= 0 && powered.axialVelocity < (double)0.01f) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet((AEntityD_Definable<?>)engine, "engine_shift_neutral", 1.0));
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet((AEntityD_Definable<?>)engine, "engine_shift_down", 1.0));
                        } else if (throttleValue > 0.25 && engine.currentGear <= 0 && powered.axialVelocity < (double)0.01f) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet((AEntityD_Definable<?>)engine, "engine_shift_neutral", 1.0));
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet((AEntityD_Definable<?>)engine, "engine_shift_up", 1.0));
                        }
                    });
                }
            }
        } else {
            ControlSystem.controlBrake(powered, ControlsKeyboardDynamic.CAR_PARK, ControlsJoystick.CAR_BRAKE, ControlsJoystick.CAR_BRAKE_DIGITAL, ControlsJoystick.CAR_PARK);
            if (InterfaceManager.inputInterface.isJoystickPresent(ControlsJoystick.CAR_GAS.config.joystickName)) {
                throttleLevel = ControlsJoystick.CAR_GAS.getAxisState(true);
                if (powered.autopilotSetting == 0.0 || throttleLevel > powered.throttle) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "throttle", throttleLevel));
                }
            } else if (ControlsKeyboardDynamic.CAR_SLOW.isPressed()) {
                throttlePressedLastCheck = true;
                if (!((Boolean)ConfigSystem.client.controlSettings.halfThrottle.value).booleanValue()) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "throttle", 0.5));
                } else {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "throttle", 1.0));
                }
            } else if (ControlsKeyboard.CAR_GAS.isPressed()) {
                throttlePressedLastCheck = true;
                if (!((Boolean)ConfigSystem.client.controlSettings.halfThrottle.value).booleanValue()) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "throttle", 1.0));
                } else {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "throttle", 0.5));
                }
            } else if (powered.autopilotSetting == 0.0 || throttlePressedLastCheck) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "throttle", 0.0));
                throttlePressedLastCheck = false;
            }
        }
        if (!powered.lockedOnRoad) {
            ControlSystem.controlControlSurface(powered, ControlsJoystick.CAR_TURN, ControlsKeyboard.CAR_TURN_R, ControlsKeyboard.CAR_TURN_L, (Double)ConfigSystem.client.controlSettings.steeringControlRate.value, 45.0, "input_rudder", powered.rudderInput, (Double)ConfigSystem.client.controlSettings.steeringReturnRate.value);
        }
        if (((Boolean)ConfigSystem.client.controlSettings.useShifter.value).booleanValue()) {
            int gearNumber = ControlsJoystick.CAR_SHIFT_1.isPressed() ? 1 : (ControlsJoystick.CAR_SHIFT_2.isPressed() ? 2 : (ControlsJoystick.CAR_SHIFT_3.isPressed() ? 3 : (ControlsJoystick.CAR_SHIFT_4.isPressed() ? 4 : (ControlsJoystick.CAR_SHIFT_5.isPressed() ? 5 : (ControlsJoystick.CAR_SHIFT_6.isPressed() ? 6 : (ControlsJoystick.CAR_SHIFT_7.isPressed() ? 7 : (ControlsJoystick.CAR_SHIFT_8.isPressed() ? 8 : (ControlsJoystick.CAR_SHIFT_9.isPressed() ? 9 : (ControlsJoystick.CAR_SHIFT_R.isPressed() ? 10 : 11)))))))));
            powered.engines.forEach(engine -> InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet((AEntityD_Definable<?>)engine, "engine_shift_request", gearNumber)));
        } else if (ControlsKeyboardDynamic.CAR_SHIFT_NU.isPressed() || ControlsKeyboardDynamic.CAR_SHIFT_ND.isPressed()) {
            powered.engines.forEach(engine -> InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle((AEntityD_Definable<?>)engine, "engine_shift_neutral")));
        } else {
            if (ControlsKeyboard.CAR_SHIFT_U.isPressed()) {
                powered.engines.forEach(engine -> {
                    if (engine.currentIsAutomatic != 0.0f) {
                        if (engine.currentGear < 0) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle((AEntityD_Definable<?>)engine, "engine_shift_neutral"));
                        } else if (engine.currentGear == 0) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle((AEntityD_Definable<?>)engine, "engine_shift_up"));
                        }
                    } else {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle((AEntityD_Definable<?>)engine, "engine_shift_up"));
                    }
                });
            }
            if (ControlsKeyboard.CAR_SHIFT_D.isPressed()) {
                powered.engines.forEach(engine -> {
                    if (engine.currentIsAutomatic != 0.0f) {
                        if (engine.currentGear > 0) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle((AEntityD_Definable<?>)engine, "engine_shift_neutral"));
                        } else if (engine.currentGear == 0) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle((AEntityD_Definable<?>)engine, "engine_shift_down"));
                        }
                    } else {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle((AEntityD_Definable<?>)engine, "engine_shift_down"));
                    }
                });
            }
        }
        if (ControlsKeyboard.CAR_HORN.isPressed()) {
            if (!hornPressedLastCheck) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "horn", 1.0));
            }
            hornPressedLastCheck = true;
        } else {
            hornPressedLastCheck = false;
        }
        if (!ControlsKeyboard.CAR_HORN.isPressed()) {
            if (!hornReleasedLastCheck) {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(powered, "horn", 0.0));
            }
            hornReleasedLastCheck = true;
        } else {
            hornReleasedLastCheck = false;
        }
        if (ControlsKeyboard.CAR_LIGHTS.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered, "running_light"));
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered, "headlight"));
        }
        if (ControlsKeyboard.CAR_TURNSIGNAL_L.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered, "left_turn_signal"));
        }
        if (ControlsKeyboard.CAR_TURNSIGNAL_R.isPressed()) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered, "right_turn_signal"));
        }
        if (((Boolean)ConfigSystem.client.controlSettings.autoTrnSignals.value).booleanValue()) {
            if (!powered.turningLeft && powered.rudderInput < -20.0) {
                powered.turningLeft = true;
                powered.turningCooldown = (byte)40;
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered, "left_turn_signal"));
            }
            if (!powered.turningRight && powered.rudderInput > 20.0) {
                powered.turningRight = true;
                powered.turningCooldown = (byte)40;
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered, "right_turn_signal"));
            }
            if (powered.turningLeft && (powered.rudderInput > 0.0 || powered.turningCooldown == 0)) {
                powered.turningLeft = false;
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered, "left_turn_signal"));
            }
            if (powered.turningRight && (powered.rudderInput < 0.0 || powered.turningCooldown == 0)) {
                powered.turningRight = false;
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(powered, "right_turn_signal"));
            }
            if (powered.velocity != 0.0 && powered.turningCooldown > 0 && powered.rudderInput == 0.0) {
                powered.turningCooldown = (byte)(powered.turningCooldown - 1);
            }
        }
    }

    static {
        clickingLeft = false;
        clickingRight = false;
        throttlePressedLastCheck = false;
        parkingBrakePressedLastCheck = false;
        hornPressedLastCheck = false;
        hornReleasedLastCheck = false;
        interactResult = null;
        for (ControlsJoystick controlsJoystick : ControlsJoystick.values()) {
            ConfigSystem.client.controls.joystick.put(controlsJoystick.systemName, controlsJoystick.config);
        }
        for (Enum enum_ : ControlsKeyboard.values()) {
            ConfigSystem.client.controls.keyboard.put(((ControlsKeyboard)enum_).systemName, ((ControlsKeyboard)enum_).config);
        }
        for (Enum enum_ : ControlsKeyboard.values()) {
            if (((ControlsKeyboard)enum_).config.keyCode > 0) continue;
            ((ControlsKeyboard)enum_).config.keyCode = InterfaceManager.inputInterface.getKeyCodeForName(((ControlsKeyboard)enum_).defaultKeyName);
        }
        ConfigSystem.saveToDisk();
    }

    public static enum ControlsKeyboard {
        AIRCRAFT_MOD(ControlsJoystick.AIRCRAFT_MOD, false, "RSHIFT", LanguageSystem.INPUT_MOD),
        AIRCRAFT_YAW_R(ControlsJoystick.AIRCRAFT_YAW, false, "L", LanguageSystem.INPUT_YAW_R),
        AIRCRAFT_YAW_L(ControlsJoystick.AIRCRAFT_YAW, false, "J", LanguageSystem.INPUT_YAW_L),
        AIRCRAFT_PITCH_U(ControlsJoystick.AIRCRAFT_PITCH, false, "S", LanguageSystem.INPUT_PITCH_U),
        AIRCRAFT_PITCH_D(ControlsJoystick.AIRCRAFT_PITCH, false, "W", LanguageSystem.INPUT_PITCH_D),
        AIRCRAFT_ROLL_R(ControlsJoystick.AIRCRAFT_ROLL, false, "D", LanguageSystem.INPUT_ROLL_R),
        AIRCRAFT_ROLL_L(ControlsJoystick.AIRCRAFT_ROLL, false, "A", LanguageSystem.INPUT_ROLL_L),
        AIRCRAFT_THROTTLE_U(ControlsJoystick.AIRCRAFT_THROTTLE, false, "I", LanguageSystem.INPUT_THROTTLE_U),
        AIRCRAFT_THROTTLE_D(ControlsJoystick.AIRCRAFT_THROTTLE, false, "K", LanguageSystem.INPUT_THROTTLE_D),
        AIRCRAFT_FLAPS_U(ControlsJoystick.AIRCRAFT_FLAPS_U, true, "Y", LanguageSystem.INPUT_FLAPS_U),
        AIRCRAFT_FLAPS_D(ControlsJoystick.AIRCRAFT_FLAPS_D, true, "H", LanguageSystem.INPUT_FLAPS_D),
        AIRCRAFT_BRAKE(ControlsJoystick.AIRCRAFT_BRAKE, false, "B", LanguageSystem.INPUT_BRAKE),
        AIRCRAFT_PANEL(ControlsJoystick.AIRCRAFT_PANEL, true, "U", LanguageSystem.INPUT_PANEL),
        AIRCRAFT_RADIO(ControlsJoystick.AIRCRAFT_RADIO, true, "MINUS", LanguageSystem.INPUT_RADIO),
        AIRCRAFT_GUN_FIRE(ControlsJoystick.AIRCRAFT_GUN_FIRE, false, "SPACE", LanguageSystem.INPUT_GUN_FIRE),
        AIRCRAFT_GUN_SWITCH(ControlsJoystick.AIRCRAFT_GUN_SWITCH, true, "V", LanguageSystem.INPUT_GUN_SWITCH),
        AIRCRAFT_ZOOM_I(ControlsJoystick.AIRCRAFT_ZOOM_I, true, "PRIOR", LanguageSystem.INPUT_ZOOM_I),
        AIRCRAFT_ZOOM_O(ControlsJoystick.AIRCRAFT_ZOOM_O, true, "NEXT", LanguageSystem.INPUT_ZOOM_O),
        AIRCRAFT_CHANGEVIEW(ControlsJoystick.AIRCRAFT_CHANGEVIEW, true, "X", LanguageSystem.INPUT_CHANGEVIEW),
        AIRCRAFT_JS_INHIBIT(ControlsJoystick.AIRCRAFT_JS_INHIBIT, true, "SCROLL", LanguageSystem.INPUT_JS_INHIBIT),
        CAR_MOD(ControlsJoystick.CAR_MOD, false, "RSHIFT", LanguageSystem.INPUT_MOD),
        CAR_TURN_R(ControlsJoystick.CAR_TURN, false, "D", LanguageSystem.INPUT_TURN_R),
        CAR_TURN_L(ControlsJoystick.CAR_TURN, false, "A", LanguageSystem.INPUT_TURN_L),
        CAR_GAS(ControlsJoystick.CAR_GAS, false, "W", LanguageSystem.INPUT_GAS),
        CAR_BRAKE(ControlsJoystick.CAR_BRAKE, false, "S", LanguageSystem.INPUT_BRAKE),
        CAR_PANEL(ControlsJoystick.CAR_PANEL, true, "U", LanguageSystem.INPUT_PANEL),
        CAR_SHIFT_U(ControlsJoystick.CAR_SHIFT_U, true, "R", LanguageSystem.INPUT_SHIFT_U),
        CAR_SHIFT_D(ControlsJoystick.CAR_SHIFT_D, true, "F", LanguageSystem.INPUT_SHIFT_D),
        CAR_HORN(ControlsJoystick.CAR_HORN, false, "C", LanguageSystem.INPUT_HORN),
        CAR_RADIO(ControlsJoystick.CAR_RADIO, true, "MINUS", LanguageSystem.INPUT_RADIO),
        CAR_GUN_FIRE(ControlsJoystick.CAR_GUN_FIRE, false, "SPACE", LanguageSystem.INPUT_GUN_FIRE),
        CAR_GUN_SWITCH(ControlsJoystick.CAR_GUN_SWITCH, true, "V", LanguageSystem.INPUT_GUN_SWITCH),
        CAR_ZOOM_I(ControlsJoystick.CAR_ZOOM_I, true, "PRIOR", LanguageSystem.INPUT_ZOOM_I),
        CAR_ZOOM_O(ControlsJoystick.CAR_ZOOM_O, true, "NEXT", LanguageSystem.INPUT_ZOOM_O),
        CAR_CHANGEVIEW(ControlsJoystick.CAR_CHANGEVIEW, true, "X", LanguageSystem.INPUT_CHANGEVIEW),
        CAR_LIGHTS(ControlsJoystick.CAR_LIGHTS, true, "NUMPAD5", LanguageSystem.INPUT_LIGHTS),
        CAR_TURNSIGNAL_L(ControlsJoystick.CAR_TURNSIGNAL_L, true, "NUMPAD4", LanguageSystem.INPUT_TURNSIGNAL_L),
        CAR_TURNSIGNAL_R(ControlsJoystick.CAR_TURNSIGNAL_R, true, "NUMPAD6", LanguageSystem.INPUT_TURNSIGNAL_R),
        CAR_JS_INHIBIT(ControlsJoystick.CAR_JS_INHIBIT, true, "SCROLL", LanguageSystem.INPUT_JS_INHIBIT);

        public final boolean isMomentary;
        public final String systemName;
        public final LanguageSystem.LanguageEntry language;
        public final String defaultKeyName;
        public final JSONConfigClient.ConfigKeyboard config;
        private final ControlsJoystick linkedJoystick;
        private boolean wasPressedLastCall;

        private ControlsKeyboard(ControlsJoystick linkedJoystick, boolean isMomentary, String defaultKeyName, LanguageSystem.LanguageEntry language) {
            this.linkedJoystick = linkedJoystick;
            this.isMomentary = isMomentary;
            this.systemName = this.name().toLowerCase(Locale.ROOT).replaceFirst("_", ".");
            this.language = language;
            this.defaultKeyName = defaultKeyName;
            this.config = ConfigSystem.client.controls.keyboard.containsKey(this.systemName) ? ConfigSystem.client.controls.keyboard.get(this.systemName) : new JSONConfigClient.ConfigKeyboard();
        }

        public boolean isPressed() {
            if (this.linkedJoystick.isPressed()) {
                return true;
            }
            if (InterfaceManager.inputInterface.isJoystickPresent(this.linkedJoystick.config.joystickName) && ((Boolean)ConfigSystem.client.controlSettings.kbOverride.value).booleanValue()) {
                return false;
            }
            if (this.isMomentary) {
                if (this.wasPressedLastCall) {
                    this.wasPressedLastCall = InterfaceManager.inputInterface.isKeyPressed(this.config.keyCode);
                    return false;
                }
                this.wasPressedLastCall = InterfaceManager.inputInterface.isKeyPressed(this.config.keyCode);
                return this.wasPressedLastCall;
            }
            return InterfaceManager.inputInterface.isKeyPressed(this.config.keyCode);
        }
    }

    public static enum ControlsJoystick {
        AIRCRAFT_MOD(false, false, LanguageSystem.INPUT_MOD),
        AIRCRAFT_CAMLOCK(false, true, LanguageSystem.INPUT_CAMLOCK),
        AIRCRAFT_YAW(true, false, LanguageSystem.INPUT_YAW),
        AIRCRAFT_PITCH(true, false, LanguageSystem.INPUT_PITCH),
        AIRCRAFT_ROLL(true, false, LanguageSystem.INPUT_ROLL),
        AIRCRAFT_THROTTLE(true, false, LanguageSystem.INPUT_THROTTLE),
        AIRCRAFT_BRAKE(true, false, LanguageSystem.INPUT_BRAKE),
        AIRCRAFT_BRAKE_DIGITAL(false, false, LanguageSystem.INPUT_BRAKE),
        AIRCRAFT_GEAR(false, true, LanguageSystem.INPUT_GEAR),
        AIRCRAFT_FLAPS_U(false, true, LanguageSystem.INPUT_FLAPS_U),
        AIRCRAFT_FLAPS_D(false, true, LanguageSystem.INPUT_FLAPS_D),
        AIRCRAFT_PANEL(false, true, LanguageSystem.INPUT_PANEL),
        AIRCRAFT_PARK(false, true, LanguageSystem.INPUT_PARK),
        AIRCRAFT_RADIO(false, true, LanguageSystem.INPUT_RADIO),
        AIRCRAFT_GUN_FIRE(false, false, LanguageSystem.INPUT_GUN_FIRE),
        AIRCRAFT_GUN_SWITCH(false, true, LanguageSystem.INPUT_GUN_SWITCH),
        AIRCRAFT_ZOOM_I(false, true, LanguageSystem.INPUT_ZOOM_I),
        AIRCRAFT_ZOOM_O(false, true, LanguageSystem.INPUT_ZOOM_O),
        AIRCRAFT_CHANGEVIEW(false, true, LanguageSystem.INPUT_CHANGEVIEW),
        AIRCRAFT_LOOK_L(false, false, LanguageSystem.INPUT_LOOK_L),
        AIRCRAFT_LOOK_R(false, false, LanguageSystem.INPUT_LOOK_R),
        AIRCRAFT_LOOK_U(false, false, LanguageSystem.INPUT_LOOK_U),
        AIRCRAFT_LOOK_D(false, false, LanguageSystem.INPUT_LOOK_D),
        AIRCRAFT_LOOK_A(false, false, LanguageSystem.INPUT_LOOK_A),
        AIRCRAFT_TRIM_YAW_R(false, false, LanguageSystem.INPUT_TRIM_YAW_R),
        AIRCRAFT_TRIM_YAW_L(false, false, LanguageSystem.INPUT_TRIM_YAW_L),
        AIRCRAFT_TRIM_PITCH_U(false, false, LanguageSystem.INPUT_TRIM_PITCH_U),
        AIRCRAFT_TRIM_PITCH_D(false, false, LanguageSystem.INPUT_TRIM_PITCH_D),
        AIRCRAFT_TRIM_ROLL_R(false, false, LanguageSystem.INPUT_TRIM_ROLL_R),
        AIRCRAFT_TRIM_ROLL_L(false, false, LanguageSystem.INPUT_TRIM_ROLL_L),
        AIRCRAFT_REVERSE(false, true, LanguageSystem.INPUT_REVERSE),
        AIRCRAFT_JS_INHIBIT(false, true, LanguageSystem.INPUT_JS_INHIBIT),
        CAR_MOD(false, false, LanguageSystem.INPUT_MOD),
        CAR_CAMLOCK(false, true, LanguageSystem.INPUT_CAMLOCK),
        CAR_TURN(true, false, LanguageSystem.INPUT_TURN),
        CAR_GAS(true, false, LanguageSystem.INPUT_GAS),
        CAR_BRAKE(true, false, LanguageSystem.INPUT_BRAKE),
        CAR_BRAKE_DIGITAL(false, false, LanguageSystem.INPUT_BRAKE),
        CAR_PANEL(false, true, LanguageSystem.INPUT_PANEL),
        CAR_SHIFT_U(false, true, LanguageSystem.INPUT_SHIFT_U),
        CAR_SHIFT_D(false, true, LanguageSystem.INPUT_SHIFT_D),
        CAR_SHIFT_1(false, false, LanguageSystem.INPUT_SHIFT_1),
        CAR_SHIFT_2(false, false, LanguageSystem.INPUT_SHIFT_2),
        CAR_SHIFT_3(false, false, LanguageSystem.INPUT_SHIFT_3),
        CAR_SHIFT_4(false, false, LanguageSystem.INPUT_SHIFT_4),
        CAR_SHIFT_5(false, false, LanguageSystem.INPUT_SHIFT_5),
        CAR_SHIFT_6(false, false, LanguageSystem.INPUT_SHIFT_6),
        CAR_SHIFT_7(false, false, LanguageSystem.INPUT_SHIFT_7),
        CAR_SHIFT_8(false, false, LanguageSystem.INPUT_SHIFT_8),
        CAR_SHIFT_9(false, false, LanguageSystem.INPUT_SHIFT_9),
        CAR_SHIFT_R(false, false, LanguageSystem.INPUT_SHIFT_R),
        CAR_HORN(false, false, LanguageSystem.INPUT_HORN),
        CAR_PARK(false, true, LanguageSystem.INPUT_PARK),
        CAR_RADIO(false, true, LanguageSystem.INPUT_RADIO),
        CAR_GUN_FIRE(false, false, LanguageSystem.INPUT_GUN_FIRE),
        CAR_GUN_SWITCH(false, true, LanguageSystem.INPUT_GUN_SWITCH),
        CAR_ZOOM_I(false, true, LanguageSystem.INPUT_ZOOM_I),
        CAR_ZOOM_O(false, true, LanguageSystem.INPUT_ZOOM_O),
        CAR_CHANGEVIEW(false, true, LanguageSystem.INPUT_CHANGEVIEW),
        CAR_LOOK_L(false, false, LanguageSystem.INPUT_LOOK_L),
        CAR_LOOK_R(false, false, LanguageSystem.INPUT_LOOK_R),
        CAR_LOOK_U(false, false, LanguageSystem.INPUT_LOOK_U),
        CAR_LOOK_D(false, false, LanguageSystem.INPUT_LOOK_D),
        CAR_LOOK_A(false, false, LanguageSystem.INPUT_LOOK_A),
        CAR_LIGHTS(false, true, LanguageSystem.INPUT_LIGHTS),
        CAR_TURNSIGNAL_L(false, true, LanguageSystem.INPUT_TURNSIGNAL_L),
        CAR_TURNSIGNAL_R(false, true, LanguageSystem.INPUT_TURNSIGNAL_R),
        CAR_JS_INHIBIT(false, true, LanguageSystem.INPUT_JS_INHIBIT);

        public final boolean isAxis;
        public final boolean isMomentary;
        public final String systemName;
        public final LanguageSystem.LanguageEntry language;
        public final JSONConfigClient.ConfigJoystick config;
        private boolean wasPressedLastCall;

        private ControlsJoystick(boolean isAxis, boolean isMomentary, LanguageSystem.LanguageEntry language) {
            this.isAxis = isAxis;
            this.isMomentary = isMomentary;
            this.systemName = this.name().toLowerCase(Locale.ROOT).replaceFirst("_", ".");
            this.language = language;
            this.config = ConfigSystem.client.controls.joystick.containsKey(this.systemName) ? ConfigSystem.client.controls.joystick.get(this.systemName) : new JSONConfigClient.ConfigJoystick();
        }

        public boolean isPressed() {
            if (this.isMomentary) {
                if (this.wasPressedLastCall) {
                    this.wasPressedLastCall = InterfaceManager.inputInterface.getJoystickButtonValue(this.config.joystickName, this.config.buttonIndex);
                    return false;
                }
                this.wasPressedLastCall = InterfaceManager.inputInterface.getJoystickButtonValue(this.config.joystickName, this.config.buttonIndex);
                return this.wasPressedLastCall;
            }
            return InterfaceManager.inputInterface.getJoystickButtonValue(this.config.joystickName, this.config.buttonIndex);
        }

        private float getMultistateValue() {
            return InterfaceManager.inputInterface.getJoystickAxisValue(this.config.joystickName, this.config.buttonIndex);
        }

        private double getAxisState(boolean ignoreDeadzone) {
            double pollValue = this.getMultistateValue();
            if (ignoreDeadzone || Math.abs(pollValue) > (Double)ConfigSystem.client.controlSettings.joystickDeadZone.value) {
                pollValue = Math.max(this.config.axisMinTravel, pollValue);
                pollValue = Math.min(this.config.axisMaxTravel, pollValue);
                pollValue = (pollValue - this.config.axisMinTravel) / (this.config.axisMaxTravel - this.config.axisMinTravel);
                if (this.config.invertedAxis) {
                    pollValue = 1.0 - pollValue;
                }
                return pollValue;
            }
            return Double.NaN;
        }

        public void setControl(String joystickName, int buttonIndex) {
            this.config.joystickName = joystickName;
            this.config.buttonIndex = buttonIndex;
            ConfigSystem.client.controls.joystick.put(this.systemName, this.config);
            ConfigSystem.saveToDisk();
        }

        public void setAxisControl(String joystickName, int buttonIndex, double axisMinTravel, double axisMaxTravel, boolean invertedAxis) {
            this.config.axisMinTravel = axisMinTravel;
            this.config.axisMaxTravel = axisMaxTravel;
            this.config.invertedAxis = invertedAxis;
            this.setControl(joystickName, buttonIndex);
        }

        public void clearControl() {
            this.setControl(null, 999);
        }
    }

    public static enum ControlsKeyboardDynamic {
        AIRCRAFT_PARK(ControlsKeyboard.AIRCRAFT_BRAKE, ControlsKeyboard.AIRCRAFT_MOD, LanguageSystem.INPUT_PARK),
        CAR_PARK(ControlsKeyboard.CAR_BRAKE, ControlsKeyboard.CAR_MOD, LanguageSystem.INPUT_PARK),
        CAR_SLOW(ControlsKeyboard.CAR_GAS, ControlsKeyboard.CAR_MOD, LanguageSystem.INPUT_SLOW),
        CAR_SHIFT_NU(ControlsKeyboard.CAR_SHIFT_U, ControlsKeyboard.CAR_MOD, LanguageSystem.INPUT_SHIFT_N),
        CAR_SHIFT_ND(ControlsKeyboard.CAR_SHIFT_D, ControlsKeyboard.CAR_MOD, LanguageSystem.INPUT_SHIFT_N);

        public final LanguageSystem.LanguageEntry language;
        public final ControlsKeyboard mainControl;
        public final ControlsKeyboard modControl;

        private ControlsKeyboardDynamic(ControlsKeyboard mainControl, ControlsKeyboard modControl, LanguageSystem.LanguageEntry language) {
            this.language = language;
            this.mainControl = mainControl;
            this.modControl = modControl;
        }

        public boolean isPressed() {
            return this.modControl.isPressed() && this.mainControl.isPressed();
        }
    }
}

