/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.sound;

import java.util.Random;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.instances.EntityRadio;
import minecrafttransportsimulator.jsondefs.JSONSound;

public class SoundInstance {
    private static final Random soundRandom = new Random();
    public final AEntityB_Existing entity;
    public final String soundName;
    public final String soundPlayingName;
    public final JSONSound soundDef;
    public final EntityRadio radio;
    public final Point3D position;
    public int sourceIndex;
    public float volume = 1.0f;
    public float pitch = 1.0f;
    public boolean stopSound = false;
    public static final int DEFAULT_MAX_DISTANCE = 32;

    public SoundInstance(AEntityB_Existing entity, String soundName) {
        this(entity, soundName, null, null);
    }

    public SoundInstance(AEntityB_Existing entity, JSONSound soundDef) {
        this(entity, soundDef.name, soundDef, null);
    }

    public SoundInstance(AEntityB_Existing entity, String soundName, JSONSound soundDef, EntityRadio radio) {
        this.entity = entity;
        this.soundDef = soundDef;
        this.soundName = soundName;
        this.soundPlayingName = soundDef != null && soundDef.soundVariations != null ? soundDef.soundVariations.get(soundRandom.nextInt(soundDef.soundVariations.size())) : soundName;
        this.radio = radio;
        this.position = new Point3D();
        this.updatePosition();
    }

    public void updatePosition() {
        if (this.soundDef != null && this.soundDef.pos != null) {
            this.position.set(this.soundDef.pos).rotate(this.entity.orientation).add(this.entity.position);
        } else {
            this.position.set(this.entity.position);
        }
    }
}

