/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.jsondefs.JSONLight;

public class RenderableVertices {
    public static final float Z_BUFFER_OFFSET = 2.0E-4f;
    public final String name;
    public final FloatBuffer vertices;
    public final boolean cacheVertices;
    public final boolean isTranslucent;
    public final boolean isLines;
    private static final List<List<BoxOffset>> FACE_POINT_INDEXES = Arrays.asList(Arrays.asList(BoxOffset.MINX_MINY_MINZ, BoxOffset.MINX_MINY_MAXZ, BoxOffset.MINX_MAXY_MAXZ, BoxOffset.MINX_MINY_MINZ, BoxOffset.MINX_MAXY_MAXZ, BoxOffset.MINX_MAXY_MINZ), Arrays.asList(BoxOffset.MAXX_MINY_MAXZ, BoxOffset.MAXX_MINY_MINZ, BoxOffset.MAXX_MAXY_MINZ, BoxOffset.MAXX_MINY_MAXZ, BoxOffset.MAXX_MAXY_MINZ, BoxOffset.MAXX_MAXY_MAXZ), Arrays.asList(BoxOffset.MAXX_MAXY_MINZ, BoxOffset.MINX_MAXY_MINZ, BoxOffset.MINX_MAXY_MAXZ, BoxOffset.MAXX_MAXY_MINZ, BoxOffset.MINX_MAXY_MAXZ, BoxOffset.MAXX_MAXY_MAXZ), Arrays.asList(BoxOffset.MAXX_MINY_MAXZ, BoxOffset.MINX_MINY_MAXZ, BoxOffset.MINX_MINY_MINZ, BoxOffset.MAXX_MINY_MAXZ, BoxOffset.MINX_MINY_MINZ, BoxOffset.MAXX_MINY_MINZ), Arrays.asList(BoxOffset.MAXX_MINY_MINZ, BoxOffset.MINX_MINY_MINZ, BoxOffset.MINX_MAXY_MINZ, BoxOffset.MAXX_MINY_MINZ, BoxOffset.MINX_MAXY_MINZ, BoxOffset.MAXX_MAXY_MINZ), Arrays.asList(BoxOffset.MINX_MINY_MAXZ, BoxOffset.MAXX_MINY_MAXZ, BoxOffset.MAXX_MAXY_MAXZ, BoxOffset.MINX_MINY_MAXZ, BoxOffset.MAXX_MAXY_MAXZ, BoxOffset.MINX_MAXY_MAXZ));
    private static final List<List<BoxOffset>> WIREFRAME_POINT_INDEXES = Arrays.asList(Arrays.asList(BoxOffset.MINX_MINY_MINZ, BoxOffset.MINX_MINY_MAXZ), Arrays.asList(BoxOffset.MAXX_MINY_MINZ, BoxOffset.MAXX_MINY_MAXZ), Arrays.asList(BoxOffset.MINX_MINY_MINZ, BoxOffset.MAXX_MINY_MINZ), Arrays.asList(BoxOffset.MINX_MINY_MAXZ, BoxOffset.MAXX_MINY_MAXZ), Arrays.asList(BoxOffset.MINX_MAXY_MINZ, BoxOffset.MINX_MAXY_MAXZ), Arrays.asList(BoxOffset.MAXX_MAXY_MINZ, BoxOffset.MAXX_MAXY_MAXZ), Arrays.asList(BoxOffset.MINX_MAXY_MINZ, BoxOffset.MAXX_MAXY_MINZ), Arrays.asList(BoxOffset.MINX_MAXY_MAXZ, BoxOffset.MAXX_MAXY_MAXZ), Arrays.asList(BoxOffset.MINX_MINY_MINZ, BoxOffset.MINX_MAXY_MINZ), Arrays.asList(BoxOffset.MINX_MINY_MAXZ, BoxOffset.MINX_MAXY_MAXZ), Arrays.asList(BoxOffset.MAXX_MINY_MINZ, BoxOffset.MAXX_MAXY_MINZ), Arrays.asList(BoxOffset.MAXX_MINY_MAXZ, BoxOffset.MAXX_MAXY_MAXZ));
    private static final float[][] FACE_NORMALS = new float[][]{{-1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, -1.0f}, {0.0f, 0.0f, 1.0f}};
    private static final int VERTEX_BUFFER_NX_OFFSET = 0;
    private static final int VERTEX_BUFFER_NY_OFFSET = 1;
    private static final int VERTEX_BUFFER_NZ_OFFSET = 2;
    private static final int VERTEX_BUFFER_U_OFFSET = 3;
    private static final int VERTEX_BUFFER_V_OFFSET = 4;
    private static final int VERTEX_BUFFER_X_OFFSET = 5;
    private static final int VERTEX_BUFFER_Y_OFFSET = 6;
    private static final int VERTEX_BUFFER_Z_OFFSET = 7;
    private static final int QUAD_TRI1_BOTTOM_RIGHT_INDEX = 0;
    private static final int QUAD_TRI1_TOP_RIGHT_INDEX = 1;
    private static final int QUAD_TRI1_TOP_LEFT_INDEX = 2;
    private static final int QUAD_TRI2_BOTTOM_RIGHT_INDEX = 3;
    private static final int QUAD_TRI2_TOP_LEFT_INDEX = 4;
    private static final int QUAD_TRI2_BOTTOM_LEFT_INDEX = 5;
    private static final int VERTEXES_PER_FACE = 3;
    private static final int FACES_PER_QUAD = 2;
    private static final int VERTEXES_PER_QUAD = 6;
    private static final int SIDES_PER_BOX = 6;
    private static final int FLOATS_PER_LINE = 6;
    private static final int FLOATS_PER_VERTEX = 8;
    private static final int FLOATS_PER_FACE = 24;
    private static final int FLOATS_PER_HOLGRAPHIC_BOX = 288;
    private static final int FLOATS_PER_WIREFRAME_BOX = 72;
    private static final int BEAM_CENTER_INDEX = 0;
    private static final int BEAM_OUTER1_INDEX = 1;
    private static final int BEAM_OUTER2_INDEX = 2;
    private static final int SIDES_PER_BEAM = 2;
    private static final int FACES_PER_BEAM = 40;
    private static final float BEAM_OFFSET = -0.15f;

    public RenderableVertices(String name, FloatBuffer vertexData, boolean cacheVertices) {
        this.name = name;
        this.vertices = vertexData;
        this.cacheVertices = cacheVertices;
        this.isTranslucent = name.toLowerCase(Locale.ROOT).contains("translucent");
        this.isLines = false;
    }

    public RenderableVertices(int numberLines) {
        this.name = "LINES";
        this.vertices = FloatBuffer.allocate(numberLines * 6);
        this.cacheVertices = false;
        this.isTranslucent = false;
        this.isLines = true;
    }

    public RenderableVertices(boolean holographic) {
        this.name = holographic ? "BOX_HOLOGRAPHIC" : "BOX_WIREFRAME";
        this.vertices = FloatBuffer.allocate(holographic ? 288 : 72);
        this.cacheVertices = false;
        this.isTranslucent = holographic;
        this.isLines = !holographic;
    }

    public static RenderableVertices createSprite(int spriteSegments, List<TransformationMatrix> transforms, List<Point3D> normals) {
        RenderableVertices vertexObject = new RenderableVertices("2D_TEXTURE", FloatBuffer.allocate(48 * spriteSegments), false);
        FloatBuffer vertices = vertexObject.vertices;
        for (int vertexIndex = 0; vertexIndex < 6 * spriteSegments; ++vertexIndex) {
            if (normals != null) {
                Point3D normal = normals.get(vertexIndex / 6);
                vertices.put((float)normal.x);
                vertices.put((float)normal.y);
                vertices.put((float)normal.z);
            } else {
                vertices.put(0.0f);
                vertices.put(0.0f);
                vertices.put(1.0f);
            }
            switch (vertexIndex % 6) {
                case 0: 
                case 3: {
                    vertices.put(1.0f);
                    vertices.put(1.0f);
                    vertices.put(0.5f);
                    vertices.put(-0.5f);
                    break;
                }
                case 1: {
                    vertices.put(1.0f);
                    vertices.put(0.0f);
                    vertices.put(0.5f);
                    vertices.put(0.5f);
                    break;
                }
                case 2: 
                case 4: {
                    vertices.put(0.0f);
                    vertices.put(0.0f);
                    vertices.put(-0.5f);
                    vertices.put(0.5f);
                    break;
                }
                case 5: {
                    vertices.put(0.0f);
                    vertices.put(1.0f);
                    vertices.put(-0.5f);
                    vertices.put(-0.5f);
                }
            }
            vertices.put(0.0f);
            if (transforms == null) continue;
            int xOffset = vertices.position() - 3;
            int yOffset = vertices.position() - 2;
            int zOffset = vertices.position() - 1;
            Point3D helperPoint = new Point3D(vertices.get(xOffset), vertices.get(yOffset), vertices.get(zOffset));
            helperPoint.transform(transforms.get(vertexIndex / 6));
            vertices.put(xOffset, (float)helperPoint.x);
            vertices.put(yOffset, (float)helperPoint.y);
            vertices.put(zOffset, (float)helperPoint.z);
        }
        vertices.flip();
        return vertexObject;
    }

    public static RenderableVertices createLightBeams(List<JSONLight.JSONLightBlendableComponent> beamDefs) {
        RenderableVertices vertexObject = new RenderableVertices("LIGHT_BEAMS", FloatBuffer.allocate(beamDefs.size() * 2 * 40 * 3 * 8), false);
        FloatBuffer vertices = vertexObject.vertices;
        for (JSONLight.JSONLightBlendableComponent beamDef : beamDefs) {
            RotationMatrix rotation = new RotationMatrix().setToVector(beamDef.axis, false);
            Point3D vertexOffset = new Point3D();
            Point3D centerOffset = beamDef.axis.copy().scale(-0.15f).add(beamDef.pos);
            for (int faceIndex = -40; faceIndex < 40; ++faceIndex) {
                for (int vertexIndex = 0; vertexIndex < 3; ++vertexIndex) {
                    float[] newVertex = new float[8];
                    newVertex[0] = 0.0f;
                    newVertex[1] = 0.0f;
                    newVertex[2] = 0.0f;
                    switch (vertexIndex) {
                        case 0: {
                            newVertex[3] = 0.0f;
                            newVertex[4] = 0.0f;
                            break;
                        }
                        case 1: {
                            newVertex[3] = 0.0f;
                            newVertex[4] = 1.0f;
                            break;
                        }
                        case 2: {
                            newVertex[3] = 1.0f;
                            newVertex[4] = 1.0f;
                        }
                    }
                    if (vertexIndex == 0) {
                        vertexOffset.set(0.0, 0.0, 0.0);
                    } else {
                        double currentAngleRad = faceIndex < 0 ? (vertexIndex == 1 ? Math.PI * 2 * ((double)(faceIndex + 1) / 40.0) : Math.PI * 2 * ((double)faceIndex / 40.0)) : (vertexIndex == 1 ? Math.PI * 2 * ((double)faceIndex / 40.0) : Math.PI * 2 * ((double)(faceIndex + 1) / 40.0));
                        vertexOffset.x = (double)(beamDef.beamDiameter / 2.0f) * Math.cos(currentAngleRad);
                        vertexOffset.y = (double)(beamDef.beamDiameter / 2.0f) * Math.sin(currentAngleRad);
                        vertexOffset.z = beamDef.beamLength;
                    }
                    vertexOffset.rotate(rotation).add(centerOffset);
                    newVertex[5] = (float)vertexOffset.x;
                    newVertex[6] = (float)vertexOffset.y;
                    newVertex[7] = (float)vertexOffset.z;
                    vertices.put(newVertex);
                }
            }
        }
        vertices.flip();
        return vertexObject;
    }

    public RenderableVertices createOverlay(float offset) {
        RenderableVertices offsetObject = new RenderableVertices(this.name + "_OVERLAY", FloatBuffer.allocate(this.vertices.capacity()), false);
        float[] vertexData = new float[8];
        while (this.vertices.hasRemaining()) {
            this.vertices.get(vertexData);
            offsetObject.vertices.put(vertexData, 0, 5);
            offsetObject.vertices.put(vertexData[5] + vertexData[0] * offset);
            offsetObject.vertices.put(vertexData[6] + vertexData[1] * offset);
            offsetObject.vertices.put(vertexData[7] + vertexData[2] * offset);
        }
        this.vertices.rewind();
        offsetObject.vertices.flip();
        offsetObject.setTextureBounds(0.0f, 1.0f, 0.0f, 1.0f);
        return offsetObject;
    }

    public RenderableVertices createBackface() {
        RenderableVertices backfaceObject = new RenderableVertices(this.name + "_BACKFACE", FloatBuffer.allocate(this.vertices.capacity()), this.cacheVertices);
        float[] vertexData = new float[8];
        for (int backfaceVertexIndex = this.vertices.capacity() - 8; backfaceVertexIndex >= 0; backfaceVertexIndex -= 8) {
            this.vertices.get(vertexData);
            backfaceObject.vertices.position(backfaceVertexIndex);
            backfaceObject.vertices.put(vertexData);
        }
        this.vertices.rewind();
        backfaceObject.vertices.position(0);
        backfaceObject.vertices.limit(this.vertices.limit());
        return backfaceObject;
    }

    public void addLine(Point3D point1, Point3D point2) {
        this.vertices.put((float)point1.x);
        this.vertices.put((float)point1.y);
        this.vertices.put((float)point1.z);
        this.vertices.put((float)point2.x);
        this.vertices.put((float)point2.y);
        this.vertices.put((float)point2.z);
        if (!this.vertices.hasRemaining()) {
            this.vertices.flip();
        }
    }

    public void setBoundingBox(BoundingBox box, boolean wireframe) {
        if (wireframe) {
            for (List<BoxOffset> indexes : WIREFRAME_POINT_INDEXES) {
                this.vertices.put(indexes.get(0).getEdgePoint(box));
                this.vertices.put(indexes.get(1).getEdgePoint(box));
            }
        } else {
            for (int boxSide = 0; boxSide < 6; ++boxSide) {
                for (int boxVertex = 0; boxVertex < 6; ++boxVertex) {
                    this.vertices.put(FACE_NORMALS[boxSide]);
                    this.vertices.put(0.0f);
                    this.vertices.put(0.0f);
                    this.vertices.put(RenderableVertices.FACE_POINT_INDEXES.get(boxSide).get(boxVertex).getEdgePoint(box));
                }
            }
            this.setTextureBounds(0.0f, 1.0f, 0.0f, 1.0f);
        }
        this.vertices.flip();
    }

    public void setTextureBounds(float u, float U, float v, float V) {
        int verticesInObject = this.vertices.capacity() / 8;
        block6: for (int vertexIndex = 0; vertexIndex < verticesInObject; ++vertexIndex) {
            switch (vertexIndex % 6) {
                case 0: 
                case 3: {
                    this.vertices.put(vertexIndex * 8 + 3, U);
                    this.vertices.put(vertexIndex * 8 + 4, V);
                    continue block6;
                }
                case 1: {
                    this.vertices.put(vertexIndex * 8 + 3, U);
                    this.vertices.put(vertexIndex * 8 + 4, v);
                    continue block6;
                }
                case 2: 
                case 4: {
                    this.vertices.put(vertexIndex * 8 + 3, u);
                    this.vertices.put(vertexIndex * 8 + 4, v);
                    continue block6;
                }
                case 5: {
                    this.vertices.put(vertexIndex * 8 + 3, u);
                    this.vertices.put(vertexIndex * 8 + 4, V);
                }
            }
        }
    }

    public void setSpriteProperties(int spriteIndex, int offsetX, int offsetY, int width, int height, float u, float v, float U, float V) {
        this.setSpritePropertiesAdvancedTexture(spriteIndex, offsetX, offsetY, width, height, u, v, u, V, U, V, U, v);
    }

    public void setSpritePropertiesAdvancedTexture(int spriteIndex, int offsetX, int offsetY, int width, int height, float u1, float v1, float u2, float v2, float u3, float v3, float u4, float v4) {
        block6: for (int vertexIndex = spriteIndex * 6; vertexIndex < (spriteIndex + 1) * 6; ++vertexIndex) {
            int quadVertexIndex = vertexIndex % 6;
            switch (quadVertexIndex) {
                case 0: 
                case 3: {
                    this.vertices.put(vertexIndex * 8 + 3, u3);
                    this.vertices.put(vertexIndex * 8 + 4, v3);
                    this.vertices.put(vertexIndex * 8 + 5, offsetX + width);
                    this.vertices.put(vertexIndex * 8 + 6, offsetY - height);
                    continue block6;
                }
                case 1: {
                    this.vertices.put(vertexIndex * 8 + 3, u4);
                    this.vertices.put(vertexIndex * 8 + 4, v4);
                    this.vertices.put(vertexIndex * 8 + 5, offsetX + width);
                    this.vertices.put(vertexIndex * 8 + 6, offsetY);
                    continue block6;
                }
                case 2: 
                case 4: {
                    this.vertices.put(vertexIndex * 8 + 3, u1);
                    this.vertices.put(vertexIndex * 8 + 4, v1);
                    this.vertices.put(vertexIndex * 8 + 5, offsetX);
                    this.vertices.put(vertexIndex * 8 + 6, offsetY);
                    continue block6;
                }
                case 5: {
                    this.vertices.put(vertexIndex * 8 + 3, u2);
                    this.vertices.put(vertexIndex * 8 + 4, v2);
                    this.vertices.put(vertexIndex * 8 + 5, offsetX);
                    this.vertices.put(vertexIndex * 8 + 6, offsetY - height);
                }
            }
        }
    }

    private static enum BoxOffset {
        MINX_MINY_MINZ(false, false, false),
        MINX_MINY_MAXZ(false, false, true),
        MINX_MAXY_MINZ(false, true, false),
        MINX_MAXY_MAXZ(false, true, true),
        MAXX_MINY_MINZ(true, false, false),
        MAXX_MINY_MAXZ(true, false, true),
        MAXX_MAXY_MINZ(true, true, false),
        MAXX_MAXY_MAXZ(true, true, true);

        private final boolean positiveX;
        private final boolean positiveY;
        private final boolean positiveZ;

        private BoxOffset(boolean positiveX, boolean positiveY, boolean positiveZ) {
            this.positiveX = positiveX;
            this.positiveY = positiveY;
            this.positiveZ = positiveZ;
        }

        private float[] getEdgePoint(BoundingBox box) {
            return new float[]{(float)(this.positiveX ? box.widthRadius : -box.widthRadius), (float)(this.positiveY ? box.heightRadius : -box.heightRadius), (float)(this.positiveZ ? box.depthRadius : -box.depthRadius)};
        }
    }
}

