/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import minecrafttransportsimulator.baseclasses.AnimationSwitchbox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONAnimatedObject;
import minecrafttransportsimulator.jsondefs.JSONLight;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.rendering.AModelParser;
import minecrafttransportsimulator.rendering.GIFParser;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.rendering.RenderableData;
import minecrafttransportsimulator.rendering.RenderableVertices;
import minecrafttransportsimulator.rendering.TreadRoller;
import minecrafttransportsimulator.systems.ConfigSystem;

public class RenderableModelObject {
    public final RenderableData renderable;
    private final boolean isWindow;
    private final boolean isOnlineTexture;
    private final JSONAnimatedObject objectDef;
    private final JSONLight lightDef;
    private final AnimationSwitchbox switchbox;
    private final RenderableData interiorWindowRenderable;
    private final RenderableData colorRenderable;
    private final RenderableData flareRenderable;
    private final RenderableData beamRenderable;
    private final RenderableData coverRenderable;
    private final List<Double[]> treadPoints;
    private static final TransformationMatrix treadPathBaseTransform = new TransformationMatrix();
    private static final RotationMatrix treadRotation = new RotationMatrix();
    private static final float COLOR_OFFSET = 2.0E-4f;
    private static final float FLARE_OFFSET = 4.0E-4f;
    private static final float COVER_OFFSET = 5.9999997E-4f;
    private final Set<String> downloadingTextures = new HashSet<String>();
    private final Set<String> downloadedTextures = new HashSet<String>();
    private static final String ERROR_TEXTURE_NAME = "ERROR";
    private static final Map<String, String> erroredTextures = new HashMap<String, String>();
    private static boolean errorTextureBound;

    public RenderableModelObject(AEntityD_Definable<?> entity, RenderableVertices vertexObject) {
        this.isWindow = vertexObject.name.toLowerCase(Locale.ROOT).contains("window");
        this.isOnlineTexture = vertexObject.name.toLowerCase(Locale.ROOT).startsWith("url") || vertexObject.name.toLowerCase(Locale.ROOT).endsWith("url");
        this.objectDef = entity.animatedObjectDefinitions.get(vertexObject.name);
        this.lightDef = entity.lightObjectDefinitions.get(vertexObject.name);
        this.switchbox = entity.animatedObjectSwitchboxes.get(vertexObject.name);
        if (this.isWindow) {
            this.renderable = new RenderableData(vertexObject, "mts:textures/rendering/glass.png");
            this.renderable.vertexObject.setTextureBounds(0.0f, 1.0f, 0.0f, 1.0f);
            this.interiorWindowRenderable = new RenderableData(vertexObject.createBackface(), "mts:textures/rendering/glass.png");
        } else {
            this.renderable = new RenderableData(vertexObject);
            this.interiorWindowRenderable = null;
        }
        if (this.lightDef != null) {
            this.colorRenderable = this.lightDef.emissive ? new RenderableData(vertexObject.createOverlay(2.0E-4f), "mts:textures/rendering/light.png") : null;
            if (this.lightDef.isBeam) {
                this.renderable.setTransucentOverride();
            }
            if (this.lightDef.blendableComponents != null && !this.lightDef.blendableComponents.isEmpty()) {
                ArrayList<JSONLight.JSONLightBlendableComponent> flareDefs = new ArrayList<JSONLight.JSONLightBlendableComponent>();
                ArrayList<JSONLight.JSONLightBlendableComponent> beamDefs = new ArrayList<JSONLight.JSONLightBlendableComponent>();
                for (JSONLight.JSONLightBlendableComponent component : this.lightDef.blendableComponents) {
                    if (component.flareHeight > 0.0f) {
                        flareDefs.add(component);
                    }
                    if (!(component.beamDiameter > 0.0f)) continue;
                    beamDefs.add(component);
                }
                if (!flareDefs.isEmpty()) {
                    ArrayList<TransformationMatrix> flareTransforms = new ArrayList<TransformationMatrix>();
                    ArrayList<Point3D> flareNormals = new ArrayList<Point3D>();
                    for (JSONLight.JSONLightBlendableComponent flareDef : flareDefs) {
                        TransformationMatrix transform = new TransformationMatrix();
                        transform.applyTranslation(flareDef.axis.copy().scale(4.0E-4f).add(flareDef.pos));
                        transform.applyRotation(new RotationMatrix().setToVector(flareDef.axis, false));
                        transform.applyScaling(flareDef.flareWidth, flareDef.flareHeight, 1.0);
                        flareTransforms.add(transform);
                        flareNormals.add(flareDef.axis);
                    }
                    this.flareRenderable = new RenderableData(RenderableVertices.createSprite(flareDefs.size(), flareTransforms, flareNormals), "mts:textures/rendering/lensflare.png");
                    this.flareRenderable.setTransucentOverride();
                } else {
                    this.flareRenderable = null;
                }
                if (!beamDefs.isEmpty()) {
                    this.beamRenderable = new RenderableData(RenderableVertices.createLightBeams(beamDefs), "mts:textures/rendering/lightbeam.png");
                    this.beamRenderable.setTransucentOverride();
                } else {
                    this.beamRenderable = null;
                }
            } else {
                this.flareRenderable = null;
                this.beamRenderable = null;
            }
            this.coverRenderable = this.lightDef.covered ? new RenderableData(this.renderable.vertexObject.createOverlay(5.9999997E-4f), "mts:textures/rendering/glass.png") : null;
        } else {
            this.colorRenderable = null;
            this.flareRenderable = null;
            this.beamRenderable = null;
            this.coverRenderable = null;
        }
        this.treadPoints = entity instanceof PartGroundDevice && ((JSONPart)((PartGroundDevice)entity).definition).ground.isTread && !((PartGroundDevice)entity).isSpare ? RenderableModelObject.generateTreads((PartGroundDevice)entity) : null;
        if (!errorTextureBound) {
            InterfaceManager.renderingInterface.bindURLTexture(ERROR_TEXTURE_NAME, null);
            errorTextureBound = true;
        }
    }

    public void render(AEntityD_Definable<?> entity, TransformationMatrix transform, boolean blendingEnabled, float partialTicks) {
        if (this.shouldRender(entity, blendingEnabled, partialTicks)) {
            float lightLevel;
            if (this.isOnlineTexture) {
                for (Map.Entry<JSONText, String> textEntry : entity.text.entrySet()) {
                    JSONText textDef = textEntry.getKey();
                    if (textDef.fieldName == null || !this.renderable.vertexObject.name.contains(textDef.fieldName)) continue;
                    String textValue = entity.text.get(textDef);
                    if (erroredTextures.containsKey(textValue)) {
                        textEntry.setValue(erroredTextures.get(textValue));
                    }
                    if (textValue.startsWith(ERROR_TEXTURE_NAME)) {
                        this.renderable.setTexture(ERROR_TEXTURE_NAME);
                        break;
                    }
                    if (this.downloadedTextures.contains(textValue)) {
                        this.renderable.setTexture(textValue);
                        break;
                    }
                    if (this.downloadingTextures.contains(textValue)) {
                        return;
                    }
                    if (textValue.isEmpty()) {
                        return;
                    }
                    new ConnectorThread(textValue, this).run();
                    this.downloadingTextures.add(textValue);
                    return;
                }
            } else if (!this.isWindow) {
                this.renderable.setTexture(entity.getTexture());
            }
            if (this.objectDef != null && this.objectDef.blendedAnimations && this.switchbox != null && this.switchbox.lastVisibilityClock != null) {
                if (this.switchbox.lastVisibilityValue < (double)this.switchbox.lastVisibilityClock.animation.clampMin) {
                    this.renderable.setAlpha(0.0f);
                } else if (this.switchbox.lastVisibilityValue >= (double)this.switchbox.lastVisibilityClock.animation.clampMax) {
                    this.renderable.setAlpha(1.0f);
                } else {
                    this.renderable.setAlpha((float)(this.switchbox.lastVisibilityValue - (double)this.switchbox.lastVisibilityClock.animation.clampMin) / (this.switchbox.lastVisibilityClock.animation.clampMax - this.switchbox.lastVisibilityClock.animation.clampMin));
                }
            }
            if (this.renderable.isTranslucent != blendingEnabled && this.lightDef == null) {
                return;
            }
            if (this.lightDef != null) {
                lightLevel = entity.lightBrightnessValues.get(this.lightDef).floatValue();
                AEntityD_Definable<?> masterEntity = entity;
                if (masterEntity instanceof APart) {
                    masterEntity = ((APart)masterEntity).masterEntity;
                }
                if (this.lightDef.isElectric && masterEntity instanceof EntityVehicleF_Physics) {
                    double electricPower = ((EntityVehicleF_Physics)masterEntity).electricPower;
                    if (electricPower < 3.0) {
                        lightLevel = 0.0f;
                    } else if (electricPower < 10.0) {
                        lightLevel = (float)((double)lightLevel * ((electricPower - 3.0) / 7.0));
                    }
                }
            } else {
                lightLevel = 0.0f;
            }
            this.renderable.transform.set(transform);
            if (this.switchbox != null) {
                this.renderable.transform.multiply(this.switchbox.netMatrix);
            }
            if (this.treadPoints != null) {
                this.renderable.setLightValue(entity.worldLightValue);
                this.doTreadRendering((PartGroundDevice)entity, partialTicks);
            } else if (this.renderable.isTranslucent == blendingEnabled) {
                if (this.lightDef != null && this.lightDef.isBeam) {
                    this.renderable.setLightValue(entity.worldLightValue);
                    this.renderable.setLightMode((Boolean)ConfigSystem.client.renderingSettings.brightLights.value != false ? RenderableData.LightingMode.IGNORE_ALL_LIGHTING : RenderableData.LightingMode.NORMAL);
                    this.renderable.setBlending((Boolean)ConfigSystem.client.renderingSettings.blendedLights.value);
                    this.renderable.setAlpha(Math.min((1.0f - entity.world.getLightBrightness(entity.position, false)) * lightLevel, 1.0f));
                    this.renderable.render();
                } else {
                    this.renderable.setLightValue(entity.worldLightValue);
                    this.renderable.setLightMode((Boolean)ConfigSystem.client.renderingSettings.brightLights.value != false && lightLevel > 0.0f && !this.lightDef.emissive && !this.lightDef.isBeam ? RenderableData.LightingMode.IGNORE_ALL_LIGHTING : RenderableData.LightingMode.NORMAL);
                    this.renderable.render();
                    if (this.interiorWindowRenderable != null && ((Boolean)ConfigSystem.client.renderingSettings.innerWindows.value).booleanValue()) {
                        this.interiorWindowRenderable.setLightValue(this.renderable.worldLightValue);
                        this.interiorWindowRenderable.transform.set(this.renderable.transform);
                        this.interiorWindowRenderable.render();
                    }
                }
            }
            if (this.lightDef != null && !this.lightDef.isBeam) {
                float blendableBrightness;
                ColorRGB color = entity.lightColorValues.get(this.lightDef);
                if (this.colorRenderable != null && lightLevel > 0.0f) {
                    this.colorRenderable.setAlpha(lightLevel);
                    if (blendingEnabled == this.colorRenderable.isTranslucent) {
                        this.colorRenderable.setLightValue(this.renderable.worldLightValue);
                        this.colorRenderable.setLightMode((Boolean)ConfigSystem.client.renderingSettings.brightLights.value != false ? RenderableData.LightingMode.IGNORE_ALL_LIGHTING : RenderableData.LightingMode.IGNORE_ORIENTATION_LIGHTING);
                        this.colorRenderable.setColor(color);
                        this.colorRenderable.transform.set(this.renderable.transform);
                        this.colorRenderable.render();
                    }
                }
                if (blendingEnabled && lightLevel > 0.0f && (blendableBrightness = Math.min((1.0f - entity.world.getLightBrightness(entity.position, false)) * lightLevel, 1.0f)) > 0.0f) {
                    if (this.flareRenderable != null) {
                        this.flareRenderable.setLightValue(this.renderable.worldLightValue);
                        this.flareRenderable.setLightMode((Boolean)ConfigSystem.client.renderingSettings.brightLights.value != false ? RenderableData.LightingMode.IGNORE_ALL_LIGHTING : RenderableData.LightingMode.NORMAL);
                        this.flareRenderable.setColor(color);
                        this.flareRenderable.setAlpha(blendableBrightness);
                        this.flareRenderable.transform.set(this.renderable.transform);
                        this.flareRenderable.render();
                    }
                    if (this.beamRenderable != null && entity.shouldRenderBeams()) {
                        this.beamRenderable.setLightValue(this.renderable.worldLightValue);
                        this.beamRenderable.setLightMode((Boolean)ConfigSystem.client.renderingSettings.brightLights.value != false ? RenderableData.LightingMode.IGNORE_ALL_LIGHTING : RenderableData.LightingMode.NORMAL);
                        this.beamRenderable.setBlending((Boolean)ConfigSystem.client.renderingSettings.blendedLights.value);
                        this.beamRenderable.setColor(color);
                        this.beamRenderable.setAlpha(blendableBrightness);
                        this.beamRenderable.transform.set(this.renderable.transform);
                        this.beamRenderable.render();
                    }
                }
                if (!blendingEnabled && this.coverRenderable != null) {
                    this.coverRenderable.setLightValue(this.renderable.worldLightValue);
                    this.coverRenderable.setLightMode((Boolean)ConfigSystem.client.renderingSettings.brightLights.value != false && lightLevel > 0.0f ? RenderableData.LightingMode.IGNORE_ALL_LIGHTING : RenderableData.LightingMode.NORMAL);
                    this.coverRenderable.transform.set(this.renderable.transform);
                    this.coverRenderable.render();
                }
            }
            if (!blendingEnabled) {
                for (Map.Entry<JSONText, String> textEntry : entity.text.entrySet()) {
                    JSONText textDef = textEntry.getKey();
                    if (!this.renderable.vertexObject.name.equals(textDef.attachedTo)) continue;
                    RenderText.draw3DText(textEntry.getValue(), entity, this.renderable.transform, textDef, false);
                }
            }
        }
    }

    public void destroy() {
        this.renderable.destroy();
    }

    private boolean shouldRender(AEntityD_Definable<?> entity, boolean blendingEnabled, float partialTicks) {
        if (this.treadPoints != null && blendingEnabled) {
            return false;
        }
        if (this.isWindow && !((Boolean)ConfigSystem.client.renderingSettings.renderWindows.value).booleanValue()) {
            return false;
        }
        if (this.switchbox != null) {
            if (this.objectDef.blendedAnimations) {
                this.switchbox.runSwitchbox(partialTicks, false);
            } else {
                return this.switchbox.runSwitchbox(partialTicks, false);
            }
        }
        return true;
    }

    private void doTreadRendering(PartGroundDevice tread, float partialTicks) {
        float treadLinearPosition = (float)(tread.getRawVariableValue("ground_rotation", partialTicks) / 360.0);
        float treadMovementPercentage = treadLinearPosition % ((JSONPart)tread.definition).ground.spacing / ((JSONPart)tread.definition).ground.spacing;
        if (treadMovementPercentage < 0.0f) {
            treadMovementPercentage += 1.0f;
        }
        if (!(tread.entityOn instanceof APart)) {
            this.renderable.transform.applyTranslation(0.0, -tread.localOffset.y, -tread.localOffset.z);
        }
        Double[] point = this.treadPoints.get(0);
        this.renderable.transform.applyTranslation(0.0, point[0], point[1]);
        boolean[] renderIndexes = null;
        if (((JSONPart)tread.definition).ground.treadOrder != null) {
            double treadCycleTotalDistance;
            int treadCycleCount = ((JSONPart)tread.definition).ground.treadOrder.size();
            int treadCycleIndex = (int)Math.floor((double)treadCycleCount * ((double)treadLinearPosition % (treadCycleTotalDistance = (double)((float)treadCycleCount * ((JSONPart)tread.definition).ground.spacing)) / treadCycleTotalDistance));
            if (treadCycleIndex < 0) {
                treadCycleIndex += treadCycleCount;
            }
            renderIndexes = new boolean[treadCycleCount];
            for (int i = 0; i < treadCycleCount; ++i) {
                String treadObject = ((JSONPart)tread.definition).ground.treadOrder.get(i);
                renderIndexes[(i + treadCycleIndex) % treadCycleCount] = treadObject.equals(this.renderable.vertexObject.name);
            }
        }
        for (int i = 0; i < this.treadPoints.size() - 1; ++i) {
            double angleDelta;
            Double[] nextPoint;
            point = this.treadPoints.get(i);
            if (i == this.treadPoints.size() - 1) {
                nextPoint = this.treadPoints.get(0);
                angleDelta = nextPoint[2] + 360.0 - point[2];
            } else {
                nextPoint = this.treadPoints.get(i + 1);
                angleDelta = nextPoint[2] - point[2];
            }
            double yDelta = nextPoint[0] - point[0];
            double zDelta = nextPoint[1] - point[1];
            if (angleDelta > 180.0) {
                angleDelta -= 360.0;
            } else if (angleDelta < -180.0) {
                angleDelta += 360.0;
            }
            if (renderIndexes != null && !renderIndexes[i % renderIndexes.length]) {
                this.renderable.transform.applyTranslation(0.0, yDelta, zDelta);
                continue;
            }
            this.renderable.transform.applyTranslation(0.0, yDelta * (double)treadMovementPercentage, zDelta * (double)treadMovementPercentage);
            if (point[2] != 0.0 || angleDelta != 0.0) {
                treadPathBaseTransform.set(this.renderable.transform);
                treadRotation.setToAxisAngle(1.0, 0.0, 0.0, point[2] + angleDelta * (double)treadMovementPercentage);
                this.renderable.transform.applyRotation(treadRotation);
                this.renderable.render();
                this.renderable.transform.set(treadPathBaseTransform);
            } else {
                this.renderable.render();
            }
            this.renderable.transform.applyTranslation(0.0, yDelta * (double)(1.0f - treadMovementPercentage), zDelta * (double)(1.0f - treadMovementPercentage));
        }
    }

    private static <TreadEntity extends AEntityD_Definable<?>> List<Double[]> generateTreads(PartGroundDevice tread) {
        int i;
        List<RenderableVertices> parsedModel = AModelParser.parseModel(((AJSONPartProvider)tread.entityOn.definition).getModelLocation((JSONSubDefinition)((AJSONPartProvider)tread.entityOn.definition).definitions.get(0)), true);
        ArrayList<TreadRoller> rollers = new ArrayList<TreadRoller>();
        if (tread.placementDefinition.treadPath == null) {
            throw new IllegalArgumentException("No tread path found for part slot on " + tread.entityOn + "!");
        }
        for (String rollerName : tread.placementDefinition.treadPath) {
            boolean foundRoller = false;
            for (RenderableVertices modelObject : parsedModel) {
                if (!modelObject.name.equals(rollerName)) continue;
                rollers.add(new TreadRoller(modelObject));
                foundRoller = true;
                break;
            }
            if (foundRoller) continue;
            throw new IllegalArgumentException("Could not create tread path for " + tread.entityOn + " Due to missing roller " + rollerName + " in the model!");
        }
        for (i = 0; i < rollers.size(); ++i) {
            if (i < rollers.size() - 1) {
                ((TreadRoller)rollers.get(i)).calculateEndpoints((TreadRoller)rollers.get(i + 1));
                continue;
            }
            ((TreadRoller)rollers.get(i)).calculateEndpoints((TreadRoller)rollers.get(0));
        }
        ((TreadRoller)rollers.get(0)).setEndAngle(180.0);
        for (i = 1; i < rollers.size(); ++i) {
            TreadRoller roller = (TreadRoller)rollers.get(i);
            TreadRoller priorRoller = (TreadRoller)rollers.get(i - 1);
            double d = roller.startAngle = i == 1 ? 180.0 : priorRoller.endAngle;
            while (roller.endAngle < roller.startAngle - 30.0) {
                roller.endAngle += 360.0;
            }
            while (roller.endAngle > roller.startAngle + 330.0) {
                roller.endAngle -= 360.0;
            }
            if (roller.endAngle < roller.startAngle) {
                double midPoint;
                roller.startAngle = midPoint = roller.endAngle + (roller.startAngle - roller.endAngle) / 2.0;
                roller.endAngle = midPoint;
            }
            roller.setStartAngle(roller.startAngle);
            roller.setEndAngle(roller.endAngle);
        }
        ((TreadRoller)rollers.get(0)).setStartAngle(((TreadRoller)rollers.get((int)(rollers.size() - 1))).endAngle);
        double totalPathLength = 0.0;
        for (int i2 = 0; i2 < rollers.size(); ++i2) {
            TreadRoller roller = (TreadRoller)rollers.get(i2);
            double angleDelta = roller.endAngle - roller.startAngle;
            if (i2 == 0) {
                angleDelta += 360.0;
            }
            totalPathLength += Math.PI * 2 * roller.radius * angleDelta / 360.0;
            TreadRoller nextRoller = i2 == rollers.size() - 1 ? (TreadRoller)rollers.get(0) : (TreadRoller)rollers.get(i2 + 1);
            double straightPathLength = Math.hypot(nextRoller.startY - roller.endY, nextRoller.startZ - roller.endZ);
            if (tread.placementDefinition.treadDroopConstant > 0.0f && (roller.endAngle % 360.0 < 10.0 || roller.endAngle % 360.0 > 350.0) && (nextRoller.startAngle % 360.0 < 10.0 || nextRoller.startAngle % 360.0 > 350.0)) {
                totalPathLength += 2.0 * (double)tread.placementDefinition.treadDroopConstant * Math.sinh(straightPathLength / 2.0 / (double)tread.placementDefinition.treadDroopConstant);
                continue;
            }
            totalPathLength += straightPathLength;
        }
        double deltaDist = (double)((JSONPart)tread.definition).ground.spacing + totalPathLength % (double)((JSONPart)tread.definition).ground.spacing / (totalPathLength / (double)((JSONPart)tread.definition).ground.spacing);
        double leftoverPathLength = 0.0;
        double yPoint = 0.0;
        double zPoint = 0.0;
        ArrayList<Double[]> points = new ArrayList<Double[]>();
        for (int i3 = 0; i3 < rollers.size(); ++i3) {
            TreadRoller roller = (TreadRoller)rollers.get(i3);
            double currentAngle = roller.startAngle;
            double angleDelta = roller.endAngle - roller.startAngle;
            if (i3 == 0) {
                angleDelta += 360.0;
            }
            double rollerPathLength = Math.PI * 2 * roller.radius * angleDelta / 360.0;
            if (i3 == 0) {
                yPoint = roller.centerPoint.y + roller.radius * Math.cos(Math.toRadians(currentAngle));
                zPoint = roller.centerPoint.z + roller.radius * Math.sin(Math.toRadians(currentAngle));
                points.add(new Double[]{yPoint, zPoint, currentAngle + 180.0});
            }
            if (deltaDist - leftoverPathLength < rollerPathLength) {
                if (leftoverPathLength > 0.0) {
                    currentAngle -= 360.0 * leftoverPathLength / roller.circumference;
                    rollerPathLength += leftoverPathLength;
                    leftoverPathLength = 0.0;
                }
                while (rollerPathLength > deltaDist) {
                    rollerPathLength -= deltaDist;
                    yPoint = roller.centerPoint.y + roller.radius * Math.cos(Math.toRadians(currentAngle += 360.0 * (deltaDist / roller.circumference)));
                    zPoint = roller.centerPoint.z + roller.radius * Math.sin(Math.toRadians(currentAngle));
                    points.add(new Double[]{yPoint, zPoint, currentAngle + 180.0});
                }
            }
            currentAngle = roller.endAngle;
            TreadRoller nextRoller = i3 == rollers.size() - 1 ? (TreadRoller)rollers.get(0) : (TreadRoller)rollers.get(i3 + 1);
            double straightPathLength = Math.hypot(nextRoller.startY - roller.endY, nextRoller.startZ - roller.endZ);
            double extraPathLength = rollerPathLength + leftoverPathLength;
            double normalizedY = (nextRoller.startY - roller.endY) / straightPathLength;
            double normalizedZ = (nextRoller.startZ - roller.endZ) / straightPathLength;
            if (tread.placementDefinition.treadDroopConstant > 0.0f && (roller.endAngle % 360.0 < 10.0 || roller.endAngle % 360.0 > 350.0) && (nextRoller.startAngle % 360.0 < 10.0 || nextRoller.startAngle % 360.0 > 350.0)) {
                double catenaryPathLength = 2.0 * (double)tread.placementDefinition.treadDroopConstant * Math.sinh(straightPathLength / 2.0 / (double)tread.placementDefinition.treadDroopConstant);
                double catenaryPathEdgeY = (double)tread.placementDefinition.treadDroopConstant * Math.cosh(straightPathLength / 2.0 / (double)tread.placementDefinition.treadDroopConstant);
                double catenaryFunctionCurrent = -catenaryPathLength / 2.0;
                double startingCatenaryPathLength = catenaryPathLength;
                while (catenaryPathLength + extraPathLength > deltaDist) {
                    if (extraPathLength > 0.0) {
                        catenaryFunctionCurrent += deltaDist - extraPathLength;
                        catenaryPathLength -= deltaDist - extraPathLength;
                        extraPathLength = 0.0;
                    } else {
                        catenaryFunctionCurrent += deltaDist;
                        catenaryPathLength -= deltaDist;
                    }
                    double value = catenaryFunctionCurrent / (double)tread.placementDefinition.treadDroopConstant;
                    double arcSin = catenaryFunctionCurrent == 0.0 ? 0.0 : Math.log(value + Math.sqrt(value * value + 1.0));
                    double catenaryFunctionPercent = (catenaryFunctionCurrent + startingCatenaryPathLength / 2.0) / startingCatenaryPathLength;
                    double catenaryPointZ = (double)tread.placementDefinition.treadDroopConstant * arcSin;
                    double catenaryPointY = (double)tread.placementDefinition.treadDroopConstant * Math.cosh(catenaryPointZ / (double)tread.placementDefinition.treadDroopConstant);
                    yPoint = roller.endY + normalizedY * catenaryFunctionPercent + catenaryPointY - catenaryPathEdgeY;
                    zPoint = roller.endZ + catenaryPointZ + straightPathLength / 2.0;
                    points.add(new Double[]{yPoint, zPoint, currentAngle + 180.0 - Math.toDegrees(Math.asin(catenaryFunctionCurrent / (double)tread.placementDefinition.treadDroopConstant))});
                }
                leftoverPathLength = catenaryPathLength;
                continue;
            }
            while (straightPathLength + extraPathLength > deltaDist) {
                if (extraPathLength > 0.0) {
                    yPoint = roller.endY + normalizedY * (deltaDist - extraPathLength);
                    zPoint = roller.endZ + normalizedZ * (deltaDist - extraPathLength);
                    straightPathLength -= deltaDist - extraPathLength;
                    extraPathLength = 0.0;
                } else {
                    yPoint += normalizedY * deltaDist;
                    zPoint += normalizedZ * deltaDist;
                    straightPathLength -= deltaDist;
                }
                points.add(new Double[]{yPoint, zPoint, currentAngle + 180.0});
            }
            leftoverPathLength = straightPathLength;
        }
        return points;
    }

    private static class ConnectorThread
    extends Thread {
        private final String urlString;
        private final RenderableModelObject objectOn;

        public ConnectorThread(String urlString, RenderableModelObject objectOn) {
            this.urlString = urlString;
            this.objectOn = objectOn;
        }

        @Override
        public void run() {
            int tryCount = 0;
            String errorString = null;
            do {
                try {
                    URL urlObject = new URL(this.urlString);
                    HttpURLConnection connection = (HttpURLConnection)urlObject.openConnection();
                    try {
                        connection.connect();
                        String contentType = connection.getContentType();
                        String[] typeParams = contentType.split("/");
                        if (typeParams[0].equals("text")) {
                            errorString = "ERROR: Found only text at the URL.  This is not a direct image link, or you don't have permission to view this image (hosted behind a login).";
                            continue;
                        }
                        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(typeParams[1]);
                        if (iterator.hasNext()) {
                            ImageReader reader = iterator.next();
                            if (typeParams[1].equals("gif")) {
                                ImageInputStream stream = ImageIO.createImageInputStream(connection.getInputStream());
                                reader.setInput(stream);
                                GIFParser.ParsedGIF gif = GIFParser.parseGIF(reader);
                                if (gif != null) {
                                    if (InterfaceManager.renderingInterface.bindURLGIF(this.urlString, gif)) {
                                        this.objectOn.downloadedTextures.add(this.urlString);
                                        this.objectOn.downloadingTextures.remove(this.urlString);
                                        return;
                                    }
                                    errorString = "ERROR: Could not parse GIF due to an internal MC-system interface error.  Contact the mod author!";
                                    continue;
                                }
                                errorString = "ERROR: Could not parse GIF due to no frames being present.  Is this a real direct link or a fake one?";
                                continue;
                            }
                            if (InterfaceManager.renderingInterface.bindURLTexture(this.urlString, connection.getInputStream())) {
                                this.objectOn.downloadedTextures.add(this.urlString);
                                this.objectOn.downloadingTextures.remove(this.urlString);
                                return;
                            }
                            errorString = "ERROR: Got a correct image type, but was missing data for the image?  Likely partial data sent by the server source, try again later.";
                            continue;
                        }
                        errorString = "ERROR: Invalid content type found.  Found:" + contentType + ", but the only valid types are: ";
                        for (String imageSuffix : ImageIO.getReaderFileSuffixes()) {
                            errorString = errorString + "image/" + imageSuffix + ", ";
                        }
                    }
                    catch (Exception e) {
                        errorString = "ERROR: Could not parse images.  Error was: " + e.getMessage();
                    }
                }
                catch (Exception e) {
                    errorString = "ERROR: Could not open URL for processing.  Error was: " + e.getMessage();
                }
            } while (++tryCount < 10);
            InterfaceManager.renderingInterface.bindURLTexture(this.urlString, null);
            erroredTextures.put(this.urlString, errorString);
            this.objectOn.downloadingTextures.remove(this.urlString);
            this.objectOn.downloadedTextures.add(this.urlString);
        }
    }
}

