/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import minecrafttransportsimulator.baseclasses.AnimationSwitchbox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONInstrumentDefinition;
import minecrafttransportsimulator.rendering.DurationDelayClock;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.rendering.RenderableData;
import minecrafttransportsimulator.systems.ConfigSystem;

public final class RenderInstrument {
    private static int partNumber = 0;
    private static RenderableData renderable = null;
    private static final TransformationMatrix textTransform = new TransformationMatrix();
    private static final Point3D textureCoord1 = new Point3D();
    private static final Point3D textureCoord2 = new Point3D();
    private static final Point3D textureCoord3 = new Point3D();
    private static final Point3D textureCoord4 = new Point3D();
    private static final RotationMatrix helperRotation = new RotationMatrix();
    private static final RotationMatrix helperRotationMatrix = new RotationMatrix();

    public static void drawInstrument(AEntityE_Interactable<?> entity, TransformationMatrix transform, int slot, boolean onGUI, boolean blendingEnabled, float partialTicks) {
        ItemInstrument instrument = entity.instruments.get(slot);
        JSONInstrumentDefinition slotDefinition = ((AJSONInteractableEntity)entity.definition).instruments.get(slot);
        boolean lightsOn = entity.renderTextLit();
        float slotScale = onGUI ? slotDefinition.hudScale : slotDefinition.scale;
        partNumber = slotDefinition.optionalPartNumber;
        for (int i = 0; i < ((JSONInstrument)instrument.definition).components.size(); ++i) {
            JSONInstrument.JSONInstrumentComponent component = ((JSONInstrument)instrument.definition).components.get(i);
            if (component.overlayTexture != blendingEnabled) continue;
            if (component.textObject != null) {
                boolean addSuffix;
                textTransform.set(transform);
                textTransform.applyTranslation(0.0, 0.0, (float)i * 2.0E-4f);
                double totalScaling = slotScale * component.scale;
                textTransform.applyScaling(totalScaling, totalScaling, totalScaling);
                InstrumentSwitchbox switchbox = entity.instrumentComponentSwitchboxes.get(component);
                if (switchbox != null && !switchbox.runSwitchbox(partialTicks, true)) continue;
                int variablePartNumber = AEntityF_Multipart.getVariableNumber(component.textObject.variableName);
                boolean bl = addSuffix = variablePartNumber == -1 && (component.textObject.variableName.startsWith("engine_") || component.textObject.variableName.startsWith("propeller_") || component.textObject.variableName.startsWith("gun_") || component.textObject.variableName.startsWith("seat_"));
                if (addSuffix) {
                    String oldName = component.textObject.variableName;
                    component.textObject.variableName = component.textObject.variableName + "_" + partNumber;
                    RenderText.draw3DText(entity.getAnimatedTextVariableValue(component.textObject, partialTicks), entity, textTransform, component.textObject, true);
                    component.textObject.variableName = oldName;
                    continue;
                }
                RenderText.draw3DText(entity.getAnimatedTextVariableValue(component.textObject, partialTicks), entity, textTransform, component.textObject, true);
                continue;
            }
            renderable = entity.instrumentRenderables.get(slot).get(i);
            renderable.setTexture("/assets/" + ((JSONInstrument)instrument.definition).packID + "/textures/" + ((JSONInstrument)instrument.definition).textureName);
            RenderInstrument.renderable.transform.set(transform);
            RenderInstrument.renderable.transform.applyTranslation(0.0, 0.0, (float)i * 2.0E-4f);
            RenderInstrument.renderable.transform.applyScaling(slotScale, slotScale, slotScale);
            textureCoord1.set((double)(-component.textureWidth) / 2.0, (double)(-component.textureHeight) / 2.0, 0.0);
            textureCoord2.set((double)(-component.textureWidth) / 2.0, (double)component.textureHeight / 2.0, 0.0);
            textureCoord3.set((double)component.textureWidth / 2.0, (double)component.textureHeight / 2.0, 0.0);
            textureCoord4.set((double)component.textureWidth / 2.0, (double)(-component.textureHeight) / 2.0, 0.0);
            InstrumentSwitchbox switchbox = entity.instrumentComponentSwitchboxes.get(component);
            if (switchbox != null && !switchbox.runSwitchbox(partialTicks, true)) continue;
            textureCoord1.add(component.textureXCenter, component.textureYCenter, 0.0).scale(9.765625E-4);
            textureCoord2.add(component.textureXCenter, component.textureYCenter, 0.0).scale(9.765625E-4);
            textureCoord3.add(component.textureXCenter, component.textureYCenter, 0.0).scale(9.765625E-4);
            textureCoord4.add(component.textureXCenter, component.textureYCenter, 0.0).scale(9.765625E-4);
            RenderInstrument.renderable.transform.applyTranslation(component.xCenter, -component.yCenter, 0.0);
            RenderInstrument.renderable.transform.applyScaling(component.scale, component.scale, component.scale);
            renderable.setLightValue(entity.worldLightValue);
            if (component.lightUpTexture && lightsOn && ((Boolean)ConfigSystem.client.renderingSettings.brightLights.value).booleanValue()) {
                renderable.setLightMode(RenderableData.LightingMode.IGNORE_ALL_LIGHTING);
            } else {
                renderable.setLightMode(onGUI ? RenderableData.LightingMode.IGNORE_ORIENTATION_LIGHTING : RenderableData.LightingMode.NORMAL);
            }
            RenderInstrument.renderable.vertexObject.setSpritePropertiesAdvancedTexture(0, -component.textureWidth / 2, component.textureHeight / 2, component.textureWidth, component.textureHeight, (float)RenderInstrument.textureCoord1.x, (float)RenderInstrument.textureCoord1.y, (float)RenderInstrument.textureCoord2.x, (float)RenderInstrument.textureCoord2.y, (float)RenderInstrument.textureCoord3.x, (float)RenderInstrument.textureCoord3.y, (float)RenderInstrument.textureCoord4.x, (float)RenderInstrument.textureCoord4.y);
            if (component.overlayTexture) {
                renderable.setTransucentOverride();
            }
            renderable.render();
        }
    }

    public static class InstrumentSwitchbox
    extends AnimationSwitchbox {
        private final JSONInstrument.JSONInstrumentComponent component;

        public InstrumentSwitchbox(AEntityD_Definable<?> entity, JSONInstrument.JSONInstrumentComponent component) {
            super(entity, component.animations, null);
            this.component = component;
        }

        private String convertAnimationPartNumber(DurationDelayClock clock) {
            boolean addSuffix;
            int variablePartNumber = AEntityF_Multipart.getVariableNumber(clock.animation.variable);
            boolean bl = addSuffix = variablePartNumber == -1 && !(this.entity instanceof APart) && (clock.animation.variable.startsWith("engine_") || clock.animation.variable.startsWith("propeller_") || clock.animation.variable.startsWith("gun_") || clock.animation.variable.startsWith("seat_"));
            if (partNumber == 0 && addSuffix) {
                partNumber = 1;
            }
            String oldVariable = clock.animation.variable;
            if (partNumber != 0) {
                clock.animation.variable = clock.animation.variable + "_" + partNumber;
            }
            return oldVariable;
        }

        @Override
        public void runTranslation(DurationDelayClock clock, float partialTicks) {
            String oldVariable = this.convertAnimationPartNumber(clock);
            double xTranslation = this.entity.getAnimatedVariableValue(clock, clock.animation.axis.x, partialTicks);
            double yTranslation = this.entity.getAnimatedVariableValue(clock, clock.animation.axis.y, partialTicks);
            clock.animation.variable = oldVariable;
            if (this.component.extendWindow) {
                if (clock.animation.axis.x < 0.0) {
                    textureCoord1.x += xTranslation;
                    textureCoord2.x += xTranslation;
                } else if (clock.animation.axis.x > 0.0) {
                    textureCoord3.x += xTranslation;
                    textureCoord4.x += xTranslation;
                }
                if (clock.animation.axis.y < 0.0) {
                    textureCoord1.y += yTranslation;
                    textureCoord4.y += yTranslation;
                } else if (clock.animation.axis.y > 0.0) {
                    textureCoord2.y += yTranslation;
                    textureCoord3.y += yTranslation;
                }
            } else if (this.component.moveComponent) {
                renderable.transform.applyTranslation(xTranslation, yTranslation, 0.0);
            } else if (this.component.textObject != null) {
                textTransform.applyTranslation(xTranslation, yTranslation, 0.0);
            } else {
                if (clock.animation.axis.x != 0.0) {
                    textureCoord1.y += xTranslation;
                    textureCoord2.y += xTranslation;
                    textureCoord3.y += xTranslation;
                    textureCoord4.y += xTranslation;
                }
                if (clock.animation.axis.y != 0.0) {
                    textureCoord1.y += yTranslation;
                    textureCoord2.y += yTranslation;
                    textureCoord3.y += yTranslation;
                    textureCoord4.y += yTranslation;
                }
            }
        }

        @Override
        public void runRotation(DurationDelayClock clock, float partialTicks) {
            String oldVariable = this.convertAnimationPartNumber(clock);
            double variableValue = -this.entity.getAnimatedVariableValue(clock, clock.animation.axis.z, partialTicks);
            clock.animation.variable = oldVariable;
            if (this.component.rotateWindow) {
                textureCoord1.add(clock.animation.centerPoint);
                textureCoord2.add(clock.animation.centerPoint);
                textureCoord3.add(clock.animation.centerPoint);
                textureCoord4.add(clock.animation.centerPoint);
                helperRotation.angles.set(0.0, 0.0, variableValue);
                textureCoord1.rotate(helperRotation);
                textureCoord2.rotate(helperRotation);
                textureCoord3.rotate(helperRotation);
                textureCoord4.rotate(helperRotation);
                textureCoord1.subtract(clock.animation.centerPoint);
                textureCoord2.subtract(clock.animation.centerPoint);
                textureCoord3.subtract(clock.animation.centerPoint);
                textureCoord4.subtract(clock.animation.centerPoint);
            } else if (this.component.textObject != null) {
                textTransform.applyTranslation((double)this.component.xCenter + clock.animation.centerPoint.x, -((double)this.component.yCenter + clock.animation.centerPoint.y), 0.0);
                helperRotationMatrix.setToAxisAngle(0.0, 0.0, 1.0, variableValue);
                textTransform.applyRotation(helperRotationMatrix);
                textTransform.applyTranslation(-((double)this.component.xCenter + clock.animation.centerPoint.x), (double)this.component.yCenter + clock.animation.centerPoint.y, 0.0);
            } else {
                renderable.transform.applyTranslation((double)this.component.xCenter + clock.animation.centerPoint.x, -((double)this.component.yCenter + clock.animation.centerPoint.y), 0.0);
                helperRotationMatrix.setToAxisAngle(0.0, 0.0, 1.0, variableValue);
                renderable.transform.applyRotation(helperRotationMatrix);
                renderable.transform.applyTranslation(-((double)this.component.xCenter + clock.animation.centerPoint.x), (double)this.component.yCenter + clock.animation.centerPoint.y, 0.0);
            }
        }
    }
}

