/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.items.instances.ItemPoleComponent;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;

public class PacketTileEntityPoleChange
extends APacketEntityInteract<TileEntityPole, IWrapperPlayer> {
    private final ABlockBase.Axis axis;
    private final IWrapperNBT data;

    public PacketTileEntityPoleChange(TileEntityPole pole, IWrapperPlayer player, ABlockBase.Axis axis, IWrapperNBT data) {
        super(pole, player);
        this.axis = axis;
        this.data = data;
    }

    public PacketTileEntityPoleChange(ByteBuf buf) {
        super(buf);
        this.axis = ABlockBase.Axis.values()[buf.readByte()];
        this.data = buf.readBoolean() ? PacketTileEntityPoleChange.readDataFromBuffer(buf) : null;
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.axis.ordinal());
        if (this.data != null) {
            buf.writeBoolean(true);
            PacketTileEntityPoleChange.writeDataToBuffer(this.data, buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    protected boolean handle(AWrapperWorld world, TileEntityPole pole, IWrapperPlayer player) {
        if (this.data != null) {
            pole.changeComponent(this.axis, ItemPoleComponent.PoleComponentType.createComponent(pole, player, this.axis, (ItemPoleComponent)this.data.getPackItem(), this.data));
        } else {
            pole.changeComponent(this.axis, null);
        }
        return false;
    }
}

