/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.blocks.tileentities.instances.ATileEntityFuelPump;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.instances.GUIFuelPump;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;

public class PacketTileEntityFuelPumpDispense
extends APacketEntityInteract<ATileEntityFuelPump, IWrapperPlayer> {
    private final int slotClicked;
    private final int amountChangedTo;

    public PacketTileEntityFuelPumpDispense(ATileEntityFuelPump pump, IWrapperPlayer player, int slotClicked, int amountChangedTo) {
        super(pump, player);
        this.slotClicked = slotClicked;
        this.amountChangedTo = amountChangedTo;
    }

    public PacketTileEntityFuelPumpDispense(ATileEntityFuelPump pump, IWrapperPlayer player, int slotClicked) {
        super(pump, player);
        this.slotClicked = slotClicked;
        this.amountChangedTo = -1;
    }

    public PacketTileEntityFuelPumpDispense(ByteBuf buf) {
        super(buf);
        this.slotClicked = buf.readInt();
        this.amountChangedTo = buf.readInt();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.slotClicked);
        buf.writeInt(this.amountChangedTo);
    }

    @Override
    protected boolean handle(AWrapperWorld world, ATileEntityFuelPump pump, IWrapperPlayer player) {
        if (this.amountChangedTo != -1) {
            pump.fuelAmounts.set(this.slotClicked, this.amountChangedTo);
            return true;
        }
        IWrapperItemStack stack = pump.fuelItems.getStack(this.slotClicked);
        if (world.isClient()) {
            pump.fuelPurchased = pump.fuelAmounts.get(this.slotClicked);
            pump.fuelDispensedThisPurchase = 0.0;
            if (player.equals(InterfaceManager.clientInterface.getClientPlayer()) && AGUIBase.activeInputGUI instanceof GUIFuelPump) {
                AGUIBase.activeInputGUI.close();
            }
            return false;
        }
        if (player.getInventory().removeStack(stack, stack.getSize(), true)) {
            stack = stack.copy();
            pump.paymentItems.addStack(stack);
            pump.fuelPurchased = pump.fuelAmounts.get(this.slotClicked);
            pump.fuelDispensedThisPurchase = 0.0;
            return true;
        }
        return false;
    }
}

