/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.items.instances.ItemBullet;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketPartGun
extends APacketEntity<PartGun> {
    private final Request stateRequest;
    private final ItemBullet bulletItem;

    public PacketPartGun(PartGun gun, Request stateRequest) {
        super(gun);
        this.stateRequest = stateRequest;
        this.bulletItem = null;
    }

    public PacketPartGun(PartGun gun, ItemBullet bullet) {
        super(gun);
        this.stateRequest = Request.RELOAD;
        this.bulletItem = bullet;
    }

    public PacketPartGun(ByteBuf buf) {
        super(buf);
        this.stateRequest = Request.values()[buf.readByte()];
        this.bulletItem = this.stateRequest == Request.RELOAD ? (ItemBullet)PacketPartGun.readItemFromBuffer(buf) : null;
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeByte(this.stateRequest.ordinal());
        if (this.stateRequest == Request.RELOAD) {
            PacketPartGun.writeItemToBuffer(this.bulletItem, buf);
        }
    }

    @Override
    public boolean handle(AWrapperWorld world, PartGun gun) {
        switch (this.stateRequest) {
            case RELOAD: {
                gun.clientNextBullet = this.bulletItem;
                break;
            }
            case TRIGGER_ON: {
                gun.playerHoldingTrigger = true;
                break;
            }
            case TRIGGER_OFF: {
                gun.playerHoldingTrigger = false;
                break;
            }
            case AIM_ON: {
                gun.isHandHeldGunAimed = true;
                break;
            }
            case AIM_OFF: {
                gun.isHandHeldGunAimed = false;
                break;
            }
            case BULLETS_OUT: {
                gun.bulletsPresentOnServer = false;
                break;
            }
            case BULLETS_PRESENT: {
                gun.bulletsPresentOnServer = true;
                break;
            }
            case KNOCKBACK: {
                gun.performGunKnockback();
            }
        }
        return this.stateRequest.sendToClients;
    }

    public static enum Request {
        RELOAD(false),
        TRIGGER_ON(true),
        TRIGGER_OFF(true),
        AIM_ON(true),
        AIM_OFF(true),
        BULLETS_OUT(false),
        BULLETS_PRESENT(false),
        KNOCKBACK(true);

        private final boolean sendToClients;

        private Request(boolean sendToClients) {
            this.sendToClients = sendToClients;
        }
    }
}

