/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketPartChange_Add
extends APacketEntity<AEntityF_Multipart<?>> {
    private final int partSlot;
    private final AItemPart item;
    private final IWrapperNBT data;

    public PacketPartChange_Add(AEntityF_Multipart<?> entity, APart partAdded) {
        super(entity);
        this.partSlot = partAdded.placementSlot;
        this.item = (AItemPart)partAdded.cachedItem;
        this.data = partAdded.save(InterfaceManager.coreInterface.getNewNBTWrapper());
    }

    public PacketPartChange_Add(ByteBuf buf) {
        super(buf);
        this.partSlot = buf.readInt();
        this.item = (AItemPart)PacketPartChange_Add.readItemFromBuffer(buf);
        this.data = PacketPartChange_Add.readDataFromBuffer(buf);
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.partSlot);
        PacketPartChange_Add.writeItemToBuffer(this.item, buf);
        PacketPartChange_Add.writeDataToBuffer(this.data, buf);
    }

    @Override
    public boolean handle(AWrapperWorld world, AEntityF_Multipart<?> entity) {
        APart part = this.item.createPart(entity, null, ((AJSONPartProvider)entity.definition).parts.get(this.partSlot), this.data);
        entity.addPart(part, false);
        part.addPartsPostAddition(null, this.data);
        return false;
    }
}

