/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockPole;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityPole_Component;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_Core;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_Sign;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_StreetLight;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_TrafficSignal;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.components.IItemBlock;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;

public class ItemPoleComponent
extends AItemSubTyped<JSONPoleComponent>
implements IItemBlock {
    public ItemPoleComponent(JSONPoleComponent definition, JSONSubDefinition subDefinition, String sourcePackID) {
        super(definition, subDefinition, sourcePackID);
    }

    @Override
    public boolean onBlockClicked(AWrapperWorld world, IWrapperPlayer player, Point3D position, ABlockBase.Axis axis) {
        if (((JSONPoleComponent)this.definition).pole.type.equals((Object)PoleComponentType.CORE)) {
            return this.placeBlock(world, player, position, axis);
        }
        return false;
    }

    @Override
    public Class<? extends ABlockBase> getBlockClass() {
        return BlockPole.class;
    }

    public static enum PoleComponentType {
        CORE,
        TRAFFIC_SIGNAL,
        STREET_LIGHT,
        SIGN;


        public static ATileEntityPole_Component createComponent(TileEntityPole pole, IWrapperPlayer placingPlayer, ABlockBase.Axis axis, ItemPoleComponent item, IWrapperNBT data) {
            switch (((JSONPoleComponent)item.definition).pole.type) {
                case CORE: {
                    return new TileEntityPole_Core(pole, placingPlayer, axis, item, data);
                }
                case TRAFFIC_SIGNAL: {
                    return new TileEntityPole_TrafficSignal(pole, placingPlayer, axis, item, data);
                }
                case STREET_LIGHT: {
                    return new TileEntityPole_StreetLight(pole, placingPlayer, axis, item, data);
                }
                case SIGN: {
                    return new TileEntityPole_Sign(pole, placingPlayer, axis, item, data);
                }
            }
            return null;
        }
    }
}

