/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.systems.LanguageSystem;

public class ItemPartGroundDevice
extends AItemPart {
    public static final AItemPart.AItemPartCreator CREATOR = new AItemPart.AItemPartCreator(){

        @Override
        public boolean isCreatorValid(JSONPart definition) {
            return definition.generic.type.startsWith("ground");
        }

        @Override
        public ItemPartGroundDevice createItem(JSONPart definition, JSONSubDefinition subDefinition, String sourcePackID) {
            return new ItemPartGroundDevice(definition, subDefinition, sourcePackID);
        }
    };

    public ItemPartGroundDevice(JSONPart definition, JSONSubDefinition subDefinition, String sourcePackID) {
        super(definition, subDefinition, sourcePackID);
    }

    @Override
    public boolean isPartValidForPackDef(JSONPartDefinition placementDefinition, JSONSubDefinition subDefinition, boolean checkMinMax) {
        return super.isPartValidForPackDef(placementDefinition, subDefinition, checkMinMax) && (!checkMinMax || placementDefinition.minValue <= ((JSONPart)this.definition).ground.height && placementDefinition.maxValue >= ((JSONPart)this.definition).ground.height);
    }

    @Override
    public PartGroundDevice createPart(AEntityF_Multipart<?> entity, IWrapperPlayer placingPlayer, JSONPartDefinition packVehicleDef, IWrapperNBT partData) {
        return new PartGroundDevice(entity, placingPlayer, packVehicleDef, this, partData);
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, IWrapperNBT data) {
        super.addTooltipLines(tooltipLines, data);
        tooltipLines.add(LanguageSystem.ITEMINFO_GROUND_DEVICE_DIAMETER.getCurrentValue() + ((JSONPart)this.definition).ground.height);
        tooltipLines.add(LanguageSystem.ITEMINFO_GROUND_DEVICE_MOTIVEFRICTION.getCurrentValue() + ((JSONPart)this.definition).ground.motiveFriction);
        tooltipLines.add(LanguageSystem.ITEMINFO_GROUND_DEVICE_LATERALFRICTION.getCurrentValue() + ((JSONPart)this.definition).ground.lateralFriction);
        tooltipLines.add(LanguageSystem.ITEMINFO_GROUND_DEVICE_WETFRICTION.getCurrentValue() + ((JSONPart)this.definition).ground.wetFrictionPenalty);
        TreeMap<Float, String> frictionValues = new TreeMap<Float, String>();
        for (Map.Entry<ABlockBase.BlockMaterial, Float> modifier : ((JSONPart)this.definition).ground.frictionModifiers.entrySet()) {
            Float value2 = modifier.getValue();
            if (!frictionValues.containsKey(value2)) {
                frictionValues.put(value2, value2 + ": " + modifier.getKey().name().toLowerCase(Locale.ROOT));
                continue;
            }
            frictionValues.put(value2, (String)frictionValues.get(value2) + ", " + modifier.getKey().name().toLowerCase(Locale.ROOT));
        }
        tooltipLines.add(LanguageSystem.ITEMINFO_GROUND_DEVICE_FRICTIONMODIFIERS.getCurrentValue());
        frictionValues.forEach((key, value) -> tooltipLines.add((String)value));
        tooltipLines.add(((JSONPart)this.definition).ground.isWheel ? LanguageSystem.ITEMINFO_GROUND_DEVICE_ROTATESONSHAFT_TRUE.getCurrentValue() : LanguageSystem.ITEMINFO_GROUND_DEVICE_ROTATESONSHAFT_FALSE.getCurrentValue());
        tooltipLines.add(((JSONPart)this.definition).ground.canFloat ? LanguageSystem.ITEMINFO_GROUND_DEVICE_CANFLOAT_TRUE.getCurrentValue() : LanguageSystem.ITEMINFO_GROUND_DEVICE_CANFLOAT_FALSE.getCurrentValue());
    }

    @Override
    public boolean needsRepair(IWrapperNBT data) {
        return super.needsRepair(data) || data != null && data.getBoolean("isFlat");
    }

    @Override
    public void repair(IWrapperNBT data) {
        super.repair(data);
        data.deleteEntry("isFlat");
    }
}

