/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_Sign;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponent3DModel;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityTextChange;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.systems.LanguageSystem;

public class GUITextEditor
extends AGUIBase {
    private GUIComponentButton confirmButton;
    private final Map<String, GUIComponentTextBox> textInputBoxes = new HashMap<String, GUIComponentTextBox>();
    private final AEntityD_Definable<?> entity;
    private final Map<GUIComponentLabel, String> signTextLabels = new HashMap<GUIComponentLabel, String>();

    public GUITextEditor(AEntityD_Definable<?> entity) {
        this.entity = entity;
    }

    @Override
    public void setupComponents() {
        GUIComponentLabel label;
        ArrayList<String> textLines;
        ArrayList<JSONText> textObjects;
        int boxWidth;
        super.setupComponents();
        this.textInputBoxes.clear();
        if (this.entity instanceof TileEntityPole_Sign) {
            GUIComponent3DModel modelRender = new GUIComponent3DModel(this.guiLeft + 3 * this.getWidth() / 4, this.guiTop + 160, 64.0f, false, false, false);
            this.addComponent(modelRender);
            modelRender.modelLocation = ((AJSONMultiModelProvider)this.entity.definition).getModelLocation(this.entity.subDefinition);
            modelRender.textureLocation = ((AJSONMultiModelProvider)this.entity.definition).getTextureLocation(this.entity.subDefinition);
            boxWidth = 100;
            textObjects = new ArrayList<JSONText>(this.entity.text.keySet());
            textLines = new ArrayList<String>(this.entity.text.values());
            this.signTextLabels.clear();
            for (int i = 0; i < textObjects.size(); i = (int)((byte)(i + 1))) {
                JSONText textDef = (JSONText)textObjects.get(i);
                label = new GUIComponentLabel(modelRender.constructedX + (int)(textDef.pos.x * 64.0), modelRender.constructedY - (int)(textDef.pos.y * 64.0), textDef.color, (String)textLines.get(i), RenderText.TextAlignment.values()[textDef.renderPosition], textDef.scale * 64.0f / 16.0f, textDef.wrapWidth * 64 / 16, textDef.fontName, textDef.autoScale);
                this.addComponent(label);
                this.signTextLabels.put(label, textDef.fieldName);
            }
        } else {
            boxWidth = 200;
            textObjects = new ArrayList<JSONText>(this.entity.text.keySet());
            textLines = new ArrayList<String>(this.entity.text.values());
            if (this.entity instanceof AEntityF_Multipart) {
                for (APart part : ((AEntityF_Multipart)this.entity).allParts) {
                    textObjects.addAll(part.text.keySet());
                    textLines.addAll(part.text.values());
                }
            }
        }
        int currentOffset = 0;
        for (JSONText textObject : textObjects) {
            if (textObject.variableName != null || this.textInputBoxes.containsKey(textObject.fieldName)) continue;
            label = new GUIComponentLabel(this.guiLeft + 20, this.guiTop + 30 + currentOffset, ColorRGB.BLACK, textObject.fieldName);
            this.addComponent(label);
            int textRowsRequired = 1 + 5 * textObject.maxLength / boxWidth;
            GUIComponentTextBox box = new GUIComponentTextBox(this, this.guiLeft + 20, label.constructedY + 10, boxWidth, 12 * textRowsRequired, (String)textLines.get(textObjects.indexOf(textObject)), ColorRGB.WHITE, textObject.maxLength);
            this.addComponent(box);
            this.textInputBoxes.put(textObject.fieldName, box);
            currentOffset += box.height + 12;
        }
        this.confirmButton = new GUIComponentButton(this, this.guiLeft + 150, this.guiTop + 15, 80, 20, LanguageSystem.GUI_CONFIRM.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                LinkedHashMap<String, String> packetTextLines = new LinkedHashMap<String, String>();
                for (JSONText textObject : textObjects) {
                    if (textObject.variableName != null) continue;
                    packetTextLines.put(textObject.fieldName, ((GUIComponentTextBox)GUITextEditor.this.textInputBoxes.get(textObject.fieldName)).getText());
                }
                InterfaceManager.packetInterface.sendToServer(new PacketEntityTextChange(GUITextEditor.this.entity, packetTextLines));
                GUITextEditor.this.close();
            }
        };
        this.addComponent(this.confirmButton);
    }

    @Override
    public void setStates() {
        super.setStates();
        this.confirmButton.enabled = true;
        this.signTextLabels.forEach((label, fieldName) -> {
            label.text = this.textInputBoxes.get(fieldName).getText();
        });
    }

    @Override
    protected boolean canStayOpen() {
        return super.canStayOpen() && this.entity.isValid;
    }
}

