/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.blocks.tileentities.instances.ATileEntityFuelPump;
import minecrafttransportsimulator.guis.components.AGUIComponent;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.guis.instances.AGUIInventory;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketInventoryContainerChange;
import minecrafttransportsimulator.packets.instances.PacketPlayerItemTransfer;
import minecrafttransportsimulator.packets.instances.PacketTileEntityFuelPumpDispense;

public class GUIFuelPump
extends AGUIInventory {
    private final ATileEntityFuelPump pump;
    private final boolean configuring;
    private final List<GUIComponentTextBox> interactableSlotBoxes = new ArrayList<GUIComponentTextBox>();
    private final List<AGUIComponent> fuelComponents = new ArrayList<AGUIComponent>();
    private final List<AGUIComponent> paymentComponents = new ArrayList<AGUIComponent>();
    private final List<GUIComponentItem> fuelItems = new ArrayList<GUIComponentItem>();
    private final List<GUIComponentItem> paymentItems = new ArrayList<GUIComponentItem>();

    public GUIFuelPump(ATileEntityFuelPump pump, boolean configuring) {
        super(null);
        this.pump = pump;
        this.configuring = configuring;
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        this.interactableSlotBoxes.clear();
        this.fuelComponents.clear();
        this.paymentComponents.clear();
        this.fuelItems.clear();
        this.paymentItems.clear();
        int xOffset = 8;
        for (int i = 0; i < this.pump.fuelItems.getSize(); ++i) {
            IWrapperItemStack stack = this.pump.fuelItems.getStack(i);
            GUIComponentButton itemButton = new GUIComponentButton(this, this.guiLeft + xOffset, this.guiTop + 12 + 22 * (i % (this.pump.fuelItems.getSize() / 2)), true){

                @Override
                public void onClicked(boolean leftSide) {
                    if (GUIFuelPump.this.configuring) {
                        IWrapperItemStack changedStack = ((GUIFuelPump)GUIFuelPump.this).pump.fuelItems.getStack(GUIFuelPump.this.interactableSlotButtons.indexOf(this));
                        changedStack.add(-changedStack.getSize());
                        InterfaceManager.packetInterface.sendToServer(new PacketInventoryContainerChange(((GUIFuelPump)GUIFuelPump.this).pump.fuelItems, GUIFuelPump.this.interactableSlotButtons.indexOf(this), changedStack));
                    } else {
                        InterfaceManager.packetInterface.sendToServer(new PacketTileEntityFuelPumpDispense(GUIFuelPump.this.pump, GUIFuelPump.this.player, GUIFuelPump.this.interactableSlotButtons.indexOf(this)));
                    }
                }
            };
            itemButton.visible = !stack.isEmpty() || this.configuring;
            this.addComponent(itemButton);
            this.interactableSlotButtons.add(itemButton);
            this.fuelComponents.add(itemButton);
            GUIComponentItem itemIcon = new GUIComponentItem(itemButton);
            itemIcon.stack = stack;
            this.addComponent(itemIcon);
            this.interactableSlotIcons.add(itemIcon);
            this.fuelComponents.add(itemIcon);
            this.fuelItems.add(itemIcon);
            GUIComponentTextBox fuelAmount = new GUIComponentTextBox(this, itemButton.constructedX + itemButton.width + 4, itemButton.constructedY, 50, String.valueOf(this.pump.fuelAmounts.get(i))){

                @Override
                public boolean isTextValid(String newText) {
                    return newText.matches("\\d+");
                }

                @Override
                public void handleTextChange() {
                    InterfaceManager.packetInterface.sendToServer(new PacketTileEntityFuelPumpDispense(GUIFuelPump.this.pump, GUIFuelPump.this.player, GUIFuelPump.this.interactableSlotBoxes.indexOf(this), Integer.parseInt(this.getText())));
                }
            };
            fuelAmount.visible = !stack.isEmpty() || this.configuring;
            fuelAmount.enabled = this.configuring;
            this.addComponent(fuelAmount);
            this.interactableSlotBoxes.add(fuelAmount);
            this.fuelComponents.add(fuelAmount);
            if (i != this.pump.fuelItems.getSize() / 2 - 1) continue;
            xOffset += 100;
        }
        final int buttonOffset = this.interactableSlotButtons.size();
        int inventoryRowOffset = (54 - this.pump.paymentItems.getSize()) * 18 / 9 / 2;
        for (int i = 0; i < this.pump.paymentItems.getSize(); i = (int)((byte)(i + 1))) {
            GUIComponentButton itemButton = new GUIComponentButton(this, this.guiLeft + 8 + 18 * (i % 9), this.guiTop + 52 + inventoryRowOffset + 18 * (i / 9), true){

                @Override
                public void onClicked(boolean leftSide) {
                    int index = GUIFuelPump.this.interactableSlotButtons.indexOf(this) - buttonOffset;
                    if (!((GUIFuelPump)GUIFuelPump.this).pump.paymentItems.getStack(index).isEmpty()) {
                        InterfaceManager.packetInterface.sendToServer(new PacketPlayerItemTransfer(((GUIFuelPump)GUIFuelPump.this).pump.paymentItems, GUIFuelPump.this.player, index, -1, false));
                    }
                }
            };
            this.addComponent(itemButton);
            this.interactableSlotButtons.add(itemButton);
            this.paymentComponents.add(itemButton);
            GUIComponentItem itemIcon = new GUIComponentItem(itemButton);
            this.addComponent(itemIcon);
            this.interactableSlotIcons.add(itemIcon);
            this.paymentComponents.add(itemIcon);
            this.paymentItems.add(itemIcon);
        }
    }

    @Override
    public void setStates() {
        super.setStates();
        if (this.configuring) {
            int i;
            for (i = 0; i < this.fuelItems.size(); ++i) {
                this.fuelItems.get((int)i).stack = this.pump.fuelItems.getStack(i);
            }
            for (i = 0; i < this.paymentItems.size(); ++i) {
                this.paymentItems.get((int)i).stack = this.pump.paymentItems.getStack(i);
            }
        }
        this.paymentComponents.forEach(component -> {
            component.visible = this.configuring;
        });
    }

    @Override
    protected void handlePlayerItemClick(int slotClicked) {
        if (this.configuring) {
            for (int i = 0; i < this.pump.fuelItems.getSize(); ++i) {
                IWrapperItemStack stack = this.pump.fuelItems.getStack(i);
                if (!stack.isEmpty()) continue;
                InterfaceManager.packetInterface.sendToServer(new PacketInventoryContainerChange(this.pump.fuelItems, i, this.playerInventory.getStack(slotClicked)));
                return;
            }
        }
    }

    @Override
    protected boolean canStayOpen() {
        return super.canStayOpen() && this.pump.isValid;
    }
}

