/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.entities.instances.EntityFurnace;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.instances.ItemPartInteractable;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketFurnaceFuelAdd;
import minecrafttransportsimulator.packets.instances.PacketPartInteractable;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public final class PartInteractable
extends APart {
    public final EntityFurnace furnace;
    public final EntityInventoryContainer inventory;
    public final EntityFluidTank tank;
    public String jerrycanFluid;
    public PartInteractable linkedPart;
    public EntityVehicleF_Physics linkedVehicle;

    public PartInteractable(AEntityF_Multipart<?> entityOn, IWrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, ItemPartInteractable item, IWrapperNBT data) {
        super(entityOn, placingPlayer, placementDefinition, item, data);
        switch (((JSONPart)this.definition).interactable.interactionType) {
            case FURNACE: {
                this.furnace = new EntityFurnace(this.world, data != null ? data.getData("furnace") : null, ((JSONPart)this.definition).interactable);
                this.inventory = this.furnace;
                this.tank = null;
                this.world.addEntity(this.furnace);
                break;
            }
            case CRATE: {
                this.furnace = null;
                this.inventory = new EntityInventoryContainer(this.world, data != null ? data.getData("inventory") : null, (int)(((JSONPart)this.definition).interactable.inventoryUnits * 9.0f), ((JSONPart)this.definition).interactable.inventoryStackSize > 0 ? ((JSONPart)this.definition).interactable.inventoryStackSize : 64);
                this.tank = null;
                this.world.addEntity(this.inventory);
                break;
            }
            case BARREL: {
                this.furnace = null;
                this.inventory = null;
                this.tank = new EntityFluidTank(this.world, data != null ? data.getData("tank") : null, (int)(((JSONPart)this.definition).interactable.inventoryUnits * 10000.0f));
                this.world.addEntity(this.tank);
                break;
            }
            case JERRYCAN: {
                this.jerrycanFluid = data != null ? data.getString("jerrycanFluid") : "";
            }
            default: {
                this.furnace = null;
                this.inventory = null;
                this.tank = null;
            }
        }
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        if (this.vehicleOn == null || !this.vehicleOn.locked) {
            if (((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE) || ((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRAFTING_BENCH) || ((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.FURNACE)) {
                player.sendPacket(new PacketPartInteractable(this, player));
            } else if (((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRAFTING_TABLE)) {
                player.openCraftingGUI();
            } else if (((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.JERRYCAN)) {
                this.entityOn.removePart(this, true, null);
                this.world.spawnItemStack(this.getStack(), this.position, null);
            } else if (this.tank != null) {
                player.getHeldStack().interactWith(this.tank, player);
            }
        } else {
            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_LOCKED, new Object[0]));
        }
        return true;
    }

    @Override
    public LanguageSystem.LanguageEntry checkForRemoval(IWrapperPlayer player) {
        if (!((JSONPart)this.definition).generic.canBeRemovedByHand && this.inventory != null && this.getMass() > (double)((JSONPart)this.definition).generic.mass) {
            return LanguageSystem.INTERACT_PARTREMOVE_INVENTORY;
        }
        return super.checkForRemoval(player);
    }

    @Override
    public void attack(Damage damage) {
        super.attack(damage);
        if (!damage.isWater && damage.amount > 25.0) {
            this.destroy(damage.box);
        }
    }

    @Override
    public void remove() {
        super.remove();
        if (this.inventory != null) {
            this.inventory.remove();
        }
        if (this.tank != null) {
            this.tank.remove();
        }
    }

    @Override
    public void destroy(BoundingBox box) {
        double explosivePower = this.getExplosiveContribution();
        if (explosivePower > 0.0 && this.isValid) {
            super.destroy(box);
            if (!((JSONPart)this.definition).interactable.hasBlowoutPanels) {
                this.masterEntity.destroy(this.masterEntity.boundingBox);
                if (((Boolean)ConfigSystem.settings.damage.vehicleExplosions.value).booleanValue()) {
                    this.world.spawnExplosion(this.position, explosivePower, true);
                } else {
                    this.world.spawnExplosion(this.position, 0.0, false);
                }
            }
        } else {
            super.destroy(box);
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.furnace != null) {
            this.furnace.update();
            if (this.furnace.ticksLeftToSmelt > 0) {
                if (!this.world.isClient() && this.furnace.ticksLeftOfFuel == 0) {
                    this.addFurnaceFuel();
                }
                if (this.vehicleOn != null) {
                    this.vehicleOn.electricUsage += this.furnace.powerToDrawPerTick;
                }
            }
        }
        if (!this.world.isClient()) {
            EntityFluidTank linkedTank = null;
            LanguageSystem.LanguageEntry linkedMessage = null;
            if (this.linkedVehicle != null) {
                if (!this.linkedVehicle.isValid || !this.linkedVehicle.position.isDistanceToCloserThan(this.position, 16.0)) {
                    linkedMessage = LanguageSystem.INTERACT_FUELHOSE_LINKDROPPED;
                } else {
                    linkedTank = this.linkedVehicle.fuelTank;
                }
            } else if (this.linkedPart != null) {
                if (!this.linkedPart.isValid || !this.linkedPart.position.isDistanceToCloserThan(this.position, 16.0)) {
                    linkedMessage = LanguageSystem.INTERACT_FUELHOSE_LINKDROPPED;
                } else {
                    linkedTank = this.linkedPart.tank;
                }
            }
            if (linkedTank != null) {
                String fluidToTransfer = this.tank.getFluid();
                if (!fluidToTransfer.isEmpty()) {
                    double amountToTransfer = linkedTank.fill(fluidToTransfer, 10.0, false);
                    if (amountToTransfer > 0.0) {
                        if ((amountToTransfer = this.tank.drain(fluidToTransfer, amountToTransfer, true)) > 0.0) {
                            linkedTank.fill(fluidToTransfer, amountToTransfer, true);
                        } else {
                            linkedMessage = LanguageSystem.INTERACT_FUELHOSE_TANKEMPTY;
                        }
                    } else {
                        linkedMessage = LanguageSystem.INTERACT_FUELHOSE_TANKFULL;
                    }
                } else {
                    linkedMessage = LanguageSystem.INTERACT_FUELHOSE_TANKEMPTY;
                }
            }
            if (linkedMessage != null) {
                this.linkedVehicle = null;
                this.linkedPart = null;
                for (IWrapperPlayer player : this.world.getPlayersWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                    player.sendPacket(new PacketPlayerChatMessage(player, linkedMessage, new Object[0]));
                }
            }
        }
    }

    private void addFurnaceFuel() {
        switch (this.furnace.definition.furnaceType) {
            case STANDARD: {
                IWrapperItemStack currentFuel = this.furnace.getStack(2);
                if (!currentFuel.isEmpty() && currentFuel.getMaxSize() >= currentFuel.getSize()) break;
                for (APart part : this.linkedParts) {
                    if (!(part instanceof PartInteractable) || !part.isActive || !((JSONPart)part.definition).interactable.feedsVehicles || !((JSONPart)part.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.CRATE)) continue;
                    PartInteractable crate = (PartInteractable)part;
                    for (int i = 0; i < crate.inventory.getSize(); ++i) {
                        IWrapperItemStack stack = crate.inventory.getStack(i);
                        if (stack.getFuelValue() == 0 || !currentFuel.isEmpty() && !stack.isCompleteMatch(currentFuel)) continue;
                        this.furnace.ticksLeftOfFuel = this.furnace.ticksAddedOfFuel = stack.getFuelValue();
                        crate.inventory.removeFromSlot(i, 1);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketFurnaceFuelAdd(this.furnace));
                        return;
                    }
                }
                break;
            }
            case FUEL: {
                for (APart part : this.linkedParts) {
                    if (!(part instanceof PartInteractable) || !part.isActive || !((JSONPart)part.definition).interactable.feedsVehicles || !((JSONPart)part.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.BARREL)) continue;
                    PartInteractable barrel = (PartInteractable)part;
                    if (!(barrel.tank.getFluidLevel() > 0.0) || !ConfigSystem.settings.fuel.fuels.get("furnace").containsKey(barrel.tank.getFluid())) continue;
                    this.furnace.ticksLeftOfFuel = this.furnace.ticksAddedOfFuel = (int)(ConfigSystem.settings.fuel.fuels.get("furnace").get(barrel.tank.getFluid()) * 20.0 * (double)this.furnace.definition.furnaceEfficiency);
                    barrel.tank.drain(barrel.tank.getFluid(), 1.0, true);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketFurnaceFuelAdd(this.furnace));
                }
                break;
            }
            case ELECTRIC: {
                this.furnace.powerToDrawPerTick = 0.0;
                if (this.vehicleOn == null || !(this.vehicleOn.electricPower > 1.0)) break;
                int ticksToDrawPower = (int)(500.0f * this.furnace.definition.furnaceEfficiency);
                this.furnace.powerToDrawPerTick = 1.0 / (double)ticksToDrawPower;
                this.furnace.ticksLeftOfFuel = this.furnace.ticksAddedOfFuel = ticksToDrawPower;
                InterfaceManager.packetInterface.sendToAllClients(new PacketFurnaceFuelAdd(this.furnace));
            }
        }
    }

    @Override
    public double getMass() {
        double currentMass = super.getMass();
        if (this.inventory != null) {
            currentMass += this.inventory.getMass();
        } else if (this.tank != null) {
            currentMass += this.tank.getMass();
        }
        return currentMass;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "interactable_count": {
                if (this.inventory != null) {
                    return this.inventory.getCount();
                }
                return 0.0;
            }
            case "interactable_percent": {
                if (this.inventory != null) {
                    return (double)this.inventory.getCount() / (double)this.inventory.getSize();
                }
                if (this.tank != null) {
                    return this.tank.getFluidLevel() / (double)this.tank.getMaxLevel();
                }
                return 0.0;
            }
            case "interactable_capacity": {
                if (this.inventory != null) {
                    return this.inventory.getSize();
                }
                if (this.tank != null) {
                    return this.tank.getMaxLevel() / 1000;
                }
                return 0.0;
            }
            case "interactable_furnace_fuel": {
                if (this.furnace != null) {
                    return this.furnace.ticksLeftOfFuel;
                }
                return 0.0;
            }
            case "interactable_furnace_remaining": {
                if (this.furnace != null) {
                    return this.furnace.ticksLeftToSmelt;
                }
                return 0.0;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    public double getExplosiveContribution() {
        if (this.inventory != null) {
            return this.inventory.getExplosiveness();
        }
        if (this.tank != null) {
            return this.tank.getExplosiveness();
        }
        return 0.0;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        if (this.furnace != null) {
            data.setData("furnace", this.furnace.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        } else if (this.inventory != null) {
            data.setData("inventory", this.inventory.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        } else if (this.tank != null) {
            data.setData("tank", this.tank.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        } else if (((JSONPart)this.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.JERRYCAN)) {
            data.setString("jerrycanFluid", this.jerrycanFluid);
        }
        return data;
    }
}

