/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BlockHitResult;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.instances.ItemBullet;
import minecrafttransportsimulator.items.instances.ItemPartGun;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONMuzzle;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.jsondefs.JSONVariableModifier;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperInventory;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPartGun;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;

public class PartGun
extends APart {
    private final double minYaw;
    private final double maxYaw;
    private final double defaultYaw;
    private final double yawSpeed;
    private final double minPitch;
    private final double maxPitch;
    private final double defaultPitch;
    private final double pitchSpeed;
    private float currentFireDelay;
    private float currentBulletSpreadFactor;
    public float currentIsTwoHandedness;
    private final boolean resetPosition;
    private final List<PartInteractable> connectedCrates = new ArrayList<PartInteractable>();
    public int bulletsFired;
    private int bulletsLeft;
    private int currentMuzzleGroupIndex;
    private final RotationMatrix internalOrientation;
    private final RotationMatrix prevInternalOrientation;
    public ItemBullet loadedBullet;
    public ItemBullet lastLoadedBullet;
    private ItemBullet reloadingBullet;
    public ItemBullet clientNextBullet;
    private final Random randomGenerator;
    public GunState state;
    public boolean bulletsPresentOnServer;
    public boolean firedThisRequest;
    public boolean firedThisCheck;
    public boolean playerHoldingTrigger;
    public boolean isHandHeldGunAimed;
    public boolean isHandHeldGunEquipped;
    public boolean isRunningInCoaxialMode;
    private int camOffset;
    private int cooldownTimeRemaining;
    private int reloadDelayRemaining;
    private int reloadTimeRemaining;
    private int windupTimeCurrent;
    private int windupRotation;
    private long lastMillisecondFired;
    public IWrapperEntity lastController;
    private PartSeat lastControllerSeat;
    private Point3D controllerRelativeLookVector = new Point3D();
    public IWrapperEntity entityTarget;
    public PartEngine engineTarget;
    public Point3D targetPosition;
    public EntityBullet currentBullet;
    public final Set<EntityBullet> activeManualBullets = new HashSet<EntityBullet>();
    private final Point3D bulletPosition = new Point3D();
    private final Point3D bulletVelocity = new Point3D();
    private final RotationMatrix bulletOrientation = new RotationMatrix();
    private final Point3D bulletPositionRender = new Point3D();
    private final Point3D bulletVelocityRender = new Point3D();
    private final RotationMatrix bulletOrientationRender = new RotationMatrix();
    private final List<PartSeat> seatsControllingGun = new ArrayList<PartSeat>();
    private final Point3D targetVector = new Point3D();
    private final Point3D targetAngles = new Point3D();
    private final Point3D controllerAngles = new Point3D();
    private final RotationMatrix firingSpreadRotation = new RotationMatrix();
    private final RotationMatrix pitchMuzzleRotation = new RotationMatrix();
    private final RotationMatrix yawMuzzleRotation = new RotationMatrix();
    private final Point3D normalizedConeVector = new Point3D();
    private final Point3D normalizedEntityVector = new Point3D();
    private static final int RAYTRACE_DISTANCE = 750;
    private static final double DEFAULT_CONE_ANGLE = 2.0;

    public PartGun(AEntityF_Multipart<?> entityOn, IWrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, ItemPartGun item, IWrapperNBT data) {
        super(entityOn, placingPlayer, placementDefinition, item, data);
        if (placementDefinition.minYaw == -180.0f && placementDefinition.maxYaw == 180.0f) {
            this.minYaw = -180.0;
            this.maxYaw = 180.0;
        } else {
            this.minYaw = ((JSONPart)this.definition).gun.minYaw != 0.0f ? (placementDefinition.minYaw != 0.0f ? (double)Math.max(((JSONPart)this.definition).gun.minYaw, placementDefinition.minYaw) : (double)((JSONPart)this.definition).gun.minYaw) : (double)placementDefinition.minYaw;
            this.maxYaw = ((JSONPart)this.definition).gun.maxYaw != 0.0f ? (placementDefinition.maxYaw != 0.0f ? (double)Math.min(((JSONPart)this.definition).gun.maxYaw, placementDefinition.maxYaw) : (double)((JSONPart)this.definition).gun.maxYaw) : (double)placementDefinition.maxYaw;
        }
        this.defaultYaw = placementDefinition.defaultYaw != 0.0f && (double)placementDefinition.defaultYaw >= this.minYaw && (double)placementDefinition.defaultYaw <= this.maxYaw ? (double)placementDefinition.defaultYaw : (double)((JSONPart)this.definition).gun.defaultYaw;
        this.yawSpeed = ((JSONPart)this.definition).gun.yawSpeed != 0.0f && placementDefinition.yawSpeed != 0.0f ? (((JSONPart)this.definition).gun.yawSpeed < placementDefinition.yawSpeed ? (double)((JSONPart)this.definition).gun.yawSpeed : (double)placementDefinition.yawSpeed) : (((JSONPart)this.definition).gun.yawSpeed != 0.0f ? (double)((JSONPart)this.definition).gun.yawSpeed : (double)placementDefinition.yawSpeed);
        this.minPitch = ((JSONPart)this.definition).gun.minPitch != 0.0f ? (placementDefinition.maxPitch != 0.0f ? (double)Math.max(-((JSONPart)this.definition).gun.maxPitch, -placementDefinition.maxPitch) : (double)(-((JSONPart)this.definition).gun.maxPitch)) : (double)(-placementDefinition.maxPitch);
        this.maxPitch = ((JSONPart)this.definition).gun.minPitch != 0.0f ? (placementDefinition.minPitch != 0.0f ? (double)Math.min(-((JSONPart)this.definition).gun.minPitch, -placementDefinition.minPitch) : (double)(-((JSONPart)this.definition).gun.minPitch)) : (double)(-placementDefinition.minPitch);
        this.defaultPitch = placementDefinition.defaultPitch != 0.0f && (double)(-placementDefinition.defaultPitch) >= this.minPitch && (double)(-placementDefinition.defaultPitch) <= this.maxPitch ? (double)(-placementDefinition.defaultPitch) : (double)(-((JSONPart)this.definition).gun.defaultPitch);
        this.pitchSpeed = ((JSONPart)this.definition).gun.pitchSpeed != 0.0f && placementDefinition.pitchSpeed != 0.0f ? (((JSONPart)this.definition).gun.pitchSpeed < placementDefinition.pitchSpeed ? (double)((JSONPart)this.definition).gun.pitchSpeed : (double)placementDefinition.pitchSpeed) : (((JSONPart)this.definition).gun.pitchSpeed != 0.0f ? (double)((JSONPart)this.definition).gun.pitchSpeed : (double)placementDefinition.pitchSpeed);
        boolean bl = this.resetPosition = ((JSONPart)this.definition).gun.resetPosition || placementDefinition.resetPosition;
        if (data != null) {
            this.state = GunState.values()[data.getInteger("state")];
            this.bulletsFired = data.getInteger("bulletsFired");
            this.bulletsLeft = data.getInteger("bulletsLeft");
            this.currentMuzzleGroupIndex = data.getInteger("currentMuzzleGroupIndex");
            this.internalOrientation = new RotationMatrix().setToAngles(data.getPoint3d("internalAngles"));
            String loadedBulletPack = data.getString("loadedBulletPack");
            if (!loadedBulletPack.isEmpty()) {
                String loadedBulletName = data.getString("loadedBulletName");
                this.lastLoadedBullet = this.loadedBullet = (ItemBullet)PackParser.getItem(loadedBulletPack, loadedBulletName);
            }
            if (this.loadedBullet == null) {
                this.bulletsLeft = 0;
            } else if (this.world.isClient()) {
                this.bulletsPresentOnServer = true;
            }
            String reloadingBulletPack = data.getString("reloadingBulletPack");
            if (!reloadingBulletPack.isEmpty()) {
                String reloadingBulletName = data.getString("reloadingBulletName");
                this.reloadingBullet = (ItemBullet)PackParser.getItem(reloadingBulletPack, reloadingBulletName);
                this.reloadTimeRemaining = ((JSONPart)this.definition).gun.reloadTime;
            }
            if (data.getBoolean("savedSeed")) {
                long randomSeed = (long)data.getInteger("randomSeedPart1") << 32 | (long)data.getInteger("randomSeedPart2") & 0xFFFFFFFFL;
                this.randomGenerator = new Random(randomSeed);
            } else {
                this.randomGenerator = new Random();
            }
        } else {
            this.state = GunState.INACTIVE;
            this.internalOrientation = new RotationMatrix();
            this.randomGenerator = new Random();
            if (((JSONPart)this.definition).gun.preloadedBullet != null) {
                String[] splitName = ((JSONPart)this.definition).gun.preloadedBullet.split(":");
                this.lastLoadedBullet = this.loadedBullet = (ItemBullet)PackParser.getItem(splitName[0], splitName[1]);
                if (this.loadedBullet != null) {
                    this.bulletsLeft = ((JSONBullet)this.loadedBullet.definition).bullet.quantity;
                } else {
                    InterfaceManager.coreInterface.logError("Tried to load preloaded bullet " + ((JSONPart)this.definition).gun.preloadedBullet + " into gun " + this.definition + " but couldn't because the bullet doesn't exist.  Report this to the pack author!");
                }
            }
        }
        this.prevInternalOrientation = new RotationMatrix().set(this.internalOrientation);
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        AItemBase heldItem = player.getHeldItem();
        if (heldItem instanceof ItemBullet && this.tryToReload((ItemBullet)heldItem) && !player.isCreative()) {
            player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
        }
        return true;
    }

    @Override
    public void update() {
        this.firedThisCheck = false;
        this.isRunningInCoaxialMode = false;
        this.prevInternalOrientation.set(this.internalOrientation);
        if (this.currentBullet != null && !this.currentBullet.isValid) {
            this.currentBullet = null;
        }
        if (this.isActive && !this.isSpare) {
            boolean ableToFire;
            IWrapperEntity controller = this.getGunController();
            if (controller != null) {
                this.lastController = controller;
                if (this.entityOn instanceof EntityPlayerGun) {
                    this.state = this.state.promote(GunState.CONTROLLED);
                } else {
                    this.lastControllerSeat = (PartSeat)this.lastController.getEntityRiding();
                    if (!(this.cachedItem != this.lastControllerSeat.activeGunItem || ((JSONPart)this.definition).gun.fireSolo && this.lastControllerSeat.gunGroups.get(this.cachedItem).get(this.lastControllerSeat.gunIndex) != this)) {
                        this.state = this.state.promote(GunState.CONTROLLED);
                    } else {
                        this.state = this.state.demote(GunState.ACTIVE);
                        controller = null;
                        this.entityTarget = null;
                        this.engineTarget = null;
                    }
                }
            }
            if (controller == null) {
                if (!this.parts.isEmpty()) {
                    for (APart part : this.parts) {
                        if (!(part instanceof PartGun) || !part.placementDefinition.isCoAxial || (controller = ((PartGun)part).getGunController()) == null) continue;
                        this.lastController = controller;
                        this.lastControllerSeat = (PartSeat)this.lastController.getEntityRiding();
                        if (part.cachedItem != this.lastControllerSeat.activeGunItem || ((JSONPart)this.definition).gun.fireSolo && this.lastControllerSeat.gunGroups.get(part.cachedItem).get(this.lastControllerSeat.gunIndex) != part) continue;
                        this.state = this.state.promote(GunState.CONTROLLED);
                        this.isRunningInCoaxialMode = true;
                        break;
                    }
                }
                if (this.placementDefinition.isCoAxial && this.entityOn instanceof PartGun && (controller = ((PartGun)this.entityOn).getGunController()) != null) {
                    this.lastController = controller;
                    this.lastControllerSeat = (PartSeat)this.lastController.getEntityRiding();
                    if (!(this.entityOn.cachedItem != this.lastControllerSeat.activeGunItem || ((JSONPart)this.definition).gun.fireSolo && this.lastControllerSeat.gunGroups.get(this.entityOn.cachedItem).get(this.lastControllerSeat.gunIndex) != this.entityOn)) {
                        this.state = this.state.promote(GunState.CONTROLLED);
                        this.isRunningInCoaxialMode = true;
                    }
                }
                if (controller == null) {
                    this.state = this.state.demote(GunState.ACTIVE);
                    if (this.entityOn instanceof EntityPlayerGun) {
                        this.remove();
                        return;
                    }
                }
            }
            if (this.state.isAtLeast(GunState.CONTROLLED)) {
                this.handleControl(controller);
                if (this.isRunningInCoaxialMode) {
                    this.state = this.state.demote(GunState.ACTIVE);
                    controller = null;
                    this.entityTarget = null;
                    this.engineTarget = null;
                }
            }
            if (this.state.isAtLeast(GunState.FIRING_REQUESTED)) {
                this.reloadDelayRemaining = ((JSONPart)this.definition).gun.reloadDelay;
            } else if (this.reloadDelayRemaining > 0) {
                --this.reloadDelayRemaining;
            }
            boolean bl = ableToFire = this.windupTimeCurrent == ((JSONPart)this.definition).gun.windupTime && (!((JSONPart)this.definition).gun.isSemiAuto || !this.firedThisRequest);
            if (ableToFire && this.state.isAtLeast(GunState.FIRING_REQUESTED)) {
                if (this.cooldownTimeRemaining == 0) {
                    boolean serverIsPrimaryController;
                    if (this.camOffset <= 0) {
                        if (!((JSONPart)this.definition).gun.fireSolo && this.lastControllerSeat != null) {
                            List<PartGun> gunGroup = this.lastControllerSeat.gunGroups.get(this.cachedItem);
                            int thisGunIndex = gunGroup.indexOf(this);
                            this.camOffset = this.lastControllerSeat.gunGroupIndex == thisGunIndex ? (gunGroup.size() > 1 ? (int)this.currentFireDelay / gunGroup.size() : 0) : -1;
                        }
                    } else {
                        --this.camOffset;
                    }
                    boolean cycledGun = false;
                    boolean bl2 = serverIsPrimaryController = this.loadedBullet != null && (((JSONBullet)this.loadedBullet.definition).bullet.isLongRange || !(this.lastController instanceof IWrapperPlayer));
                    if (this.bulletsLeft > 0 || this.world.isClient() && serverIsPrimaryController && this.bulletsPresentOnServer) {
                        this.state = this.state.promote(GunState.FIRING_CURRENTLY);
                        if (this.camOffset == 0) {
                            for (JSONMuzzle muzzle : ((JSONPart)this.definition).gun.muzzleGroups.get((int)this.currentMuzzleGroupIndex).muzzles) {
                                for (int i = 0; i < (((JSONBullet)this.loadedBullet.definition).bullet.pellets > 0 ? ((JSONBullet)this.loadedBullet.definition).bullet.pellets : 1); ++i) {
                                    EntityBullet newBullet;
                                    ++this.bulletsFired;
                                    if (!this.world.isClient() && !serverIsPrimaryController) continue;
                                    this.setBulletSpawn(this.bulletPosition, this.bulletVelocity, this.bulletOrientation, muzzle, true);
                                    if (((JSONBullet)this.loadedBullet.definition).bullet.turnRate > 0.0f) {
                                        if (this.entityTarget != null) {
                                            newBullet = new EntityBullet(this.bulletPosition, this.bulletVelocity, this.bulletOrientation, this, this.entityTarget);
                                        } else if (this.engineTarget != null) {
                                            newBullet = new EntityBullet(this.bulletPosition, this.bulletVelocity, this.bulletOrientation, this, this.engineTarget);
                                        } else if (((JSONPart)this.definition).gun.lockOnType == JSONPart.LockOnType.MANUAL) {
                                            newBullet = new EntityBullet(this.bulletPosition, this.bulletVelocity, this.bulletOrientation, this, this.targetPosition);
                                            this.activeManualBullets.add(newBullet);
                                        } else {
                                            newBullet = new EntityBullet(this.bulletPosition, this.bulletVelocity, this.bulletOrientation, this);
                                        }
                                    } else {
                                        newBullet = new EntityBullet(this.bulletPosition, this.bulletVelocity, this.bulletOrientation, this);
                                    }
                                    this.world.addEntity(newBullet);
                                    if (!(this.entityOn instanceof EntityPlayerGun) || ((JSONPart)this.definition).gun.knockback == 0.0f) continue;
                                    if (!this.world.isClient()) {
                                        this.performGunKnockback();
                                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartGun(this, PacketPartGun.Request.KNOCKBACK));
                                        continue;
                                    }
                                    if (!InterfaceManager.clientInterface.getClientPlayer().equals(this.lastController)) continue;
                                    InterfaceManager.packetInterface.sendToServer(new PacketPartGun(this, PacketPartGun.Request.KNOCKBACK));
                                }
                                if (this.bulletsLeft <= 0 || --this.bulletsLeft != 0) continue;
                                if (this.world.isClient()) break;
                                this.loadedBullet = null;
                                InterfaceManager.packetInterface.sendToAllClients(new PacketPartGun(this, PacketPartGun.Request.BULLETS_OUT));
                                break;
                            }
                            this.cooldownTimeRemaining = (int)this.currentFireDelay;
                            this.firedThisRequest = true;
                            this.firedThisCheck = true;
                            cycledGun = true;
                            this.lastMillisecondFired = System.currentTimeMillis();
                            if (((JSONPart)this.definition).gun.muzzleGroups.size() == ++this.currentMuzzleGroupIndex) {
                                this.currentMuzzleGroupIndex = 0;
                            }
                        }
                    } else if (this.camOffset == 0) {
                        cycledGun = true;
                    }
                    if (cycledGun && this.lastControllerSeat != null) {
                        List<PartGun> gunGroup = this.lastControllerSeat.gunGroups.get(this.cachedItem);
                        int currentIndex = gunGroup.indexOf(this);
                        this.lastControllerSeat.gunGroupIndex = currentIndex + 1 < gunGroup.size() ? currentIndex + 1 : 0;
                    }
                }
            } else if (!ableToFire) {
                this.state = this.state.demote(GunState.FIRING_REQUESTED);
                if (!this.state.isAtLeast(GunState.FIRING_REQUESTED)) {
                    this.firedThisRequest = false;
                }
            }
            if (!this.world.isClient() && this.bulletsLeft < ((JSONPart)this.definition).gun.capacity && this.reloadingBullet == null && this.reloadDelayRemaining == 0) {
                if (this.entityOn instanceof EntityPlayerGun) {
                    if (((JSONPart)this.definition).gun.autoReload || this.bulletsLeft == 0) {
                        IWrapperInventory inventory = ((IWrapperPlayer)this.lastController).getInventory();
                        for (int i = 0; i < inventory.getSize(); ++i) {
                            IWrapperItemStack stack = inventory.getStack(i);
                            AItemBase item = stack.getItem();
                            if (!(item instanceof ItemBullet) || !this.tryToReload((ItemBullet)item)) continue;
                            if (!((Boolean)ConfigSystem.settings.general.devMode.value).booleanValue()) {
                                inventory.removeFromSlot(i, 1);
                            }
                            break;
                        }
                    }
                } else if (((JSONPart)this.definition).gun.autoReload) {
                    block4: for (PartInteractable crate : this.connectedCrates) {
                        if (!crate.isActive) continue;
                        EntityInventoryContainer inventory = crate.inventory;
                        for (int i = 0; i < inventory.getSize(); ++i) {
                            IWrapperItemStack stack = inventory.getStack(i);
                            AItemBase item = stack.getItem();
                            if (!(item instanceof ItemBullet) || !this.tryToReload((ItemBullet)item)) continue;
                            if (((Boolean)ConfigSystem.settings.general.devMode.value).booleanValue()) continue block4;
                            inventory.removeFromSlot(i, 1);
                            continue block4;
                        }
                    }
                }
            }
        } else {
            this.state = GunState.INACTIVE;
            this.entityTarget = null;
            this.engineTarget = null;
            if (this.resetPosition) {
                this.handleMovement(this.defaultYaw - this.internalOrientation.angles.y, this.defaultPitch - this.internalOrientation.angles.x);
            }
        }
        if (this.clientNextBullet != null) {
            this.reloadingBullet = this.clientNextBullet;
            this.reloadTimeRemaining = ((JSONPart)this.definition).gun.reloadTime;
            this.clientNextBullet = null;
        }
        if (this.reloadTimeRemaining > 0) {
            --this.reloadTimeRemaining;
        } else if (this.reloadingBullet != null) {
            this.lastLoadedBullet = this.loadedBullet = this.reloadingBullet;
            this.bulletsLeft += ((JSONBullet)this.reloadingBullet.definition).bullet.quantity;
            this.reloadingBullet = null;
            if (!this.world.isClient()) {
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartGun(this, PacketPartGun.Request.BULLETS_PRESENT));
            }
        }
        if (this.state.isAtLeast(GunState.FIRING_REQUESTED)) {
            if (this.windupTimeCurrent < ((JSONPart)this.definition).gun.windupTime) {
                ++this.windupTimeCurrent;
            }
        } else if (this.windupTimeCurrent > 0) {
            --this.windupTimeCurrent;
        }
        this.windupRotation += this.windupTimeCurrent;
        if (!this.state.isAtLeast(GunState.FIRING_REQUESTED)) {
            this.firedThisRequest = false;
        }
        if (this.cooldownTimeRemaining > 0) {
            --this.cooldownTimeRemaining;
        }
        super.update();
        if (this.lastControllerSeat != null && this.parts.contains(this.lastControllerSeat)) {
            this.orientation.convertToAngles();
            this.lastControllerSeat.riderRelativeOrientation.angles.y -= this.orientation.angles.y - this.prevOrientation.angles.y;
            this.lastControllerSeat.riderRelativeOrientation.angles.x -= this.orientation.angles.x - this.prevOrientation.angles.x;
        }
    }

    @Override
    public void updatePartList() {
        super.updatePartList();
        this.seatsControllingGun.clear();
        this.addLinkedPartsToList(this.seatsControllingGun, PartSeat.class);
        for (APart part : this.parts) {
            if (!(part instanceof PartSeat)) continue;
            this.seatsControllingGun.add((PartSeat)part);
        }
        this.connectedCrates.clear();
        for (APart part : this.parts) {
            if (!(part instanceof PartInteractable)) continue;
            this.connectedCrates.add((PartInteractable)part);
        }
        this.addLinkedPartsToList(this.connectedCrates, PartInteractable.class);
        this.connectedCrates.removeIf(crate -> ((JSONPart)crate.definition).interactable.interactionType != JSONPart.InteractableComponentType.CRATE || !((JSONPart)crate.definition).interactable.feedsVehicles);
    }

    @Override
    public void updateVariableModifiers() {
        this.currentFireDelay = ((JSONPart)this.definition).gun.fireDelay;
        this.currentBulletSpreadFactor = ((JSONPart)this.definition).gun.bulletSpreadFactor;
        float f = this.currentIsTwoHandedness = ((JSONPart)this.definition).gun.isTwoHanded ? 1.0f : 0.0f;
        if (((JSONPart)this.definition).variableModifiers != null) {
            block14: for (JSONVariableModifier modifier : ((JSONPart)this.definition).variableModifiers) {
                switch (modifier.variable) {
                    case "fireDelay": {
                        this.currentFireDelay = this.adjustVariable(modifier, this.currentFireDelay);
                        continue block14;
                    }
                    case "bulletSpreadFactor": {
                        this.currentBulletSpreadFactor = this.adjustVariable(modifier, this.currentBulletSpreadFactor);
                        continue block14;
                    }
                    case "isTwoHanded": {
                        this.currentIsTwoHandedness = this.adjustVariable(modifier, this.currentIsTwoHandedness);
                        continue block14;
                    }
                    case "gun_yaw": {
                        this.internalOrientation.angles.y = this.adjustVariable(modifier, (float)this.internalOrientation.angles.y);
                        continue block14;
                    }
                    case "gun_pitch": {
                        this.internalOrientation.angles.x = this.adjustVariable(modifier, (float)this.internalOrientation.angles.x);
                        continue block14;
                    }
                }
                this.setVariable(modifier.variable, this.adjustVariable(modifier, (float)this.getVariable(modifier.variable)));
            }
        }
    }

    private void handleControl(IWrapperEntity controller) {
        if (!(controller instanceof IWrapperPlayer)) {
            boolean checkForCloser;
            boolean bl = checkForCloser = this.entityTarget != null && this.ticksExisted % 20L == 0L;
            if (this.entityTarget == null || checkForCloser) {
                for (IWrapperEntity entity : this.world.getEntitiesHostile(controller, 48.0)) {
                    if (!this.validateTarget(entity)) continue;
                    if (this.entityTarget != null) {
                        double distanceToBeat = this.position.distanceTo(this.entityTarget.getPosition());
                        if (checkForCloser) {
                            distanceToBeat += 5.0;
                        }
                        if (this.position.distanceTo(entity.getPosition()) > distanceToBeat) continue;
                    }
                    this.entityTarget = entity;
                }
            }
            if (this.entityTarget != null) {
                if (this.validateTarget(this.entityTarget)) {
                    this.controllerAngles.set(this.targetVector).getAngles(true);
                    controller.setYaw(this.controllerAngles.y);
                    controller.setPitch(this.controllerAngles.x);
                    this.state = Math.abs(this.targetAngles.y - this.internalOrientation.angles.y) < this.yawSpeed && Math.abs(this.targetAngles.x - this.internalOrientation.angles.x) < this.pitchSpeed ? this.state.promote(GunState.FIRING_REQUESTED) : this.state.demote(GunState.CONTROLLED);
                } else {
                    this.entityTarget = null;
                    this.state = this.state.demote(GunState.CONTROLLED);
                }
            } else {
                this.state = this.state.demote(GunState.CONTROLLED);
            }
        } else {
            if (((JSONPart)this.definition).gun.canLockTargets || this.loadedBullet != null && ((JSONBullet)this.loadedBullet.definition).bullet.turnRate > 0.0f) {
                Point3D startPoint = null;
                Point3D searchVector = null;
                double coneAngle = 0.0;
                switch (((JSONPart)this.definition).gun.lockOnType) {
                    case DEFAULT: {
                        startPoint = controller.getEyePosition();
                        searchVector = controller.getLineOfSight(750.0);
                        coneAngle = 2.0;
                        break;
                    }
                    case BORESIGHT: {
                        startPoint = this.position;
                        searchVector = new Point3D(0.0, 0.0, ((JSONPart)this.definition).gun.lockRange).rotate(this.orientation);
                        coneAngle = ((JSONPart)this.definition).gun.lockMaxAngle;
                        break;
                    }
                    case RADAR: {
                        break;
                    }
                    case MANUAL: {
                        if (this.targetPosition != null) break;
                        this.targetPosition = new Point3D();
                    }
                }
                this.engineTarget = null;
                this.entityTarget = null;
                if (startPoint != null) {
                    double targetAngle;
                    double entityDistance;
                    if (((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.ALL || ((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.HARD || ((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.AIRCRAFT || ((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.GROUND) {
                        this.normalizedConeVector.set(searchVector).normalize();
                        EntityVehicleF_Physics vehicleTarget = null;
                        double smallestDistance = searchVector.length();
                        for (EntityVehicleF_Physics vehicle : this.world.getEntitiesOfType(EntityVehicleF_Physics.class)) {
                            if (vehicle == this.vehicleOn || ((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.AIRCRAFT && !((JSONVehicle)vehicle.definition).motorized.isAircraft || ((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.GROUND && ((JSONVehicle)vehicle.definition).motorized.isAircraft) continue;
                            this.targetVector.set(vehicle.position).subtract(startPoint);
                            if (this.world.getBlockHit(startPoint, this.targetVector) != null || !((entityDistance = vehicle.position.distanceTo(startPoint)) < smallestDistance)) continue;
                            this.normalizedEntityVector.set(vehicle.position).subtract(startPoint).normalize();
                            targetAngle = Math.abs(Math.toDegrees(Math.acos(this.normalizedConeVector.dotProduct(this.normalizedEntityVector, false))));
                            if (!(targetAngle < coneAngle)) continue;
                            smallestDistance = entityDistance;
                            vehicleTarget = vehicle;
                        }
                        if (vehicleTarget != null && !vehicleTarget.outOfHealth) {
                            for (APart part : vehicleTarget.parts) {
                                if (!(part instanceof PartEngine)) continue;
                                this.engineTarget = (PartEngine)part;
                                break;
                            }
                        }
                    }
                    if (this.engineTarget == null && ((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.ALL || ((JSONPart)this.definition).gun.targetType == JSONPart.TargetType.SOFT) {
                        this.normalizedConeVector.set(searchVector).normalize();
                        double smallestDistance = searchVector.length();
                        BoundingBox searchBox = new BoundingBox(this.position, smallestDistance, smallestDistance, smallestDistance);
                        for (IWrapperEntity entity : this.world.getEntitiesWithin(searchBox)) {
                            if (!entity.isValid() || entity == controller) continue;
                            this.targetVector.set(entity.getPosition()).subtract(startPoint);
                            if (this.world.getBlockHit(startPoint, this.targetVector) != null || !((entityDistance = entity.getPosition().distanceTo(startPoint)) < smallestDistance)) continue;
                            this.normalizedEntityVector.set(entity.getPosition()).subtract(startPoint).normalize();
                            targetAngle = Math.abs(Math.toDegrees(Math.acos(this.normalizedConeVector.dotProduct(this.normalizedEntityVector, false))));
                            if (!(targetAngle < coneAngle)) continue;
                            smallestDistance = entityDistance;
                            this.entityTarget = entity;
                        }
                    }
                }
            }
            if (!this.activeManualBullets.isEmpty()) {
                Point3D laserStart = controller.getPosition().copy();
                BlockHitResult laserHit = this.world.getBlockHit(laserStart, controller.getLineOfSight(2048.0));
                if (laserHit != null) {
                    this.targetPosition.set(laserHit.hitPosition);
                } else {
                    this.targetPosition.set(laserStart).add(controller.getLineOfSight(1024.0));
                }
            }
            this.state = this.playerHoldingTrigger ? this.state.promote(GunState.FIRING_REQUESTED) : this.state.demote(GunState.CONTROLLED);
        }
        if (this.lastControllerSeat != null) {
            this.controllerRelativeLookVector.computeVectorAngles(controller.getOrientation(), this.zeroReferenceOrientation);
            this.handleMovement(this.controllerRelativeLookVector.y - this.internalOrientation.angles.y, this.controllerRelativeLookVector.x - this.internalOrientation.angles.x);
            if (!this.lastControllerSeat.externalAnglesRotated.isZero() && this.lastControllerSeat.placementDefinition.animations != null) {
                boolean updateYaw = false;
                boolean updatePitch = false;
                for (JSONAnimationDefinition def : this.lastControllerSeat.placementDefinition.animations) {
                    if (def.variable.contains("gun_yaw")) {
                        updateYaw = true;
                        continue;
                    }
                    if (!def.variable.contains("gun_pitch")) continue;
                    updatePitch = true;
                }
                if (updateYaw) {
                    this.lastControllerSeat.riderRelativeOrientation.angles.y -= this.internalOrientation.angles.y - this.prevInternalOrientation.angles.y;
                }
                if (updatePitch) {
                    this.lastControllerSeat.riderRelativeOrientation.angles.x -= this.internalOrientation.angles.x - this.prevInternalOrientation.angles.x;
                }
            }
        }
    }

    private boolean validateTarget(IWrapperEntity target) {
        if (target.isValid()) {
            this.targetVector.set(target.getPosition());
            this.targetVector.y += target.getEyeHeight() / 2.0;
            this.targetVector.subtract(this.position);
            this.targetAngles.set(this.targetVector).reOrigin(this.zeroReferenceOrientation).getAngles(true);
            if ((this.minYaw != -180.0 || this.maxYaw != 180.0) && (this.targetAngles.y < this.minYaw || this.targetAngles.y > this.maxYaw)) {
                return false;
            }
            if (this.targetAngles.x < this.minPitch || this.targetAngles.x > this.maxPitch) {
                return false;
            }
            return this.world.getBlockHit(this.position, this.targetVector) == null;
        }
        return false;
    }

    private void handleMovement(double deltaYaw, double deltaPitch) {
        if (deltaYaw != 0.0 || deltaPitch != 0.0) {
            if (deltaYaw != 0.0) {
                if (deltaYaw < -180.0) {
                    deltaYaw += 360.0;
                }
                if (deltaYaw > 180.0) {
                    deltaYaw -= 360.0;
                }
                if (deltaYaw < 0.0) {
                    if (deltaYaw < -this.yawSpeed) {
                        deltaYaw = -this.yawSpeed;
                    }
                    this.internalOrientation.angles.y += deltaYaw;
                } else if (deltaYaw > 0.0) {
                    if (deltaYaw > this.yawSpeed) {
                        deltaYaw = this.yawSpeed;
                    }
                    this.internalOrientation.angles.y += deltaYaw;
                }
                if (this.minYaw == -180.0 && this.maxYaw == 180.0) {
                    if (this.internalOrientation.angles.y > 180.0) {
                        this.internalOrientation.angles.y -= 360.0;
                        this.prevInternalOrientation.angles.y -= 360.0;
                    } else if (this.internalOrientation.angles.y < -180.0) {
                        this.internalOrientation.angles.y += 360.0;
                        this.prevInternalOrientation.angles.y += 360.0;
                    }
                } else {
                    if (this.internalOrientation.angles.y > this.maxYaw) {
                        this.internalOrientation.angles.y = this.maxYaw;
                    }
                    if (this.internalOrientation.angles.y < this.minYaw) {
                        this.internalOrientation.angles.y = this.minYaw;
                    }
                }
            }
            if (deltaPitch != 0.0) {
                if (deltaPitch < 0.0) {
                    if (deltaPitch < -this.pitchSpeed) {
                        deltaPitch = -this.pitchSpeed;
                    }
                    this.internalOrientation.angles.x += deltaPitch;
                } else if (deltaPitch > 0.0) {
                    if (deltaPitch > this.pitchSpeed) {
                        deltaPitch = this.pitchSpeed;
                    }
                    this.internalOrientation.angles.x += deltaPitch;
                }
                if (this.internalOrientation.angles.x > this.maxPitch) {
                    this.internalOrientation.angles.x = this.maxPitch;
                }
                if (this.internalOrientation.angles.x < this.minPitch) {
                    this.internalOrientation.angles.x = this.minPitch;
                }
            }
        }
    }

    public boolean tryToReload(ItemBullet item) {
        if (!((JSONPart)this.definition).gun.blockReloading && ((JSONBullet)item.definition).bullet != null) {
            boolean isNewBulletValid;
            boolean bl = isNewBulletValid = ((JSONBullet)item.definition).bullet.diameter == ((JSONPart)this.definition).gun.diameter && ((JSONBullet)item.definition).bullet.caseLength >= ((JSONPart)this.definition).gun.minCaseLength && ((JSONBullet)item.definition).bullet.caseLength <= ((JSONPart)this.definition).gun.maxCaseLength;
            if (this.reloadingBullet == null && (this.loadedBullet == null ? isNewBulletValid : this.loadedBullet.equals(item)) && ((JSONBullet)item.definition).bullet.quantity + this.bulletsLeft <= ((JSONPart)this.definition).gun.capacity) {
                this.reloadingBullet = item;
                this.reloadTimeRemaining = ((JSONPart)this.definition).gun.reloadTime;
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartGun(this, this.reloadingBullet));
                return true;
            }
        }
        return false;
    }

    public IWrapperEntity getGunController() {
        if (this.masterEntity.outOfHealth) {
            return null;
        }
        if (this.entityOn instanceof EntityPlayerGun) {
            return ((EntityPlayerGun)this.entityOn).player;
        }
        if (this.entityOn instanceof PartSeat && this.entityOn.rider != null) {
            return this.entityOn.rider;
        }
        for (APart part : this.parts) {
            if (!(part instanceof PartSeat) || part.rider == null) continue;
            return part.rider;
        }
        for (PartSeat seat : this.seatsControllingGun) {
            if (seat.rider == null) continue;
            return seat.rider;
        }
        return null;
    }

    public void performGunKnockback() {
        double knockback = -((JSONPart)this.definition).gun.knockback;
        if (((JSONBullet)this.lastLoadedBullet.definition).bullet.pellets != 0) {
            knockback /= (double)((JSONBullet)this.lastLoadedBullet.definition).bullet.pellets;
        }
        ((EntityPlayerGun)this.entityOn).player.applyMotion(new Point3D(0.0, 0.0, 1.0).rotate(this.orientation).scale(knockback));
    }

    public void setBulletSpawn(Point3D bulletPosition, Point3D bulletVelocity, RotationMatrix bulletOrientation, JSONMuzzle muzzle, boolean addSpread) {
        if (((JSONPart)this.definition).gun.muzzleVelocity != 0) {
            bulletVelocity.set(0.0, 0.0, (double)((JSONPart)this.definition).gun.muzzleVelocity / 20.0);
            if (addSpread) {
                if (this.loadedBullet == null) {
                    if (this.currentBulletSpreadFactor > 0.0f) {
                        this.firingSpreadRotation.angles.set((this.randomGenerator.nextFloat() - 0.5f) * this.currentBulletSpreadFactor, (this.randomGenerator.nextFloat() - 0.5f) * this.currentBulletSpreadFactor, 0.0);
                        bulletVelocity.rotate(this.firingSpreadRotation);
                    }
                } else if (this.currentBulletSpreadFactor > 0.0f || ((JSONBullet)this.loadedBullet.definition).bullet.pelletSpreadFactor > 0.0f) {
                    this.firingSpreadRotation.angles.set((this.randomGenerator.nextFloat() - 0.5f) * (this.currentBulletSpreadFactor + ((JSONBullet)this.loadedBullet.definition).bullet.pelletSpreadFactor), (this.randomGenerator.nextFloat() - 0.5f) * (this.currentBulletSpreadFactor + ((JSONBullet)this.loadedBullet.definition).bullet.pelletSpreadFactor), 0.0);
                    bulletVelocity.rotate(this.firingSpreadRotation);
                }
            }
            if (muzzle.rot != null) {
                bulletVelocity.rotate(muzzle.rot);
            }
            bulletVelocity.rotate(this.internalOrientation).rotate(this.zeroReferenceOrientation);
        } else {
            bulletVelocity.set(0.0, 0.0, 0.0);
        }
        if (this.vehicleOn != null) {
            bulletVelocity.addScaled(this.motion, this.vehicleOn.speedFactor);
        } else {
            bulletVelocity.add(this.motion);
        }
        bulletPosition.set(muzzle.pos);
        if (muzzle.center != null) {
            this.pitchMuzzleRotation.setToZero().rotateX(this.internalOrientation.angles.x);
            this.yawMuzzleRotation.setToZero().rotateY(this.internalOrientation.angles.y);
            bulletPosition.subtract(muzzle.center).rotate(this.pitchMuzzleRotation).add(muzzle.center).rotate(this.yawMuzzleRotation);
        } else {
            bulletPosition.rotate(this.internalOrientation);
        }
        bulletPosition.rotate(this.zeroReferenceOrientation).add(this.position);
        bulletOrientation.set(this.zeroReferenceOrientation).multiply(this.internalOrientation);
        if (muzzle.rot != null && !((JSONPart)this.definition).gun.disableMuzzleOrientation) {
            bulletOrientation.multiply(muzzle.rot);
        }
    }

    public double getLockedOnDirection() {
        Point3D referencePos;
        double direction = 0.0;
        Point3D point3D = referencePos = this.vehicleOn != null ? this.vehicleOn.position : this.position;
        if (this.engineTarget != null) {
            direction = Math.toDegrees(Math.atan2(-this.engineTarget.vehicleOn.position.z + referencePos.z, -this.engineTarget.vehicleOn.position.x + referencePos.x)) + 90.0 + this.orientation.angles.y;
        } else if (this.entityTarget != null) {
            direction = Math.toDegrees(Math.atan2(-this.entityTarget.getPosition().z + referencePos.z, -this.entityTarget.getPosition().x + referencePos.x)) + 90.0 + this.orientation.angles.y;
        }
        while (direction < -180.0) {
            direction += 360.0;
        }
        while (direction > 180.0) {
            direction -= 360.0;
        }
        return direction;
    }

    public double getLockedOnAngle() {
        Point3D referencePos;
        double angle = 0.0;
        Point3D point3D = referencePos = this.vehicleOn != null ? this.vehicleOn.position : this.position;
        if (this.engineTarget != null) {
            angle = -Math.toDegrees(Math.atan2(-this.engineTarget.position.y + referencePos.y, Math.hypot(-this.engineTarget.position.z + referencePos.z, -this.engineTarget.position.x + referencePos.x))) + this.orientation.angles.x;
        } else if (this.entityTarget != null) {
            angle = -Math.toDegrees(Math.atan2(-this.entityTarget.getPosition().y + referencePos.y, Math.hypot(-this.entityTarget.getPosition().z + referencePos.z, -this.entityTarget.getPosition().x + referencePos.x))) + this.orientation.angles.x;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        while (angle > 180.0) {
            angle -= 360.0;
        }
        return angle;
    }

    public Point3D getLockedOnLeadPoint() {
        Point3D leadPoint = new Point3D();
        double ticksToTarget = 0.0;
        if (this.engineTarget != null) {
            ticksToTarget = this.engineTarget.vehicleOn.position.distanceTo(this.position) / ((double)((JSONPart)this.definition).gun.muzzleVelocity / 20.0);
            leadPoint.set(this.engineTarget.vehicleOn.position).addScaled(this.engineTarget.vehicleOn.motion, this.engineTarget.vehicleOn.speedFactor * ticksToTarget);
        } else if (this.entityTarget != null) {
            ticksToTarget = this.entityTarget.getPosition().distanceTo(this.position) / ((double)((JSONPart)this.definition).gun.muzzleVelocity / 20.0);
            leadPoint.set(this.entityTarget.getPosition()).addScaled(this.entityTarget.getVelocity(), ticksToTarget);
        }
        return leadPoint;
    }

    public double getLeadPointDirection() {
        double direction = 0.0;
        if (this.engineTarget != null || this.entityTarget != null) {
            direction = Math.toDegrees(Math.atan2(-this.getLockedOnLeadPoint().z + this.position.z, -this.getLockedOnLeadPoint().x + this.position.x)) + 90.0 + this.orientation.angles.y;
        }
        while (direction < -180.0) {
            direction += 360.0;
        }
        while (direction > 180.0) {
            direction -= 360.0;
        }
        return direction;
    }

    public double getLeadAngleY() {
        Point3D referencePos;
        double angle = 0.0;
        Point3D point3D = referencePos = this.vehicleOn != null ? this.vehicleOn.position : this.position;
        if (this.engineTarget != null) {
            angle = -Math.toDegrees(Math.atan2(-this.getLockedOnLeadPoint().y + this.position.y, Math.hypot(-this.getLockedOnLeadPoint().z + this.position.z, -this.getLockedOnLeadPoint().x + this.position.x))) + this.orientation.angles.x - (-Math.toDegrees(Math.atan2(-this.engineTarget.position.y + referencePos.y, Math.hypot(-this.engineTarget.position.z + referencePos.z, -this.engineTarget.position.x + referencePos.x))) + this.orientation.angles.x);
        } else if (this.entityTarget != null) {
            angle = -Math.toDegrees(Math.atan2(-this.getLockedOnLeadPoint().y + this.position.y, Math.hypot(-this.getLockedOnLeadPoint().z + this.position.z, -this.getLockedOnLeadPoint().x + this.position.x))) + this.orientation.angles.x - (-Math.toDegrees(Math.atan2(-this.entityTarget.getPosition().y + referencePos.y, Math.hypot(-this.entityTarget.getPosition().z + referencePos.z, -this.entityTarget.getPosition().x + referencePos.x))) + this.orientation.angles.x);
        }
        return angle;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        switch (variable) {
            case "gun_inhand": {
                return this.entityOn instanceof EntityPlayerGun ? 1.0 : 0.0;
            }
            case "gun_inhand_sneaking": {
                return this.entityOn instanceof EntityPlayerGun && ((EntityPlayerGun)this.entityOn).player != null && ((EntityPlayerGun)this.entityOn).player.isSneaking() ? 1.0 : 0.0;
            }
            case "gun_inhand_aiming": {
                return this.isHandHeldGunAimed ? 1.0 : 0.0;
            }
            case "gun_inhand_equipped": {
                return this.isHandHeldGunEquipped ? 1.0 : 0.0;
            }
            case "gun_controller_firstperson": {
                return InterfaceManager.clientInterface.getClientPlayer().equals(this.lastController) && InterfaceManager.clientInterface.getCameraMode() == CameraSystem.CameraMode.FIRST_PERSON ? 1.0 : 0.0;
            }
            case "gun_active": {
                return this.state.isAtLeast(GunState.CONTROLLED) ? 1.0 : 0.0;
            }
            case "gun_firing": {
                return this.state.isAtLeast(GunState.FIRING_REQUESTED) ? 1.0 : 0.0;
            }
            case "gun_fired": {
                return this.firedThisCheck ? 1.0 : 0.0;
            }
            case "gun_muzzleflash": {
                return this.firedThisCheck && this.lastMillisecondFired + 25L < System.currentTimeMillis() ? 1.0 : 0.0;
            }
            case "gun_lockedon": {
                return this.entityTarget != null || this.engineTarget != null ? 1.0 : 0.0;
            }
            case "gun_lockedon_x": {
                return this.entityTarget != null ? this.entityTarget.getPosition().x : (this.engineTarget != null ? this.engineTarget.position.x : 0.0);
            }
            case "gun_lockedon_y": {
                return this.entityTarget != null ? this.entityTarget.getPosition().y : (this.engineTarget != null ? this.engineTarget.position.y : 0.0);
            }
            case "gun_lockedon_z": {
                return this.entityTarget != null ? this.entityTarget.getPosition().z : (this.engineTarget != null ? this.engineTarget.position.z : 0.0);
            }
            case "gun_lockedon_direction": {
                return this.entityTarget != null ? this.getLockedOnDirection() : (this.engineTarget != null ? this.getLockedOnDirection() : 0.0);
            }
            case "gun_lockedon_angle": {
                return this.entityTarget != null ? this.getLockedOnAngle() : (this.engineTarget != null ? this.getLockedOnAngle() : 0.0);
            }
            case "gun_lockedon_leadpoint_direction": {
                return this.entityTarget != null ? this.getLeadPointDirection() : (this.engineTarget != null ? this.getLeadPointDirection() : 0.0);
            }
            case "gun_lockedon_leadpoint_angle": {
                return this.entityTarget != null ? -Math.toDegrees(Math.atan2(-this.getLockedOnLeadPoint().y + this.position.y, Math.hypot(-this.getLockedOnLeadPoint().z + this.position.z, -this.getLockedOnLeadPoint().x + this.position.x))) + this.orientation.angles.x : (this.engineTarget != null ? -Math.toDegrees(Math.atan2(-this.getLockedOnLeadPoint().y + this.position.y, Math.hypot(-this.getLockedOnLeadPoint().z + this.position.z, -this.getLockedOnLeadPoint().x + this.position.x))) + this.orientation.angles.x : 0.0);
            }
            case "gun_lockedon_distance": {
                return this.entityTarget != null ? this.entityTarget.getPosition().distanceTo(this.position) : (this.engineTarget != null ? this.engineTarget.position.distanceTo(this.position) : 0.0);
            }
            case "gun_lockedon_leadangle_x": {
                return this.entityTarget != null ? this.getLeadPointDirection() - this.getLockedOnDirection() : (this.engineTarget != null ? this.getLeadPointDirection() - this.getLockedOnDirection() : 0.0);
            }
            case "gun_lockedon_leadangle_y": {
                return this.entityTarget != null ? this.getLeadAngleY() : (this.engineTarget != null ? this.getLeadAngleY() : 0.0);
            }
            case "gun_pitch": {
                return partialTicks != 0.0f ? this.prevInternalOrientation.angles.x + (this.internalOrientation.angles.x - this.prevInternalOrientation.angles.x) * (double)partialTicks : this.internalOrientation.angles.x;
            }
            case "gun_yaw": {
                return partialTicks != 0.0f ? this.prevInternalOrientation.angles.y + (this.internalOrientation.angles.y - this.prevInternalOrientation.angles.y) * (double)partialTicks : this.internalOrientation.angles.y;
            }
            case "gun_pitching": {
                return Math.abs(this.prevInternalOrientation.angles.x - this.internalOrientation.angles.x) > 0.01 ? 1.0 : 0.0;
            }
            case "gun_yawing": {
                return Math.abs(this.prevInternalOrientation.angles.y - this.internalOrientation.angles.y) > 0.01 ? 1.0 : 0.0;
            }
            case "gun_cooldown": {
                return this.cooldownTimeRemaining > 0 ? 1.0 : 0.0;
            }
            case "gun_windup_time": {
                return this.windupTimeCurrent;
            }
            case "gun_windup_rotation": {
                return this.windupRotation;
            }
            case "gun_windup_complete": {
                return this.windupTimeCurrent == ((JSONPart)this.definition).gun.windupTime ? 1.0 : 0.0;
            }
            case "gun_reload": {
                return this.reloadTimeRemaining > 0 ? 1.0 : 0.0;
            }
            case "gun_ammo_count": {
                return this.bulletsLeft;
            }
            case "gun_ammo_count_reloading": {
                return this.reloadingBullet != null ? (double)((JSONBullet)this.reloadingBullet.definition).bullet.quantity : 0.0;
            }
            case "gun_ammo_percent": {
                return this.bulletsLeft / ((JSONPart)this.definition).gun.capacity;
            }
            case "gun_active_muzzlegroup": {
                return this.currentMuzzleGroupIndex + 1;
            }
            case "gun_bullet_present": {
                return this.currentBullet != null ? 1.0 : 0.0;
            }
            case "gun_bullet_x": {
                return this.currentBullet != null ? this.currentBullet.getRelativePos(1, partialTicks) : 0.0;
            }
            case "gun_bullet_y": {
                return this.currentBullet != null ? this.currentBullet.getRelativePos(2, partialTicks) : 0.0;
            }
            case "gun_bullet_z": {
                return this.currentBullet != null ? this.currentBullet.getRelativePos(3, partialTicks) : 0.0;
            }
            case "gun_bullet_yaw": {
                return this.currentBullet != null ? this.currentBullet.orientation.angles.y - this.orientation.angles.y : 0.0;
            }
            case "gun_bullet_pitch": {
                return this.currentBullet != null ? this.currentBullet.orientation.angles.x - this.orientation.angles.x : 0.0;
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public String getRawTextVariableValue(JSONText textDef, float partialTicks) {
        if (textDef.variableName.equals("gun_lockedon_name")) {
            return this.entityTarget != null ? this.entityTarget.getName() : (this.engineTarget != null ? this.engineTarget.masterEntity.toString() : "");
        }
        return super.getRawTextVariableValue(textDef, partialTicks);
    }

    @Override
    public void renderBoundingBoxes(TransformationMatrix transform) {
        if (this.entityOn.isVariableListTrue(this.placementDefinition.interactableVariables)) {
            super.renderBoundingBoxes(transform);
            for (JSONMuzzle muzzle : ((JSONPart)this.definition).gun.muzzleGroups.get((int)this.currentMuzzleGroupIndex).muzzles) {
                this.setBulletSpawn(this.bulletPositionRender, this.bulletVelocityRender, this.bulletOrientationRender, muzzle, false);
                new BoundingBox(this.bulletPositionRender, 0.25, 0.25, 0.25).renderWireframe(this, transform, null, ColorRGB.BLUE);
            }
        }
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setInteger("state", (byte)this.state.ordinal());
        data.setInteger("bulletsFired", this.bulletsFired);
        data.setInteger("bulletsLeft", this.bulletsLeft);
        data.setInteger("currentMuzzleGroupIndex", this.currentMuzzleGroupIndex);
        data.setPoint3d("internalAngles", this.internalOrientation.angles);
        if (this.loadedBullet != null) {
            data.setString("loadedBulletPack", ((JSONBullet)this.loadedBullet.definition).packID);
            data.setString("loadedBulletName", ((JSONBullet)this.loadedBullet.definition).systemName);
        }
        if (this.reloadingBullet != null) {
            data.setString("reloadingBulletPack", ((JSONBullet)this.reloadingBullet.definition).packID);
            data.setString("reloadingBulletName", ((JSONBullet)this.reloadingBullet.definition).systemName);
        }
        long randomSeed = this.randomGenerator.nextLong();
        data.setBoolean("savedSeed", true);
        data.setInteger("randomSeedPart1", (int)(randomSeed >> 32));
        data.setInteger("randomSeedPart2", (int)randomSeed);
        return data;
    }

    public static enum GunState {
        INACTIVE,
        ACTIVE,
        CONTROLLED,
        FIRING_REQUESTED,
        FIRING_CURRENTLY;


        public GunState promote(GunState newState) {
            return newState.ordinal() > this.ordinal() ? newState : this;
        }

        public GunState demote(GunState newState) {
            return newState.ordinal() < this.ordinal() ? newState : this;
        }

        public boolean isAtLeast(GunState testState) {
            return this.ordinal() >= testState.ordinal();
        }
    }
}

