/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.TowingConnection;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.components.AEntityG_Towable;
import minecrafttransportsimulator.entities.instances.AEntityVehicleE_Powered;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartPropeller;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVariableModifier;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.systems.ConfigSystem;

public class EntityVehicleF_Physics
extends AEntityVehicleE_Powered {
    public double aileronInput;
    public double aileronAngle;
    public double aileronTrim;
    public static final double MAX_AILERON_ANGLE = 25.0;
    public static final double MAX_AILERON_TRIM = 10.0;
    public static final double AILERON_DAMPEN_RATE = 0.6;
    public static final String AILERON_INPUT_VARIABLE = "input_aileron";
    public static final String AILERON_VARIABLE = "aileron";
    public static final String AILERON_TRIM_VARIABLE = "trim_aileron";
    public double elevatorInput;
    public double elevatorAngle;
    public double elevatorTrim;
    public static final double MAX_ELEVATOR_ANGLE = 25.0;
    public static final double MAX_ELEVATOR_TRIM = 10.0;
    public static final double ELEVATOR_DAMPEN_RATE = 0.6;
    public static final String ELEVATOR_INPUT_VARIABLE = "input_elevator";
    public static final String ELEVATOR_VARIABLE = "elevator";
    public static final String ELEVATOR_TRIM_VARIABLE = "trim_elevator";
    public double rudderInput;
    public double rudderAngle;
    public double rudderTrim;
    public static final double MAX_RUDDER_ANGLE = 45.0;
    public static final double MAX_RUDDER_TRIM = 10.0;
    public static final double RUDDER_DAMPEN_RATE = 2.0;
    public static final double RUDDER_DAMPEN_RETURN_RATE = 4.0;
    public static final String RUDDER_INPUT_VARIABLE = "input_rudder";
    public static final String RUDDER_VARIABLE = "rudder";
    public static final String RUDDER_TRIM_VARIABLE = "trim_rudder";
    public static final short MAX_FLAP_ANGLE_REFERENCE = 350;
    public double flapDesiredAngle;
    public double flapCurrentAngle;
    public static final String FLAPS_VARIABLE = "flaps_setpoint";
    public boolean turningLeft;
    public boolean turningRight;
    public byte turningCooldown;
    public int repairCooldownTicks;
    public double autopilotSetting;
    public double airDensity;
    public double seaLevel;
    public static final String AUTOPILOT_VALUE_VARIABLE = "autopilot";
    public static final String AUTOPILOT_ACTIVE_VARIABLE = "autopilot_active";
    public static final String AUTOLEVEL_VARIABLE = "auto_level";
    public int controllerCount;
    public IWrapperPlayer lastController;
    private boolean hasRotors;
    private double trackAngle;
    private double indicatedSpeed;
    private final Point3D normalizedVelocityVector;
    private final Point3D verticalVector;
    private final Point3D sideVector;
    private final Point3D hitchPrevOffset;
    private final Point3D hitchCurrentOffset;
    private final Set<AEntityG_Towable<?>> towedEntitiesCheckedForWeights;
    public float currentWingArea;
    public float currentWingSpan;
    public float currentAileronArea;
    public float currentElevatorArea;
    public float currentRudderArea;
    public float currentDragCoefficient;
    public float currentBallastVolume;
    public float currentWaterBallastFactor;
    public float currentAxleRatio;
    private double wingLiftCoeff;
    private double aileronLiftCoeff;
    private double elevatorLiftCoeff;
    private double rudderLiftCoeff;
    private double dragCoeff;
    private double dragForce;
    private double wingForce;
    private double aileronForce;
    private double elevatorForce;
    private double rudderForce;
    private double ballastForce;
    private double gravitationalForce;
    private final Point3D thrustForce;
    private double thrustForceValue;
    private final Point3D towingThrustForce;
    private final Point3D totalForce;
    private double momentRoll;
    private double momentPitch;
    private double momentYaw;
    private double aileronTorque;
    private double elevatorTorque;
    private double rudderTorque;
    private final Point3D thrustTorque;
    private final Point3D totalTorque;
    private final Point3D rotorRotation;

    public EntityVehicleF_Physics(AWrapperWorld world, IWrapperPlayer placingPlayer, ItemVehicle item, IWrapperNBT data) {
        super(world, placingPlayer, item, data);
        this.seaLevel = ((Integer)ConfigSystem.settings.general.seaLevel.value).intValue();
        this.normalizedVelocityVector = new Point3D();
        this.verticalVector = new Point3D();
        this.sideVector = new Point3D();
        this.hitchPrevOffset = new Point3D();
        this.hitchCurrentOffset = new Point3D();
        this.towedEntitiesCheckedForWeights = new HashSet();
        this.thrustForce = new Point3D();
        this.towingThrustForce = new Point3D();
        this.totalForce = new Point3D();
        this.thrustTorque = new Point3D();
        this.totalTorque = new Point3D();
        this.rotorRotation = new Point3D();
        if (data != null) {
            this.flapCurrentAngle = data.getDouble("flapCurrentAngle");
        }
    }

    @Override
    public void update() {
        super.update();
        this.world.beginProfiling("VehicleF_Level", true);
        if (this.repairCooldownTicks > 0) {
            --this.repairCooldownTicks;
        }
        this.verticalVector.set(0.0, 1.0, 0.0).rotate(this.orientation);
        this.normalizedVelocityVector.set(this.motion).normalize();
        this.sideVector.set(this.verticalVector.crossProduct(this.headingVector));
        this.aileronInput = this.getVariable(AILERON_INPUT_VARIABLE);
        this.aileronTrim = this.getVariable(AILERON_TRIM_VARIABLE);
        this.elevatorInput = this.getVariable(ELEVATOR_INPUT_VARIABLE);
        this.elevatorTrim = this.getVariable(ELEVATOR_TRIM_VARIABLE);
        this.rudderInput = this.getVariable(RUDDER_INPUT_VARIABLE);
        this.rudderTrim = this.getVariable(RUDDER_TRIM_VARIABLE);
        this.autopilotSetting = this.getVariable(AUTOPILOT_VALUE_VARIABLE);
        this.flapDesiredAngle = this.getVariable(FLAPS_VARIABLE);
        this.indicatedSpeed = this.axialVelocity * this.speedFactor * 20.0;
        if (this.isVariableActive(AUTOPILOT_ACTIVE_VARIABLE)) {
            if (!this.isVariableActive(AUTOPILOT_VALUE_VARIABLE)) {
                if (((JSONVehicle)this.definition).motorized.isAircraft) {
                    this.setVariable(AUTOPILOT_VALUE_VARIABLE, this.position.y);
                } else {
                    this.setVariable(AUTOPILOT_VALUE_VARIABLE, this.indicatedSpeed);
                }
            }
        } else if (this.autopilotSetting != 0.0) {
            this.toggleVariable(AUTOPILOT_VALUE_VARIABLE);
        }
        this.world.endProfiling();
    }

    @Override
    public boolean requiresDeltaUpdates() {
        return true;
    }

    @Override
    public double getMass() {
        double combinedMass = super.getMass();
        if (!this.towingConnections.isEmpty()) {
            for (TowingConnection connection : this.towingConnections) {
                EntityVehicleF_Physics towedEntity = connection.towedVehicle;
                if (this.towedEntitiesCheckedForWeights.contains(towedEntity)) {
                    InterfaceManager.coreInterface.logError("Infinite loop detected on weight checking code!  Is a trailer towing the thing that's towing it?");
                    break;
                }
                this.towedEntitiesCheckedForWeights.add(towedEntity);
                combinedMass += ((AEntityF_Multipart)towedEntity).getMass();
                this.towedEntitiesCheckedForWeights.clear();
            }
        }
        return combinedMass;
    }

    @Override
    protected double getSteeringAngle() {
        return -this.rudderInput / 45.0;
    }

    @Override
    protected void addToSteeringAngle(double degrees) {
        double delta = this.rudderInput - degrees > 45.0 ? 45.0 - this.rudderInput : (this.rudderInput - degrees < -45.0 ? -45.0 - this.rudderInput : -degrees);
        this.setVariable(RUDDER_INPUT_VARIABLE, this.rudderInput + delta);
        InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, RUDDER_INPUT_VARIABLE, delta));
    }

    @Override
    public void updateVariableModifiers() {
        this.currentWingArea = (float)((double)((JSONVehicle)this.definition).motorized.wingArea + (double)(((JSONVehicle)this.definition).motorized.wingArea * 0.15f) * this.flapCurrentAngle / 350.0);
        this.currentWingSpan = ((JSONVehicle)this.definition).motorized.wingSpan;
        this.currentAileronArea = ((JSONVehicle)this.definition).motorized.aileronArea;
        this.currentElevatorArea = ((JSONVehicle)this.definition).motorized.elevatorArea;
        this.currentRudderArea = ((JSONVehicle)this.definition).motorized.rudderArea;
        this.currentDragCoefficient = ((JSONVehicle)this.definition).motorized.dragCoefficient;
        this.currentBallastVolume = ((JSONVehicle)this.definition).motorized.ballastVolume;
        this.currentWaterBallastFactor = ((JSONVehicle)this.definition).motorized.waterBallastFactor;
        this.currentSteeringForceIgnoresSpeed = ((JSONVehicle)this.definition).motorized.steeringForceIgnoresSpeed ? 1.0f : 0.0f;
        this.currentSteeringForceFactor = ((JSONVehicle)this.definition).motorized.steeringForceFactor;
        this.currentBrakingFactor = ((JSONVehicle)this.definition).motorized.brakingFactor;
        this.currentOverSteer = ((JSONVehicle)this.definition).motorized.overSteer;
        this.currentUnderSteer = ((JSONVehicle)this.definition).motorized.underSteer;
        this.currentAxleRatio = ((JSONVehicle)this.definition).motorized.axleRatio;
        this.aileronAngle = this.aileronInput;
        this.setVariable(AILERON_VARIABLE, this.aileronAngle);
        this.elevatorAngle = this.elevatorInput;
        this.setVariable(ELEVATOR_VARIABLE, this.elevatorAngle);
        this.rudderAngle = this.rudderInput;
        this.setVariable(RUDDER_VARIABLE, this.rudderAngle);
        if (((JSONVehicle)this.definition).motorized.flapNotches != null && !((JSONVehicle)this.definition).motorized.flapNotches.isEmpty()) {
            if (this.flapCurrentAngle < this.flapDesiredAngle) {
                this.flapCurrentAngle += (double)((JSONVehicle)this.definition).motorized.flapSpeed;
            } else if (this.flapCurrentAngle > this.flapDesiredAngle) {
                this.flapCurrentAngle -= (double)((JSONVehicle)this.definition).motorized.flapSpeed;
            }
            if (Math.abs(this.flapCurrentAngle - this.flapDesiredAngle) < (double)((JSONVehicle)this.definition).motorized.flapSpeed) {
                this.flapCurrentAngle = this.flapDesiredAngle;
            }
        }
        if (((JSONVehicle)this.definition).variableModifiers != null) {
            block40: for (JSONVariableModifier modifier : ((JSONVehicle)this.definition).variableModifiers) {
                switch (modifier.variable) {
                    case "wingArea": {
                        this.currentWingArea = this.adjustVariable(modifier, this.currentWingArea);
                        continue block40;
                    }
                    case "wingSpan": {
                        this.currentWingSpan = this.adjustVariable(modifier, this.currentWingSpan);
                        continue block40;
                    }
                    case "aileronArea": {
                        this.currentAileronArea = this.adjustVariable(modifier, this.currentAileronArea);
                        continue block40;
                    }
                    case "elevatorArea": {
                        this.currentElevatorArea = this.adjustVariable(modifier, this.currentElevatorArea);
                        continue block40;
                    }
                    case "rudderArea": {
                        this.currentRudderArea = this.adjustVariable(modifier, this.currentRudderArea);
                        continue block40;
                    }
                    case "dragCoefficient": {
                        this.currentDragCoefficient = this.adjustVariable(modifier, this.currentDragCoefficient);
                        continue block40;
                    }
                    case "ballastVolume": {
                        this.currentBallastVolume = this.adjustVariable(modifier, this.currentBallastVolume);
                        continue block40;
                    }
                    case "waterBallastFactor": {
                        this.currentWaterBallastFactor = this.adjustVariable(modifier, this.currentWaterBallastFactor);
                        continue block40;
                    }
                    case "steeringForceIgnoresSpeed": {
                        this.currentSteeringForceIgnoresSpeed = this.adjustVariable(modifier, this.currentSteeringForceIgnoresSpeed);
                        continue block40;
                    }
                    case "steeringForceFactor": {
                        this.currentSteeringForceFactor = this.adjustVariable(modifier, this.currentSteeringForceFactor);
                        continue block40;
                    }
                    case "brakingFactor": {
                        this.currentBrakingFactor = this.adjustVariable(modifier, this.currentBrakingFactor);
                        continue block40;
                    }
                    case "overSteer": {
                        this.currentOverSteer = this.adjustVariable(modifier, this.currentOverSteer);
                        continue block40;
                    }
                    case "underSteer": {
                        this.currentUnderSteer = this.adjustVariable(modifier, this.currentUnderSteer);
                        continue block40;
                    }
                    case "axleRatio": {
                        this.currentAxleRatio = this.adjustVariable(modifier, this.currentAxleRatio);
                        continue block40;
                    }
                    case "flaps_actual": {
                        this.flapCurrentAngle = this.adjustVariable(modifier, (float)this.flapCurrentAngle);
                        continue block40;
                    }
                    case "aileron": {
                        this.aileronAngle = this.adjustVariable(modifier, (float)this.aileronAngle);
                        this.setVariable(AILERON_VARIABLE, this.aileronAngle);
                        continue block40;
                    }
                    case "elevator": {
                        this.elevatorAngle = this.adjustVariable(modifier, (float)this.elevatorAngle);
                        this.setVariable(ELEVATOR_VARIABLE, this.elevatorAngle);
                        continue block40;
                    }
                    case "rudder": {
                        this.rudderAngle = this.adjustVariable(modifier, (float)this.rudderAngle);
                        this.setVariable(RUDDER_VARIABLE, this.rudderAngle);
                        continue block40;
                    }
                }
                this.setVariable(modifier.variable, this.adjustVariable(modifier, (float)this.getVariable(modifier.variable)));
            }
        }
    }

    @Override
    protected void getForcesAndMotions() {
        this.hasRotors = false;
        this.thrustForce.set(0.0, 0.0, 0.0);
        this.thrustTorque.set(0.0, 0.0, 0.0);
        this.rotorRotation.set(0.0, 0.0, 0.0);
        this.thrustForceValue = 0.0;
        if (this.towedByConnection == null || !this.towedByConnection.hitchConnection.mounted) {
            for (APart part : this.allParts) {
                if (part instanceof PartEngine) {
                    this.thrustForceValue += ((PartEngine)part).addToForceOutput(this.thrustForce, this.thrustTorque);
                    continue;
                }
                if (!(part instanceof PartPropeller)) continue;
                PartPropeller propeller = (PartPropeller)part;
                this.thrustForceValue += propeller.addToForceOutput(this.thrustForce, this.thrustTorque);
                if (!((JSONPart)propeller.definition).propeller.isRotor || !this.groundDeviceCollective.isAnythingOnGround()) continue;
                this.hasRotors = true;
                if (this.autopilotSetting == 0.0 && this.getVariable(AUTOLEVEL_VARIABLE) != 0.0) {
                    this.rotorRotation.set((-(this.elevatorAngle + this.elevatorTrim) - this.orientation.angles.x) / 25.0, -5.0 * this.rudderAngle / 45.0, (this.aileronAngle + this.aileronTrim - this.orientation.angles.z) / 25.0);
                    continue;
                }
                if (this.autopilotSetting == 0.0) {
                    this.rotorRotation.set(-5.0 * this.elevatorAngle / 25.0, -5.0 * this.rudderAngle / 45.0, 5.0 * this.aileronAngle / 25.0);
                    continue;
                }
                this.rotorRotation.x = this.orientation.angles.x < -1.0 ? 1.0 : (this.orientation.angles.x > 1.0 ? -1.0 : -this.orientation.angles.x);
                this.rotorRotation.z = this.orientation.angles.z < -1.0 ? 1.0 : (this.orientation.angles.z > 1.0 ? -1.0 : -this.orientation.angles.z);
                this.rotorRotation.y = -5.0 * this.rudderAngle / 45.0;
            }
        }
        if (this.towedByConnection == null) {
            this.airDensity = 1.225 * Math.pow(2.0, -(this.position.y - this.seaLevel) / (500.0 * (double)this.world.getMaxHeight() / 256.0));
            this.momentRoll = (double)((JSONVehicle)this.definition).motorized.emptyMass * (1.5 + this.fuelTank.getFluidLevel() / 10000.0);
            this.momentPitch = 2.0 * this.currentMass;
            this.momentYaw = 3.0 * this.currentMass;
            double towedThrust = this.getRecursiveTowingThrust();
            if (towedThrust != 0.0) {
                this.towingThrustForce.set(0.0, 0.0, towedThrust).rotate(this.orientation);
                this.thrustForce.add(this.towingThrustForce);
            }
            this.trackAngle = -Math.toDegrees(Math.asin(this.verticalVector.dotProduct(this.normalizedVelocityVector, true)));
            if (((JSONVehicle)this.definition).motorized.isBlimp) {
                this.thrustTorque.x = 0.0;
                this.thrustTorque.z = 0.0;
                if (Math.hypot(this.motion.x, this.motion.z) < 0.15 && (this.brake > 0.0 || this.parkingBrakeOn)) {
                    this.motion.x = 0.0;
                    this.motion.z = 0.0;
                    this.thrustForce.set(0.0, 0.0, 0.0);
                    this.thrustTorque.set(0.0, 0.0, 0.0);
                }
            }
            double yawAngleDelta = Math.toDegrees(Math.asin(this.sideVector.dotProduct(this.normalizedVelocityVector, true)));
            this.wingLiftCoeff = EntityVehicleF_Physics.getLiftCoeff(this.trackAngle, 2.0 + this.flapCurrentAngle / 350.0);
            this.aileronLiftCoeff = EntityVehicleF_Physics.getLiftCoeff(this.aileronAngle + this.aileronTrim, 2.0);
            this.elevatorLiftCoeff = EntityVehicleF_Physics.getLiftCoeff(-2.5 + this.trackAngle - (this.elevatorAngle + this.elevatorTrim), 2.0);
            this.rudderLiftCoeff = EntityVehicleF_Physics.getLiftCoeff(yawAngleDelta - (this.rudderAngle + this.rudderTrim), 2.0);
            if (((JSONVehicle)this.definition).motorized.isBlimp) {
                this.dragCoeff = (double)0.004f * Math.pow(Math.abs(yawAngleDelta), 2.0) + (double)this.currentDragCoefficient;
            } else if (((JSONVehicle)this.definition).motorized.isAircraft) {
                this.dragCoeff = (double)4.0E-4f * Math.pow(this.trackAngle, 2.0) + (double)this.currentDragCoefficient;
            } else {
                this.dragCoeff = this.currentDragCoefficient;
                if (this.groundDeviceCollective.groundedGroundDevices.isEmpty()) {
                    this.dragCoeff *= 3.0;
                }
            }
            this.dragForce = ((JSONVehicle)this.definition).motorized.crossSectionalArea > 0.0f ? 0.5 * this.airDensity * this.velocity * this.velocity * (double)((JSONVehicle)this.definition).motorized.crossSectionalArea * this.dragCoeff : (this.currentWingSpan > 0.0f ? 0.5 * this.airDensity * this.velocity * this.velocity * (double)this.currentWingArea * (this.dragCoeff + this.wingLiftCoeff * this.wingLiftCoeff / (Math.PI * (double)((JSONVehicle)this.definition).motorized.wingSpan * (double)((JSONVehicle)this.definition).motorized.wingSpan / (double)this.currentWingArea * 0.8)) : 0.5 * this.airDensity * this.velocity * this.velocity * 5.0 * this.dragCoeff);
            if (this.currentBallastVolume > 0.0f) {
                if (this.elevatorAngle < 0.0) {
                    this.ballastForce = this.airDensity * (double)this.currentBallastVolume * -this.elevatorAngle / 10.0;
                } else if (this.elevatorAngle > 0.0) {
                    this.ballastForce = 1.225 * (double)this.currentBallastVolume * -this.elevatorAngle / 10.0;
                } else if (this.motion.y < -0.15 || this.motion.y > 0.15) {
                    this.ballastForce = 1.225 * (double)this.currentBallastVolume * 10.0 * -this.motion.y;
                } else {
                    this.ballastForce = 0.0;
                    this.motion.y = 0.0;
                }
                if (this.motion.y * this.ballastForce != 0.0) {
                    this.ballastForce /= Math.pow(1.0 + Math.abs(this.motion.y), 2.0);
                }
            }
            this.wingForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * (double)this.currentWingArea * this.wingLiftCoeff;
            this.aileronForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * (double)this.currentAileronArea * this.aileronLiftCoeff;
            this.elevatorForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * (double)this.currentElevatorArea * this.elevatorLiftCoeff;
            this.rudderForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * (double)this.currentRudderArea * this.rudderLiftCoeff;
            this.aileronTorque = this.aileronForce * (double)this.currentWingSpan * 0.5 * 0.75;
            this.elevatorTorque = this.elevatorForce * (double)((JSONVehicle)this.definition).motorized.tailDistance;
            this.rudderTorque = this.rudderForce * (double)((JSONVehicle)this.definition).motorized.tailDistance;
            if (Math.abs(this.elevatorTorque) < 2.0 * this.currentMass / 400.0) {
                this.elevatorTorque = 0.0;
            }
            if (((JSONVehicle)this.definition).motorized.isBlimp) {
                this.aileronTorque = this.orientation.angles.z > 0.0 ? -Math.min(0.5, this.orientation.angles.z) * this.currentMass / 100.0 : (this.orientation.angles.z < 0.0 ? -Math.max(-0.5, this.orientation.angles.z) * this.currentMass / 100.0 : 0.0);
                this.elevatorTorque = this.orientation.angles.x > 0.0 ? -Math.min(0.5, this.orientation.angles.x) * this.currentMass / 100.0 : (this.orientation.angles.x < 0.0 ? -Math.max(-0.5, this.orientation.angles.x) * this.currentMass / 100.0 : 0.0);
                if (this.rudderTorque * this.rudderAngle > 0.0) {
                    this.rudderTorque = 0.0;
                }
            }
            if (this.currentWingArea > 0.0f && this.trackAngle > 40.0 && this.orientation.angles.x < 45.0 && this.motion.y < -0.1 && this.groundDeviceCollective.isAnythingOnGround()) {
                this.elevatorTorque += 100.0;
            }
            if (this.outOfHealth) {
                this.wingForce = 0.0;
                this.elevatorForce = 0.0;
                this.aileronForce = 0.0;
                this.rudderForce = 0.0;
                this.elevatorTorque = 0.0;
                this.aileronTorque = 0.0;
                this.rudderTorque = 0.0;
                this.ballastForce = 0.0;
                this.currentBallastVolume = 0.0f;
            }
            double d = this.gravitationalForce = this.currentBallastVolume == 0.0f ? this.currentMass * 0.0245 : 0.0;
            if (this.currentWaterBallastFactor != 0.0f && this.world.isBlockLiquid(this.position)) {
                this.gravitationalForce -= this.gravitationalForce * (double)this.currentWaterBallastFactor;
                this.elevatorTorque = -this.orientation.angles.x * 2.0;
                this.aileronTorque = -this.orientation.angles.z * 2.0;
            }
            if (!((JSONVehicle)this.definition).motorized.isAircraft) {
                this.gravitationalForce *= ((Double)ConfigSystem.settings.general.gravityFactor.value).doubleValue();
            }
            if ((Double)ConfigSystem.settings.general.maxFlightHeight.value > 0.0 && this.position.y > (Double)ConfigSystem.settings.general.maxFlightHeight.value) {
                this.wingForce = 0.0;
                this.thrustForce.y = 0.0;
            }
            this.totalForce.set(0.0, this.wingForce - this.elevatorForce, 0.0).rotate(this.orientation);
            this.totalForce.add(this.thrustForce);
            this.totalForce.addScaled(this.normalizedVelocityVector, -this.dragForce);
            this.totalForce.y += this.ballastForce - this.gravitationalForce;
            this.motion.addScaled(this.totalForce, 1.0 / this.currentMass);
            this.totalTorque.set(this.elevatorTorque, this.rudderTorque, this.aileronTorque).add(this.thrustTorque).scale(57.29577951308232);
            this.totalTorque.x /= this.momentPitch;
            this.totalTorque.y /= this.momentYaw;
            this.totalTorque.z /= this.momentRoll;
            this.rotation.angles.set(this.totalTorque).add(this.rotorRotation);
        } else if (!this.lockedOnRoad) {
            this.towedByConnection.hookupPriorPosition.set(this.towedByConnection.hookupCurrentPosition);
            if (this.towedByConnection.hitchConnection.mounted || this.towedByConnection.hitchConnection.restricted) {
                this.rotation.set(this.towedByConnection.towingEntity.orientation);
                if (this.towedByConnection.hitchConnection.rot != null) {
                    this.rotation.multiply(this.towedByConnection.hitchConnection.rot);
                }
                if (this.towedByConnection.hookupConnection.rot != null) {
                    this.rotation.multiply(this.towedByConnection.hookupConnection.rot);
                }
                if (this.towedByConnection.hitchConnection.restricted) {
                    this.rotation.angles.x = this.orientation.angles.x;
                    this.rotation.angles.z = this.orientation.angles.z;
                    this.rotation.updateToAngles();
                }
                this.towedByConnection.hookupCurrentPosition.set(this.towedByConnection.hookupConnection.pos).multiply(this.towedByConnection.towedEntity.scale).rotate(this.rotation).add(this.towedByConnection.towedEntity.position);
            } else if (!this.towedByConnection.hitchPriorPosition.isZero()) {
                if (this.towedByConnection.hookupConnection.pos.x != 0.0) {
                    this.hitchPrevOffset.set(-this.towedByConnection.hookupConnection.pos.x, 0.0, 0.0).rotate(this.prevOrientation);
                    this.hitchCurrentOffset.set(-this.towedByConnection.hookupConnection.pos.x, 0.0, 0.0).rotate(this.orientation);
                    this.hitchPrevOffset.add(this.towedByConnection.hitchPriorPosition).subtract(this.prevPosition);
                    this.hitchCurrentOffset.add(this.towedByConnection.hitchCurrentPosition).subtract(this.position);
                } else {
                    this.hitchPrevOffset.set(this.towedByConnection.hitchPriorPosition).subtract(this.prevPosition);
                    this.hitchCurrentOffset.set(this.towedByConnection.hitchCurrentPosition).subtract(this.position);
                }
                this.hitchPrevOffset.y = 0.0;
                this.hitchCurrentOffset.y = 0.0;
                this.hitchPrevOffset.normalize();
                this.hitchCurrentOffset.normalize();
                double rotationDelta = Math.toDegrees(Math.acos(this.hitchPrevOffset.dotProduct(this.hitchCurrentOffset, true)));
                if (this.hitchPrevOffset.crossProduct((Point3D)this.hitchCurrentOffset).y < 0.0) {
                    rotationDelta = -rotationDelta;
                }
                this.rotation.angles.set(0.0, rotationDelta, 0.0);
                this.rotation.updateToAngles();
                this.towedByConnection.hookupCurrentPosition.set(this.towedByConnection.hookupConnection.pos).multiply(this.towedByConnection.towedEntity.scale).rotate(this.towedByConnection.towedEntity.orientation).rotate(this.rotation).add(this.towedByConnection.towedEntity.position);
            }
            this.motion.set(this.towedByConnection.hitchCurrentPosition).subtract(this.towedByConnection.hookupCurrentPosition).scale(1.0 / this.speedFactor);
        } else {
            this.motion.set(this.towedByConnection.towingVehicle.motion);
            this.rotation.angles.set(0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void adjustControlSurfaces() {
        if (!((JSONVehicle)this.definition).motorized.isAircraft && this.autopilotSetting != 0.0) {
            if (this.indicatedSpeed < this.autopilotSetting) {
                if (this.throttle < 1.0) {
                    this.throttle += 0.01;
                    this.setVariable("throttle", this.throttle);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, "throttle", 0.01));
                }
            } else if (this.indicatedSpeed > this.autopilotSetting && this.throttle > 0.0) {
                this.throttle -= 0.01;
                this.setVariable("throttle", this.throttle);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, "throttle", -0.01));
            }
        }
        if (this.hasRotors) {
            if (this.autopilotSetting != 0.0) {
                if (this.ticksExisted % 10L == 0L) {
                    if (this.motion.y < 0.0 && this.throttle < 1.0) {
                        this.throttle += 0.01;
                        this.setVariable("throttle", this.throttle);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, "throttle", 0.01));
                    } else if (this.motion.y > 0.0 && this.throttle < 1.0) {
                        this.throttle -= 0.01;
                        this.setVariable("throttle", this.throttle);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, "throttle", -0.01));
                    }
                }
                double forwardsVelocity = this.motion.dotProduct(this.headingVector, false);
                double sidewaysVelocity = this.motion.dotProduct(this.sideVector, false);
                double forwardsDelta = forwardsVelocity - this.prevMotion.dotProduct(this.headingVector, false);
                double sidewaysDelta = sidewaysVelocity - this.prevMotion.dotProduct(this.sideVector, false);
                if (forwardsDelta > 0.0 && forwardsVelocity > 0.0 && this.elevatorTrim < 10.0) {
                    this.setVariable(ELEVATOR_TRIM_VARIABLE, this.elevatorTrim + 1.0);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_TRIM_VARIABLE, 1.0));
                } else if (forwardsDelta < 0.0 && forwardsVelocity < 0.0 && this.elevatorTrim > -10.0) {
                    this.setVariable(ELEVATOR_TRIM_VARIABLE, this.elevatorTrim - 1.0);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_TRIM_VARIABLE, -1.0));
                }
                if (sidewaysVelocity > 0.0 && sidewaysDelta > 0.0 && this.aileronTrim < 10.0) {
                    this.setVariable(AILERON_TRIM_VARIABLE, this.aileronTrim + 1.0);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_TRIM_VARIABLE, 1.0));
                } else if (sidewaysVelocity < 0.0 && sidewaysDelta < 0.0 && this.aileronTrim > -10.0) {
                    this.setVariable(AILERON_TRIM_VARIABLE, this.aileronTrim - 1.0);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_TRIM_VARIABLE, -1.0));
                }
            } else {
                if (this.elevatorTrim < 0.0) {
                    this.setVariable(ELEVATOR_TRIM_VARIABLE, this.elevatorTrim + 1.0);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_TRIM_VARIABLE, 1.0));
                } else if (this.elevatorTrim > 0.0) {
                    this.setVariable(ELEVATOR_TRIM_VARIABLE, this.elevatorTrim - 1.0);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_TRIM_VARIABLE, -1.0));
                }
                if (this.aileronTrim < 0.0) {
                    this.setVariable(AILERON_TRIM_VARIABLE, this.aileronTrim + 1.0);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_TRIM_VARIABLE, 1.0));
                } else if (this.aileronTrim > 0.0) {
                    this.setVariable(AILERON_TRIM_VARIABLE, this.aileronTrim - 1.0);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_TRIM_VARIABLE, -1.0));
                }
            }
        } else if (((JSONVehicle)this.definition).motorized.isAircraft && this.autopilotSetting != 0.0) {
            if (-this.motion.y * 10.0 > this.elevatorTrim + 1.0 && this.elevatorTrim < 10.0) {
                this.setVariable(ELEVATOR_TRIM_VARIABLE, this.elevatorTrim + 0.1);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_TRIM_VARIABLE, 0.1));
            } else if (-this.motion.y * 10.0 < this.elevatorTrim - 1.0 && this.elevatorTrim > -10.0) {
                this.setVariable(ELEVATOR_TRIM_VARIABLE, this.elevatorTrim - 0.1);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_TRIM_VARIABLE, -0.1));
            }
            if (-this.orientation.angles.z > this.aileronTrim + 0.1 && this.aileronTrim < 10.0) {
                this.setVariable(AILERON_TRIM_VARIABLE, this.aileronTrim + 0.1);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_TRIM_VARIABLE, 0.1));
            } else if (-this.orientation.angles.z < this.aileronTrim - 0.1 && this.aileronTrim > -10.0) {
                this.setVariable(AILERON_TRIM_VARIABLE, this.aileronTrim - 0.1);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_TRIM_VARIABLE, -0.1));
            }
        }
        if (!this.lockedOnRoad && this.controllerCount == 0) {
            if (this.aileronInput > 0.6) {
                this.setVariable(AILERON_INPUT_VARIABLE, this.aileronInput - 0.6);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_INPUT_VARIABLE, -0.6, 0.0, 25.0));
            } else if (this.aileronInput < -0.6) {
                this.setVariable(AILERON_INPUT_VARIABLE, this.aileronInput + 0.6);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, AILERON_INPUT_VARIABLE, 0.6, -25.0, 0.0));
            } else if (this.aileronInput != 0.0) {
                this.setVariable(AILERON_INPUT_VARIABLE, 0.0);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableSet(this, AILERON_INPUT_VARIABLE, 0.0));
            }
            if (this.elevatorInput > 0.6) {
                this.setVariable(ELEVATOR_INPUT_VARIABLE, this.elevatorInput - 0.6);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_INPUT_VARIABLE, -0.6, 0.0, 25.0));
            } else if (this.elevatorInput < -0.6) {
                this.setVariable(ELEVATOR_INPUT_VARIABLE, this.elevatorInput + 0.6);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, ELEVATOR_INPUT_VARIABLE, 0.6, -25.0, 0.0));
            } else if (this.elevatorInput != 0.0) {
                this.setVariable(ELEVATOR_INPUT_VARIABLE, 0.0);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableSet(this, ELEVATOR_INPUT_VARIABLE, 0.0));
            }
            if (this.rudderInput > 2.0) {
                this.setVariable(RUDDER_INPUT_VARIABLE, this.rudderInput - 2.0);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, RUDDER_INPUT_VARIABLE, -2.0, 0.0, 45.0));
            } else if (this.rudderInput < -2.0) {
                this.setVariable(RUDDER_INPUT_VARIABLE, this.rudderInput + 2.0);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, RUDDER_INPUT_VARIABLE, 2.0, -45.0, 0.0));
            } else if (this.rudderInput != 0.0) {
                this.setVariable(RUDDER_INPUT_VARIABLE, 0.0);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableSet(this, RUDDER_INPUT_VARIABLE, 0.0));
            }
        }
    }

    protected double getRecursiveTowingThrust() {
        if (!this.towingConnections.isEmpty()) {
            double thrust = 0.0;
            for (TowingConnection connection : this.towingConnections) {
                if (connection.hitchConnection.mounted) continue;
                thrust += connection.towedVehicle.thrustForceValue + connection.towedVehicle.getRecursiveTowingThrust();
            }
            return thrust;
        }
        return 0.0;
    }

    protected static double getLiftCoeff(double angleOfAttack, double maxLiftCoeff) {
        if (angleOfAttack == 0.0) {
            return 0.0;
        }
        if (Math.abs(angleOfAttack) <= 18.75) {
            return maxLiftCoeff * Math.sin(1.5707963267948966 * angleOfAttack / 15.0);
        }
        if (Math.abs(angleOfAttack) <= 22.5) {
            if (angleOfAttack > 0.0) {
                return maxLiftCoeff * (0.4 + 1.0 / (angleOfAttack - 15.0));
            }
            return maxLiftCoeff * (-0.4 + 1.0 / (angleOfAttack + 15.0));
        }
        return maxLiftCoeff * Math.sin(0.5235987755982988 * angleOfAttack / 15.0);
    }

    @Override
    public boolean shouldRenderBeams() {
        return (Boolean)ConfigSystem.client.renderingSettings.vehicleBeams.value;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        if (((JSONVehicle)this.definition).motorized.isTrailer && this.towedByConnection != null && ((JSONVehicle)this.definition).motorized.hookupVariables.contains(variable)) {
            return this.towedByConnection.towingVehicle.getRawVariableValue(variable, partialTicks);
        }
        switch (variable) {
            case "yaw": {
                return this.orientation.angles.y;
            }
            case "heading": {
                double heading = -this.orientation.angles.y;
                if (((Boolean)ConfigSystem.client.controlSettings.north360.value).booleanValue()) {
                    heading += 180.0;
                }
                while (heading < 0.0) {
                    heading += 360.0;
                }
                while (heading > 360.0) {
                    heading -= 360.0;
                }
                return heading;
            }
            case "pitch": {
                return this.orientation.angles.x;
            }
            case "roll": {
                return this.orientation.angles.z;
            }
            case "altitude": {
                return this.position.y - this.seaLevel;
            }
            case "speed": {
                return this.indicatedSpeed;
            }
            case "speed_scaled": {
                return this.indicatedSpeed / this.speedFactor;
            }
            case "speed_factor": {
                return this.speedFactor;
            }
            case "acceleration": {
                return this.motion.length() - this.prevMotion.length();
            }
            case "road_angle_front": {
                return this.frontFollower != null ? this.frontFollower.getCurrentYaw() - this.orientation.angles.y : 0.0;
            }
            case "road_angle_rear": {
                return this.rearFollower != null ? this.rearFollower.getCurrentYaw() - this.orientation.angles.y : 0.0;
            }
            case "autopilot_present": {
                return ((JSONVehicle)this.definition).motorized.hasAutopilot ? 1.0 : 0.0;
            }
            case "fuel": {
                return this.fuelTank.getFluidLevel() / (double)this.fuelTank.getMaxLevel();
            }
            case "mass": {
                return this.currentMass;
            }
            case "electric_power": {
                return this.electricPower;
            }
            case "electric_usage": {
                return this.electricFlow * 20.0;
            }
            case "engines_on": {
                return this.enginesOn ? 1.0 : 0.0;
            }
            case "engines_starting": {
                return this.enginesStarting ? 1.0 : 0.0;
            }
            case "engines_running": {
                return this.enginesRunning ? 1.0 : 0.0;
            }
            case "reverser": {
                return this.reverseThrust ? 1.0 : 0.0;
            }
            case "reverser_present": {
                return this.hasReverseThrust ? 1.0 : 0.0;
            }
            case "locked": {
                return this.locked ? 1.0 : 0.0;
            }
            case "door": {
                return this.parkingBrakeOn && this.velocity < 0.25 ? 1.0 : 0.0;
            }
            case "fueling": {
                return this.beingFueled ? 1.0 : 0.0;
            }
            case "thrust": {
                return this.thrustForceValue;
            }
            case "flaps_actual": {
                return this.flapCurrentAngle;
            }
            case "flaps_moving": {
                return this.flapCurrentAngle != this.flapDesiredAngle ? 1.0 : 0.0;
            }
            case "flaps_increasing": {
                return this.flapCurrentAngle < this.flapDesiredAngle ? 1.0 : 0.0;
            }
            case "flaps_decreasing": {
                return this.flapCurrentAngle > this.flapDesiredAngle ? 1.0 : 0.0;
            }
            case "vertical_speed": {
                return this.motion.y * this.speedFactor * 20.0;
            }
            case "lift_reserve": {
                return -this.trackAngle;
            }
            case "turn_coordinator": {
                return (this.rotation.angles.z / 10.0 + this.rotation.angles.y) / 0.15 * 25.0;
            }
            case "turn_indicator": {
                return this.rotation.angles.y / (double)0.15f * 25.0;
            }
            case "pitch_indicator": {
                return this.rotation.angles.x / (double)0.15f * 25.0;
            }
            case "slip": {
                return 75.0 * this.sideVector.dotProduct(this.normalizedVelocityVector, true);
            }
            case "slip_degrees": {
                return -Math.toDegrees(Math.asin(this.sideVector.dotProduct(this.normalizedVelocityVector, false)));
            }
            case "slip_understeer": {
                return this.getSteeringAngle() * (1.0 - Math.max(0.0, Math.min(1.0, Math.abs(this.turningForce) / 10.0)));
            }
            case "gear_present": {
                return ((JSONVehicle)this.definition).motorized.gearSequenceDuration != 0 ? 1.0 : 0.0;
            }
            case "gear_moving": {
                return (this.isVariableActive("gear_setpoint") ? this.gearMovementTime != ((JSONVehicle)this.definition).motorized.gearSequenceDuration : this.gearMovementTime != 0) ? 1.0 : 0.0;
            }
            case "beacon_direction": {
                return this.selectedBeacon != null ? this.orientation.angles.getClampedYDelta(Math.toDegrees(Math.atan2(this.selectedBeacon.position.x - this.position.x, this.selectedBeacon.position.z - this.position.z))) : 0.0;
            }
            case "beacon_bearing_setpoint": {
                return this.selectedBeacon != null ? this.selectedBeacon.bearing : 0.0;
            }
            case "beacon_bearing_delta": {
                return this.selectedBeacon != null ? this.selectedBeacon.getBearingDelta(this) : 0.0;
            }
            case "beacon_glideslope_setpoint": {
                return this.selectedBeacon != null ? this.selectedBeacon.glideSlope : 0.0;
            }
            case "beacon_glideslope_actual": {
                return this.selectedBeacon != null ? Math.toDegrees(Math.asin((this.position.y - this.selectedBeacon.position.y) / this.position.distanceTo(this.selectedBeacon.position))) : 0.0;
            }
            case "beacon_glideslope_delta": {
                return this.selectedBeacon != null ? this.selectedBeacon.glideSlope - Math.toDegrees(Math.asin((this.position.y - this.selectedBeacon.position.y) / this.position.distanceTo(this.selectedBeacon.position))) : 0.0;
            }
            case "beacon_distance": {
                return this.selectedBeacon != null ? Math.hypot(-this.selectedBeacon.position.z + this.position.z, -this.selectedBeacon.position.x + this.position.x) : 0.0;
            }
        }
        if (variable.startsWith("missile_")) {
            String missileVariable = variable.substring(variable.lastIndexOf("_") + 1);
            int missileNumber = EntityVehicleF_Physics.getVariableNumber(variable.substring(0, variable.lastIndexOf(95)));
            if (missileNumber != -1) {
                if (this.missilesIncoming.size() <= missileNumber) {
                    return 0.0;
                }
                switch (missileVariable) {
                    case "distance": {
                        return ((EntityBullet)this.missilesIncoming.get((int)missileNumber)).targetDistance;
                    }
                    case "direction": {
                        Point3D missilePos = ((EntityBullet)this.missilesIncoming.get((int)missileNumber)).position;
                        return Math.toDegrees(Math.atan2(-missilePos.z + this.position.z, -missilePos.x + this.position.x)) + 90.0 + this.orientation.angles.y;
                    }
                }
            } else if (missileVariable.equals("incoming")) {
                return this.missilesIncoming.isEmpty() ? 0.0 : 1.0;
            }
        }
        if (variable.startsWith("radar_")) {
            List radarList;
            String[] parsedVariable = variable.split("_");
            switch (parsedVariable[1]) {
                case "aircraft": {
                    radarList = this.aircraftOnRadar;
                    break;
                }
                case "ground": {
                    radarList = this.groundersOnRadar;
                    break;
                }
                default: {
                    switch (parsedVariable.length) {
                        case 2: {
                            switch (parsedVariable[1]) {
                                case "detected": {
                                    return this.radarsTracking.isEmpty() ? 0.0 : 1.0;
                                }
                            }
                            break;
                        }
                        case 3: {
                            int radarNumber = Integer.parseInt(parsedVariable[1]) - 1;
                            if (this.radarsTracking.size() <= radarNumber) {
                                return 0.0;
                            }
                            switch (parsedVariable[2]) {
                                case "detected": {
                                    return 1.0;
                                }
                                case "distance": {
                                    return ((AEntityD_Definable)this.radarsTracking.get((int)radarNumber)).position.distanceTo(this.position);
                                }
                                case "direction": {
                                    Point3D entityPos = ((AEntityD_Definable)this.radarsTracking.get((int)radarNumber)).position;
                                    return Math.toDegrees(Math.atan2(-entityPos.z + this.position.z, -entityPos.x + this.position.x)) + 90.0 + this.orientation.angles.y;
                                }
                            }
                        }
                    }
                    return 0.0;
                }
            }
            int radarNumber = Integer.parseInt(parsedVariable[2]) - 1;
            if (radarNumber < radarList.size()) {
                AEntityB_Existing contact = (AEntityB_Existing)radarList.get(radarNumber);
                switch (parsedVariable[3]) {
                    case "distance": {
                        return contact.position.distanceTo(this.position);
                    }
                    case "direction": {
                        double delta;
                        for (delta = Math.toDegrees(Math.atan2(-contact.position.z + this.position.z, -contact.position.x + this.position.x)) + 90.0 + this.orientation.angles.y; delta < -180.0; delta += 360.0) {
                        }
                        while (delta > 180.0) {
                            delta -= 360.0;
                        }
                        return delta;
                    }
                    case "speed": {
                        return contact.velocity;
                    }
                    case "altitude": {
                        return contact.position.y;
                    }
                    case "angle": {
                        return -Math.toDegrees(Math.atan2(-contact.position.y + this.position.y, Math.hypot(-contact.position.z + this.position.z, -contact.position.x + this.position.x))) + this.orientation.angles.x;
                    }
                }
            }
            return 0.0;
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public void renderBoundingBoxes(TransformationMatrix transform) {
        super.renderBoundingBoxes(transform);
        if (this.towedByConnection == null || !this.towedByConnection.hitchConnection.mounted) {
            for (BoundingBox box : this.groundDeviceCollective.getGroundBounds()) {
                box.renderWireframe(this, transform, null, ColorRGB.BLUE);
            }
        }
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setDouble("flapCurrentAngle", this.flapCurrentAngle);
        return data;
    }
}

