/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.List;
import minecrafttransportsimulator.baseclasses.IInventoryProvider;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketInventoryContainerChange;

public class EntityInventoryContainer
extends AEntityA_Base
implements IInventoryProvider {
    private static final IWrapperNBT blankData = InterfaceManager.coreInterface.getNewNBTWrapper();
    private final List<IWrapperItemStack> inventory;
    private final int stackSize;

    public EntityInventoryContainer(AWrapperWorld world, IWrapperNBT data, int maxSlots) {
        this(world, data, maxSlots, 64);
    }

    public EntityInventoryContainer(AWrapperWorld world, IWrapperNBT data, int maxSlots, int stackSize) {
        super(world, data);
        this.inventory = data != null ? data.getStacks(maxSlots) : blankData.getStacks(maxSlots);
        this.stackSize = stackSize;
    }

    @Override
    public AEntityA_Base.EntityAutoUpdateTime getUpdateTime() {
        return AEntityA_Base.EntityAutoUpdateTime.NEVER;
    }

    @Override
    public double getMass() {
        return this.getInventoryMass();
    }

    @Override
    public int getSize() {
        return this.inventory.size();
    }

    @Override
    public int getStackSize() {
        return this.stackSize;
    }

    @Override
    public IWrapperItemStack getStack(int index) {
        return this.inventory.get(index);
    }

    @Override
    public void setStack(IWrapperItemStack stackToSet, int index) {
        this.inventory.set(index, stackToSet);
        if (!this.world.isClient()) {
            InterfaceManager.packetInterface.sendToAllClients(new PacketInventoryContainerChange(this, index, stackToSet));
        }
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setStacks(this.inventory);
        return data;
    }
}

