/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.components;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TowingConnection;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.instances.GUIPanel;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONConnection;
import minecrafttransportsimulator.jsondefs.JSONConnectionGroup;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityTowingChange;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.LanguageSystem;

public abstract class AEntityG_Towable<JSONDefinition extends AJSONPartProvider>
extends AEntityF_Multipart<JSONDefinition> {
    public TowingConnection towedByConnection;
    private TowingConnection savedTowedByConnection;
    public final List<TowingConnection> towingConnections = new ArrayList<TowingConnection>();
    private final List<TowingConnection> savedTowingConnections = new ArrayList<TowingConnection>();
    private final List<TowingConnection> disconnectedTowingConnections = new ArrayList<TowingConnection>();
    private final List<TowingConnection> savedDisconnectedTowingConnections = new ArrayList<TowingConnection>();
    public static final String TOWING_CONNECTION_REQUEST_VARIABLE = "connection_requested";

    public AEntityG_Towable(AWrapperWorld world, IWrapperPlayer placingPlayer, AItemSubTyped<JSONDefinition> item, IWrapperNBT data) {
        super(world, placingPlayer, item, data);
        if (data != null) {
            int i;
            IWrapperNBT towData = data.getData("towedByConnection");
            if (towData != null) {
                this.savedTowedByConnection = new TowingConnection(towData);
            }
            int towingConnectionCount = data.getInteger("towingConnectionCount");
            for (i = 0; i < towingConnectionCount; ++i) {
                towData = data.getData("towingConnection" + i);
                if (towData == null) continue;
                this.savedTowingConnections.add(new TowingConnection(towData));
            }
            towingConnectionCount = data.getInteger("disconnectedTowingConnectionCount");
            for (i = 0; i < towingConnectionCount; ++i) {
                towData = data.getData("disconnectedTowingConnection" + i);
                if (towData == null) continue;
                this.savedDisconnectedTowingConnections.add(new TowingConnection(towData));
            }
        }
    }

    @Override
    public void update() {
        int connectionRequestIndex;
        TowingConnection savedTowingConnection;
        int i;
        super.update();
        this.world.beginProfiling("EntityG_Level", true);
        if (this.towedByConnection != null && !this.towedByConnection.towingEntity.isValid) {
            this.towedByConnection.towingVehicle.disconnectTrailer(this.towedByConnection.towingVehicle.towingConnections.indexOf(this.towedByConnection));
        }
        if (!this.towingConnections.isEmpty()) {
            for (i = 0; i < this.towingConnections.size(); ++i) {
                TowingConnection connection = this.towingConnections.get(i);
                if (connection.towedEntity.isValid) continue;
                this.disconnectTrailer(i);
                --i;
            }
        }
        if (this.savedTowedByConnection != null && this.ticksExisted % 20L == 0L && this.ticksExisted > 0L) {
            if (this.ticksExisted <= 100L || this.world.isClient()) {
                if (this.savedTowedByConnection.initConnection(this.world)) {
                    this.savedTowedByConnection.towingVehicle.connectTrailer(this.savedTowedByConnection, false);
                }
            } else {
                this.savedTowedByConnection = null;
                InterfaceManager.coreInterface.logError("Could not hook-up trailer to entity towing it.  Did the JSON or pack change?");
            }
        }
        if (!this.savedTowingConnections.isEmpty() && this.ticksExisted % 20L == 0L && this.ticksExisted > 0L) {
            if (this.ticksExisted <= 100L || this.world.isClient()) {
                for (i = 0; i < this.savedTowingConnections.size(); ++i) {
                    savedTowingConnection = this.savedTowingConnections.get(i);
                    try {
                        if (!savedTowingConnection.initConnection(this.world)) continue;
                        this.connectTrailer(savedTowingConnection, false);
                        --i;
                        continue;
                    }
                    catch (Exception e) {
                        InterfaceManager.coreInterface.logError("Could not connect a trailer to the entity towing it.  Did the JSON or pack change?");
                    }
                }
            } else {
                this.savedTowingConnections.clear();
                InterfaceManager.coreInterface.logError("Could not connect trailer(s) to the entity towing them.  Did the JSON or pack change?");
            }
        }
        if (!this.savedDisconnectedTowingConnections.isEmpty() && this.ticksExisted % 20L == 0L) {
            if (this.ticksExisted <= 100L || this.world.isClient()) {
                for (i = 0; i < this.savedDisconnectedTowingConnections.size(); ++i) {
                    savedTowingConnection = this.savedDisconnectedTowingConnections.get(i);
                    try {
                        if (!savedTowingConnection.initConnection(this.world)) continue;
                        this.disconnectedTowingConnections.add(savedTowingConnection);
                        --i;
                        continue;
                    }
                    catch (Exception e) {
                        InterfaceManager.coreInterface.logError("Could not restore saved disconnected trailer(s) to the entity towing them.  Did the JSON or pack change?");
                    }
                }
            } else {
                this.savedDisconnectedTowingConnections.clear();
                InterfaceManager.coreInterface.logError("Could not restore saved disconnected trailer(s) to the entity towing them.  Did the JSON or pack change?");
            }
        }
        if ((connectionRequestIndex = (int)this.getVariable(TOWING_CONNECTION_REQUEST_VARIABLE)) != 0) {
            if (!this.world.isClient()) {
                this.handleConnectionRequest(this, connectionRequestIndex - 1);
            }
            this.setVariable(TOWING_CONNECTION_REQUEST_VARIABLE, 0.0);
        } else if (!this.world.isClient() && !this.snapConnectionIndexes.isEmpty() && this.ticksExisted % (long)(10 / this.snapConnectionIndexes.size()) == 0L) {
            if (++this.lastSnapConnectionTried == this.snapConnectionIndexes.size()) {
                this.lastSnapConnectionTried = 0;
            }
            if (!this.connectionGroupsIndexesInUse.contains(this.lastSnapConnectionTried)) {
                this.setVariable(TOWING_CONNECTION_REQUEST_VARIABLE, this.lastSnapConnectionTried + 1);
                this.bypassConnectionPacket = true;
            }
        }
        for (APart part : this.allParts) {
            connectionRequestIndex = (int)part.getVariable(TOWING_CONNECTION_REQUEST_VARIABLE);
            if (connectionRequestIndex != 0) {
                if (!this.world.isClient()) {
                    this.handleConnectionRequest(part, connectionRequestIndex - 1);
                }
                part.setVariable(TOWING_CONNECTION_REQUEST_VARIABLE, 0.0);
                continue;
            }
            if (this.world.isClient() || this.towedByConnection != null || part.snapConnectionIndexes.isEmpty() || part.ticksExisted % (long)(10 / part.snapConnectionIndexes.size()) != 0L) continue;
            if (++part.lastSnapConnectionTried == part.snapConnectionIndexes.size()) {
                part.lastSnapConnectionTried = 0;
            }
            if (part.connectionGroupsIndexesInUse.contains(part.lastSnapConnectionTried)) continue;
            part.setVariable(TOWING_CONNECTION_REQUEST_VARIABLE, part.lastSnapConnectionTried + 1);
            part.bypassConnectionPacket = true;
            break;
        }
        this.world.endProfiling();
    }

    public boolean blockMainUpdateCall() {
        return this.towedByConnection != null;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        if (variable.startsWith("connection")) {
            TowingConnection foundConnection = null;
            String[] variableData = variable.split("_");
            if (variableData.length >= 3) {
                int connectionIndex;
                boolean isHookup = false;
                int groupIndex = Integer.parseInt(variableData[1]) - 1;
                int n = connectionIndex = variableData.length == 4 ? Integer.parseInt(variableData[2]) - 1 : -1;
                if (this.towedByConnection != null && this.towedByConnection.hookupGroupIndex == groupIndex && (connectionIndex == -1 || this.towedByConnection.hookupConnectionIndex == connectionIndex)) {
                    isHookup = true;
                    foundConnection = this.towedByConnection;
                }
                if (foundConnection == null && !this.towingConnections.isEmpty()) {
                    for (TowingConnection towingConnection : this.towingConnections) {
                        if (towingConnection.hitchGroupIndex != groupIndex || connectionIndex != -1 && towingConnection.hitchConnectionIndex != connectionIndex) continue;
                        foundConnection = towingConnection;
                        break;
                    }
                }
                variable = variableData[variableData.length == 4 ? 3 : 2];
                if (foundConnection != null) {
                    switch (variable) {
                        case "connected": {
                            return 1.0;
                        }
                        case "pitch": {
                            return isHookup ? new Point3D((double)0.0, (double)0.0, (double)1.0).rotate((RotationMatrix)foundConnection.towingVehicle.orientation).reOrigin((RotationMatrix)this.orientation).getAngles((boolean)false).x : new Point3D((double)0.0, (double)0.0, (double)1.0).rotate((RotationMatrix)foundConnection.towedVehicle.orientation).reOrigin((RotationMatrix)this.orientation).getAngles((boolean)false).x;
                        }
                        case "yaw": {
                            return isHookup ? new Point3D((double)0.0, (double)0.0, (double)1.0).rotate((RotationMatrix)foundConnection.towingVehicle.orientation).reOrigin((RotationMatrix)this.orientation).getAngles((boolean)false).y : new Point3D((double)0.0, (double)0.0, (double)1.0).rotate((RotationMatrix)foundConnection.towedVehicle.orientation).reOrigin((RotationMatrix)this.orientation).getAngles((boolean)false).y;
                        }
                        case "roll": {
                            return isHookup ? new Point3D((double)0.0, (double)0.0, (double)1.0).rotate((RotationMatrix)foundConnection.towingVehicle.orientation).reOrigin((RotationMatrix)this.orientation).getAngles((boolean)false).z : new Point3D((double)0.0, (double)0.0, (double)1.0).rotate((RotationMatrix)foundConnection.towedVehicle.orientation).reOrigin((RotationMatrix)this.orientation).getAngles((boolean)false).z;
                        }
                    }
                } else if (variable.equals("present")) {
                    return ((AJSONPartProvider)this.definition).connectionGroups != null && ((AJSONPartProvider)this.definition).connectionGroups.size() > groupIndex ? 1.0 : 0.0;
                }
            }
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    @Override
    public void doPostUpdateLogic() {
        super.doPostUpdateLogic();
        if (!this.towingConnections.isEmpty()) {
            this.world.beginProfiling("TowedEntities", true);
            for (TowingConnection connection : this.towingConnections) {
                connection.hitchPriorPosition.set(connection.hitchCurrentPosition);
                connection.hitchCurrentPosition.set(connection.hitchConnection.pos).multiply(connection.towingEntity.scale).rotate(connection.towingEntity.orientation).add(connection.towingEntity.position);
                connection.towedVehicle.update();
                connection.towedVehicle.doPostUpdateLogic();
                if (connection.towedVehicle.towedByConnection != null) continue;
                break;
            }
            this.world.endProfiling();
        }
        if (!this.disconnectedTowingConnections.isEmpty()) {
            this.world.beginProfiling("DisconnectedEntities", true);
            for (TowingConnection connection : this.disconnectedTowingConnections) {
                connection.hitchCurrentPosition.set(connection.hitchConnection.pos).multiply(connection.towingEntity.scale).rotate(connection.towingEntity.orientation).add(connection.towingEntity.position);
                connection.hookupCurrentPosition.set(connection.hookupConnection.pos).multiply(connection.towedEntity.scale).rotate(connection.towedEntity.orientation).add(connection.towedEntity.position);
                if (connection.towingEntity.isValid && connection.towedEntity.isValid && connection.hitchCurrentPosition.isDistanceToCloserThan(connection.hookupCurrentPosition, connection.hitchConnection.distance * 2.0)) continue;
                this.disconnectedTowingConnections.remove(connection);
                connection.towingEntity.connectionGroupsIndexesInUse.remove(connection.hitchGroupIndex);
                connection.towedEntity.connectionGroupsIndexesInUse.remove(connection.hookupGroupIndex);
                break;
            }
            this.world.endProfiling();
        }
    }

    @Override
    public boolean canCollideWith(AEntityB_Existing entityToCollide) {
        return super.canCollideWith(entityToCollide) && !(entityToCollide instanceof AEntityG_Towable) || !this.areWeTowedBy((AEntityG_Towable)entityToCollide) && !this.areWeTowing((AEntityG_Towable)entityToCollide);
    }

    protected boolean areWeTowedBy(AEntityG_Towable<?> entity) {
        if (this.towedByConnection == null) {
            return false;
        }
        if (entity == this.towedByConnection.towingVehicle) {
            return true;
        }
        return this.towedByConnection.towingVehicle.areWeTowedBy(entity);
    }

    protected boolean areWeTowing(AEntityG_Towable<?> entity) {
        if (!this.towingConnections.isEmpty()) {
            for (TowingConnection connection : this.towingConnections) {
                if (entity == connection.towedVehicle) {
                    return true;
                }
                if (!connection.towedVehicle.areWeTowing(entity)) continue;
                return true;
            }
        }
        return false;
    }

    private void handleConnectionRequest(AEntityE_Interactable<?> connectionDefiner, int connectionGroupIndex) {
        JSONConnectionGroup requestedGroup = ((AJSONInteractableEntity)connectionDefiner.definition).connectionGroups.get(connectionGroupIndex);
        Object connectionToDisconnect = null;
        if (requestedGroup.isHitch) {
            for (TowingConnection connection : this.towingConnections) {
                if (!connectionDefiner.equals(connection.towingEntity) || connection.hitchGroupIndex != connectionGroupIndex) continue;
                connectionToDisconnect = connection;
                break;
            }
        }
        if (requestedGroup.isHookup && this.towedByConnection != null && this.towedByConnection.hookupGroupIndex == connectionGroupIndex) {
            connectionToDisconnect = this.towedByConnection;
        }
        if (connectionToDisconnect == null) {
            TrailerConnectionResult result;
            ArrayList<EntityVehicleF_Physics> entitiesToCheck = new ArrayList<EntityVehicleF_Physics>(this.world.getEntitiesOfType(EntityVehicleF_Physics.class));
            if (requestedGroup.isHitch) {
                for (AEntityG_Towable aEntityG_Towable : entitiesToCheck) {
                    result = this.checkIfTrailerCanConnect(this, connectionDefiner, connectionGroupIndex, aEntityG_Towable, aEntityG_Towable, -1);
                    if (result.skip) {
                        for (APart testPart : aEntityG_Towable.allParts) {
                            result = this.checkIfTrailerCanConnect(this, connectionDefiner, connectionGroupIndex, aEntityG_Towable, testPart, -1);
                            if (result.skip) continue;
                            result.handlePacket(connectionDefiner);
                            return;
                        }
                        continue;
                    }
                    result.handlePacket(connectionDefiner);
                    return;
                }
            }
            if (requestedGroup.isHookup) {
                for (AEntityG_Towable aEntityG_Towable : entitiesToCheck) {
                    result = aEntityG_Towable.checkIfTrailerCanConnect(aEntityG_Towable, aEntityG_Towable, -1, this, connectionDefiner, connectionGroupIndex);
                    if (result.skip) {
                        for (APart testPart : aEntityG_Towable.allParts) {
                            result = aEntityG_Towable.checkIfTrailerCanConnect(aEntityG_Towable, testPart, -1, this, connectionDefiner, connectionGroupIndex);
                            if (result.skip) continue;
                            result.handlePacket(connectionDefiner);
                            return;
                        }
                        continue;
                    }
                    result.handlePacket(connectionDefiner);
                    return;
                }
            }
            TrailerConnectionResult.NOTFOUND.handlePacket(connectionDefiner);
        } else if (connectionToDisconnect.equals(this.towedByConnection)) {
            this.towedByConnection.towingVehicle.disconnectTrailer(this.towedByConnection.towingVehicle.towingConnections.indexOf(this.towedByConnection));
            TrailerConnectionResult.DISCONNECTED.handlePacket(this);
        } else {
            this.disconnectTrailer(this.towingConnections.indexOf(connectionToDisconnect));
            TrailerConnectionResult.DISCONNECTED.handlePacket(this);
        }
    }

    private TrailerConnectionResult checkIfTrailerCanConnect(AEntityG_Towable<?> hitchEntity, AEntityE_Interactable<?> hitchConnectionDefiner, int requestedHitchGroupIndex, AEntityG_Towable<?> hookupEntity, AEntityE_Interactable<?> hookupConnectionDefiner, int requestedHookupGroupIndex) {
        if (hitchConnectionDefiner.connectionGroupsIndexesInUse.contains(requestedHitchGroupIndex) || hookupConnectionDefiner.connectionGroupsIndexesInUse.contains(requestedHookupGroupIndex)) {
            return TrailerConnectionResult.ALREADY_TOWED;
        }
        if (hookupEntity.towedByConnection != null) {
            return TrailerConnectionResult.ALREADY_TOWED;
        }
        if (hookupEntity.equals(hitchEntity)) {
            return TrailerConnectionResult.FEEDBACK_LOOP;
        }
        if (super.isAlreadyTowing(hitchEntity, hookupEntity)) {
            return TrailerConnectionResult.FEEDBACK_LOOP;
        }
        boolean matchingConnection = false;
        boolean trailerInRange = false;
        if (hitchConnectionDefiner.position.isDistanceToCloserThan(hookupConnectionDefiner.position, 25.0) && ((AJSONInteractableEntity)hitchConnectionDefiner.definition).connectionGroups != null && !((AJSONInteractableEntity)hitchConnectionDefiner.definition).connectionGroups.isEmpty() && ((AJSONInteractableEntity)hookupConnectionDefiner.definition).connectionGroups != null && !((AJSONInteractableEntity)hookupConnectionDefiner.definition).connectionGroups.isEmpty()) {
            for (int hitchGroupIndex = 0; hitchGroupIndex < ((AJSONInteractableEntity)hitchConnectionDefiner.definition).connectionGroups.size(); ++hitchGroupIndex) {
                JSONConnectionGroup hitchConnectionGroup = ((AJSONInteractableEntity)hitchConnectionDefiner.definition).connectionGroups.get(hitchGroupIndex);
                if (!hitchConnectionGroup.isHitch || requestedHitchGroupIndex != -1 && hitchGroupIndex != requestedHitchGroupIndex) continue;
                for (int hookupGroupIndex = 0; hookupGroupIndex < ((AJSONInteractableEntity)hookupConnectionDefiner.definition).connectionGroups.size(); ++hookupGroupIndex) {
                    JSONConnectionGroup hookupConnectionGroup = ((AJSONInteractableEntity)hookupConnectionDefiner.definition).connectionGroups.get(hookupGroupIndex);
                    if (!hookupConnectionGroup.isHookup || requestedHookupGroupIndex != -1 && hookupGroupIndex != requestedHookupGroupIndex) continue;
                    for (int hitchConnectionIndex = 0; hitchConnectionIndex < hitchConnectionGroup.connections.size(); ++hitchConnectionIndex) {
                        JSONConnection hitchConnection = hitchConnectionGroup.connections.get(hitchConnectionIndex);
                        Point3D hitchPos = hitchConnection.pos.copy().multiply(hitchConnectionDefiner.scale).rotate(hitchConnectionDefiner.orientation).add(hitchConnectionDefiner.position);
                        for (int hookupConnectionIndex = 0; hookupConnectionIndex < hookupConnectionGroup.connections.size(); ++hookupConnectionIndex) {
                            JSONConnection hookupConnection = hookupConnectionGroup.connections.get(hookupConnectionIndex);
                            Point3D hookupPos = hookupConnection.pos.copy().multiply(hookupConnectionDefiner.scale).rotate(hookupConnectionDefiner.orientation).add(hookupConnectionDefiner.position);
                            if (!hitchPos.isDistanceToCloserThan(hookupPos, hitchConnection.distance + 10.0)) continue;
                            boolean validType = hitchConnection.type.equals(hookupConnection.type);
                            boolean validDistance = hitchPos.isDistanceToCloserThan(hookupPos, hitchConnection.distance);
                            if (validType && validDistance) {
                                this.connectTrailer(new TowingConnection(hitchConnectionDefiner, hitchGroupIndex, hitchConnectionIndex, hookupConnectionDefiner, hookupGroupIndex, hookupConnectionIndex), true);
                                return TrailerConnectionResult.CONNECTED;
                            }
                            if (validType) {
                                matchingConnection = true;
                                continue;
                            }
                            if (!validDistance) continue;
                            trailerInRange = true;
                        }
                    }
                }
            }
        }
        if (matchingConnection && !trailerInRange) {
            return TrailerConnectionResult.TOOFAR;
        }
        if (!matchingConnection && trailerInRange) {
            return TrailerConnectionResult.WRONGHITCH;
        }
        if (matchingConnection && trailerInRange) {
            return TrailerConnectionResult.MISMATCH;
        }
        return TrailerConnectionResult.NOTFOUND;
    }

    private boolean isAlreadyTowing(AEntityG_Towable<?> vehicleTowing, AEntityG_Towable<?> vehicleToTow) {
        for (TowingConnection connection : this.towingConnections) {
            if (connection.towedVehicle.equals(vehicleTowing) || connection.towedVehicle.equals(vehicleToTow)) {
                return true;
            }
            for (TowingConnection nextConnection : connection.towedVehicle.towingConnections) {
                if (!super.isAlreadyTowing(vehicleTowing, vehicleToTow)) continue;
                return true;
            }
        }
        return false;
    }

    public void connectTrailer(TowingConnection connection, boolean notifyClient) {
        this.towingConnections.add(connection);
        connection.towedVehicle.towedByConnection = connection;
        connection.towingEntity.connectionGroupsIndexesInUse.add(connection.hitchGroupIndex);
        connection.towedEntity.connectionGroupsIndexesInUse.add(connection.hookupGroupIndex);
        connection.hitchCurrentPosition.set(connection.hitchConnection.pos).rotate(connection.towingEntity.orientation).add(connection.towingEntity.position);
        connection.hookupCurrentPosition.set(connection.hookupConnection.pos).rotate(connection.towedEntity.orientation).add(connection.towedEntity.position);
        connection.towedVehicle.savedTowedByConnection = null;
        this.savedTowingConnections.removeIf(testConnection -> connection.hitchConnectionGroup.equals(testConnection.hitchConnectionGroup) && connection.hitchConnectionIndex == testConnection.hitchConnectionIndex);
        if (!this.world.isClient()) {
            if (notifyClient) {
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityTowingChange(this, connection));
            }
        } else if (AGUIBase.activeInputGUI instanceof GUIPanel) {
            ((GUIPanel)AGUIBase.activeInputGUI).handleConnectionChange(connection);
        }
    }

    public void disconnectTrailer(int connectionIndex) {
        TowingConnection connection = this.towingConnections.remove(connectionIndex);
        connection.towedVehicle.towedByConnection = null;
        if (connection.hitchConnectionGroup.isSnap || connection.hookupConnectionGroup.isSnap) {
            this.disconnectedTowingConnections.add(connection);
        } else {
            connection.towingEntity.connectionGroupsIndexesInUse.remove(connection.hitchGroupIndex);
            connection.towedEntity.connectionGroupsIndexesInUse.remove(connection.hookupGroupIndex);
        }
        if (!this.world.isClient()) {
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityTowingChange(this, connectionIndex));
        } else if (AGUIBase.activeInputGUI instanceof GUIPanel) {
            ((GUIPanel)AGUIBase.activeInputGUI).handleConnectionChange(connection);
        }
    }

    public void disconnectAllConnections() {
        this.towingConnections.clear();
        this.towedByConnection = null;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        if (this.towedByConnection != null) {
            data.setData("towedByConnection", this.towedByConnection.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        }
        int towingConnectionIndex = 0;
        for (TowingConnection towingEntry : this.towingConnections) {
            data.setData("towingConnection" + towingConnectionIndex++, towingEntry.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        }
        for (TowingConnection towingEntry : this.savedTowingConnections) {
            data.setData("towingConnection" + towingConnectionIndex++, towingEntry.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        }
        data.setInteger("towingConnectionCount", towingConnectionIndex);
        towingConnectionIndex = 0;
        for (TowingConnection towingEntry : this.disconnectedTowingConnections) {
            data.setData("disconnectedTowingConnection" + towingConnectionIndex++, towingEntry.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        }
        data.setInteger("disconnectedTowingConnectionCount", towingConnectionIndex);
        return data;
    }

    private static enum TrailerConnectionResult {
        FEEDBACK_LOOP(true, LanguageSystem.INTERACT_TRAILER_FEEDBACKLOOP),
        ALREADY_TOWED(true, LanguageSystem.INTERACT_TRAILER_ALREADYTOWED),
        NOTFOUND(true, LanguageSystem.INTERACT_TRAILER_NOTFOUND),
        TOOFAR(true, LanguageSystem.INTERACT_TRAILER_TOOFAR),
        WRONGHITCH(true, LanguageSystem.INTERACT_TRAILER_WRONGHITCH),
        MISMATCH(true, LanguageSystem.INTERACT_TRAILER_MISMATCH),
        CONNECTED(false, LanguageSystem.INTERACT_TRAILER_CONNECTED),
        DISCONNECTED(false, LanguageSystem.INTERACT_TRAILER_DISCONNECTED);

        private final boolean skip;
        private final LanguageSystem.LanguageEntry language;

        private TrailerConnectionResult(boolean skip, LanguageSystem.LanguageEntry language) {
            this.skip = skip;
            this.language = language;
        }

        private void handlePacket(AEntityE_Interactable<?> messageSource) {
            if (messageSource.bypassConnectionPacket) {
                messageSource.bypassConnectionPacket = false;
            } else {
                for (IWrapperPlayer player : messageSource.world.getPlayersWithin(new BoundingBox(messageSource.position, 16.0, 16.0, 16.0))) {
                    player.sendPacket(new PacketPlayerChatMessage(player, this.language, new Object[0]));
                }
            }
        }
    }
}

