/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.AnimationSwitchbox;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONCollisionBox;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.jsondefs.JSONConnectionGroup;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONInstrumentDefinition;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.rendering.RenderInstrument;
import minecrafttransportsimulator.rendering.RenderableData;
import minecrafttransportsimulator.rendering.RenderableVertices;
import minecrafttransportsimulator.systems.LanguageSystem;

public abstract class AEntityE_Interactable<JSONDefinition extends AJSONInteractableEntity>
extends AEntityD_Definable<JSONDefinition> {
    private static final TransformationMatrix instrumentTransform = new TransformationMatrix();
    private static final RotationMatrix INSTRUMENT_ROTATION_INVERSION = new RotationMatrix().setToAxisAngle(0.0, 1.0, 0.0, 180.0);
    public final List<List<BoundingBox>> definitionCollisionBoxes;
    public final Set<BoundingBox> collisionBoxes;
    private final Map<JSONCollisionGroup, AnimationSwitchbox> collisionSwitchboxes;
    public final BoundingBox encompassingBox;
    public final Set<AEntityE_Interactable<?>> collidedEntities;
    public final List<ItemInstrument> instruments;
    public final List<List<RenderableData>> instrumentRenderables;
    public final Map<JSONInstrument.JSONInstrumentComponent, RenderInstrument.InstrumentSwitchbox> instrumentComponentSwitchboxes;
    public final Map<JSONInstrumentDefinition, AnimationSwitchbox> instrumentSlotSwitchboxes;
    public double damageAmount;
    public static final String DAMAGE_VARIABLE = "damage";
    public boolean outOfHealth;
    protected final List<Integer> snapConnectionIndexes;
    protected final Set<Integer> connectionGroupsIndexesInUse;
    protected int lastSnapConnectionTried;
    protected boolean bypassConnectionPacket;

    public AEntityE_Interactable(AWrapperWorld world, IWrapperPlayer placingPlayer, AItemSubTyped<JSONDefinition> item, IWrapperNBT data) {
        block9: {
            int i;
            super(world, placingPlayer, item, data);
            this.definitionCollisionBoxes = new ArrayList<List<BoundingBox>>();
            this.collisionBoxes = new HashSet<BoundingBox>();
            this.collisionSwitchboxes = new HashMap<JSONCollisionGroup, AnimationSwitchbox>();
            this.encompassingBox = new BoundingBox(new Point3D(), new Point3D(), 0.0, 0.0, 0.0, false, null);
            this.collidedEntities = new HashSet();
            this.instruments = new ArrayList<ItemInstrument>();
            this.instrumentRenderables = new ArrayList<List<RenderableData>>();
            this.instrumentComponentSwitchboxes = new LinkedHashMap<JSONInstrument.JSONInstrumentComponent, RenderInstrument.InstrumentSwitchbox>();
            this.instrumentSlotSwitchboxes = new LinkedHashMap<JSONInstrumentDefinition, AnimationSwitchbox>();
            this.snapConnectionIndexes = new ArrayList<Integer>();
            this.connectionGroupsIndexesInUse = new HashSet<Integer>();
            this.lastSnapConnectionTried = 0;
            this.damageAmount = this.getVariable(DAMAGE_VARIABLE);
            boolean bl = this.outOfHealth = this.damageAmount == (double)((AJSONInteractableEntity)this.definition).general.health && ((AJSONInteractableEntity)this.definition).general.health != 0;
            if (((AJSONInteractableEntity)this.definition).instruments == null) break block9;
            for (i = 0; i < ((AJSONInteractableEntity)this.definition).instruments.size(); ++i) {
                this.instruments.add(null);
                this.instrumentRenderables.add(null);
            }
            if (data != null) {
                for (i = 0; i < ((AJSONInteractableEntity)this.definition).instruments.size(); ++i) {
                    ItemInstrument instrument;
                    String instrumentPackID = data.getString("instrument" + i + "_packID");
                    String instrumentSystemName = data.getString("instrument" + i + "_systemName");
                    if (instrumentPackID.isEmpty() || (instrument = (ItemInstrument)PackParser.getItem(instrumentPackID, instrumentSystemName)) == null) continue;
                    this.addInstrument(instrument, i);
                }
            } else {
                for (JSONInstrumentDefinition packInstrument : ((AJSONInteractableEntity)this.definition).instruments) {
                    if (packInstrument.defaultInstrument == null) continue;
                    try {
                        String instrumentPackID = packInstrument.defaultInstrument.substring(0, packInstrument.defaultInstrument.indexOf(58));
                        String instrumentSystemName = packInstrument.defaultInstrument.substring(packInstrument.defaultInstrument.indexOf(58) + 1);
                        try {
                            ItemInstrument instrument = (ItemInstrument)PackParser.getItem(instrumentPackID, instrumentSystemName);
                            if (instrument == null) continue;
                            this.addInstrument(instrument, ((AJSONInteractableEntity)this.definition).instruments.indexOf(packInstrument));
                        }
                        catch (NullPointerException e) {
                            placingPlayer.sendPacket(new PacketPlayerChatMessage(placingPlayer, LanguageSystem.SYSTEM_DEBUG, "Attempted to add defaultInstrument: " + instrumentPackID + ":" + instrumentSystemName + " to: " + ((AJSONInteractableEntity)this.definition).packID + ":" + ((AJSONInteractableEntity)this.definition).systemName + " but that instrument doesn't exist in the pack item registry."));
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        placingPlayer.sendPacket(new PacketPlayerChatMessage(placingPlayer, LanguageSystem.SYSTEM_DEBUG, "Could not parse defaultInstrument definition: " + packInstrument.defaultInstrument + ".  Format should be \"packId:instrumentName\""));
                    }
                }
            }
        }
    }

    @Override
    public void initializeAnimations() {
        super.initializeAnimations();
        if (((AJSONInteractableEntity)this.definition).collisionGroups != null) {
            for (JSONCollisionGroup groupDef : ((AJSONInteractableEntity)this.definition).collisionGroups) {
                ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
                for (JSONCollisionBox boxDef : groupDef.collisions) {
                    boxes.add(new BoundingBox(boxDef, groupDef));
                }
                this.definitionCollisionBoxes.add(boxes);
                if (groupDef.animations == null && groupDef.applyAfter == null) continue;
                ArrayList<JSONAnimationDefinition> animations = new ArrayList<JSONAnimationDefinition>();
                if (groupDef.animations != null) {
                    animations.addAll(groupDef.animations);
                }
                this.collisionSwitchboxes.put(groupDef, new AnimationSwitchbox(this, animations, groupDef.applyAfter));
            }
        }
        if (((AJSONInteractableEntity)this.definition).instruments != null) {
            for (JSONInstrumentDefinition packInstrument : ((AJSONInteractableEntity)this.definition).instruments) {
                if (packInstrument.animations == null) continue;
                ArrayList<JSONAnimationDefinition> animations = new ArrayList<JSONAnimationDefinition>(packInstrument.animations);
                this.instrumentSlotSwitchboxes.put(packInstrument, new AnimationSwitchbox(this, animations, packInstrument.applyAfter));
            }
        }
        this.lastSnapConnectionTried = 0;
        if (((AJSONInteractableEntity)this.definition).connectionGroups != null) {
            for (JSONConnectionGroup group : ((AJSONInteractableEntity)this.definition).connectionGroups) {
                if (!group.isSnap || !group.isHookup) continue;
                this.snapConnectionIndexes.add(((AJSONInteractableEntity)this.definition).connectionGroups.indexOf(group));
            }
        }
    }

    @Override
    public void update() {
        super.update();
        this.world.beginProfiling("EntityE_Level", true);
        this.damageAmount = this.getVariable(DAMAGE_VARIABLE);
        this.outOfHealth = this.damageAmount == (double)((AJSONInteractableEntity)this.definition).general.health && ((AJSONInteractableEntity)this.definition).general.health != 0;
        this.world.endProfiling();
    }

    @Override
    public boolean requiresDeltaUpdates() {
        return !this.collisionSwitchboxes.isEmpty() || this.ticksExisted == 1L;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        if ("damage_percent".equals(variable)) {
            return this.damageAmount / (double)((AJSONInteractableEntity)this.definition).general.health;
        }
        if ("damage_totaled".equals(variable)) {
            return this.outOfHealth ? 1.0 : 0.0;
        }
        return super.getRawVariableValue(variable, partialTicks);
    }

    protected void updateCollisionBoxes(boolean requiresDeltaUpdates) {
        this.collisionBoxes.clear();
        if (((AJSONInteractableEntity)this.definition).collisionGroups != null) {
            for (int i = 0; i < ((AJSONInteractableEntity)this.definition).collisionGroups.size(); ++i) {
                AnimationSwitchbox switchBox;
                JSONCollisionGroup groupDef = ((AJSONInteractableEntity)this.definition).collisionGroups.get(i);
                List<BoundingBox> boxes = this.definitionCollisionBoxes.get(i);
                if (groupDef.health != 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!(this.getVariable(stringBuilder.append("collision_").append(i + 1).append("_damage").toString()) < (double)groupDef.health)) continue;
                }
                if ((switchBox = this.collisionSwitchboxes.get(groupDef)) != null) {
                    if (!switchBox.runSwitchbox(0.0f, false)) continue;
                    if (requiresDeltaUpdates) {
                        for (BoundingBox box : boxes) {
                            box.globalCenter.set(box.localCenter).transform(switchBox.netMatrix);
                            box.updateToEntity(this, box.globalCenter);
                        }
                    }
                } else if (requiresDeltaUpdates) {
                    for (BoundingBox box : boxes) {
                        box.updateToEntity(this, null);
                    }
                }
                this.collisionBoxes.addAll(boxes);
            }
        }
    }

    protected void updateEncompassingBox() {
        this.encompassingBox.widthRadius = 0.0;
        this.encompassingBox.heightRadius = 0.0;
        this.encompassingBox.depthRadius = 0.0;
        for (BoundingBox box : this.collisionBoxes) {
            this.encompassingBox.widthRadius = (float)Math.max(this.encompassingBox.widthRadius, Math.abs(box.globalCenter.x - this.position.x) + box.widthRadius);
            this.encompassingBox.heightRadius = (float)Math.max(this.encompassingBox.heightRadius, Math.abs(box.globalCenter.y - this.position.y) + box.heightRadius);
            this.encompassingBox.depthRadius = (float)Math.max(this.encompassingBox.depthRadius, Math.abs(box.globalCenter.z - this.position.z) + box.depthRadius);
        }
        this.encompassingBox.updateToEntity(this, null);
    }

    public void damageCollisionBox(BoundingBox box, double damageAmount) {
        String variableName = "collision_" + (((AJSONInteractableEntity)this.definition).collisionGroups.indexOf(box.groupDef) + 1) + "_damage";
        double currentDamage = this.getVariable(variableName) + damageAmount;
        if (currentDamage > (double)box.groupDef.health) {
            double amountActuallyNeeded = damageAmount - (currentDamage - (double)box.groupDef.health);
            currentDamage = box.groupDef.health;
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, variableName, amountActuallyNeeded));
        } else {
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, variableName, damageAmount));
        }
        this.setVariable(variableName, currentDamage);
    }

    @Override
    public void doPostUpdateLogic() {
        super.doPostUpdateLogic();
        this.world.beginProfiling("CollisionBoxUpdates", true);
        this.updateCollisionBoxes(this.requiresDeltaUpdates());
        this.updateEncompassingBox();
        this.world.endProfiling();
    }

    public void addInstrument(ItemInstrument instrument, int slot) {
        this.instruments.set(slot, instrument);
        ArrayList<RenderableData> renderables = new ArrayList<RenderableData>();
        for (JSONInstrument.JSONInstrumentComponent component : ((JSONInstrument)instrument.definition).components) {
            if (component.textObject != null) {
                renderables.add(null);
            } else {
                renderables.add(new RenderableData(RenderableVertices.createSprite(1, null, null)));
            }
            if (component.animations == null) continue;
            this.instrumentComponentSwitchboxes.put(component, new RenderInstrument.InstrumentSwitchbox(this, component));
        }
        this.instrumentRenderables.set(slot, renderables);
    }

    public void removeIntrument(int slot) {
        ItemInstrument removedInstrument = this.instruments.set(slot, null);
        if (removedInstrument != null) {
            for (JSONInstrument.JSONInstrumentComponent component : ((JSONInstrument)removedInstrument.definition).components) {
                this.instrumentComponentSwitchboxes.remove(component);
            }
            this.instrumentRenderables.set(slot, null);
        }
    }

    public void attack(Damage damage) {
        if (!damage.isWater && !this.outOfHealth) {
            this.damageAmount += damage.amount;
            if (this.damageAmount > (double)((AJSONInteractableEntity)this.definition).general.health) {
                this.damageAmount = ((AJSONInteractableEntity)this.definition).general.health;
                this.outOfHealth = true;
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableSet(this, DAMAGE_VARIABLE, this.damageAmount));
            } else {
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableIncrement(this, DAMAGE_VARIABLE, damage.amount));
            }
            this.setVariable(DAMAGE_VARIABLE, this.damageAmount);
        }
    }

    @Override
    public void renderBoundingBoxes(TransformationMatrix transform) {
        this.collisionBoxes.forEach(box -> box.renderWireframe(this, transform, null, null));
    }

    @Override
    protected void renderModel(TransformationMatrix transform, boolean blendingEnabled, float partialTicks) {
        super.renderModel(transform, blendingEnabled, partialTicks);
        if (((AJSONInteractableEntity)this.definition).instruments != null) {
            this.world.beginProfiling("Instruments", true);
            for (int i = 0; i < ((AJSONInteractableEntity)this.definition).instruments.size(); ++i) {
                ItemInstrument instrument = this.instruments.get(i);
                if (instrument == null) continue;
                JSONInstrumentDefinition packInstrument = ((AJSONInteractableEntity)this.definition).instruments.get(i);
                instrumentTransform.set(transform);
                AnimationSwitchbox switchbox = this.instrumentSlotSwitchboxes.get(packInstrument);
                if (switchbox != null && !switchbox.runSwitchbox(partialTicks, false)) continue;
                if (switchbox != null) {
                    instrumentTransform.multiply(switchbox.netMatrix);
                }
                instrumentTransform.applyTranslation(packInstrument.pos);
                if (packInstrument.rot != null) {
                    instrumentTransform.applyRotation(packInstrument.rot);
                }
                instrumentTransform.applyRotation(INSTRUMENT_ROTATION_INVERSION);
                instrumentTransform.applyScaling(0.0625, 0.0625, 0.0625);
                RenderInstrument.drawInstrument(this, instrumentTransform, i, false, blendingEnabled, partialTicks);
            }
            this.world.endProfiling();
        }
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        if (((AJSONInteractableEntity)this.definition).instruments != null) {
            for (int i = 0; i < ((AJSONInteractableEntity)this.definition).instruments.size(); ++i) {
                ItemInstrument instrument = this.instruments.get(i);
                if (instrument == null) continue;
                data.setString("instrument" + i + "_packID", ((JSONInstrument)instrument.definition).packID);
                data.setString("instrument" + i + "_systemName", ((JSONInstrument)instrument.definition).systemName);
            }
        }
        return data;
    }
}

