/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.NavBeacon;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;

public class TileEntityBeacon
extends TileEntityDecor {
    public NavBeacon currentBeacon;

    public TileEntityBeacon(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
    }

    @Override
    public void initializeAnimations() {
        super.initializeAnimations();
        Iterator iterator = this.text.keySet().iterator();
        if (iterator.hasNext()) {
            JSONText textDef = (JSONText)iterator.next();
            this.currentBeacon = NavBeacon.getByNameFromWorld(this.world, (String)this.text.get(textDef));
            return;
        }
    }

    @Override
    public void destroy(BoundingBox box) {
        super.destroy(box);
        if (this.currentBeacon != null) {
            NavBeacon.removeFromWorld(this.world, this.currentBeacon.name);
        }
    }

    @Override
    public void updateText(LinkedHashMap<String, String> textLines) {
        if (this.currentBeacon != null) {
            NavBeacon.removeFromWorld(this.world, this.currentBeacon.name);
            this.currentBeacon = null;
        }
        try {
            String name = null;
            double glideSlope = 0.0;
            double bearing = 0.0;
            int entry = 0;
            for (Map.Entry<String, String> textEntry : textLines.entrySet()) {
                switch (entry++) {
                    case 0: {
                        name = textEntry.getValue();
                        break;
                    }
                    case 1: {
                        glideSlope = Double.parseDouble(textEntry.getValue());
                        break;
                    }
                    case 2: {
                        bearing = Double.parseDouble(textEntry.getValue());
                        break;
                    }
                }
            }
            NavBeacon newBeacon = new NavBeacon(this.world, name, glideSlope, bearing, this.position);
            super.updateText(textLines);
            this.currentBeacon = newBeacon;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

