/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.entities.instances.AEntityVehicleE_Powered;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketEntityInteractGUI;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packets.instances.PacketTileEntityFuelPumpConnection;
import minecrafttransportsimulator.systems.LanguageSystem;

public abstract class ATileEntityFuelPump
extends TileEntityDecor {
    public EntityVehicleF_Physics connectedVehicle;
    public final EntityInventoryContainer fuelItems;
    public final EntityInventoryContainer paymentItems;
    public final List<Integer> fuelAmounts = new ArrayList<Integer>();
    public int fuelPurchased;
    public double fuelDispensedThisPurchase;
    public double fuelDispensedThisConnection;
    public boolean isCreative;
    public final UUID placingPlayerID;

    public ATileEntityFuelPump(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
        if (data != null) {
            this.fuelItems = new EntityInventoryContainer(world, data.getData("inventory"), 6);
            this.paymentItems = new EntityInventoryContainer(world, data.getData("inventory2"), 18);
            world.addEntity(this.fuelItems);
            world.addEntity(this.paymentItems);
            for (int i = 0; i < this.fuelItems.getSize(); ++i) {
                this.fuelAmounts.add(data.getInteger("fuelAmount" + i));
            }
            this.fuelPurchased = data.getInteger("fuelPurchased");
            this.fuelDispensedThisPurchase = data.getDouble("fuelDispensedThisPurchase");
            this.placingPlayerID = placingPlayer != null ? placingPlayer.getID() : data.getUUID("placingPlayerID");
        } else {
            this.fuelItems = new EntityInventoryContainer(world, null, 6);
            this.paymentItems = new EntityInventoryContainer(world, null, 18);
            world.addEntity(this.fuelItems);
            world.addEntity(this.paymentItems);
            for (int i = 0; i < this.fuelItems.getSize(); ++i) {
                this.fuelAmounts.add(0);
            }
            this.placingPlayerID = placingPlayer != null ? placingPlayer.getID() : null;
        }
    }

    @Override
    public void update() {
        super.update();
        this.isCreative = true;
        for (int i = 0; i < this.fuelItems.getSize(); ++i) {
            if (this.fuelItems.getStack(i).isEmpty()) continue;
            this.isCreative = false;
        }
        if (this.connectedVehicle != null && !this.world.isClient()) {
            if (!this.connectedVehicle.isValid) {
                this.connectedVehicle.beingFueled = false;
                this.connectedVehicle = null;
                return;
            }
            if (!this.connectedVehicle.position.isDistanceToCloserThan(this.position, 15.0)) {
                this.setConnection(null);
                InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityFuelPumpConnection(this));
                for (IWrapperPlayer player : this.world.getPlayersWithin(new BoundingBox(this.position, 25.0, 25.0, 25.0))) {
                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELPUMP_TOOFAR, new Object[0]));
                }
                return;
            }
            if (this.connectedVehicle.fuelTank.getFluidLevel() == (double)this.connectedVehicle.fuelTank.getMaxLevel()) {
                this.setConnection(null);
                InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityFuelPumpConnection(this));
                for (IWrapperPlayer player : this.world.getPlayersWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELPUMP_COMPLETE, new Object[0]));
                }
                return;
            }
            double amountToDispenseThisTick = (double)this.connectedVehicle.fuelTank.getMaxLevel() - this.connectedVehicle.fuelTank.getFluidLevel();
            if (amountToDispenseThisTick > (double)((JSONDecor)this.definition).decor.pumpRate) {
                amountToDispenseThisTick = ((JSONDecor)this.definition).decor.pumpRate;
            }
            this.fuelVehicle(amountToDispenseThisTick);
        }
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        if (player.isHoldingItemType(JSONItem.ItemComponentType.WRENCH) && (player.getID().equals(this.placingPlayerID) || player.isOP())) {
            player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.FUEL_PUMP_CONFIG));
            this.playersInteracting.add(player);
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityInteractGUI(this, player, true));
            return true;
        }
        if (!this.isCreative && !this.hasFuel()) {
            boolean haveEmptySlot = false;
            for (int i = 0; i < this.paymentItems.getSize(); ++i) {
                if (!this.paymentItems.getStack(i).isEmpty()) continue;
                haveEmptySlot = true;
                break;
            }
            if (haveEmptySlot) {
                player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.FUEL_PUMP));
                this.playersInteracting.add(player);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityInteractGUI(this, player, true));
            } else {
                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELPUMP_FULLITEMS, new Object[0]));
            }
            return true;
        }
        if (!this.hasFuel()) {
            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELPUMP_NOFUEL, new Object[0]));
            return true;
        }
        if (this.connectedVehicle == null) {
            EntityVehicleF_Physics nearestVehicle = null;
            double lowestDistance = 16.0;
            for (EntityVehicleF_Physics testVehicle : this.world.getEntitiesOfType(EntityVehicleF_Physics.class)) {
                double vehicleDistance = testVehicle.position.distanceTo(this.position);
                if (!(vehicleDistance < lowestDistance)) continue;
                lowestDistance = vehicleDistance;
                nearestVehicle = testVehicle;
            }
            if (nearestVehicle != null) {
                switch (this.checkPump(nearestVehicle)) {
                    case NOENGINE: {
                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELPUMP_NOENGINE, new Object[0]));
                        return true;
                    }
                    case VALID: {
                        this.setConnection(nearestVehicle);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityFuelPumpConnection(this, nearestVehicle));
                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELPUMP_CONNECT, new Object[0]));
                        return true;
                    }
                    case INVALID: {
                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELPUMP_WRONGENGINES, new Object[0]));
                        return true;
                    }
                    case MISMATCH: {
                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELPUMP_WRONGTYPE, nearestVehicle.fuelTank.getFluid()));
                        return true;
                    }
                }
            } else {
                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELPUMP_TOOFAR, new Object[0]));
            }
        } else {
            this.setConnection(null);
            InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityFuelPumpConnection(this));
            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELPUMP_DISCONNECT, new Object[0]));
        }
        return true;
    }

    @Override
    public IWrapperItemStack getStack() {
        IWrapperItemStack stack = super.getStack();
        stack.setData(this.saveFuelData(InterfaceManager.coreInterface.getNewNBTWrapper()));
        return stack;
    }

    public void setConnection(EntityVehicleF_Physics newVehicle) {
        if (newVehicle != null) {
            newVehicle.beingFueled = true;
            this.fuelDispensedThisConnection = 0.0;
        } else if (this.connectedVehicle != null) {
            this.connectedVehicle.beingFueled = false;
        }
        this.connectedVehicle = newVehicle;
    }

    protected abstract boolean hasFuel();

    protected abstract AEntityVehicleE_Powered.FuelTankResult checkPump(EntityVehicleF_Physics var1);

    protected abstract void fuelVehicle(double var1);

    private IWrapperNBT saveFuelData(IWrapperNBT data) {
        data.setData("inventory", this.fuelItems.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        data.setData("inventory2", this.paymentItems.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        for (int i = 0; i < this.fuelItems.getSize(); ++i) {
            data.setInteger("fuelAmount" + i, this.fuelAmounts.get(i));
        }
        data.setInteger("fuelPurchased", this.fuelPurchased);
        data.setDouble("fuelDispensedThisPurchase", this.fuelDispensedThisPurchase);
        if (this.placingPlayerID != null) {
            data.setUUID("placingPlayerID", this.placingPlayerID);
        }
        return data;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        this.saveFuelData(data);
        return data;
    }
}

