/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mcinterface1122.ABuilderEntityBase;
import mcinterface1122.WrapperAABBCollective;
import mcinterface1122.WrapperItemStack;
import mcinterface1122.WrapperNBT;
import mcinterface1122.WrapperPlayer;
import mcinterface1122.WrapperWorld;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.BoundingBoxHitResult;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.IItemEntityProvider;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class BuilderEntityExisting
extends ABuilderEntityBase {
    protected static final Map<String, IItemEntityProvider.IItemEntityFactory> entityMap = new HashMap<String, IItemEntityProvider.IItemEntityFactory>();
    protected AEntityB_Existing entity;
    private static Point3D lastExplosionPosition;
    private WrapperAABBCollective collisionBoxes;
    private WrapperAABBCollective interactAttackBoxes;

    public BuilderEntityExisting(World world) {
        super(world);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.entity != null) {
            if (!this.entity.isValid) {
                this.func_70106_y();
            } else {
                BlockPos pos;
                this.func_70107_b(this.entity.position.x, this.entity.position.y, this.entity.position.z);
                if (!this.field_70170_p.field_72995_K && (this.field_70170_p.func_189509_E(pos = this.func_180425_c()) ? this.field_70163_u < 0.0 : !this.field_70170_p.func_175723_af().func_177746_a(pos))) {
                    this.func_70106_y();
                    return;
                }
                if (this.entity instanceof AEntityE_Interactable) {
                    AEntityE_Interactable interactable = (AEntityE_Interactable)this.entity;
                    this.collisionBoxes = new WrapperAABBCollective(interactable, true);
                    this.interactAttackBoxes = new WrapperAABBCollective(interactable, false);
                    if (this.entity instanceof EntityVehicleF_Physics && interactable.ticksExisted > 1L && interactable.ticksExisted % 20L == 0L) {
                        this.func_70105_a((float)Math.max(interactable.encompassingBox.widthRadius * 2.0, interactable.encompassingBox.depthRadius * 2.0), (float)interactable.encompassingBox.heightRadius * 2.0f);
                        if (World.MAX_ENTITY_RADIUS < interactable.encompassingBox.widthRadius || World.MAX_ENTITY_RADIUS < interactable.encompassingBox.heightRadius || World.MAX_ENTITY_RADIUS < interactable.encompassingBox.depthRadius) {
                            double maxEntityRadius = Math.max(Math.max(interactable.encompassingBox.widthRadius, interactable.encompassingBox.depthRadius), interactable.encompassingBox.heightRadius);
                            if (maxEntityRadius < 150.0) {
                                World.MAX_ENTITY_RADIUS = maxEntityRadius;
                            } else {
                                InterfaceManager.coreInterface.logError("Attempted to set the world entity max size to way too big of a number (" + maxEntityRadius + ") for " + this.entity + "  Removing entity from world as this is likely a pack error that will cause lots of TPS loss!");
                                this.func_70106_y();
                            }
                        }
                    }
                }
            }
        } else if (!this.loadedFromSavedNBT && this.loadFromSavedNBT) {
            WrapperWorld worldWrapper = WrapperWorld.getWrapperFor(this.field_70170_p);
            try {
                WrapperNBT data = new WrapperNBT(this.lastLoadedNBT);
                this.entity = entityMap.get(this.lastLoadedNBT.func_74779_i("entityid")).restoreEntityFromData(worldWrapper, data);
                if (this.entity instanceof AEntityF_Multipart) {
                    ((AEntityF_Multipart)this.entity).addPartsPostAddition(null, data);
                }
                this.entity.world.addEntity(this.entity);
                this.loadedFromSavedNBT = true;
                this.lastLoadedNBT = null;
            }
            catch (Exception e) {
                InterfaceManager.coreInterface.logError("Failed to load entity on builder from saved NBT.  Did a pack change?");
                InterfaceManager.coreInterface.logError(e.getMessage());
                this.func_70106_y();
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.entity != null) {
            this.entity.remove();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (((Boolean)ConfigSystem.settings.damage.allowExternalDamage.value).booleanValue() && !this.field_70170_p.field_72995_K && this.entity instanceof AEntityF_Multipart) {
            WrapperPlayer playerSource;
            AEntityF_Multipart multipart = (AEntityF_Multipart)this.entity;
            if (multipart instanceof EntityVehicleF_Physics) {
                amount = (float)((double)amount * ConfigSystem.externalDamageOverrides.overrides.get(((AJSONPartProvider)multipart.definition).packID).get(((AJSONPartProvider)multipart.definition).systemName));
            }
            Entity attacker = source.func_76364_f();
            Entity trueSource = source.func_76346_g();
            WrapperPlayer wrapperPlayer = playerSource = trueSource instanceof EntityPlayer ? WrapperPlayer.getWrapperFor((EntityPlayer)trueSource) : null;
            if (lastExplosionPosition != null && source.func_94541_c()) {
                BoundingBox explosiveBounds = new BoundingBox(lastExplosionPosition, amount, amount, amount);
                for (BoundingBox box : this.interactAttackBoxes.getBoxes()) {
                    if (!box.intersects(explosiveBounds)) continue;
                    multipart.attack(new Damage(amount, box, null, playerSource, null).setExplosive());
                }
                lastExplosionPosition = null;
            } else if (attacker != null) {
                Point3D endPosition;
                Collection<BoundingBoxHitResult> hitResults;
                Point3D attackerPosition = new Point3D(attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v);
                for (BoundingBox box : this.interactAttackBoxes.getBoxes()) {
                    if (!box.isPointInside(attackerPosition, null)) continue;
                    multipart.attack(new Damage(amount, box, null, playerSource, null));
                    return true;
                }
                Vec3d mcMovement = attacker.func_174791_d();
                if (mcMovement.func_189985_c() != 0.0 && (hitResults = multipart.getHitBoxes(attackerPosition, endPosition = attackerPosition.copy().add(mcMovement.field_72450_a, mcMovement.field_72448_b, mcMovement.field_72449_c), new BoundingBox(attackerPosition, endPosition), false)) != null) {
                    multipart.attackProjectile(new Damage(amount, null, null, playerSource, null), null, hitResults);
                }
            }
        }
        return true;
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.interactAttackBoxes != null ? this.interactAttackBoxes : super.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.collisionBoxes != null ? this.collisionBoxes : super.func_70046_E();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        if (this.entity instanceof AEntityF_Multipart) {
            for (APart part : ((AEntityF_Multipart)this.entity).parts) {
                for (BoundingBox box : part.collisionBoxes) {
                    IWrapperItemStack stack;
                    if (!box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.CLICK) || !box.isPointInside(new Point3D(target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c), null) || (stack = part.getStack()) == null) continue;
                    return ((WrapperItemStack)stack).stack;
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_70067_L() {
        return this.collisionBoxes != null && !this.collisionBoxes.getBoxes().isEmpty();
    }

    @Override
    public NBTTagCompound func_189511_e(NBTTagCompound tag) {
        super.func_189511_e(tag);
        if (this.entity != null) {
            this.entity.save(new WrapperNBT(tag));
            tag.func_74778_a("entityid", this.entity.getClass().getSimpleName());
        }
        return tag;
    }

    @SubscribeEvent
    public static void onIVExplosion(ExplosionEvent.Detonate event) {
        if (!event.getWorld().field_72995_K) {
            lastExplosionPosition = new Point3D(event.getExplosion().getPosition().field_72450_a, event.getExplosion().getPosition().field_72448_b, event.getExplosion().getPosition().field_72449_c);
        }
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        for (AItemPack<?> packItem : PackParser.getAllPackItems()) {
            if (!(packItem instanceof IItemEntityProvider)) continue;
            ((IItemEntityProvider)((Object)packItem)).registerEntities(entityMap);
        }
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(BuilderEntityExisting.class).id(new ResourceLocation(InterfaceManager.coreModID, "mts_entity"), 0).name("mts_entity").tracker(512, 5, false).build());
    }
}

