/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import fossilsarcheology.client.sound.FASoundRegistry;
import fossilsarcheology.server.entity.ai.DinoAIEatFeedersAndBlocks;
import fossilsarcheology.server.entity.ai.DinoAIEatItems;
import fossilsarcheology.server.entity.ai.DinoAIFleeBattle;
import fossilsarcheology.server.entity.ai.DinoAIFollowOwner;
import fossilsarcheology.server.entity.ai.DinoAIHunt;
import fossilsarcheology.server.entity.ai.DinoAIHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAILookIdle;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtTarget;
import fossilsarcheology.server.entity.ai.DinoAIRiding;
import fossilsarcheology.server.entity.ai.DinoAIWander;
import fossilsarcheology.server.entity.ai.DinoAIWatchClosest;
import fossilsarcheology.server.entity.ai.DinoMeleeAttackAI;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityTypeAI;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityParasaurolophus
extends EntityPrehistoric {
    private static final DataParameter<Boolean> STANDING = EntityDataManager.func_187226_a(EntityParasaurolophus.class, (DataSerializer)DataSerializers.field_187198_h);
    public float standProgress;
    private boolean isStanding;
    private int standTicks;

    public EntityParasaurolophus(World world) {
        super(world, PrehistoricEntityType.PARASAUROLOPHUS, 2.0, 9.0, 25.0, 70.0, 0.25, 0.35, 3.0, 12.0);
        this.setActualSize(2.2f, 1.9f);
        this.nearByMobsAllowed = 6;
        this.minSize = 0.15f;
        this.maxSize = 1.6f;
        this.teenAge = 5;
        this.developsResistance = true;
        this.breaksBlocks = true;
        this.pediaScale = 30.0f;
        this.ridingY = 2.5f;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIFleeBattle(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoMeleeAttackAI(this, 1.0, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIEatFeedersAndBlocks(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new DinoAIEatItems(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIRiding(this, 1.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new DinoAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new DinoAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new DinoAIHurtByTarget(this));
        this.field_70715_bh.func_75776_a(4, new DinoAIHunt<EntityLivingBase>(this, EntityLivingBase.class, true, (Predicate<EntityLivingBase>)((com.google.common.base.Predicate)entity -> entity instanceof EntityLivingBase)));
    }

    @Override
    public int getSpeakLength() {
        return 40;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STANDING, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Standing", this.isStanding);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setStanding(compound.func_74767_n("Standing"));
    }

    public boolean isStanding() {
        if (this.field_70170_p.field_72995_K) {
            boolean isStanding;
            this.isStanding = isStanding = ((Boolean)this.field_70180_af.func_187225_a(STANDING)).booleanValue();
            return isStanding;
        }
        return this.isStanding;
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(STANDING, (Object)standing);
        if (!this.field_70170_p.field_72995_K) {
            this.isStanding = standing;
        }
    }

    @Override
    public int getAttackLength() {
        return 30;
    }

    @Override
    public int getAdultAge() {
        return 13;
    }

    @Override
    public void setSpawnValues() {
    }

    @Override
    public PrehistoricEntityTypeAI.Activity aiActivityType() {
        return PrehistoricEntityTypeAI.Activity.DIURINAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Attacking aiAttackType() {
        return PrehistoricEntityTypeAI.Attacking.CHARGE;
    }

    @Override
    public PrehistoricEntityTypeAI.Climbing aiClimbType() {
        return PrehistoricEntityTypeAI.Climbing.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Following aiFollowType() {
        return PrehistoricEntityTypeAI.Following.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Jumping aiJumpType() {
        return PrehistoricEntityTypeAI.Jumping.BASIC;
    }

    @Override
    public PrehistoricEntityTypeAI.Response aiResponseType() {
        return PrehistoricEntityTypeAI.Response.TERITORIAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Stalking aiStalkType() {
        return PrehistoricEntityTypeAI.Stalking.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Taming aiTameType() {
        return PrehistoricEntityTypeAI.Taming.IMPRINTING;
    }

    @Override
    public PrehistoricEntityTypeAI.Untaming aiUntameType() {
        return PrehistoricEntityTypeAI.Untaming.STARVE;
    }

    @Override
    public PrehistoricEntityTypeAI.Moving aiMovingType() {
        return PrehistoricEntityTypeAI.Moving.WALK;
    }

    @Override
    public PrehistoricEntityTypeAI.WaterAbility aiWaterAbilityType() {
        return PrehistoricEntityTypeAI.WaterAbility.NONE;
    }

    @Override
    public boolean doesFlock() {
        return false;
    }

    @Override
    public Item getOrderItem() {
        return Items.field_151055_y;
    }

    @Override
    public int getTailSegments() {
        return 3;
    }

    public boolean func_70652_k(Entity entity) {
        if (this.getAnimation() != this.ATTACK_ANIMATION) {
            this.setAnimation(this.ATTACK_ANIMATION);
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        boolean standing = this.isStanding();
        if (standing && this.standProgress < 20.0f) {
            this.standProgress += 0.5f;
        } else if (!standing && this.standProgress > 0.0f) {
            this.standProgress -= 0.5f;
        }
        if (standing) {
            ++this.standTicks;
        } else if (!standing && this.standTicks != 0) {
            this.standTicks = 0;
        }
        if (this.getAnimation() == this.ATTACK_ANIMATION && this.getAnimationTick() == 12 && this.func_70638_az() != null) {
            this.doAttack();
            this.doAttackKnockback(0.5f);
        }
        if (!(this.field_70170_p.field_72995_K || this.isMovementBlockedSoft() || this.isStanding() || this.func_70681_au().nextInt(100) != 0 || this.standTicks != 0)) {
            this.setStanding(true);
        }
        if (!this.field_70170_p.field_72995_K && this.isStanding() && this.func_70681_au().nextInt(800) == 0 && this.standTicks > 800) {
            this.setStanding(false);
        }
    }

    @Override
    public void setSleeping(boolean sleeping) {
        if (sleeping) {
            this.setStanding(false);
        }
        super.setSleeping(sleeping);
    }

    @Override
    public void func_70904_g(boolean sitting) {
        if (sitting) {
            this.setStanding(false);
        }
        super.func_70904_g(sitting);
    }

    @Override
    public float getMaleSize() {
        return 1.15f;
    }

    @Override
    public int getMaxHunger() {
        return 175;
    }

    @Override
    public boolean canBeRidden() {
        return true;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return FASoundRegistry.PARASAUROLOPHUS_LIVING;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return FASoundRegistry.PARASAUROLOPHUS_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return FASoundRegistry.PARASAUROLOPHUS_DEATH;
    }
}

