/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.ai;

import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.block.entity.TileEntityFeeder;
import fossilsarcheology.server.entity.ai.DinoAIMoveToBlock;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.util.FoodMappings;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DinoAIEatFeedersAndBlocks
extends DinoAIMoveToBlock {
    private static final int RADIUS = 8;
    private final EntityPrehistoric entity;
    private int feedingTicks;

    public DinoAIEatFeedersAndBlocks(EntityPrehistoric entity) {
        super(entity, 1.0, 35);
        this.entity = entity;
        this.func_75248_a(1);
    }

    @Override
    public boolean func_75250_a() {
        if (this.entity.getHunger() >= this.entity.getMaxHunger()) {
            return false;
        }
        if (this.entity.isMovementBlockedSoft()) {
            return false;
        }
        boolean execute = super.func_75250_a();
        if (execute) {
            this.entity.shouldWander = false;
        }
        return execute;
    }

    @Override
    public boolean func_75253_b() {
        if (this.entity.getHunger() >= this.entity.getMaxHunger()) {
            return false;
        }
        return !this.entity.isMovementBlockedSoft() && this.destinationBlock != null && this.shouldTarget(this.destinationBlock);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void func_75246_d() {
        double check;
        super.func_75246_d();
        boolean isFeeder = false;
        if (this.destinationBlock != null) {
            this.entity.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, 1.0);
        }
        if (!this.getIsAboveDestination()) return;
        if (this.destinationBlock == null) return;
        BlockPos up = this.destinationBlock;
        Block block = this.entity.field_70170_p.func_180495_p(up).func_177230_c();
        if (!this.shouldTarget(this.destinationBlock)) return;
        double distance = this.getDistance(up);
        if (distance < (check = Math.max(this.getRequiredDistance(1.5), 1.5))) {
            if (this.entity.field_70170_p.func_180495_p(this.destinationBlock).func_177230_c() == FABlockRegistry.FEEDER) {
                isFeeder = true;
                TileEntity entity = this.entity.field_70170_p.func_175625_s(this.destinationBlock);
                TileEntityFeeder feeder = (TileEntityFeeder)entity;
                if (this.entity.getHunger() < this.entity.getMaxHunger() && !feeder.isEmpty(this.entity.type)) {
                    ++this.feedingTicks;
                    feeder.feedDinosaur(this.entity);
                    this.entity.func_70606_j(Math.min(this.entity.func_110138_aP(), (float)((int)(this.entity.func_110143_aJ() + (float)(this.feedingTicks / 4)))));
                    this.entity.doFoodEffect();
                    return;
                }
                this.feedingTicks = 0;
                this.func_75251_c();
                return;
            }
            if (FoodMappings.INSTANCE.getBlockFoodAmount(this.entity.field_70170_p.func_180495_p(this.destinationBlock).func_177230_c(), this.entity.type.diet) > 0) {
                this.entity.setHunger(Math.min(this.entity.getMaxHunger(), this.entity.getHunger() + FoodMappings.INSTANCE.getBlockFoodAmount(block, this.entity.type.diet)));
                this.entity.func_70606_j(Math.min(this.entity.func_110138_aP(), (float)((int)(this.entity.func_110143_aJ() + (float)(FoodMappings.INSTANCE.getBlockFoodAmount(block, this.entity.type.diet) / 10)))));
                this.entity.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                this.entity.field_70170_p.func_175655_b(up, false);
                this.func_75251_c();
                return;
            }
            this.func_75251_c();
            return;
        }
        if (isFeeder) return;
        if (this.entity.rayTraceFeeder(up, true) && FoodMappings.INSTANCE.getBlockFoodAmount(this.entity.field_70170_p.func_180495_p(up).func_177230_c(), this.entity.type.diet) != 0) {
            if (this.canReachBlock((Entity)this.entity, up)) return;
        }
        this.func_75251_c();
    }

    private boolean shouldTarget(BlockPos pos) {
        TileEntity entity = this.entity.field_70170_p.func_175625_s(pos);
        if (entity instanceof TileEntityFeeder) {
            TileEntityFeeder feeder = (TileEntityFeeder)entity;
            return !feeder.isEmpty(this.entity.type) && this.entity.rayTraceFeeder(pos, false);
        }
        return FoodMappings.INSTANCE.getBlockFoodAmount(this.entity.field_70170_p.func_180495_p(pos).func_177230_c(), this.entity.type.diet) > 0 && this.entity.rayTraceFeeder(pos, true);
    }

    @Override
    protected boolean shouldMoveTo(World worldIn, BlockPos below) {
        BlockPos pos = below;
        return this.shouldTarget(pos) && this.canReachBlock((Entity)this.entity, pos);
    }

    @Override
    public void func_75251_c() {
        this.entity.shouldWander = true;
        this.runDelay = 0;
        this.feedingTicks = 0;
    }

    private double getDistance(BlockPos pos) {
        double deltaX = this.entity.field_70165_t - ((double)pos.func_177958_n() + 0.5);
        double deltaY = this.entity.field_70163_u - ((double)pos.func_177956_o() + 0.5);
        double deltaZ = this.entity.field_70161_v - ((double)pos.func_177952_p() + 0.5);
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    public boolean canReachBlock(Entity entity, BlockPos leafBlock) {
        return true;
    }

    @Override
    protected boolean overrideDelay() {
        return (double)this.entity.getHunger() <= 0.25 * (double)this.entity.getMaxHunger();
    }
}

