/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology;

import fossilsarcheology.server.ServerProxy;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.compat.crafttweaker.CraftTweakerCompatBridge;
import fossilsarcheology.server.compat.thaumcraft.ThaumcraftCompatBridge;
import fossilsarcheology.server.compat.tinkers.TinkersCompatBridge;
import fossilsarcheology.server.config.FossilConfig;
import fossilsarcheology.server.entity.utility.FossilsMammalProperties;
import fossilsarcheology.server.entity.utility.FossilsPlayerProperties;
import fossilsarcheology.server.event.EventSharedConfig;
import fossilsarcheology.server.event.FossilLivingEvent;
import fossilsarcheology.server.event.TerrainGenerationEvents;
import fossilsarcheology.server.loot.CustomizeToDinosaur;
import fossilsarcheology.server.message.MessageFoodParticles;
import fossilsarcheology.server.message.MessageHappyParticles;
import fossilsarcheology.server.message.MessageRollBall;
import fossilsarcheology.server.message.MessageSetDay;
import fossilsarcheology.server.message.MessageUpdateEgg;
import fossilsarcheology.server.message.MessageUpdateFeeder;
import fossilsarcheology.server.recipe.FAMachineRecipeRegistry;
import fossilsarcheology.server.util.ReleaseType;
import java.io.File;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.ilexiconn.llibrary.server.network.NetworkWrapper;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="fossil", name="Fossils and Archeology Revival", version="8.0.5", acceptedMinecraftVersions="[1.12,1.12.2]", dependencies="required-after:forge@[14.23.5.2772,];after:JEI@[4.10.0.198,];required-after:llibrary@[1.7.17,];after:ZZZ@[0.1]", guiFactory="fossilsarcheology.client.gui.FAGUIFactory")
public class Revival {
    public static final String MODID = "fossil";
    public static final String VERSION = "8.0.5";
    public static final ReleaseType RELEASE_TYPE = ReleaseType.parseVersion("8.0.5");
    public static final String LLIBRARY_VERSION = "1.7.17";
    public static final Logger LOGGER = LogManager.getLogger((String)"fossils");
    @SidedProxy(clientSide="fossilsarcheology.client.ClientProxy", serverSide="fossilsarcheology.server.ServerProxy")
    public static ServerProxy PROXY;
    @NetworkWrapper(value={MessageFoodParticles.class, MessageSetDay.class, MessageHappyParticles.class, MessageUpdateEgg.class, MessageRollBall.class, MessageUpdateFeeder.class})
    public static SimpleNetworkWrapper NETWORK_WRAPPER;
    public static FossilConfig CONFIG_OPTIONS;
    public static Configuration config;
    @Mod.Instance(value="fossil")
    public static Revival INSTANCE;
    public static Object PEDIA_OBJECT;

    public static void debug(String message) {
        if (RELEASE_TYPE.enableDebugging()) {
            LOGGER.debug(message);
        }
    }

    public static void loadConfig() {
        File configFile = new File(Loader.instance().getConfigDir(), "fossil.cfg");
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
            }
            catch (Exception e) {
                LOGGER.warn("Could not create a new FA config file.");
                LOGGER.warn(e.getLocalizedMessage());
            }
        }
        config = new Configuration(configFile);
        config.load();
    }

    public static void syncConfig() {
        CONFIG_OPTIONS.init(config);
        config.save();
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        Revival.loadConfig();
        Revival.syncConfig();
        PROXY.onPreInit();
        ThaumcraftCompatBridge.loadThaumcraftCompat();
        TinkersCompatBridge.loadTinkersCompat();
        CraftTweakerCompatBridge.loadTweakerCompat();
        LOGGER.info("Archaean horizon");
        LOGGER.info("The first sunrise");
        LOGGER.info("On a pristine Gaea");
        LOGGER.info("Opus perfectum");
        LOGGER.info("Somewhere there, us sleeping");
        MinecraftForge.EVENT_BUS.register((Object)new EventSharedConfig());
        MinecraftForge.EVENT_BUS.register((Object)new FossilLivingEvent());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new TerrainGenerationEvents());
        EntityPropertiesHandler.INSTANCE.registerProperties(FossilsPlayerProperties.class);
        EntityPropertiesHandler.INSTANCE.registerProperties(FossilsMammalProperties.class);
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        PROXY.onInit();
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new CustomizeToDinosaur.Serializer());
        FABlockRegistry.init();
        LOGGER.info("After a billion years");
        LOGGER.info("The show is still here");
        LOGGER.info("Not a single one of your fathers died young");
        LOGGER.info("The handy travelers out of Africa");
        LOGGER.info("Little Lucy of the Afar");
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        PROXY.onPostInit();
        TinkersCompatBridge.loadTinkersPostInitCompat();
        FAMachineRecipeRegistry.postInit();
    }

    static {
        CONFIG_OPTIONS = new FossilConfig();
        FluidRegistry.enableUniversalBucket();
    }
}

