/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import pcl.opensecurity.Config;
import pcl.opensecurity.common.interfaces.IOwner;
import pcl.opensecurity.common.interfaces.IPasswordProtected;
import pcl.opensecurity.common.items.ItemCard;
import pcl.opensecurity.common.protection.IProtection;
import pcl.opensecurity.common.protection.Protection;
import pcl.opensecurity.common.tileentity.TileEntityOSBase;

public class TileEntitySecureDoor
extends TileEntityOSBase
implements IProtection,
IPasswordProtected,
IOwner {
    private UUID ownerUUID;
    private String password = "";
    private String eventName = "magData";
    private Boolean hasMagReader = false;

    public TileEntitySecureDoor() {
        super("os_magreader");
        this.node = this.hasMagReader != false ? (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create() : (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.None).withComponent(this.getComponentName()).withConnector(32.0).create();
    }

    public void func_145829_t() {
        super.func_145829_t();
        Protection.addArea(this.func_145831_w(), new AxisAlignedBB(this.func_174877_v()), this.func_174877_v());
    }

    @Override
    public void func_145843_s() {
        Protection.removeArea(this.func_145831_w(), this.func_174877_v());
        super.func_145843_s();
    }

    @Override
    public boolean isProtected(Entity entityIn, Protection.UserAction action) {
        if (!action.equals((Object)Protection.UserAction.explode) && entityIn.func_110124_au().equals(this.ownerUUID)) {
            return false;
        }
        if (entityIn != null && entityIn instanceof EntityPlayer) {
            ((EntityPlayer)entityIn).func_146105_b((ITextComponent)new TextComponentString("this door is protected"), true);
        }
        return true;
    }

    private ArrayList<TileEntitySecureDoor> getDoorTiles() {
        ArrayList<TileEntitySecureDoor> doorTEs = new ArrayList<TileEntitySecureDoor>();
        doorTEs.add(this);
        int offset = ((BlockDoor.EnumDoorHalf)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.UPPER) ? -1 : 1;
        TileEntity teDoorOtherPart = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, offset, 0));
        if (teDoorOtherPart instanceof TileEntitySecureDoor) {
            doorTEs.add((TileEntitySecureDoor)teDoorOtherPart);
        } else {
            Logger.getLogger("opensecurity").warning("failed to get all door Tiles");
        }
        return doorTEs;
    }

    public boolean doRead(@Nonnull ItemStack itemStack, EntityPlayer em, EnumFacing side) {
        if (!this.hasMagReader.booleanValue()) {
            return false;
        }
        ItemCard.CardTag cardTag = new ItemCard.CardTag(itemStack);
        if (this.node.changeBuffer(-5.0) != 0.0 || !cardTag.isValid) {
            return false;
        }
        String user = Config.getConfig().getCategory("general").get("ignoreUUIDs").getBoolean() ? "player" : em.getDisplayNameString();
        this.node.sendToReachable("computer.signal", new Object[]{this.eventName, user, cardTag.dataTag, cardTag.localUUID, cardTag.locked, side.func_176745_a()});
        return true;
    }

    @Callback(doc="function(String:name):boolean; Sets the name of the event that gets sent when a card is swipped", direct=true)
    public Object[] setEventName(Context context, Arguments args) {
        this.eventName = args.checkString(0);
        return new Object[]{true};
    }

    @Override
    public void setOwner(UUID uuid) {
        for (TileEntitySecureDoor door : this.getDoorTiles()) {
            door.ownerUUID = uuid;
        }
    }

    @Override
    public void setPassword(String pass) {
        for (TileEntitySecureDoor door : this.getDoorTiles()) {
            door.password = pass;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.ownerUUID = tag.func_186855_b("owner") ? tag.func_186857_a("owner") : (tag.func_74764_b("owner") ? UUID.fromString(tag.func_74779_i("owner")) : null);
        this.password = tag.func_74779_i("password");
        if (tag.func_74764_b("hasMag")) {
            this.hasMagReader = tag.func_74767_n("hasMag");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.ownerUUID != null) {
            tag.func_186854_a("owner", this.ownerUUID);
        }
        tag.func_74778_a("password", this.password);
        tag.func_74757_a("hasMag", this.hasMagReader.booleanValue());
        return tag;
    }

    @Override
    public UUID getOwner() {
        return this.ownerUUID;
    }

    @Override
    public String getPass() {
        return this.password;
    }

    public void enableMagReader() {
        System.out.println("Setting magreader true");
        this.hasMagReader = true;
        this.node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create();
    }
}

