/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.entity;

import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import pcl.opensecurity.client.models.ModelNanoFogSwarm;
import pcl.opensecurity.common.tileentity.TileEntityNanoFog;
import pcl.opensecurity.common.tileentity.TileEntityNanoFogTerminal;
import pcl.opensecurity.util.ItemUtils;

public class EntityNanoFogSwarm
extends Entity {
    public static final String NAME = "opensecurity.nanofogswarm";
    private Vec3d target = new Vec3d(0.0, 0.0, 0.0);
    public static final int maxProgress = 90;
    public static final int buildNotifyProgress = 30;
    static final double maxSpeed = 1.0;
    double speed = 1.0;
    public boolean targetReached = false;
    private boolean clientDataComplete = false;
    private static final DataParameter<BlockPos> FOG = EntityDataManager.func_187226_a(EntityNanoFogSwarm.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<BlockPos> TERMINAL = EntityDataManager.func_187226_a(EntityNanoFogSwarm.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> RETURNTASK = EntityDataManager.func_187226_a(EntityNanoFogSwarm.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BUILDTASK = EntityDataManager.func_187226_a(EntityNanoFogSwarm.class, (DataSerializer)DataSerializers.field_187198_h);
    double speedX;
    double speedY;
    double speedZ;
    int maxTickAge = Integer.MIN_VALUE;
    ItemStackHandler inventory = new ItemStackHandler(1);
    public int buildProgress = 0;
    public long blockJobDone = 0L;
    public ArrayList<Cube> cubes = new ArrayList();

    @SideOnly(value=Side.CLIENT)
    void initModelData() {
        for (int x = 0; x < ModelNanoFogSwarm.resolution; ++x) {
            for (int y = 0; y < ModelNanoFogSwarm.resolution; ++y) {
                for (int z = 0; z < ModelNanoFogSwarm.resolution; ++z) {
                    if (y > 0 && y < ModelNanoFogSwarm.resolution - 1 && x != 0 && x != ModelNanoFogSwarm.resolution - 1 && z != 0 && z != ModelNanoFogSwarm.resolution - 1) continue;
                    float resHalf = (float)ModelNanoFogSwarm.resolution / 2.0f;
                    Cube c = new Cube((float)x - resHalf, (float)y - resHalf, (float)z - resHalf);
                    this.cubes.add(c);
                }
            }
        }
    }

    public EntityNanoFogSwarm(World world) {
        super(world);
        this.field_70178_ae = true;
        this.field_70145_X = true;
        this.func_70105_a(1.0f, 1.0f);
        this.func_189654_d(true);
        this.func_184224_h(true);
        if (world.field_72995_K) {
            this.initModelData();
        }
    }

    public void func_70088_a() {
        this.field_70180_af.func_187214_a(RETURNTASK, (Object)false);
        this.field_70180_af.func_187214_a(BUILDTASK, (Object)false);
        this.field_70180_af.func_187214_a(FOG, (Object)new BlockPos(0, 0, 0));
        this.field_70180_af.func_187214_a(TERMINAL, (Object)new BlockPos(0, 0, 0));
    }

    BlockPos getFogBlock() {
        return (BlockPos)this.field_70180_af.func_187225_a(FOG);
    }

    BlockPos getTerminalBlock() {
        return (BlockPos)this.field_70180_af.func_187225_a(TERMINAL);
    }

    public boolean isReturnTask() {
        return (Boolean)this.field_70180_af.func_187225_a(RETURNTASK);
    }

    public boolean isBuildTask() {
        return (Boolean)this.field_70180_af.func_187225_a(BUILDTASK);
    }

    public boolean canWork() {
        return !this.field_70170_p.field_72995_K || this.clientDataComplete;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (!this.field_70170_p.field_72995_K || this.clientDataComplete) {
            return;
        }
        this.updateClient();
    }

    public void updateClient() {
        if (this.getFogBlock().equals((Object)new BlockPos(0, 0, 0))) {
            return;
        }
        if (this.getTerminalBlock().equals((Object)new BlockPos(0, 0, 0))) {
            return;
        }
        if (this.isReturnTask()) {
            this.target = new Vec3d((Vec3i)this.getTerminalBlock()).func_178787_e(new Vec3d(0.5, 0.0, 0.5));
            this.buildProgress = 40;
            this.clientDataComplete = true;
        } else if (this.isBuildTask()) {
            this.target = new Vec3d((Vec3i)this.getFogBlock()).func_178787_e(new Vec3d(0.5, 0.0, 0.5));
            this.buildProgress = 0;
            this.clientDataComplete = true;
        }
    }

    private void calculateMaxAge() {
        this.maxTickAge = 90 + 20 * (int)Math.ceil(new Vec3d((Vec3i)this.func_180425_c()).func_72438_d(this.target) / 0.5);
    }

    public void setTravelToFogBlock(BlockPos terminal, BlockPos pos) {
        this.field_70180_af.func_187227_b(BUILDTASK, (Object)true);
        this.field_70180_af.func_187227_b(TERMINAL, (Object)terminal);
        this.field_70180_af.func_187227_b(FOG, (Object)pos);
        this.func_70107_b((double)terminal.func_177958_n() + 0.5, terminal.func_177956_o(), (double)terminal.func_177952_p() + 0.5);
        this.target = new Vec3d((Vec3i)this.getFogBlock()).func_178787_e(new Vec3d(0.5, 0.0, 0.5));
        this.buildProgress = 0;
        this.calculateMaxAge();
    }

    public void setTravelToTerminal(BlockPos pos, BlockPos terminal) {
        this.field_70180_af.func_187227_b(RETURNTASK, (Object)true);
        this.field_70180_af.func_187227_b(TERMINAL, (Object)terminal);
        this.field_70180_af.func_187227_b(FOG, (Object)pos);
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        this.target = new Vec3d((Vec3i)this.getTerminalBlock()).func_178787_e(new Vec3d(0.5, 0.0, 0.5));
        this.buildProgress = 40;
        this.calculateMaxAge();
    }

    static float interpolate(float current, float max, float factor) {
        return factor * (1.0f / max * Math.min(current, max));
    }

    boolean setMotion() {
        double distance = new Vec3d((Vec3i)this.func_180425_c()).func_72438_d(this.target);
        double d0 = this.target.field_72450_a - this.field_70165_t;
        double d1 = this.target.field_72448_b - this.field_70163_u;
        double d2 = this.target.field_72449_c - this.field_70161_v;
        if (Math.abs(d0) < 0.01 && Math.abs(d1) < 0.01 && Math.abs(d2) < 0.01) {
            this.func_70107_b(this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c);
            this.targetReached = true;
            return false;
        }
        if (Math.abs(distance) < 5.0) {
            this.speed = 1.0 - (double)Math.abs(EntityNanoFogSwarm.interpolate(5.0f - (float)Math.abs(distance), 5.0f, 0.7f));
        }
        if (this.field_70173_aa < 20) {
            this.speed = 1.0 - (double)EntityNanoFogSwarm.interpolate(20 - this.field_70173_aa, 20.0f, 0.7f);
        }
        this.speedX = this.speed / distance * d0;
        this.speedY = this.speed / distance * d1;
        this.speedZ = this.speed / distance * d2;
        return true;
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.checkEntityAge();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.canWork()) {
            return;
        }
        if (this.isReturnTask()) {
            this.updateReturning();
        } else if (this.isBuildTask()) {
            this.updateBuild();
        }
    }

    void updateReturning() {
        TileEntity te;
        --this.buildProgress;
        if (this.blockJobDone == 0L && this.field_70173_aa >= 5 && (te = this.field_70170_p.func_175625_s(this.getFogBlock())) != null && te instanceof TileEntityNanoFog) {
            this.inventory.setStackInSlot(0, ((TileEntityNanoFog)te).notifyRemove());
            this.blockJobDone = this.field_70173_aa;
        }
        if (!this.targetReached && this.field_70173_aa > 30) {
            this.moveTowardsTarget();
        }
        if (!this.field_70170_p.field_72995_K && this.targetReached) {
            te = this.getTerminal();
            if (te != null) {
                te.returnFogMaterial(this.inventory.getStackInSlot(0));
            } else {
                ItemUtils.dropItem(this.inventory.getStackInSlot(0), this.func_130014_f_(), this.func_180425_c(), false, 10);
            }
            this.func_70106_y();
        }
    }

    TileEntityNanoFogTerminal getTerminal() {
        TileEntity te = this.field_70170_p.func_175625_s(this.getTerminalBlock());
        return te instanceof TileEntityNanoFogTerminal ? (TileEntityNanoFogTerminal)te : null;
    }

    void updateBuild() {
        if (!this.targetReached) {
            this.moveTowardsTarget();
        } else {
            this.updateConstructionProgress();
        }
    }

    void moveTowardsTarget() {
        if (this.target.equals((Object)new Vec3d(0.0, 0.0, 0.0))) {
            return;
        }
        if (!this.setMotion()) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70016_h(this.speedX, this.speedY, this.speedZ);
        }
        this.func_70107_b(this.field_70165_t + this.speedX, this.field_70163_u + this.speedY, this.field_70161_v + this.speedZ);
    }

    void checkEntityAge() {
        if (this.field_70170_p.field_72995_K || this.field_70173_aa < this.maxTickAge) {
            return;
        }
        Logger.getLogger("opensecurity").info("killing NanoFog swarm which lived too long... age: " + this.field_70173_aa + "/" + this.maxTickAge);
        this.func_70106_y();
    }

    void updateConstructionProgress() {
        TileEntity te;
        ++this.buildProgress;
        if (this.blockJobDone == 0L && this.buildProgress >= 30 && (te = this.field_70170_p.func_175625_s(this.getFogBlock())) != null && te instanceof TileEntityNanoFog) {
            ((TileEntityNanoFog)te).notifyBuild();
            this.blockJobDone = this.field_70173_aa;
        }
        if (!this.field_70170_p.field_72995_K && this.buildProgress > 90) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
    }

    public void func_70037_a(NBTTagCompound tag) {
    }

    public void func_70020_e(NBTTagCompound nbt) {
        this.field_70180_af.func_187227_b(RETURNTASK, (Object)nbt.func_74767_n("return"));
        this.field_70180_af.func_187227_b(BUILDTASK, (Object)nbt.func_74767_n("build"));
        BlockPos fog = new BlockPos(nbt.func_74762_e("fogX"), nbt.func_74762_e("fogY"), nbt.func_74762_e("fogZ"));
        BlockPos terminal = new BlockPos(nbt.func_74762_e("terminalX"), nbt.func_74762_e("terminalY"), nbt.func_74762_e("terminalZ"));
        this.inventory.deserializeNBT(nbt.func_74775_l("inv"));
        if (this.isReturnTask()) {
            this.setTravelToTerminal(fog, terminal);
        } else {
            this.setTravelToFogBlock(terminal, fog);
        }
        super.func_70020_e(nbt);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public NBTTagCompound func_189511_e(NBTTagCompound nbt) {
        nbt.func_74768_a("fogX", this.getFogBlock().func_177958_n());
        nbt.func_74768_a("fogY", this.getFogBlock().func_177956_o());
        nbt.func_74768_a("fogZ", this.getFogBlock().func_177952_p());
        nbt.func_74768_a("terminalX", this.getTerminalBlock().func_177958_n());
        nbt.func_74768_a("terminalY", this.getTerminalBlock().func_177956_o());
        nbt.func_74768_a("terminalZ", this.getTerminalBlock().func_177952_p());
        nbt.func_74757_a("return", this.isReturnTask());
        nbt.func_74757_a("build", this.isBuildTask());
        nbt.func_74782_a("inv", (NBTBase)this.inventory.serializeNBT());
        return super.func_189511_e(nbt);
    }

    public Random getRNG() {
        return this.field_70146_Z;
    }

    public class Cube {
        float x;
        float y;
        float z;
        Float[] r1;
        Float[] r2;

        void setupRandom(Random rand) {
            this.r1 = new Float[]{Float.valueOf(rand.nextFloat()), Float.valueOf(rand.nextFloat()), Float.valueOf(rand.nextFloat())};
            this.r2 = new Float[]{Float.valueOf(rand.nextFloat()), Float.valueOf(rand.nextFloat()), Float.valueOf(rand.nextFloat())};
        }

        Cube(float x1, float y1, float z1) {
            this.x = x1;
            this.y = y1;
            this.z = z1;
            this.setupRandom(EntityNanoFogSwarm.this.field_70146_Z);
        }

        float interpolate(float current, float max) {
            return 1.0f / max * Math.min(current, max);
        }

        @SideOnly(value=Side.CLIENT)
        public void render(float partialTicks, float scale, float randOffsetFactor) {
            float offsetFactor = 20.0f * this.interpolate(EntityNanoFogSwarm.this.field_70173_aa % 60, 60.0f);
            float renderX = this.x + randOffsetFactor * (this.r1[0].floatValue() + this.r2[0].floatValue() * offsetFactor);
            float renderY = this.y + randOffsetFactor * (this.r1[1].floatValue() + this.r2[1].floatValue() * offsetFactor);
            float renderZ = this.z + randOffsetFactor * (this.r1[2].floatValue() + this.r2[2].floatValue() * offsetFactor);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)renderX, (float)renderY, (float)renderZ);
            ModelNanoFogSwarm.drawCube(scale);
            GlStateManager.func_179121_F();
        }
    }
}

