/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import pcl.opensecurity.common.blocks.BlockCamouflage;
import pcl.opensecurity.common.tileentity.TileEntityNanoFog;
import pcl.opensecurity.util.BlockUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock", modid="galacticraftcore")})
public class BlockNanoFog
extends BlockCamouflage
implements ITileEntityProvider,
IPartialSealableBlock {
    public static final String NAME = "nanofog";
    public static BlockNanoFog DEFAULTITEM;
    static final AxisAlignedBB boundingBox;

    public BlockNanoFog() {
        super(Material.field_151573_f, NAME);
        this.func_149713_g(255);
        this.func_149722_s();
        this.func_149752_b(31337.0f);
        this.func_149647_a(null);
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return boundingBox;
    }

    @Deprecated
    public void func_185477_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBoundingBox, @Nonnull List<AxisAlignedBB> stacks, Entity entity, boolean isActualState) {
        if (!this.canEntityPass(world, pos, entity)) {
            super.func_185477_a(state, world, pos, entityBoundingBox, stacks, entity, isActualState);
        }
    }

    private boolean canEntityPass(World world, BlockPos pos, Entity entity) {
        if (entity == null) {
            return false;
        }
        TileEntityNanoFog te = BlockNanoFog.getTE((IBlockAccess)world, pos);
        return te != null && (!te.isSolid() || te.filterPass.contains(entity.getClass(), entity.func_70005_c_()));
    }

    @Override
    @Deprecated
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityNanoFog te = BlockNanoFog.getTE(world, pos);
        return te.isBuild() && super.func_176225_a(state, world, pos, side);
    }

    public static TileEntityNanoFog getTE(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileEntityNanoFog ? (TileEntityNanoFog)te : null;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityNanoFog();
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public void onBlockExploded(World world, @Nonnull BlockPos pos, @Nonnull Explosion explosion) {
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @Nonnull
    @Deprecated
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        TileEntityNanoFog te = BlockNanoFog.getTE((IBlockAccess)world, pos);
        if (te == null) {
            return;
        }
        if (te.getDamage() > 0 && te.filterDamage.contains(entity.getClass(), entity.func_70005_c_()) && te.getTerminal().consumeDamageEnergy(te.getDamage())) {
            entity.func_70097_a(new DamageSource("opensecurity.nanofog"), (float)te.getDamage());
        }
        if (te.getKnockback() > 0 && !this.canEntityPass(world, pos, entity) && te.getTerminal().consumeKnockbackEnergy(te.getKnockback())) {
            Vec3i kbVec = BlockUtils.getFacingFromEntity(pos, entity);
            entity.func_70024_g((double)(kbVec.func_177958_n() * te.getKnockback()), (double)(kbVec.func_177956_o() * te.getKnockback()), (double)(kbVec.func_177952_p() * te.getKnockback()));
        }
    }

    @Optional.Method(modid="galacticraftcore")
    public boolean isSealed(World var1, BlockPos var2, EnumFacing var3) {
        return true;
    }

    static {
        boundingBox = new AxisAlignedBB(0.01, 0.01, 0.01, 0.99, 0.99, 0.99);
    }
}

