/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.client.models;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pcl.opensecurity.common.blocks.BlockCamouflage;
import pcl.opensecurity.common.camouflage.CamoBlockId;

public class CamouflageBakedModel
implements IBakedModel {
    public static final ModelResourceLocation modelFacade = new ModelResourceLocation("opensecurity:camo");
    private static TextureAtlasSprite particleTexture;

    public CamouflageBakedModel(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
    }

    @SideOnly(value=Side.CLIENT)
    public static void initTextures() {
        if (particleTexture == null) {
            particleTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b("opensecurity:blocks/nanofog");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (state == null) {
            return Collections.emptyList();
        }
        try {
            IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
            CamoBlockId facadeId = (CamoBlockId)extendedBlockState.getValue((IUnlistedProperty)BlockCamouflage.CAMOID);
            if (facadeId == null) {
                return Collections.emptyList();
            }
            IBlockState facadeState = facadeId.getBlockState();
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            if (layer != null && !facadeState.func_177230_c().canRenderInLayer(facadeState, layer)) {
                return Collections.emptyList();
            }
            if (!(facadeState.func_177230_c() instanceof BlockCamouflage) && !facadeState.func_177230_c().equals(Blocks.field_150350_a)) {
                return this.getModel(facadeState).func_188616_a(state, side, rand);
            }
        }
        catch (Exception extendedBlockState) {
            // empty catch block
        }
        try {
            ModelResourceLocation loc = new ModelResourceLocation(state.func_177230_c().getRegistryName().toString(), "inventory");
            IBakedModel modelWhenNotCamouflaged = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174953_a(loc);
            return modelWhenNotCamouflaged.func_188616_a(state, side, rand);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private IBakedModel getModel(@Nonnull IBlockState facadeState) {
        CamouflageBakedModel.initTextures();
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(facadeState);
        return model;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return particleTexture;
    }

    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

