/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.util;

import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.satellite.IDataHandler;

public class MultiData
implements IDataHandler {
    private HashMap<DataStorage.DataType, DataStorage> dataStorages = new HashMap();

    public MultiData() {
        this.reset();
    }

    public void reset() {
        for (DataStorage.DataType type : DataStorage.DataType.values()) {
            if (type == DataStorage.DataType.UNDEFINED) continue;
            this.dataStorages.put(type, new DataStorage(type));
        }
    }

    public int getDataAmount(DataStorage.DataType type) {
        return this.dataStorages.get((Object)type).getData();
    }

    @Override
    public int extractData(int maxAmount, DataStorage.DataType type, EnumFacing dir, boolean commit) {
        DataStorage storage = this.dataStorages.get((Object)type);
        if (storage == null) {
            return 0;
        }
        return storage.removeData(maxAmount, commit);
    }

    @Override
    public int addData(int maxAmount, DataStorage.DataType type, EnumFacing dir, boolean commit) {
        DataStorage storage = this.dataStorages.get((Object)type);
        if (storage == null) {
            return 0;
        }
        return storage.addData(maxAmount, type, commit);
    }

    public int getMaxData() {
        return this.dataStorages.get((Object)DataStorage.DataType.ATMOSPHEREDENSITY).getMaxData();
    }

    public void setMaxData(int amount) {
        for (DataStorage.DataType type : DataStorage.DataType.values()) {
            if (type == DataStorage.DataType.UNDEFINED) continue;
            this.dataStorages.get((Object)type).setMaxData(amount);
        }
    }

    public DataStorage getDataStorageForType(DataStorage.DataType dataType) {
        return this.dataStorages.get((Object)dataType);
    }

    public void setDataAmount(int amount, DataStorage.DataType dataType) {
        if (dataType != DataStorage.DataType.UNDEFINED) {
            this.dataStorages.get((Object)dataType).setData(amount, dataType);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        for (DataStorage.DataType type : DataStorage.DataType.values()) {
            if (type == DataStorage.DataType.UNDEFINED) continue;
            NBTTagCompound dataNBT = new NBTTagCompound();
            this.dataStorages.get((Object)type).writeToNBT(dataNBT);
            nbt.func_74782_a(type.name(), (NBTBase)dataNBT);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        for (DataStorage.DataType type : DataStorage.DataType.values()) {
            if (type == DataStorage.DataType.UNDEFINED) continue;
            NBTTagCompound dataNBT = nbt.func_74775_l(type.name());
            this.dataStorages.get((Object)type).readFromNBT(dataNBT);
        }
    }
}

