/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.provider;

import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.IPlanetaryProvider;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.armor.ItemSpaceArmor;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.capability.DimensionCompat;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.util.AstronomicalBodyHelper;
import zmaster587.advancedRocketry.world.ChunkManagerPlanet;
import zmaster587.advancedRocketry.world.ChunkProviderCavePlanet;
import zmaster587.advancedRocketry.world.ChunkProviderPlanet;

public class WorldProviderPlanet
extends WorldProvider
implements IPlanetaryProvider {
    @Nonnull
    public IChunkGenerator func_186060_c() {
        int genType = DimensionManager.getInstance().getDimensionProperties(this.field_76579_a.field_73011_w.getDimension()).getGenType();
        if (genType == 1) {
            return new ChunkProviderCavePlanet(this.field_76579_a, false, this.field_76579_a.func_72905_C(), this.field_76579_a.func_72912_H().func_82571_y());
        }
        return new ChunkProviderPlanet(this.field_76579_a, this.field_76579_a.func_72905_C(), ARConfiguration.getCurrentConfig().generateVanillaStructures, this.field_76579_a.func_72912_H().func_82571_y());
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public IRenderHandler getSkyRenderer() {
        if (!ARConfiguration.getCurrentConfig().planetSkyOverride || DimensionManager.getInstance().getDimensionProperties((int)this.field_76579_a.field_73011_w.getDimension()).skyRenderOverride) {
            return null;
        }
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer(new RenderPlanetarySky());
        }
        return super.getSkyRenderer();
    }

    public long getSeed() {
        return super.getSeed() + (long)this.getDimension();
    }

    protected void func_76572_b() {
        this.field_191067_f = true;
        this.field_76579_a.func_72912_H().func_76085_a(AdvancedRocketry.planetWorldType);
        this.field_76578_c = new ChunkManagerPlanet(this.field_76579_a, this.field_76579_a.func_72912_H().func_82571_y(), DimensionManager.getInstance().getDimensionProperties(this.field_76579_a.field_73011_w.getDimension()).getBiomes());
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return this.getAtmosphereDensity(new BlockPos(0, 0, 0)) > 75.0f && super.canDoRainSnowIce(chunk);
    }

    public void calculateInitialWeather() {
        super.calculateInitialWeather();
        this.doWeatherStuff();
    }

    public void updateWeather() {
        DimensionProperties props = this.getDimensionProperties();
        if (this.field_76579_a.field_73011_w.func_191066_m() && !this.field_76579_a.field_72995_K) {
            boolean flag = this.field_76579_a.func_82736_K().func_82766_b("doWeatherCycle");
            if (flag) {
                int k2;
                int j2;
                if (props.getRainMarker() == -1 && props.getThunderMarker() == -1) {
                    this.field_76579_a.func_72912_H().func_76084_b(false);
                    this.field_76579_a.func_72912_H().func_76080_g(0);
                    this.field_76579_a.func_72912_H().func_76069_a(false);
                    this.field_76579_a.func_72912_H().func_76090_f(0);
                    this.field_76579_a.func_72912_H().func_176142_i(20000);
                }
                if ((j2 = this.field_76579_a.func_72912_H().func_176133_A()) > 0) {
                    this.field_76579_a.func_72912_H().func_176142_i(--j2);
                    this.field_76579_a.func_72912_H().func_76090_f(this.field_76579_a.func_72912_H().func_76061_m() ? 1 : 2);
                    this.field_76579_a.func_72912_H().func_76080_g(this.field_76579_a.func_72912_H().func_76059_o() ? 1 : 2);
                }
                if (props.getThunderMarker() == 1) {
                    this.field_76579_a.func_72912_H().func_176142_i(0);
                    this.field_76579_a.func_72912_H().func_76069_a(true);
                }
                if (props.getRainMarker() == 1) {
                    this.field_76579_a.func_72912_H().func_176142_i(0);
                    this.field_76579_a.func_72912_H().func_76084_b(true);
                }
                if ((k2 = this.field_76579_a.func_72912_H().func_76071_n()) <= 0) {
                    if (this.field_76579_a.func_72912_H().func_76061_m()) {
                        this.field_76579_a.func_72912_H().func_76090_f(this.field_76579_a.field_73012_v.nextInt(this.getDimensionProperties().thunderProlongationLength) + 3600);
                    } else {
                        this.field_76579_a.func_72912_H().func_76090_f(this.field_76579_a.field_73012_v.nextInt(this.getDimensionProperties().thunderStartLength) + 12000);
                    }
                } else {
                    this.field_76579_a.func_72912_H().func_76090_f(--k2);
                    if (props.getThunderMarker() == 0 && k2 <= 0) {
                        this.field_76579_a.func_72912_H().func_76069_a(!this.field_76579_a.func_72912_H().func_76061_m());
                    }
                }
                int l2 = this.field_76579_a.func_72912_H().func_76083_p();
                if (l2 <= 0) {
                    if (this.field_76579_a.func_72912_H().func_76059_o()) {
                        this.field_76579_a.func_72912_H().func_76080_g(this.field_76579_a.field_73012_v.nextInt(this.getDimensionProperties().rainProlongationLength) + 12000);
                    } else {
                        this.field_76579_a.func_72912_H().func_76080_g(this.field_76579_a.field_73012_v.nextInt(this.getDimensionProperties().rainStartLength) + 12000);
                    }
                } else {
                    this.field_76579_a.func_72912_H().func_76080_g(--l2);
                    if (props.getRainMarker() == 0 && l2 <= 0) {
                        this.field_76579_a.func_72912_H().func_76084_b(!this.field_76579_a.func_72912_H().func_76059_o());
                    }
                }
            }
            this.field_76579_a.field_73018_p = this.field_76579_a.field_73017_q;
            this.field_76579_a.field_73017_q = this.field_76579_a.func_72912_H().func_76061_m() ? (float)((double)this.field_76579_a.field_73017_q + 0.01) : (float)((double)this.field_76579_a.field_73017_q - 0.01);
            this.field_76579_a.field_73017_q = MathHelper.func_76131_a((float)this.field_76579_a.field_73017_q, (float)0.0f, (float)1.0f);
            this.field_76579_a.field_73003_n = this.field_76579_a.field_73004_o;
            this.field_76579_a.field_73004_o = this.field_76579_a.func_72912_H().func_76059_o() ? (float)((double)this.field_76579_a.field_73004_o + 0.01) : (float)((double)this.field_76579_a.field_73004_o - 0.01);
            this.field_76579_a.field_73004_o = MathHelper.func_76131_a((float)this.field_76579_a.field_73004_o, (float)0.0f, (float)1.0f);
        }
    }

    private void doWeatherStuff() {
    }

    public int getRespawnDimension(@Nonnull EntityPlayerMP player) {
        if (ARConfiguration.getCurrentConfig().canPlayerRespawnInSpace) {
            BlockPos coords = player.getBedLocation(this.getDimension());
            AtmosphereHandler atmhandler = AtmosphereHandler.getOxygenHandler(player.field_70170_p.field_73011_w.getDimension());
            if (ARConfiguration.getCurrentConfig().forcePlayerRespawnInSpace || coords != null && AtmosphereHandler.hasAtmosphereHandler(player.field_70170_p.field_73011_w.getDimension()) && atmhandler != null && atmhandler.getAtmosphereType(coords).isBreathable()) {
                return this.getDimension();
            }
        }
        return DimensionCompat.getDefaultSpawnDimension();
    }

    @Nonnull
    public WorldProvider.WorldSleepResult canSleepAt(@Nonnull EntityPlayer player, @Nonnull BlockPos pos) {
        AtmosphereHandler atmhandler = AtmosphereHandler.getOxygenHandler(player.field_70170_p.field_73011_w.getDimension());
        if (ARConfiguration.getCurrentConfig().forcePlayerRespawnInSpace || AtmosphereHandler.hasAtmosphereHandler(player.field_70170_p.field_73011_w.getDimension()) && atmhandler != null && atmhandler.getAtmosphereType(pos).isBreathable()) {
            return WorldProvider.WorldSleepResult.ALLOW;
        }
        return WorldProvider.WorldSleepResult.DENY;
    }

    public boolean func_76567_e() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        float f4;
        EntityPlayerSP cameraEntity = Minecraft.func_71410_x().field_71439_g;
        float[] colors = this.getDimensionProperties((BlockPos)new BlockPos((int)((int)Minecraft.func_71410_x().field_71439_g.field_70165_t), (int)0, (int)((int)Minecraft.func_71410_x().field_71439_g.field_70161_v))).sunriseSunsetColors;
        if (colors == null) {
            return super.func_76560_a(celestialAngle, partialTicks);
        }
        float[] intermediateColors = new float[3];
        float[] finalColors = new float[4];
        float f2 = 0.4f;
        float f3 = MathHelper.func_76134_b((float)(celestialAngle * (float)Math.PI * 2.0f)) - 0.0f;
        if (f3 >= (f4 = -0.0f) - f2 && f3 <= f4 + f2) {
            float f5 = (f3 - f4) / f2 * 0.5f + 0.5f;
            float f6 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f5 * (float)Math.PI))) * 0.99f;
            f6 *= f6;
            intermediateColors[0] = f5 * 0.3f + colors[0];
            intermediateColors[1] = f5 * f5 * 0.7f + colors[1];
            intermediateColors[2] = f5 * f5 * 0.1f + colors[2];
            if (cameraEntity.field_70170_p.field_73011_w instanceof WorldProviderPlanet) {
                WorldProviderPlanet world = (WorldProviderPlanet)cameraEntity.field_70170_p.field_73011_w;
                intermediateColors = this.operateFloatOnTriFloatArray(intermediateColors, world.getSunBrightness(partialTicks));
            }
            finalColors[0] = intermediateColors[0];
            finalColors[1] = intermediateColors[1];
            finalColors[2] = intermediateColors[2];
            finalColors[3] = f6 * this.getAtmosphereDensityFromHeight(Minecraft.func_71410_x().func_175606_aa().field_70163_u, new BlockPos((int)Minecraft.func_71410_x().field_71439_g.field_70165_t, 0, (int)Minecraft.func_71410_x().field_71439_g.field_70161_v));
            return finalColors;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        DimensionProperties properties = this.getDimensionProperties(Minecraft.func_71410_x().field_71439_g.func_180425_c());
        StellarBody star = properties.getStar();
        float atmosphere = this.getAtmosphereDensity(new BlockPos(0, 0, 0));
        float f1 = this.field_76579_a.func_72826_c(partialTicks);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f) - atmosphere / 4.0f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        f2 *= this.shouldOverrideDistanceBrightness((EntityPlayer)Minecraft.func_71410_x().field_71439_g) ? 1.0f : (float)AstronomicalBodyHelper.getPlanetaryLightLevelMultiplier(AstronomicalBodyHelper.getStellarBrightness(star, properties.getSolarOrbitalDistance()));
        if (this.field_76579_a.field_72995_K) {
            if (properties.isMoon()) {
                f2 = this.eclipseValue(properties, f2, partialTicks);
            } else {
                for (int i : properties.getChildPlanets()) {
                    DimensionProperties childProps = DimensionManager.getInstance().getDimensionProperties(i);
                    f2 = this.eclipseValue(childProps, f2, partialTicks);
                }
            }
        }
        return f2 * super.getSunBrightness(partialTicks);
    }

    private float eclipseValue(@Nonnull DimensionProperties properties, float lightValue, double partialTicks) {
        double currentTheta = (partialTicks * properties.orbitTheta + (1.0 - partialTicks) * properties.prevOrbitalTheta) * 180.0 / Math.PI % 360.0;
        int solarDistance = properties.getSolarOrbitalDistance();
        float planetaryDistance = properties.getParentOrbitalDistance();
        float difference = (float)solarDistance / (200.0f - planetaryDistance + 1.0E-5f);
        float phiMultiplier = Math.max(Math.abs(MathHelper.func_76134_b((float)((float)(properties.orbitalPhi * Math.PI / 180.0)))) - 0.95f, 0.0f) * 20.0f;
        int offset = (int)((200.0f - planetaryDistance) / 2.0f);
        if (phiMultiplier != 0.0f && currentTheta > (double)(180 - offset) && currentTheta < (double)(180 + offset)) {
            lightValue *= phiMultiplier * MathHelper.func_76131_a((float)((float)((double)(difference / 20.0f) + Math.abs(currentTheta - 180.0) * (double)difference / 10.0)), (float)0.0f, (float)1.0f) + (1.0f - phiMultiplier);
        }
        return lightValue;
    }

    public float func_76571_f() {
        return this.getAtmosphereDensity(new BlockPos(0, 0, 0)) > 0.75f ? 128.0f : -200000.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    @Nonnull
    public Vec3d getSkyColor(@Nonnull Entity cameraEntity, float partialTicks) {
        float[] vec = this.getDimensionProperties((BlockPos)new BlockPos((int)((int)cameraEntity.field_70165_t), (int)0, (int)((int)cameraEntity.field_70161_v))).skyColor;
        if (cameraEntity.field_70170_p.field_73011_w instanceof WorldProviderPlanet && cameraEntity instanceof EntityPlayer) {
            WorldProviderPlanet world = (WorldProviderPlanet)cameraEntity.field_70170_p.field_73011_w;
            vec = this.operateFloatOnTriFloatArray(vec, world.getSunBrightness(partialTicks));
        }
        Vec3d skyColorVec = this.getDimensionProperties((BlockPos)new BlockPos((int)((int)cameraEntity.field_70165_t), (int)0, (int)((int)cameraEntity.field_70161_v))).colorOverride ? new Vec3d(1.0, 1.0, 1.0) : super.getSkyColor(cameraEntity, partialTicks);
        return new Vec3d((double)vec[0] * skyColorVec.field_72450_a, (double)vec[1] * skyColorVec.field_72448_b, (double)vec[2] * skyColorVec.field_72449_c);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        EntityPlayerSP cameraEntity = Minecraft.func_71410_x().field_71439_g;
        Vec3d superVec = this.getDimensionProperties((BlockPos)new BlockPos((int)((int)cameraEntity.field_70165_t), (int)0, (int)((int)cameraEntity.field_70161_v))).colorOverride ? new Vec3d(1.0, 1.0, 1.0) : super.func_76562_b(p_76562_1_, p_76562_2_);
        float[] vec = this.getDimensionProperties((BlockPos)new BlockPos((int)((int)cameraEntity.field_70165_t), (int)0, (int)((int)cameraEntity.field_70161_v))).fogColor;
        if (cameraEntity.field_70170_p.field_73011_w instanceof WorldProviderPlanet) {
            WorldProviderPlanet world = (WorldProviderPlanet)cameraEntity.field_70170_p.field_73011_w;
            vec = this.operateFloatOnTriFloatArray(vec, world.getSunBrightness(Minecraft.func_71410_x().func_184121_ak()));
        }
        return new Vec3d((double)vec[0] * superVec.field_72450_a, (double)vec[1] * superVec.field_72448_b, (double)vec[2] * superVec.field_72449_c);
    }

    public boolean func_76568_b(int x, int z) {
        return this.getDimensionProperties(new BlockPos(x, 0, z)).getAtmosphereDensity() > 100;
    }

    public double getHorizon() {
        int genType = DimensionManager.getInstance().getDimensionProperties(this.field_76579_a.field_73011_w.getDimension()).getGenType();
        if (genType == 2) {
            return 0.0;
        }
        return 63.0;
    }

    public float func_76563_a(long p_76563_1_, float p_76563_3_) {
        int rotationalPeriod = this.getRotationalPeriod(new BlockPos(0, 0, 0));
        int j = (int)(p_76563_1_ % (long)rotationalPeriod);
        float f1 = ((float)j + p_76563_3_) / (float)rotationalPeriod - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 1.0f - (float)((Math.cos((double)f1 * Math.PI) + 1.0) / 2.0);
        f1 = f2 + (f1 - f2) / 3.0f;
        return f1;
    }

    @Override
    public double getGravitationalMultiplier(@Nullable BlockPos pos) {
        return this.getDimensionProperties((BlockPos)pos).gravitationalMultiplier;
    }

    @Override
    public int getOrbitingDimension(@Nullable BlockPos pos) {
        return this.getDimensionProperties(pos).getParentPlanet();
    }

    @Override
    public int[] getDimensionsInOrbit(@Nullable BlockPos pos) {
        Set<Integer> intSet = this.getDimensionProperties(pos).getChildPlanets();
        Integer[] intArray = new Integer[intSet.size()];
        return ArrayUtils.toPrimitive((Integer[])this.getDimensionProperties(pos).getChildPlanets().toArray(intArray));
    }

    @Override
    public int getOrbitalDistance(@Nullable BlockPos pos) {
        return this.getDimensionProperties((BlockPos)pos).orbitalDist;
    }

    @Override
    public IAtmosphere getAtmosphere(@Nullable BlockPos pos) {
        return this.getDimensionProperties(pos).getAtmosphere();
    }

    @Override
    public float getAtmosphereDensity(@Nullable BlockPos pos) {
        return (float)this.getDimensionProperties(pos).getAtmosphereDensity() / 100.0f;
    }

    @Override
    public float getAtmosphereDensityFromHeight(double y, @Nullable BlockPos pos) {
        return this.getDimensionProperties(pos).getAtmosphereDensityAtHeight(y);
    }

    @Override
    public int getAverageTemperature(@Nullable BlockPos pos) {
        return this.getDimensionProperties(pos).getAverageTemp();
    }

    @Override
    public int getRotationalPeriod(@Nullable BlockPos pos) {
        return this.getDimensionProperties((BlockPos)new BlockPos((int)0, (int)0, (int)0)).rotationalPeriod;
    }

    @Override
    public int getWetness() {
        return 0;
    }

    public String getSaveFolder() {
        return "advRocketry/" + super.getSaveFolder();
    }

    @Override
    public boolean isPlanet() {
        return true;
    }

    @Override
    public Vec3d getSunColor(@Nullable BlockPos pos) {
        float[] vec = this.getDimensionProperties(pos).getSunColor();
        return new Vec3d((double)vec[0], (double)vec[1], (double)vec[2]);
    }

    public int getSolarOrbitalDistance(@Nullable BlockPos pos) {
        return this.getDimensionProperties(pos).getSolarOrbitalDistance();
    }

    public DimensionProperties getDimensionProperties() {
        return this.getDimensionProperties(null);
    }

    @Override
    public DimensionProperties getDimensionProperties(@Nullable BlockPos pos) {
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(this.getDimension());
        return properties == null ? new DimensionProperties(this.getDimension()) : properties;
    }

    @Nonnull
    public DimensionType func_186058_p() {
        return DimensionManager.PlanetDimensionType;
    }

    private float[] operateFloatOnTriFloatArray(float[] array, float f) {
        return new float[]{array[0] * f, array[1] * f, array[2] * f};
    }

    private boolean shouldOverrideDistanceBrightness(EntityPlayer player) {
        for (ItemStack stack : player.func_184193_aE()) {
            Iterator<ItemStack> iterator;
            if (stack.func_77973_b() != AdvancedRocketryItems.itemSpaceSuit_Helmet || !(iterator = ((ItemSpaceArmor)stack.func_77973_b()).getComponents(stack).iterator()).hasNext()) continue;
            ItemStack stack1 = iterator.next();
            return stack1.func_77973_b() == AdvancedRocketryItems.itemUpgrade && stack1.func_77952_i() == 5;
        }
        return false;
    }
}

