/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.decoration;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import zmaster587.advancedRocketry.world.biome.BiomeGenDeepSwamp;

public class MapGenSwampTree
extends MapGenBase {
    private static final double arcSize = 16.0;
    Map<BlockPos, IBlockState> cachedCanopy = new HashMap<BlockPos, IBlockState>();
    Map<BlockPos, IBlockState> cachedRoots = new HashMap<BlockPos, IBlockState>();
    int chancePerChunk;

    public MapGenSwampTree(int chancePerChunk) {
        this.chancePerChunk = chancePerChunk;
        this.buildCanopy();
        this.buildRoots();
    }

    private static boolean canSwampTreeGenerateGenerate(World world, int x, int z) {
        return world.func_180494_b(new BlockPos(x, 0, z)) instanceof BiomeGenDeepSwamp;
    }

    private void buildRoots() {
        this.cachedRoots.clear();
        for (double yAngle = 0.0; yAngle < Math.PI * 2; yAngle += 1.0471975511965976) {
            int yOffset = (int)(20.0 * Math.sin(Math.PI)) + 1;
            int xOffset = (int)(17.6 * Math.cos(Math.PI) * Math.cos(yAngle));
            int zOffset = (int)(17.6 * Math.cos(Math.PI) * Math.sin(yAngle));
            for (double angle = Math.PI; angle > 0.0; angle -= 0.07853981633974483) {
                int zz;
                int yy = (int)(20.0 * Math.sin(angle));
                double xzRadius = 12.0 * Math.cos(angle);
                int xx = (int)(xzRadius * Math.cos(yAngle));
                if (!this.cachedRoots.containsKey(new BlockPos(2 + xx - xOffset, yy - yOffset + 2, (zz = (int)(xzRadius * Math.sin(yAngle))) - zOffset))) {
                    this.cachedRoots.put(new BlockPos(2 + xx - xOffset, yy - yOffset + 2, zz - zOffset), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
                }
                if (!this.cachedRoots.containsKey(new BlockPos(3 + xx - xOffset, yy - yOffset + 2, zz - zOffset))) {
                    this.cachedRoots.put(new BlockPos(3 + xx - xOffset, yy - yOffset + 2, zz - zOffset), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
                }
                if (!this.cachedRoots.containsKey(new BlockPos(2 + xx - xOffset, yy - yOffset + 2, 1 + zz - zOffset))) {
                    this.cachedRoots.put(new BlockPos(2 + xx - xOffset, yy - yOffset + 2, 1 + zz - zOffset), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
                }
                if (!this.cachedRoots.containsKey(new BlockPos(2 + xx - xOffset, yy - yOffset + 3, 1 + zz - zOffset))) {
                    this.cachedRoots.put(new BlockPos(2 + xx - xOffset, yy - yOffset + 3, 1 + zz - zOffset), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
                }
                if (!this.cachedRoots.containsKey(new BlockPos(1 + xx - xOffset, yy - yOffset + 2, zz - zOffset))) {
                    this.cachedRoots.put(new BlockPos(1 + xx - xOffset, yy - yOffset + 2, zz - zOffset), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
                }
                if (this.cachedRoots.containsKey(new BlockPos(2 + xx - xOffset, yy - yOffset + 2, zz - zOffset - 1))) continue;
                this.cachedRoots.put(new BlockPos(2 + xx - xOffset, yy - yOffset + 2, zz - zOffset - 1), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
            }
        }
    }

    private void buildCanopy() {
        this.cachedCanopy.clear();
        for (double yAngle = 0.0; yAngle < Math.PI * 2; yAngle += 0.006135923151542565) {
            int yOffset = (int)(16.0 * Math.sin(2.356194490192345));
            int xOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.cos(yAngle));
            int zOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.sin(yAngle));
            for (double angle = 2.356194490192345; angle > -0.5235987755982988; angle -= 0.02454369260617026) {
                int yy = (int)(16.0 * Math.sin(angle));
                double xzRadius = 20.8 * Math.cos(angle);
                int xx = (int)(xzRadius * Math.cos(yAngle));
                int zz = (int)(xzRadius * Math.sin(yAngle));
                for (int yyy = -2; yyy < 4; ++yyy) {
                    if (this.cachedCanopy.containsKey(new BlockPos(2 + xx - xOffset, yyy + yy - yOffset + 2, zz - zOffset))) continue;
                    this.cachedCanopy.put(new BlockPos(2 + xx - xOffset, yyy + yy - yOffset + 2, zz - zOffset), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
                }
            }
        }
    }

    protected void func_180701_a(World worldIn, int chunkX, int chunkZ, int rangeX, int rangeZ, ChunkPrimer blocks) {
        if (this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(chunkX) % this.chancePerChunk && this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(chunkZ) % this.chancePerChunk && MapGenSwampTree.canSwampTreeGenerateGenerate(this.field_75039_c, chunkX * 16, chunkZ * 16)) {
            int x = -(rangeX - chunkX) * 16;
            int z = -(rangeZ - chunkZ) * 16;
            int y = 56;
            int treeHeight = this.field_75038_b.nextInt(10) + 40;
            int radius = 4;
            int edgeRadius = 1;
            int numDiag = edgeRadius + 1;
            IBlockState block = Blocks.field_150364_r.func_176223_P();
            float SHAPE = 0.1f;
            ++y;
            for (int yOff = -20; yOff < treeHeight; ++yOff) {
                int xOff;
                int zOff;
                int currentEdgeRadius = (int)(0.1f * (float)(edgeRadius * (treeHeight - yOff)) + 0.9f * (float)edgeRadius);
                for (zOff = -numDiag - currentEdgeRadius / 2; zOff <= -currentEdgeRadius / 2; ++zOff) {
                    for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                        this.setBlock(new BlockPos(x + xOff, y + yOff, z + zOff), block, blocks);
                    }
                    ++currentEdgeRadius;
                }
                for (zOff = -currentEdgeRadius / 2; zOff <= currentEdgeRadius / 2; ++zOff) {
                    for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                        this.setBlock(new BlockPos(x + xOff, y + yOff, z + zOff), block, blocks);
                    }
                }
                for (zOff = currentEdgeRadius / 2; zOff <= numDiag + currentEdgeRadius / 2; ++zOff) {
                    for (xOff = -numDiag - --currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                        this.setBlock(new BlockPos(x + xOff, y + yOff, z + zOff), block, blocks);
                    }
                }
            }
            for (Map.Entry<BlockPos, IBlockState> entry : this.cachedCanopy.entrySet()) {
                this.setBlock(entry.getKey().func_177982_a(x - radius / 2, y + treeHeight, z), entry.getValue(), blocks);
            }
            for (double yAngle = 0.0; yAngle < Math.PI * 2; yAngle += 0.39269908169872414) {
                int yOffset = (int)(16.0 * Math.sin(2.356194490192345));
                int xOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.cos(yAngle));
                int zOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.sin(yAngle));
                for (double angle = 2.356194490192345; angle > -0.5235987755982988; angle -= 0.07853981633974483) {
                    int yy = (int)(16.0 * Math.sin(angle));
                    double xzRadius = 20.0 * Math.cos(angle);
                    int xx = (int)(xzRadius * Math.cos(yAngle));
                    int zz = (int)(xzRadius * Math.sin(yAngle));
                    int p_i46030_2_ = y + treeHeight + yy - yOffset + 2;
                    this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, p_i46030_2_, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), blocks);
                    this.setBlock(new BlockPos(x + 3 + xx - xOffset - radius / 2, p_i46030_2_, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), blocks);
                    this.setBlock(new BlockPos(x + 1 + xx - xOffset - radius / 2, p_i46030_2_, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), blocks);
                    this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 3, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), blocks);
                    this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, p_i46030_2_, z + zz - zOffset + 1), Blocks.field_150364_r.func_176223_P(), blocks);
                    this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, p_i46030_2_, z + zz - zOffset - 1), Blocks.field_150364_r.func_176223_P(), blocks);
                }
                if (this.field_75038_b.nextInt(4) != 0) continue;
                int yy = (int)(16.0 * Math.sin(1.0471975511965976));
                double xzRadius = 20.0 * Math.cos(1.5707963267948966);
                int xx = (int)(xzRadius * Math.cos(yAngle));
                int zz = (int)(xzRadius * Math.sin(yAngle));
                int xxx = xx;
                int zzz = zz;
                for (zz = -1; zz < 2; ++zz) {
                    for (xx = -1; xx < 2; ++xx) {
                        this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight - 10 + yy - yOffset + 2, z + zz - zOffset), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), blocks);
                    }
                }
                for (int yyy = 0; yyy < 10; ++yyy) {
                    for (zz = -2; zz < 3; ++zz) {
                        for (xx = -2; xx < 3; ++xx) {
                            this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight - yyy + yy - yOffset + 2, z + zz - zOffset), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), blocks);
                        }
                    }
                    xx = xxx;
                    zz = zzz;
                    int p_i46030_2_ = y + treeHeight + yy - yyy - yOffset + 2;
                    this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, p_i46030_2_, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), blocks);
                    this.setBlock(new BlockPos(x + 3 + xx - xOffset - radius / 2, p_i46030_2_, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), blocks);
                    this.setBlock(new BlockPos(x + 1 + xx - xOffset - radius / 2, p_i46030_2_, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), blocks);
                    this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 3, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), blocks);
                    this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, p_i46030_2_, z + zz - zOffset + 1), Blocks.field_150364_r.func_176223_P(), blocks);
                    this.setBlock(new BlockPos(x + 2 + xx - xOffset - radius / 2, p_i46030_2_, z + zz - zOffset - 1), Blocks.field_150364_r.func_176223_P(), blocks);
                }
            }
            for (Map.Entry<BlockPos, IBlockState> entry : this.cachedRoots.entrySet()) {
                this.setBlock(entry.getKey().func_177982_a(x - radius / 2, y, z), entry.getValue(), blocks);
            }
        }
    }

    private void setBlock(BlockPos pos, IBlockState block, ChunkPrimer blocks) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (x > 15 || x < 0 || z > 15 || z < 0 || y < 0 || y > 255) {
            return;
        }
        blocks.func_177855_a(x, y, z, block);
    }

    public boolean generate(World world, Random rand, int x, int y, int z) {
        BlockPos yOff;
        int xOff;
        int zOff;
        int treeHeight = rand.nextInt(10) + 40;
        int radius = 4;
        int edgeRadius = 1;
        int numDiag = edgeRadius + 1;
        IBlockState block = Blocks.field_150364_r.func_176223_P();
        float SHAPE = 0.1f;
        int currentEdgeRadius = (int)(0.1f * (float)(edgeRadius * treeHeight) + 0.9f * (float)edgeRadius);
        for (zOff = -numDiag - currentEdgeRadius / 2; zOff <= -currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                yOff = world.func_175645_m(new BlockPos(x + xOff, 0, z + zOff));
                while (yOff.func_177956_o() < y) {
                    world.func_175656_a(yOff, block);
                    yOff = yOff.func_177984_a();
                }
                world.func_175656_a(new BlockPos(x + xOff, y, z + zOff), block);
            }
            ++currentEdgeRadius;
        }
        for (zOff = -currentEdgeRadius / 2; zOff <= currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                yOff = world.func_175645_m(new BlockPos(x + xOff, 0, z + zOff));
                while (yOff.func_177956_o() < y) {
                    world.func_175656_a(yOff, block);
                    yOff = yOff.func_177984_a();
                }
                world.func_175656_a(new BlockPos(x + xOff, y, z + zOff), block);
            }
        }
        for (zOff = currentEdgeRadius / 2; zOff <= numDiag + currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - --currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                yOff = world.func_175645_m(new BlockPos(x + xOff, 0, z + zOff));
                while (yOff.func_177956_o() < y) {
                    world.func_175656_a(yOff, block);
                    yOff = yOff.func_177984_a();
                }
                world.func_175656_a(new BlockPos(x + xOff, y, z + zOff), block);
            }
        }
        ++y;
        for (int yOff2 = 0; yOff2 < treeHeight; ++yOff2) {
            int zOff2;
            currentEdgeRadius = (int)(0.1f * (float)(edgeRadius * (treeHeight - yOff2)) + 0.9f * (float)edgeRadius);
            for (zOff2 = -numDiag - currentEdgeRadius / 2; zOff2 <= -currentEdgeRadius / 2; ++zOff2) {
                for (int xOff2 = -numDiag - currentEdgeRadius / 2; xOff2 <= numDiag + currentEdgeRadius / 2; ++xOff2) {
                    world.func_175656_a(new BlockPos(x + xOff2, y + yOff2, z + zOff2), block);
                }
                ++currentEdgeRadius;
            }
            for (zOff2 = -currentEdgeRadius / 2; zOff2 <= currentEdgeRadius / 2; ++zOff2) {
                for (int xOff3 = -numDiag - currentEdgeRadius / 2; xOff3 <= numDiag + currentEdgeRadius / 2; ++xOff3) {
                    world.func_175656_a(new BlockPos(x + xOff3, y + yOff2, z + zOff2), block);
                }
            }
            for (zOff2 = currentEdgeRadius / 2; zOff2 <= numDiag + currentEdgeRadius / 2; ++zOff2) {
                for (int xOff4 = -numDiag - --currentEdgeRadius / 2; xOff4 <= numDiag + currentEdgeRadius / 2; ++xOff4) {
                    world.func_175656_a(new BlockPos(x + xOff4, y + yOff2, z + zOff2), block);
                }
            }
        }
        for (Map.Entry<BlockPos, IBlockState> entry : this.cachedCanopy.entrySet()) {
            world.func_180501_a(entry.getKey().func_177982_a(x - radius / 2, y + treeHeight, z), entry.getValue(), 2);
        }
        for (double yAngle = 0.0; yAngle < Math.PI * 2; yAngle += 0.39269908169872414) {
            int yyy;
            int yOffset = (int)(16.0 * Math.sin(2.356194490192345));
            int xOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.cos(yAngle));
            int zOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.sin(yAngle));
            for (double angle = 2.356194490192345; angle > -0.5235987755982988; angle -= 0.07853981633974483) {
                int yy = (int)(16.0 * Math.sin(angle));
                double xzRadius = 20.0 * Math.cos(angle);
                int xx = (int)(xzRadius * Math.cos(yAngle));
                int zz = (int)(xzRadius * Math.sin(yAngle));
                yyy = y + treeHeight + yy - yOffset + 2;
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, yyy, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 3 + xx - xOffset - radius / 2, yyy, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 1 + xx - xOffset - radius / 2, yyy, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, yyy, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, yyy, z + zz - zOffset + 1), Blocks.field_150364_r.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, yyy, z + zz - zOffset - 1), Blocks.field_150364_r.func_176223_P(), 5);
            }
            if (rand.nextInt(4) != 0) continue;
            int yy = (int)(16.0 * Math.sin(1.0471975511965976));
            double xzRadius = 20.0 * Math.cos(1.5707963267948966);
            int xx = (int)(xzRadius * Math.cos(yAngle));
            int zz = (int)(xzRadius * Math.sin(yAngle));
            int xxx = xx;
            int zzz = zz;
            yyy = y + treeHeight + yy - yOffset + 2;
            for (zz = -1; zz < 2; ++zz) {
                for (xx = -1; xx < 2; ++xx) {
                    world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight - 10 + yy - yOffset + 2, z + zz - zOffset), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), 5);
                }
            }
            for (int yyyy = 0; yyyy < 10; ++yyyy) {
                for (zz = -2; zz < 3; ++zz) {
                    for (xx = -2; xx < 3; ++xx) {
                        world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, y + treeHeight - yyyy + yy - yOffset + 2, z + zz - zOffset), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), 5);
                    }
                }
                xx = xxx;
                zz = zzz;
                int yModified = yyy - yyyy;
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, yModified, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 3 + xx - xOffset - radius / 2, yModified, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 1 + xx - xOffset - radius / 2, yModified, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, yModified + 1, z + zz - zOffset), Blocks.field_150364_r.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, yModified, z + zz - zOffset + 1), Blocks.field_150364_r.func_176223_P(), 5);
                world.func_180501_a(new BlockPos(x + 2 + xx - xOffset - radius / 2, yModified, z + zz - zOffset - 1), Blocks.field_150364_r.func_176223_P(), 5);
            }
        }
        for (Map.Entry<BlockPos, IBlockState> entry : this.cachedRoots.entrySet()) {
            world.func_180501_a(entry.getKey().func_177982_a(x - radius / 2, y, z), entry.getValue(), 2);
        }
        return true;
    }
}

