/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.decoration;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.libVulpes.block.BlockMeta;

public class MapGenCraterSmall
extends MapGenBase {
    int chancePerChunk;

    public MapGenCraterSmall(int chancePerChunk) {
        this.chancePerChunk = chancePerChunk;
        this.field_75040_a = 2;
    }

    private static boolean isCraterIgnoredBlock(Block block) {
        return block instanceof BlockLiquid || block instanceof IFluidBlock || block == Blocks.field_150350_a || block == Blocks.field_150432_aD;
    }

    public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
        int i = this.field_75040_a;
        this.field_75039_c = worldIn;
        this.field_75038_b.setSeed(worldIn.func_72905_C());
        long j = this.field_75038_b.nextLong();
        long k = this.field_75038_b.nextLong();
        for (int l = x - i; l <= x + i; ++l) {
            for (int i1 = z - i; i1 <= z + i; ++i1) {
                long j1 = (long)l * j;
                long k1 = (long)i1 * k;
                this.field_75038_b.setSeed(j1 ^ k1 ^ worldIn.func_72905_C());
                this.func_180701_a(worldIn, l, i1, x, z, primer);
            }
        }
    }

    protected void func_180701_a(World world, int chunkX, int chunkZ, int p_180701_4_, int p_180701_5_, ChunkPrimer chunkPrimerIn) {
        DimensionProperties props = DimensionManager.getInstance().getDimensionProperties(world.field_73011_w.getDimension());
        List<IBlockState> ores = props.craterOres.stream().filter(OreDictionary::doesOreNameExist).map(s -> (ItemStack)OreDictionary.getOres((String)s).get(0)).map(itemStack -> new BlockMeta(Block.func_149634_a((Item)itemStack.func_77973_b()), itemStack.func_77952_i()).getBlockState()).collect(Collectors.toList());
        if (this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(chunkX) % this.chancePerChunk || this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(chunkZ) % this.chancePerChunk && this.shouldCraterSpawn(DimensionManager.getInstance().getDimensionProperties(world.field_73011_w.getDimension()), world.func_180494_b(new BlockPos(chunkX * 16, 0, chunkZ * 16)))) {
            int y;
            int z;
            int x;
            int[] sinCoefficients = new int[]{this.field_75038_b.nextInt(15) + 1, this.field_75038_b.nextInt(15) + 1, this.field_75038_b.nextInt(15) + 1, this.field_75038_b.nextInt(15) + 1, this.field_75038_b.nextInt(15) + 1};
            int baseRadius = 4 + this.field_75038_b.nextInt(4);
            int numBulges = 3;
            int xCoord = -chunkX + p_180701_4_;
            int zCoord = -chunkZ + p_180701_5_;
            IBlockState fillBlock = Blocks.field_150350_a.func_176223_P();
            int fluidMaxY = 0;
            for (x = 15; x >= 0; --x) {
                block1: for (z = 15; z >= 0; --z) {
                    for (y = 254; y >= 0; --y) {
                        if (chunkPrimerIn.func_177856_a(x, y, z).func_177230_c() instanceof BlockLiquid || chunkPrimerIn.func_177856_a(x, y, z).func_177230_c() instanceof IFluidBlock) {
                            if (y <= fluidMaxY) continue;
                            fillBlock = chunkPrimerIn.func_177856_a(x, y, z);
                            fluidMaxY = y;
                            continue;
                        }
                        if (chunkPrimerIn.func_177856_a(x, y, z).func_177230_c() != Blocks.field_150350_a) continue block1;
                    }
                }
            }
            for (x = 15; x >= 0; --x) {
                block4: for (z = 15; z >= 0; --z) {
                    for (y = 254; y >= 0; --y) {
                        if (y <= fluidMaxY && fillBlock.func_177230_c() != Blocks.field_150350_a && chunkPrimerIn.func_177856_a(x, y, z).func_177230_c() == Blocks.field_150350_a) {
                            chunkPrimerIn.func_177855_a(x, y, z, fillBlock);
                        }
                        if (MapGenCraterSmall.isCraterIgnoredBlock(chunkPrimerIn.func_177856_a(x, y, z).func_177230_c())) continue;
                        int radius = this.getRadius(baseRadius, xCoord * 16 + x, zCoord * 16 + z, numBulges, sinCoefficients);
                        int inversePartialSquareRadius = (baseRadius * baseRadius - ((xCoord * 16 + x) * (xCoord * 16 + x) + (zCoord * 16 + z) * (zCoord * 16 + z))) / (radius * 2);
                        for (int dist = 0; dist < inversePartialSquareRadius; ++dist) {
                            if (y - dist <= 2) continue;
                            chunkPrimerIn.func_177855_a(x, y - dist, z, y - dist <= fluidMaxY ? fillBlock : Blocks.field_150350_a.func_176223_P());
                        }
                        if (baseRadius > 6) {
                            double ridgeSize = Math.max(1.0, (double)(12 * radius) / 64.0);
                            if (inversePartialSquareRadius <= radius / 4 && inversePartialSquareRadius > -3 * radius) {
                                int dist = -1;
                                while ((double)dist < 9.0 * ridgeSize * ((double)(1 - inversePartialSquareRadius) / (0.8 * (double)radius + (double)((inversePartialSquareRadius - 1) * (inversePartialSquareRadius - 1)))) - 1.06) {
                                    if (y + dist < 255 && (double)inversePartialSquareRadius > -0.875 * (double)radius) {
                                        chunkPrimerIn.func_177855_a(x, y + dist, z, this.getBlockToPlace(world, chunkX, chunkZ, ores));
                                    } else if (y + dist < 255 && (double)inversePartialSquareRadius > -1.125 * (double)radius && this.field_75038_b.nextInt(Math.abs(inversePartialSquareRadius / (radius > 48 ? 4 : 2)) + 1) == 0) {
                                        chunkPrimerIn.func_177855_a(x, y + dist, z, this.getBlockToPlace(world, chunkX, chunkZ, ores));
                                    }
                                    ++dist;
                                }
                            }
                        }
                        if (inversePartialSquareRadius < 0 || y - inversePartialSquareRadius <= 0) continue block4;
                        chunkPrimerIn.func_177855_a(x, y - inversePartialSquareRadius, z, this.getBlockToPlace(world, chunkX, chunkZ, ores));
                        chunkPrimerIn.func_177855_a(x, y - 1 - inversePartialSquareRadius, z, this.getBlockToPlace(world, chunkX, chunkZ, ores));
                        continue block4;
                    }
                }
            }
        }
    }

    private IBlockState getBlockToPlace(World world, int chunkX, int chunkZ, List<IBlockState> ores) {
        if (this.field_75038_b.nextInt(24) == 0 && !ores.isEmpty()) {
            return ores.get(this.field_75038_b.nextInt(ores.size()));
        }
        return world.func_180494_b((BlockPos)new BlockPos((int)(chunkX * 16), (int)0, (int)(chunkZ * 16))).field_76752_A;
    }

    private boolean shouldCraterSpawn(DimensionProperties properties, Biome biome) {
        if (properties.getCraterBiomeWeights().isEmpty()) {
            return true;
        }
        for (BiomeManager.BiomeEntry biomeEntry : properties.getCraterBiomeWeights()) {
            if (!biomeEntry.biome.equals(biome) || biomeEntry.field_76292_a <= this.field_75038_b.nextInt(99)) continue;
            return true;
        }
        return false;
    }

    private int getRadius(int base, int x, int z, int bumps, int[] random) {
        double radians = Math.atan2(x, z);
        int extras = 0;
        for (int i = 2; i < Math.min(5, bumps) + 2; ++i) {
            extras = (int)((double)extras + (double)(random[i - 2] * base) * Math.sin((double)i * radians) * 0.0125);
        }
        return base + extras;
    }
}

