/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Biomes;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerAddIsland;
import net.minecraft.world.gen.layer.GenLayerAddMushroomIsland;
import net.minecraft.world.gen.layer.GenLayerAddSnow;
import net.minecraft.world.gen.layer.GenLayerDeepOcean;
import net.minecraft.world.gen.layer.GenLayerEdge;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerHills;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerRareBiome;
import net.minecraft.world.gen.layer.GenLayerRemoveTooMuchOcean;
import net.minecraft.world.gen.layer.GenLayerRiver;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.GenLayerShore;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.world.GenLayerBiomePlanet;

public class ChunkManagerPlanet
extends BiomeProvider {
    private GenLayer biomeIndexLayer;
    private BiomeCache biomeCache;
    private GenLayer genBiomes;
    private List<BiomeManager.BiomeEntry> biomes;
    long seed;
    WorldType default1;
    String str;
    DimensionProperties properties;

    private void setup(long seed, WorldType default1, String str, DimensionProperties properties) {
        this.biomeCache = new BiomeCache((BiomeProvider)this);
        GenLayer[] agenlayer = ChunkManagerPlanet.initializeAllBiomeGenerators(seed, default1, str, properties);
        agenlayer = this.getModdedBiomeGenerators(default1, seed, agenlayer);
        this.genBiomes = agenlayer[0];
        this.biomeIndexLayer = agenlayer[1];
        ReflectionHelper.setPrivateValue(BiomeProvider.class, (Object)((Object)this), (Object)this.genBiomes, (String)"genBiomes", (String)"field_76944_d");
        ReflectionHelper.setPrivateValue(BiomeProvider.class, (Object)((Object)this), (Object)this.biomeIndexLayer, (String)"biomeIndexLayer", (String)"field_76945_e");
    }

    public ChunkManagerPlanet(long seed, WorldType default1, String str, DimensionProperties properties) {
        this.seed = seed;
        this.default1 = default1;
        this.str = str;
        this.properties = properties;
        this.setup(seed, default1, str, properties);
    }

    public ChunkManagerPlanet(World world, String str, List<BiomeManager.BiomeEntry> biomes) {
        this(world.func_72905_C(), AdvancedRocketry.planetWorldType, str, DimensionManager.getInstance().getDimensionProperties(world.field_73011_w.getDimension()));
        this.biomes = biomes;
    }

    public static GenLayer[] initializeAllBiomeGenerators(long seed, WorldType p_180781_2_, String p_180781_3_, DimensionProperties properties) {
        int i;
        boolean hasRivers = properties.hasRivers();
        GenLayerIsland genlayer = new GenLayerIsland(1L);
        genlayer = new GenLayerFuzzyZoom(2000L, (GenLayer)genlayer);
        GenLayerAddIsland genlayeraddisland = new GenLayerAddIsland(1L, (GenLayer)genlayer);
        GenLayerZoom genlayerzoom = new GenLayerZoom(2001L, (GenLayer)genlayeraddisland);
        GenLayerAddIsland genlayeraddisland1 = new GenLayerAddIsland(2L, (GenLayer)genlayerzoom);
        genlayeraddisland1 = new GenLayerAddIsland(50L, (GenLayer)genlayeraddisland1);
        genlayeraddisland1 = new GenLayerAddIsland(70L, (GenLayer)genlayeraddisland1);
        GenLayerRemoveTooMuchOcean genlayerremovetoomuchocean = new GenLayerRemoveTooMuchOcean(2L, (GenLayer)genlayeraddisland1);
        GenLayerAddSnow genlayeraddsnow = new GenLayerAddSnow(2L, (GenLayer)genlayerremovetoomuchocean);
        GenLayerAddIsland genlayeraddisland2 = new GenLayerAddIsland(3L, (GenLayer)genlayeraddsnow);
        GenLayerEdge genlayeredge = new GenLayerEdge(2L, (GenLayer)genlayeraddisland2, GenLayerEdge.Mode.COOL_WARM);
        genlayeredge = new GenLayerEdge(2L, (GenLayer)genlayeredge, GenLayerEdge.Mode.HEAT_ICE);
        genlayeredge = new GenLayerEdge(3L, (GenLayer)genlayeredge, GenLayerEdge.Mode.SPECIAL);
        GenLayerZoom genlayerzoom1 = new GenLayerZoom(2002L, (GenLayer)genlayeredge);
        genlayerzoom1 = new GenLayerZoom(2003L, (GenLayer)genlayerzoom1);
        GenLayerAddIsland genlayeraddisland3 = new GenLayerAddIsland(4L, (GenLayer)genlayerzoom1);
        GenLayerAddMushroomIsland genlayeraddmushroomisland = new GenLayerAddMushroomIsland(5L, (GenLayer)genlayeraddisland3);
        GenLayerDeepOcean genlayerdeepocean = new GenLayerDeepOcean(4L, (GenLayer)genlayeraddmushroomisland);
        GenLayer genlayer4 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerdeepocean, (int)0);
        int j = i = 4;
        ChunkGeneratorSettings chunkprovidersettings = null;
        if (!p_180781_3_.isEmpty()) {
            chunkprovidersettings = ChunkGeneratorSettings.Factory.func_177865_a((String)p_180781_3_).func_177864_b();
        }
        if (p_180781_2_ == WorldType.field_180271_f && !p_180781_3_.isEmpty()) {
            i = chunkprovidersettings.field_177780_G;
            j = chunkprovidersettings.field_177788_H;
        }
        if (p_180781_2_ == WorldType.field_77135_d) {
            i = 6;
        }
        i = ChunkManagerPlanet.getModdedBiomeSize(p_180781_2_, i);
        GenLayer lvt_8_1_ = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer4, (int)0);
        GenLayerRiverInit genlayerriverinit = new GenLayerRiverInit(100L, lvt_8_1_);
        GenLayer lvt_10_1_ = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        GenLayer genlayerbiomeedge = p_180781_2_.getBiomeLayer(seed, genlayer4, chunkprovidersettings);
        GenLayerHills genlayerhills = new GenLayerHills(1000L, genlayerbiomeedge, lvt_10_1_);
        GenLayer genlayer5 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        genlayer5 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer5, (int)j);
        GenLayerRiver genlayerriver = new GenLayerRiver(1L, genlayer5);
        GenLayerSmooth genlayersmooth = new GenLayerSmooth(1000L, (GenLayer)genlayerriver);
        genlayersmooth = new GenLayerSmooth(1000L, (GenLayer)genlayer);
        genlayerhills = new GenLayerRareBiome(1001L, (GenLayer)genlayerhills);
        for (int k = 0; k < i; ++k) {
            genlayerhills = new GenLayerZoom((long)(1000 + k), (GenLayer)genlayerhills);
            if (k == 0) {
                genlayerhills = new GenLayerAddIsland(3L, (GenLayer)genlayerhills);
            }
            if (k != 1 && i != 1) continue;
            genlayerhills = new GenLayerShore(1000L, (GenLayer)genlayerhills);
        }
        GenLayerSmooth genlayersmooth1 = new GenLayerSmooth(1000L, (GenLayer)genlayerhills);
        GenLayerRiverMix genlayerrivermix = hasRivers ? new GenLayerRiverMix(100L, (GenLayer)genlayersmooth1, (GenLayer)genlayersmooth) : new GenLayerRiverMix(100L, (GenLayer)genlayersmooth1, (GenLayer)genlayersmooth1);
        GenLayerVoronoiZoom genlayer3 = new GenLayerVoronoiZoom(10L, (GenLayer)genlayerrivermix);
        genlayerrivermix.func_75905_a(seed);
        genlayer3.func_75905_a(seed);
        GenLayerRiverMix finalOut = genlayerrivermix;
        return new GenLayer[]{finalOut, genlayer3, finalOut};
    }

    public static int getModdedBiomeSize(WorldType worldType, int original) {
        WorldTypeEvent.BiomeSize event = new WorldTypeEvent.BiomeSize(worldType, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.getNewSize();
    }

    @Nonnull
    public Biome[] func_76937_a(@Nullable Biome[] biomes, int x, int z, int width, int height) {
        GenLayerBiomePlanet.setupBiomesForUse(this.biomes);
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        int[] aint = this.genBiomes.func_75904_a(x, z, width, height);
        try {
            for (int i1 = 0; i1 < width * height; ++i1) {
                biomes[i1] = Biome.func_180276_a((int)aint[i1], (Biome)Biomes.field_76771_b);
            }
            return biomes;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
            crashreportcategory.func_71507_a("biomes[] size", (Object)biomes.length);
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("w", (Object)width);
            crashreportcategory.func_71507_a("h", (Object)height);
            throw new ReportedException(crashreport);
        }
    }

    public Biome[] loadBlockGeneratorData(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
        return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
    }

    public Biome getBiomeGenAt(int x, int z) {
        return this.biomeCache.func_180284_a(x, z, Biomes.field_76771_b);
    }

    @Nonnull
    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        GenLayerBiomePlanet.setupBiomesForUse(this.biomes);
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            Biome[] abiome = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(abiome, 0, listToReuse, 0, width * length);
        } else {
            int[] aint = this.biomeIndexLayer.func_75904_a(x, z, width, length);
            for (int i = 0; i < width * length; ++i) {
                listToReuse[i] = Biome.func_180276_a((int)aint[i], (Biome)Biomes.field_180279_ad);
            }
        }
        return listToReuse;
    }

    public void func_76938_b() {
        super.func_76938_b();
        this.biomeCache.func_76838_a();
    }
}

