/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.util.TerraformingHelper;
import zmaster587.advancedRocketry.util.TerraformingType;

public class chunkdata {
    public int x;
    public int z;
    public TerraformingType type;
    public boolean terrain_fully_generated;
    public boolean chunk_fully_generated;
    public boolean chunk_populated;
    public boolean chunk_fully_biomechanged;
    public boolean[][] fully_generated;
    public boolean[][] fully_decorated;
    public boolean[][] fully_biomechanged;
    public IBlockState[][][] blockStates;
    World world;
    TerraformingHelper helper;

    public chunkdata(int x, int z, IBlockState[][][] blockStates, World world, TerraformingHelper helper) {
        this.x = x;
        this.world = world;
        this.helper = helper;
        this.z = z;
        this.blockStates = blockStates;
        this.type = TerraformingType.ALLOWED;
        this.chunk_fully_generated = false;
        this.terrain_fully_generated = false;
        this.chunk_populated = false;
        this.fully_generated = new boolean[16][16];
        this.fully_decorated = new boolean[16][16];
        this.fully_biomechanged = new boolean[16][16];
    }

    public void set_position_fully_generated(int x, int z) {
        this.fully_generated[x][z] = true;
        boolean all_generated = true;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (this.fully_generated[i][j]) continue;
                all_generated = false;
            }
        }
        if (all_generated) {
            System.out.println("chunk fully generated: " + this.x + ":" + this.z);
            this.terrain_fully_generated = true;
            this.blockStates = null;
            this.helper.check_next_border_chunk_fully_generated(this.x, this.z);
            this.helper.check_can_decorate(this.x, this.z);
        }
    }

    public void set_position_biomechanged(int x, int z) {
        this.fully_biomechanged[x][z] = true;
        boolean all_generated = true;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (this.fully_biomechanged[i][j]) continue;
                all_generated = false;
            }
        }
        if (all_generated) {
            System.out.println("chunk fully biomechanged: " + this.x + ":" + this.z);
            this.chunk_fully_biomechanged = true;
            this.helper.set_chunk_biomechanged(new ChunkPos(this.x, this.z));
        }
    }

    public void populate_chunk_if_not_already_done() {
        if (!this.chunk_fully_generated && !this.chunk_populated) {
            this.world.field_73011_w.func_186060_c().func_185931_b(this.x, this.z);
            this.world.field_73011_w.func_186060_c().func_185931_b(this.x, this.z);
            System.out.println("populate chunk " + this.x + ":" + this.z);
            this.chunk_populated = true;
        }
    }

    public void set_position_decorated(int x, int z) {
        this.fully_decorated[x][z] = true;
        boolean all_decorated = true;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (this.fully_decorated[i][j]) continue;
                all_decorated = false;
            }
        }
        if (all_decorated) {
            this.helper.setChunkFullyGenerated(this.x, this.z);
        }
    }
}

