/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IFuelTank;
import zmaster587.advancedRocketry.api.IMiningDrill;
import zmaster587.advancedRocketry.api.IRocketEngine;
import zmaster587.advancedRocketry.api.IRocketNuclearCore;
import zmaster587.advancedRocketry.api.StatsRocket;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.stations.IStorageChunk;
import zmaster587.advancedRocketry.block.BlockBipropellantFuelTank;
import zmaster587.advancedRocketry.block.BlockBipropellantRocketMotor;
import zmaster587.advancedRocketry.block.BlockFuelTank;
import zmaster587.advancedRocketry.block.BlockLandingPad;
import zmaster587.advancedRocketry.block.BlockNuclearFuelTank;
import zmaster587.advancedRocketry.block.BlockNuclearRocketMotor;
import zmaster587.advancedRocketry.block.BlockOxidizerFuelTank;
import zmaster587.advancedRocketry.block.BlockRocketMotor;
import zmaster587.advancedRocketry.block.BlockSeat;
import zmaster587.advancedRocketry.item.ItemPackedStructure;
import zmaster587.advancedRocketry.tile.TileBrokenPart;
import zmaster587.advancedRocketry.tile.TileGuidanceComputer;
import zmaster587.advancedRocketry.tile.hatch.TileSatelliteHatch;
import zmaster587.advancedRocketry.util.IBreakable;
import zmaster587.advancedRocketry.util.IWeighted;
import zmaster587.advancedRocketry.util.WeightEngine;
import zmaster587.advancedRocketry.world.util.WorldDummy;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.Vector3F;
import zmaster587.libVulpes.util.ZUtils;

public class StorageChunk
implements IBlockAccess,
IStorageChunk,
IWeighted,
IBreakable {
    public Chunk chunk;
    public WorldDummy world;
    public boolean finalized = false;
    private Block[][][] blocks;
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    private short[][][] metas;
    private Map<BlockPos, TileEntity> pos2te = new HashMap<BlockPos, TileEntity>();
    private ArrayList<TileEntity> tileEntities;
    private ArrayList<TileEntity> inventoryTiles;
    private ArrayList<TileEntity> liquidTiles;
    private Entity entity;
    private float weight;
    private boolean hasServiceMonitor;

    public Block[][][] getblocks() {
        return this.blocks;
    }

    public boolean hasServiceMonitor() {
        return this.hasServiceMonitor;
    }

    public StorageChunk() {
        this.sizeX = 0;
        this.sizeY = 0;
        this.sizeZ = 0;
        this.tileEntities = new ArrayList();
        this.inventoryTiles = new ArrayList();
        this.liquidTiles = new ArrayList();
        this.world = new WorldDummy(AdvancedRocketry.proxy.getProfiler(), this);
        this.world.func_175643_b();
        this.chunk = new Chunk((World)this.world, 0, 0);
    }

    protected StorageChunk(int xSize, int ySize, int zSize) {
        this.blocks = new Block[xSize][ySize][zSize];
        this.metas = new short[xSize][ySize][zSize];
        this.sizeX = xSize;
        this.sizeY = ySize;
        this.sizeZ = zSize;
        this.tileEntities = new ArrayList();
        this.inventoryTiles = new ArrayList();
        this.liquidTiles = new ArrayList();
        this.world = new WorldDummy(AdvancedRocketry.proxy.getProfiler(), this);
        this.world.func_175643_b();
        this.chunk = new Chunk((World)this.world, 0, 0);
    }

    private static boolean isInventoryBlock(TileEntity tile) {
        return tile instanceof IInventory || tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP) && !(tile instanceof TileGuidanceComputer);
    }

    private static boolean isLiquidContainerBlock(TileEntity tile) {
        return tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public float getWeight() {
        return this.weight;
    }

    public float recalculateWeight() {
        this.weight = 0.0f;
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    Block block = this.blocks[x][y][z];
                    if (block == null) continue;
                    this.weight += WeightEngine.INSTANCE.getWeight(null, block);
                }
            }
        }
        for (TileEntity te : this.tileEntities) {
            this.weight += WeightEngine.INSTANCE.getTEWeight(te);
            if (!(te instanceof TileSatelliteHatch)) continue;
            TileSatelliteHatch hatch = (TileSatelliteHatch)te;
            if (hatch.getSatellite() != null) {
                this.weight += hatch.getSatellite().getProperties().getWeight();
                continue;
            }
            if (!(hatch.func_70301_a(0).func_77973_b() instanceof ItemPackedStructure)) continue;
            ItemPackedStructure struct = (ItemPackedStructure)hatch.func_70301_a(0).func_77973_b();
            this.weight += struct.getStructure(hatch.func_70301_a(0)).getWeight();
        }
        return this.weight;
    }

    public void recalculateStats(StatsRocket stats) {
        int thrustMonopropellant = 0;
        int thrustBipropellant = 0;
        int thrustNuclearNozzleLimit = 0;
        int thrustNuclearReactorLimit = 0;
        int thrustNuclearTotalLimit = 0;
        int monopropellantfuelUse = 0;
        int bipropellantfuelUse = 0;
        int nuclearWorkingFluidUseMax = 0;
        int fuelCapacityMonopropellant = 0;
        int fuelCapacityBipropellant = 0;
        int fuelCapacityOxidizer = 0;
        int fuelCapacityNuclearWorkingFluid = 0;
        float drillPower = 0.0f;
        stats.reset_no_fuel();
        float weight = 0.0f;
        for (int yCurr = 0; yCurr <= this.sizeY; ++yCurr) {
            for (int xCurr = 0; xCurr <= this.sizeX; ++xCurr) {
                for (int zCurr = 0; zCurr <= this.sizeZ; ++zCurr) {
                    TileEntity tile;
                    BlockPos currBlockPos = new BlockPos(xCurr, yCurr, zCurr);
                    BlockPos abovePos = new BlockPos(xCurr, yCurr + 1, zCurr);
                    BlockPos belowPos = new BlockPos(xCurr, yCurr - 1, zCurr);
                    if (this.func_180495_p(currBlockPos).func_177230_c() == Blocks.field_150350_a) continue;
                    IBlockState state = this.world.func_180495_p(currBlockPos);
                    Block block = state.func_177230_c();
                    weight = ARConfiguration.getCurrentConfig().advancedWeightSystem ? (weight += WeightEngine.INSTANCE.getWeight((World)this.world, currBlockPos)) : (weight += 1.0f);
                    if (block instanceof IRocketEngine && (this.world.func_180495_p(belowPos).func_177230_c().isAir(this.world.func_180495_p(belowPos), (IBlockAccess)this.world, belowPos) || this.world.func_180495_p(belowPos).func_177230_c() instanceof BlockLandingPad || this.world.func_180495_p(belowPos).func_177230_c() == AdvancedRocketryBlocks.blockLaunchpad)) {
                        if (block instanceof BlockNuclearRocketMotor) {
                            nuclearWorkingFluidUseMax += ((IRocketEngine)block).getFuelConsumptionRate(this.world, xCurr, yCurr, zCurr);
                            thrustNuclearNozzleLimit += ((IRocketEngine)block).getThrust(this.world, currBlockPos);
                        } else if (block instanceof BlockBipropellantRocketMotor) {
                            bipropellantfuelUse += ((IRocketEngine)block).getFuelConsumptionRate(this.world, xCurr, yCurr, zCurr);
                            thrustBipropellant += ((IRocketEngine)block).getThrust(this.world, currBlockPos);
                        } else if (block instanceof BlockRocketMotor) {
                            monopropellantfuelUse += ((IRocketEngine)block).getFuelConsumptionRate(this.world, xCurr, yCurr, zCurr);
                            thrustMonopropellant += ((IRocketEngine)block).getThrust(this.world, currBlockPos);
                        }
                        stats.addEngineLocation((float)xCurr - (float)this.sizeX / 2.0f + 0.5f, (float)yCurr + 0.5f, (float)zCurr - (float)this.sizeZ / 2.0f + 0.5f);
                    }
                    if (block instanceof IFuelTank) {
                        if (block instanceof BlockBipropellantFuelTank) {
                            fuelCapacityBipropellant = (int)((double)fuelCapacityBipropellant + (double)((IFuelTank)block).getMaxFill(this.world, currBlockPos, state) * ARConfiguration.getCurrentConfig().fuelCapacityMultiplier);
                        } else if (block instanceof BlockOxidizerFuelTank) {
                            fuelCapacityOxidizer = (int)((double)fuelCapacityOxidizer + (double)((IFuelTank)block).getMaxFill(this.world, currBlockPos, state) * ARConfiguration.getCurrentConfig().fuelCapacityMultiplier);
                        } else if (block instanceof BlockNuclearFuelTank) {
                            fuelCapacityNuclearWorkingFluid = (int)((double)fuelCapacityNuclearWorkingFluid + (double)((IFuelTank)block).getMaxFill(this.world, currBlockPos, state) * ARConfiguration.getCurrentConfig().fuelCapacityMultiplier);
                        } else if (block instanceof BlockFuelTank) {
                            fuelCapacityMonopropellant = (int)((double)fuelCapacityMonopropellant + (double)((IFuelTank)block).getMaxFill(this.world, currBlockPos, state) * ARConfiguration.getCurrentConfig().fuelCapacityMultiplier);
                        }
                    }
                    if (block instanceof IRocketNuclearCore && (this.world.func_180495_p(belowPos).func_177230_c() instanceof IRocketNuclearCore || this.world.func_180495_p(belowPos).func_177230_c() instanceof IRocketEngine)) {
                        thrustNuclearReactorLimit += ((IRocketNuclearCore)block).getMaxThrust(this.world, currBlockPos);
                    }
                    if (block instanceof BlockSeat && this.world.func_180495_p(abovePos).func_177230_c().func_176205_b((IBlockAccess)this.world, abovePos)) {
                        stats.addPassengerSeat((int)((float)xCurr - (float)this.sizeX / 2.0f + 0.5f), yCurr, (int)((float)zCurr - (float)this.sizeZ / 2.0f + 0.5f));
                    }
                    if (block instanceof IMiningDrill) {
                        drillPower += ((IMiningDrill)block).getMiningSpeed(this.world, currBlockPos);
                    }
                    if (block.func_149739_a().contains("servicemonitor")) {
                        this.hasServiceMonitor = true;
                    }
                    if (!((tile = this.world.func_175625_s(currBlockPos)) instanceof TileSatelliteHatch) || !ARConfiguration.getCurrentConfig().advancedWeightSystem) continue;
                    TileSatelliteHatch hatch = (TileSatelliteHatch)tile;
                    if (hatch.getSatellite() != null) {
                        weight += hatch.getSatellite().getProperties().getWeight();
                        continue;
                    }
                    if (!(hatch.func_70301_a(0).func_77973_b() instanceof ItemPackedStructure)) continue;
                    ItemPackedStructure struct = (ItemPackedStructure)hatch.func_70301_a(0).func_77973_b();
                    weight += struct.getStructure(hatch.func_70301_a(0)).getWeight();
                }
            }
        }
        int nuclearWorkingFluidUse = 0;
        if (thrustNuclearNozzleLimit > 0) {
            thrustNuclearTotalLimit = Math.min(thrustNuclearNozzleLimit, thrustNuclearReactorLimit);
            nuclearWorkingFluidUse = (int)((float)nuclearWorkingFluidUseMax * ((float)thrustNuclearTotalLimit / (float)thrustNuclearNozzleLimit));
            thrustNuclearTotalLimit = nuclearWorkingFluidUse * thrustNuclearNozzleLimit / nuclearWorkingFluidUseMax;
        }
        stats.setBaseFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, monopropellantfuelUse);
        stats.setBaseFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, bipropellantfuelUse);
        stats.setBaseFuelRate(FuelRegistry.FuelType.LIQUID_OXIDIZER, bipropellantfuelUse);
        stats.setBaseFuelRate(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID, nuclearWorkingFluidUse);
        stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, fuelCapacityMonopropellant);
        stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, fuelCapacityBipropellant);
        stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID_OXIDIZER, fuelCapacityOxidizer);
        stats.setFuelCapacity(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID, fuelCapacityNuclearWorkingFluid);
        stats.setWeight(weight);
        stats.setThrust(Math.max(Math.max(thrustMonopropellant, thrustBipropellant), thrustNuclearTotalLimit));
        stats.setDrillingPower(drillPower);
    }

    public void addTileEntity(TileEntity te) {
        this.pos2te.put(te.func_174877_v(), te);
        this.tileEntities.add(te);
    }

    public static StorageChunk copyWorldBB(World world, AxisAlignedBB bb) {
        int actualMinX = (int)bb.field_72336_d;
        int actualMinY = (int)bb.field_72337_e;
        int actualMinZ = (int)bb.field_72334_f;
        int actualMaxX = (int)bb.field_72340_a;
        int actualMaxY = (int)bb.field_72338_b;
        int actualMaxZ = (int)bb.field_72339_c;
        int x = (int)bb.field_72340_a;
        while ((double)x <= bb.field_72336_d) {
            int z = (int)bb.field_72339_c;
            while ((double)z <= bb.field_72334_f) {
                int y = (int)bb.field_72338_b;
                while ((double)y <= bb.field_72337_e) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (!block.isAir(world.func_180495_p(pos), (IBlockAccess)world, pos)) {
                        if (x < actualMinX) {
                            actualMinX = x;
                        }
                        if (y < actualMinY) {
                            actualMinY = y;
                        }
                        if (z < actualMinZ) {
                            actualMinZ = z;
                        }
                        if (x > actualMaxX) {
                            actualMaxX = x;
                        }
                        if (y > actualMaxY) {
                            actualMaxY = y;
                        }
                        if (z > actualMaxZ) {
                            actualMaxZ = z;
                        }
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        StorageChunk ret = new StorageChunk(actualMaxX - actualMinX + 1, actualMaxY - actualMinY + 1, actualMaxZ - actualMinZ + 1);
        float weight = 0.0f;
        for (int x2 = actualMinX; x2 <= actualMaxX; ++x2) {
            for (int z = actualMinZ; z <= actualMaxZ; ++z) {
                for (int y = actualMinY; y <= actualMaxY; ++y) {
                    TileEntity newTile;
                    TileEntity entity;
                    BlockPos pos = new BlockPos(x2, y, z);
                    weight += WeightEngine.INSTANCE.getWeight(world, pos);
                    IBlockState state = world.func_180495_p(pos);
                    ret.blocks[x2 - actualMinX][y - actualMinY][z - actualMinZ] = state.func_177230_c();
                    ret.metas[x2 - actualMinX][y - actualMinY][z - actualMinZ] = (short)state.func_177230_c().func_176201_c(state);
                    if (state.func_177230_c() == AdvancedRocketryBlocks.blockServiceMonitor) {
                        ret.hasServiceMonitor = true;
                    }
                    if ((entity = world.func_175625_s(pos)) == null) continue;
                    NBTTagCompound nbt = new NBTTagCompound();
                    entity.func_189515_b(nbt);
                    nbt.func_74768_a("x", nbt.func_74762_e("x") - actualMinX);
                    nbt.func_74768_a("y", nbt.func_74762_e("y") - actualMinY);
                    nbt.func_74768_a("z", nbt.func_74762_e("z") - actualMinZ);
                    if (nbt.func_74779_i("id").equals("minecraft:mod.chiselsandbits.tileentitychiseled")) {
                        nbt.func_74778_a("id", "minecraft:mod.chiselsandbits.tileentitychiseled.tesr");
                    }
                    if ((newTile = ZUtils.createTile((NBTTagCompound)nbt)) == null) continue;
                    newTile.func_145834_a((World)ret.world);
                    if (StorageChunk.isInventoryBlock(newTile)) {
                        ret.inventoryTiles.add(newTile);
                    }
                    if (StorageChunk.isLiquidContainerBlock(newTile)) {
                        ret.liquidTiles.add(newTile);
                    }
                    ret.addTileEntity(newTile);
                }
            }
        }
        ret.weight = weight;
        return ret;
    }

    public static StorageChunk cutWorldBB(World worldObj, AxisAlignedBB bb) {
        StorageChunk chunk = StorageChunk.copyWorldBB(worldObj, bb);
        int x = (int)bb.field_72340_a;
        while ((double)x <= bb.field_72336_d) {
            int z = (int)bb.field_72339_c;
            while ((double)z <= bb.field_72334_f) {
                int y = (int)bb.field_72338_b;
                while ((double)y <= bb.field_72337_e) {
                    BlockPos pos = new BlockPos(x, y, z);
                    TileEntity tile = worldObj.func_175625_s(pos);
                    if (tile instanceof IInventory) {
                        IInventory inv = (IInventory)tile;
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            inv.func_70299_a(i, ItemStack.field_190927_a);
                        }
                    }
                    worldObj.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        for (Entity entity : worldObj.func_72872_a(EntityItem.class, bb.func_72314_b(5.0, 5.0, 5.0))) {
            entity.func_70106_y();
        }
        return chunk;
    }

    public EntityRocketBase getEntity() {
        return (EntityRocketBase)this.entity;
    }

    public void setEntity(EntityRocketBase entity) {
        this.entity = entity;
    }

    @Override
    public int getSizeX() {
        return this.sizeX;
    }

    @Override
    public int getSizeY() {
        return this.sizeY;
    }

    @Override
    public int getSizeZ() {
        return this.sizeZ;
    }

    @Override
    public List<TileEntity> getTileEntityList() {
        return this.tileEntities;
    }

    public List<TileEntity> getFluidTiles() {
        return this.liquidTiles;
    }

    public List<TileEntity> getInventoryTiles() {
        return this.inventoryTiles;
    }

    public List<TileEntity> getGUITiles() {
        return new LinkedList<TileEntity>(this.inventoryTiles);
    }

    @Nonnull
    public IBlockState func_180495_p(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (x < 0 || x >= this.sizeX || y < 0 || y >= this.sizeY || z < 0 || z >= this.sizeZ || this.blocks[x][y][z] == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return this.blocks[x][y][z].func_176203_a((int)this.metas[x][y][z]);
    }

    public void setBlockState(BlockPos pos, IBlockState state) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.blocks[x][y][z] = state.func_177230_c();
        this.metas[x][y][z] = (short)state.func_177230_c().func_176201_c(state);
    }

    @Override
    public void rotateBy(EnumFacing dir) {
        HashedBlockPosition newSizes = new HashedBlockPosition(this.getSizeX(), this.getSizeY(), this.getSizeZ());
        HashedBlockPosition newerSize = this.remapCoord(newSizes, dir);
        newSizes = this.remapCoord(newSizes, dir);
        Block[][][] blocks = new Block[newSizes.x][newSizes.y][newSizes.z];
        short[][][] metas = new short[newSizes.x][newSizes.y][newSizes.z];
        for (int y = 0; y < this.getSizeY(); ++y) {
            for (int z = 0; z < this.getSizeZ(); ++z) {
                for (int x = 0; x < this.getSizeX(); ++x) {
                    newSizes = this.getNewCoord(new HashedBlockPosition(x, y, z), dir);
                    blocks[newSizes.x][newSizes.y][newSizes.z] = this.blocks[x][y][z];
                    metas[newSizes.x][newSizes.y][newSizes.z] = this.metas[x][y][z];
                }
            }
        }
        this.blocks = blocks;
        this.metas = metas;
        for (TileEntity e : this.tileEntities) {
            newSizes = this.getNewCoord(new HashedBlockPosition(e.func_174877_v()), dir);
            e.func_174878_a(newSizes.getBlockPos());
        }
        this.sizeX = newerSize.x;
        this.sizeY = newerSize.y;
        this.sizeZ = newerSize.z;
    }

    private HashedBlockPosition remapCoord(HashedBlockPosition in, EnumFacing dir) {
        HashedBlockPosition out = new HashedBlockPosition(0, 0, 0);
        switch (dir) {
            case DOWN: 
            case UP: {
                out.x = in.z;
                out.y = in.y;
                out.z = in.x;
                break;
            }
            case NORTH: 
            case SOUTH: {
                out.x = in.y;
                out.y = (short)in.x;
                out.z = in.z;
                break;
            }
            case EAST: 
            case WEST: {
                out.x = in.x;
                out.y = (short)in.z;
                out.z = in.y;
            }
        }
        return out;
    }

    public HashedBlockPosition getNewCoord(HashedBlockPosition in, EnumFacing dir) {
        HashedBlockPosition out = new HashedBlockPosition(0, 0, 0);
        switch (dir) {
            case DOWN: {
                out.x = in.z;
                out.y = in.y;
                out.z = this.getSizeX() - in.x - 1;
                break;
            }
            case UP: {
                out.x = this.getSizeZ() - in.z - 1;
                out.y = in.y;
                out.z = in.x;
                break;
            }
            case NORTH: {
                out.x = in.y;
                out.y = (short)(this.getSizeX() - in.x - 1);
                out.z = in.z;
                break;
            }
            case SOUTH: {
                out.x = this.getSizeY() - in.y - 1;
                out.y = (short)in.x;
                out.z = in.z;
                break;
            }
            case EAST: {
                out.x = in.x;
                out.y = (short)(this.getSizeZ() - in.z - 1);
                out.z = in.y;
                break;
            }
            case WEST: {
                out.x = in.x;
                out.y = (short)in.z;
                out.z = this.getSizeY() - in.y - 1;
            }
        }
        return out;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (this.world.field_72995_K) {
            return;
        }
        nbt.func_74768_a("xSize", this.sizeX);
        nbt.func_74768_a("ySize", this.sizeY);
        nbt.func_74768_a("zSize", this.sizeZ);
        nbt.func_74776_a("weight", this.weight);
        nbt.func_74757_a("hasServiceMonitor", this.hasServiceMonitor);
        Iterator<TileEntity> tileEntityIterator = this.tileEntities.iterator();
        NBTTagList tileList = new NBTTagList();
        while (tileEntityIterator.hasNext()) {
            TileEntity tile = tileEntityIterator.next();
            try {
                NBTTagCompound tileNbt = new NBTTagCompound();
                tile.func_189515_b(tileNbt);
                tileList.func_74742_a((NBTBase)tileNbt);
            }
            catch (RuntimeException e) {
                AdvancedRocketry.logger.warn("A tile entity has thrown an error: " + tile.getClass().getCanonicalName());
                this.blocks[tile.func_174877_v().func_177958_n()][tile.func_174877_v().func_177956_o()][tile.func_174877_v().func_177952_p()] = Blocks.field_150350_a;
                this.metas[tile.func_174877_v().func_177958_n()][tile.func_174877_v().func_177956_o()][tile.func_174877_v().func_177952_p()] = 0;
                tileEntityIterator.remove();
            }
        }
        int[] blockId = new int[this.sizeX * this.sizeY * this.sizeZ];
        int[] metasId = new int[this.sizeX * this.sizeY * this.sizeZ];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    blockId[z + this.sizeZ * y + this.sizeZ * this.sizeY * x] = Block.func_149682_b((Block)this.blocks[x][y][z]);
                    metasId[z + this.sizeZ * y + this.sizeZ * this.sizeY * x] = this.metas[x][y][z];
                }
            }
        }
        NBTTagIntArray idList = new NBTTagIntArray(blockId);
        NBTTagIntArray metaList = new NBTTagIntArray(metasId);
        nbt.func_74782_a("idList", (NBTBase)idList);
        nbt.func_74782_a("metaList", (NBTBase)metaList);
        nbt.func_74782_a("tiles", (NBTBase)tileList);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.sizeX = nbt.func_74762_e("xSize");
        this.sizeY = nbt.func_74762_e("ySize");
        this.sizeZ = nbt.func_74762_e("zSize");
        this.weight = nbt.func_74760_g("weight");
        this.hasServiceMonitor = nbt.func_74767_n("hasServiceMonitor");
        this.blocks = new Block[this.sizeX][this.sizeY][this.sizeZ];
        this.metas = new short[this.sizeX][this.sizeY][this.sizeZ];
        this.tileEntities.clear();
        this.inventoryTiles.clear();
        this.liquidTiles.clear();
        this.chunk = new Chunk((World)this.world, 0, 0);
        int[] blockId = nbt.func_74759_k("idList");
        int[] metasId = nbt.func_74759_k("metaList");
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    this.blocks[x][y][z] = Block.func_149729_e((int)blockId[z + this.sizeZ * y + this.sizeZ * this.sizeY * x]);
                    this.metas[x][y][z] = (short)metasId[z + this.sizeZ * y + this.sizeZ * this.sizeY * x];
                    this.chunk.func_177436_a(new BlockPos(x, y, z), this.blocks[x][y][z].func_176203_a((int)this.metas[x][y][z]));
                    this.world.func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(x, y, z));
                }
            }
        }
        NBTTagList tileList = nbt.func_150295_c("tiles", 10);
        for (int i = 0; i < tileList.func_74745_c(); ++i) {
            try {
                TileEntity tile = ZUtils.createTile((NBTTagCompound)tileList.func_150305_b(i));
                tile.func_145834_a((World)this.world);
                if (StorageChunk.isInventoryBlock(tile)) {
                    this.inventoryTiles.add(tile);
                }
                if (StorageChunk.isLiquidContainerBlock(tile)) {
                    this.liquidTiles.add(tile);
                }
                this.addTileEntity(tile);
                tile.func_145834_a((World)this.world);
                this.chunk.func_150813_a(tile);
                continue;
            }
            catch (Exception e) {
                AdvancedRocketry.logger.warn("Rocket missing Tile (was a mod removed?)");
            }
        }
        this.chunk.func_76603_b();
    }

    @Override
    public void pasteInWorld(World world, int xCoord, int yCoord, int zCoord) {
        for (int x = 0; x < this.sizeX; ++x) {
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int y = 0; y < this.sizeY; ++y) {
                    if (this.blocks[x][y][z] == Blocks.field_150350_a) continue;
                    world.func_180501_a(new BlockPos(xCoord + x, yCoord + y, zCoord + z), this.blocks[x][y][z].func_176203_a((int)this.metas[x][y][z]), 2);
                }
            }
        }
        for (TileEntity tile : this.tileEntities) {
            NBTTagCompound nbt = new NBTTagCompound();
            tile.func_189515_b(nbt);
            int x = nbt.func_74762_e("x");
            int y = nbt.func_74762_e("y");
            int z = nbt.func_74762_e("z");
            int tmpX = x + xCoord;
            int tmpY = y + yCoord;
            int tmpZ = z + zCoord;
            nbt.func_74768_a("x", tmpX);
            nbt.func_74768_a("y", tmpY);
            nbt.func_74768_a("z", tmpZ);
            TileEntity entity = world.func_175625_s(new BlockPos(tmpX, tmpY, tmpZ));
            if (entity == null) continue;
            entity.func_145839_a(nbt);
        }
    }

    public void damageParts() {
        for (TileEntity tile : this.tileEntities) {
            if (!(tile instanceof TileBrokenPart)) continue;
            ((TileBrokenPart)tile).transition();
        }
    }

    @Nullable
    public TileEntity func_175625_s(@Nonnull BlockPos pos) {
        return this.pos2te.getOrDefault(pos, null);
    }

    public boolean func_175623_d(BlockPos pos) {
        if (pos.func_177958_n() >= this.blocks.length || pos.func_177956_o() >= this.blocks[0].length || pos.func_177952_p() >= this.blocks[0][0].length) {
            return true;
        }
        return this.blocks[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()] == Blocks.field_150350_a;
    }

    @Nonnull
    public Biome func_180494_b(@Nullable BlockPos pos) {
        return Biomes.field_76771_b;
    }

    public boolean isSideSolid(BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (x < 0 || x >= this.sizeX || y < 0 || y >= this.sizeY || z < 0 || z >= this.sizeZ || x + side.func_82601_c() < 0 || x + side.func_82601_c() >= this.sizeX || y + side.func_96559_d() < 0 || y + side.func_96559_d() >= this.sizeY || z + side.func_82599_e() < 0 || z + side.func_82599_e() >= this.sizeZ) {
            return false;
        }
        return this.blocks[x + side.func_82601_c()][y + side.func_96559_d()][z + side.func_82599_e()].isSideSolid(this.blocks[x + side.func_82601_c()][y + side.func_96559_d()][z + side.func_82599_e()].func_176203_a((int)this.metas[x + side.func_82601_c()][y + side.func_96559_d()][z + side.func_82599_e()]), (IBlockAccess)this, pos.func_177972_a(side), side.func_176734_d());
    }

    public List<TileSatelliteHatch> getSatelliteHatches() {
        LinkedList<TileSatelliteHatch> satelliteHatches = new LinkedList<TileSatelliteHatch>();
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileSatelliteHatch)) continue;
            satelliteHatches.add((TileSatelliteHatch)tile);
        }
        return satelliteHatches;
    }

    @Deprecated
    public List<SatelliteBase> getSatellites() {
        LinkedList<SatelliteBase> satellites = new LinkedList<SatelliteBase>();
        LinkedList<TileSatelliteHatch> satelliteHatches = new LinkedList<TileSatelliteHatch>();
        for (TileEntity tileEntity : this.getTileEntityList()) {
            if (!(tileEntity instanceof TileSatelliteHatch)) continue;
            satelliteHatches.add((TileSatelliteHatch)tileEntity);
        }
        for (TileSatelliteHatch tileSatelliteHatch : satelliteHatches) {
            SatelliteBase satellite = tileSatelliteHatch.getSatellite();
            if (satellite == null) continue;
            satellites.add(satellite);
        }
        return satellites;
    }

    public TileGuidanceComputer getGuidanceComputer() {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            return (TileGuidanceComputer)tile;
        }
        return null;
    }

    @Override
    public float getBreakingProbability() {
        float prob = 0.0f;
        for (TileEntity te : this.tileEntities) {
            if (!(te instanceof TileBrokenPart)) continue;
            TileBrokenPart brokenPart = (TileBrokenPart)te;
            float additionalProb = 0.0f;
            if (te.func_145838_q() instanceof BlockNuclearRocketMotor) {
                additionalProb = 1.0f;
            } else if (te.func_145838_q() instanceof BlockRocketMotor || te.func_145838_q() instanceof BlockBipropellantRocketMotor) {
                additionalProb = 0.2f;
            }
            if (!((prob += additionalProb * (float)brokenPart.getStage() / 10.0f) >= 1.0f)) continue;
            return Math.min(1.0f, prob);
        }
        return prob;
    }

    public List<TileBrokenPart> getBrokenBlocks() {
        ArrayList<TileBrokenPart> res = new ArrayList<TileBrokenPart>();
        for (TileEntity te : this.tileEntities) {
            if (!(te instanceof TileBrokenPart)) continue;
            res.add((TileBrokenPart)te);
        }
        return res;
    }

    @Override
    public boolean shouldBreak() {
        return this.world.field_73012_v.nextFloat() < this.getBreakingProbability();
    }

    public int getDestinationDimId(int currentDimId, int x, int z) {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            return ((TileGuidanceComputer)tile).getDestinationDimId(currentDimId, new BlockPos(x, 0, z));
        }
        return -2147483647;
    }

    public Vector3F<Float> getDestinationCoordinates(int destDimID, boolean commit) {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            return ((TileGuidanceComputer)tile).getLandingLocation(destDimID, commit);
        }
        return null;
    }

    public String getDestinationName(int destDimID) {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            return ((TileGuidanceComputer)tile).getDestinationName(destDimID);
        }
        return "";
    }

    public void setDestinationCoordinates(Vector3F<Float> vec, int dimid) {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            ((TileGuidanceComputer)tile).setReturnPosition(vec, dimid);
        }
    }

    public void readtiles(ByteBuf in) {
        PacketBuffer buffer = new PacketBuffer(in);
        short numTiles = buffer.readShort();
        for (short i = 0; i < numTiles; i = (short)(i + 1)) {
            try {
                TileEntity t;
                int j;
                NBTTagCompound nbt = buffer.func_150793_b();
                TileEntity tile = ZUtils.createTile((NBTTagCompound)nbt);
                BlockPos tilepos = tile.func_174877_v();
                for (j = 0; j < this.tileEntities.size(); ++j) {
                    t = this.tileEntities.get(j);
                    if (!t.func_174877_v().equals((Object)tilepos)) continue;
                    t.func_145839_a(nbt);
                }
                if (StorageChunk.isInventoryBlock(tile)) {
                    for (j = 0; j < this.inventoryTiles.size(); ++j) {
                        t = this.inventoryTiles.get(j);
                        if (!t.func_174877_v().equals((Object)tilepos)) continue;
                        t.func_145839_a(nbt);
                    }
                }
                if (!StorageChunk.isLiquidContainerBlock(tile)) continue;
                for (j = 0; j < this.liquidTiles.size(); ++j) {
                    t = this.liquidTiles.get(j);
                    if (!t.func_174877_v().equals((Object)tilepos)) continue;
                    t.func_145839_a(nbt);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void writetiles(ByteBuf out) {
        PacketBuffer buffer = new PacketBuffer(out);
        buffer.writeShort(this.tileEntities.size());
        Iterator<TileEntity> tileIterator = this.tileEntities.iterator();
        while (tileIterator.hasNext()) {
            TileEntity tile = tileIterator.next();
            NBTTagCompound nbt = new NBTTagCompound();
            try {
                tile.func_189515_b(nbt);
                try {
                    buffer.func_150786_a(nbt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (RuntimeException e) {
                AdvancedRocketry.logger.warn("A tile entity has thrown an error while writing to network: " + tile.getClass().getCanonicalName());
                tileIterator.remove();
            }
        }
    }

    public void writeToNetwork(ByteBuf out) {
        if (DimensionManager.getWorld((int)0).field_72995_K) {
            System.out.println("This should have never been called!");
        }
        PacketBuffer buffer = new PacketBuffer(out);
        buffer.writeByte(this.sizeX);
        buffer.writeByte(this.sizeY);
        buffer.writeByte(this.sizeZ);
        buffer.writeShort(this.tileEntities.size());
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    buffer.writeInt(Block.func_149682_b((Block)this.blocks[x][y][z]));
                    buffer.writeShort((int)this.metas[x][y][z]);
                }
            }
        }
        Iterator<TileEntity> tileIterator = this.tileEntities.iterator();
        while (tileIterator.hasNext()) {
            TileEntity tile = tileIterator.next();
            NBTTagCompound nbt = new NBTTagCompound();
            try {
                tile.func_189515_b(nbt);
                try {
                    buffer.func_150786_a(nbt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (RuntimeException e) {
                AdvancedRocketry.logger.warn("A tile entity has thrown an error while writing to network: " + tile.getClass().getCanonicalName());
                tileIterator.remove();
            }
        }
        buffer.writeBoolean(this.hasServiceMonitor);
    }

    public void readFromNetwork(ByteBuf in) {
        this.finalized = false;
        PacketBuffer buffer = new PacketBuffer(in);
        this.sizeX = buffer.readByte();
        this.sizeY = buffer.readByte();
        this.sizeZ = buffer.readByte();
        short numTiles = buffer.readShort();
        this.blocks = new Block[this.sizeX][this.sizeY][this.sizeZ];
        this.metas = new short[this.sizeX][this.sizeY][this.sizeZ];
        this.chunk = new Chunk((World)this.world, 0, 0);
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    this.blocks[x][y][z] = Block.func_149729_e((int)buffer.readInt());
                    this.metas[x][y][z] = buffer.readShort();
                    this.chunk.func_177436_a(new BlockPos(x, y, z), this.blocks[x][y][z].func_176203_a((int)this.metas[x][y][z]));
                    this.world.func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(x, y, z));
                }
            }
        }
        for (short i = 0; i < numTiles; i = (short)(i + 1)) {
            try {
                NBTTagCompound nbt = buffer.func_150793_b();
                TileEntity tile = ZUtils.createTile((NBTTagCompound)nbt);
                tile.func_145834_a((World)this.world);
                this.addTileEntity(tile);
                if (StorageChunk.isInventoryBlock(tile)) {
                    this.inventoryTiles.add(tile);
                }
                if (StorageChunk.isLiquidContainerBlock(tile)) {
                    this.liquidTiles.add(tile);
                }
                this.chunk.func_150813_a(tile);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.hasServiceMonitor = buffer.readBoolean();
        this.chunk.func_76603_b();
        this.finalized = true;
    }

    public int func_175626_b(@Nullable BlockPos pos, int lightValue) {
        return lightValue;
    }

    public int func_175627_a(@Nullable BlockPos pos, @Nullable EnumFacing direction) {
        return 0;
    }

    @Nonnull
    public WorldType func_175624_G() {
        return WorldType.field_180271_f;
    }
}

