/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import zmaster587.advancedRocketry.dimension.DimensionProperties;

public class OreGenProperties {
    private static OreGenProperties[][] oreGenPropertyMap = new OreGenProperties[DimensionProperties.AtmosphereTypes.values().length][DimensionProperties.Temps.values().length];
    private List<OreEntry> oreEntries = new LinkedList<OreEntry>();

    public static void setOresForTemperature(DimensionProperties.Temps temp, OreGenProperties properties) {
        for (int i = 0; i < DimensionProperties.AtmosphereTypes.values().length; ++i) {
            OreGenProperties.oreGenPropertyMap[i][temp.ordinal()] = properties;
        }
    }

    public static void setOresForPressure(DimensionProperties.AtmosphereTypes atmType, OreGenProperties properties) {
        for (int i = 0; i < DimensionProperties.Temps.values().length; ++i) {
            OreGenProperties.oreGenPropertyMap[atmType.ordinal()][i] = properties;
        }
    }

    public static void setOresForPressureAndTemp(DimensionProperties.AtmosphereTypes atmType, DimensionProperties.Temps temp, OreGenProperties properties) {
        OreGenProperties.oreGenPropertyMap[atmType.ordinal()][temp.ordinal()] = properties;
    }

    public static OreGenProperties getOresForPressure(DimensionProperties.AtmosphereTypes atmType, DimensionProperties.Temps temp) {
        return oreGenPropertyMap[atmType.ordinal()][temp.ordinal()];
    }

    public void addEntry(IBlockState state, int minHeight, int maxHeight, int clumpSize, int chancePerChunk) {
        this.oreEntries.add(new OreEntry(state, minHeight, maxHeight, clumpSize, chancePerChunk));
    }

    public List<OreEntry> getOreEntries() {
        return this.oreEntries;
    }

    public static class OreEntry {
        int minHeight;
        int maxHeight;
        int clumpSize;
        int chancePerChunk;
        private IBlockState state;

        public OreEntry(IBlockState state, int minHeight, int maxHeight, int clumpSize, int chancePerChunk) {
            this.state = state;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
            this.clumpSize = clumpSize;
            this.chancePerChunk = chancePerChunk;
        }

        public IBlockState getBlockState() {
            return this.state;
        }

        public int getMinHeight() {
            return this.minHeight;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }

        public int getClumpSize() {
            return this.clumpSize;
        }

        public int getChancePerChunk() {
            return this.chancePerChunk;
        }
    }
}

