/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.network.PacketBiomeIDChange;
import zmaster587.advancedRocketry.util.TerraformingType;
import zmaster587.advancedRocketry.util.chunkdata;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;

public class BiomeHandler {
    public static void decorate_simple(World world, Biome biomeId, Biome old_biome, BlockPos pos) {
        BlockPos yy = world.func_175645_m(pos);
        while (!world.func_180495_p(yy.func_177977_b()).func_185914_p() && yy.func_177956_o() > 0) {
            yy = yy.func_177977_b();
        }
        if (old_biome.field_76752_A != biomeId.field_76752_A && world.func_180495_p(yy.func_177977_b()) == old_biome.field_76752_A) {
            world.func_175656_a(yy.func_177977_b(), biomeId.field_76752_A);
        }
        BiomeHandler.decorateBiome(world, yy, biomeId);
    }

    public static void changeBiome(World world, Biome biomeId, Biome old_biome, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        if (old_biome != biomeId) {
            byte[] biomeArr = chunk.func_76605_m();
            try {
                biomeArr[(pos.func_177958_n() & 0xF) + (pos.func_177952_p() & 0xF) * 16] = (byte)Biome.func_185362_a((Biome)biomeId);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
    }

    public static int get_height_blocks_only(IBlockState[] blocks) {
        int h;
        for (h = blocks.length - 1; h > 0 && !blocks[h].func_185914_p(); --h) {
        }
        return h;
    }

    public static int get_height_blocks_only(World world, BlockPos pos) {
        BlockPos yy = world.func_175645_m(pos);
        while (!world.func_180495_p(yy).func_185914_p() && yy.func_177956_o() > 0) {
            yy = yy.func_177977_b();
        }
        return yy.func_177956_o();
    }

    public static void do_heavy_terraforming(World world, Biome biomeId, Biome old_biome, BlockPos pos, int dimId) {
        int inchunkx = (pos.func_177958_n() % 16 + 16) % 16;
        int inchunkz = (pos.func_177952_p() % 16 + 16) % 16;
        long startTime = System.currentTimeMillis();
        DimensionProperties props = DimensionManager.getInstance().getDimensionProperties(dimId);
        ChunkPos cpos = DimensionProperties.proxylists.gethelper(props.getId()).getChunkPosFromBlockPos(pos);
        IBlockState[] target_blocks = DimensionProperties.proxylists.gethelper(props.getId()).getBlocksAt(pos.func_177958_n(), pos.func_177952_p());
        chunkdata data = DimensionProperties.proxylists.gethelper(props.getId()).getChunkFromList(cpos.field_77276_a, cpos.field_77275_b);
        if (data.type == TerraformingType.PROTECTED) {
            BiomeHandler.decorate_simple(world, biomeId, old_biome, pos);
            DimensionProperties.proxylists.gethelper(props.getId()).getChunkFromList(cpos.field_77276_a, cpos.field_77275_b).set_position_fully_generated(inchunkx, inchunkz);
            DimensionProperties.proxylists.gethelper(props.getId()).register_height_change(pos);
        } else if (data.type == TerraformingType.ALLOWED) {
            if (!data.fully_generated[inchunkx][inchunkz]) {
                int i;
                int target_height = 255;
                for (int i2 = 255; i2 >= 0; --i2) {
                    if (target_blocks[i2].equals(Blocks.field_150350_a.func_176223_P())) continue;
                    target_height = i2;
                    break;
                }
                int current_world_height = world.func_189649_b(pos.func_177958_n(), pos.func_177952_p());
                int y_per_iteration = 3;
                int blocks_replaced = 0;
                for (i = 0; i < 255 && i <= target_height && blocks_replaced < y_per_iteration; ++i) {
                    if (world.func_180495_p(new BlockPos(pos.func_177958_n(), i, pos.func_177952_p())).equals(target_blocks[i])) continue;
                    world.func_180501_a(new BlockPos(pos.func_177958_n(), i, pos.func_177952_p()), target_blocks[i], 2);
                    if (i < current_world_height) continue;
                    ++blocks_replaced;
                }
                for (i = 255; i >= 0 && i > target_height && blocks_replaced < y_per_iteration; --i) {
                    if (world.func_180495_p(new BlockPos(pos.func_177958_n(), i, pos.func_177952_p())).equals(target_blocks[i])) continue;
                    world.func_180501_a(new BlockPos(pos.func_177958_n(), i, pos.func_177952_p()), target_blocks[i], 2);
                    ++blocks_replaced;
                }
                if (BiomeHandler.get_height_blocks_only(world, pos) == BiomeHandler.get_height_blocks_only(target_blocks)) {
                    DimensionProperties.proxylists.gethelper(props.getId()).getChunkFromList(cpos.field_77276_a, cpos.field_77275_b).set_position_fully_generated(inchunkx, inchunkz);
                } else {
                    DimensionProperties.proxylists.gethelper(props.getId()).add_position_to_queue(pos);
                    DimensionProperties.proxylists.gethelper(props.getId()).register_height_change(pos);
                    world.func_175656_a(world.func_175645_m(pos).func_177977_b(), biomeId.field_76752_A);
                }
            }
        } else if (data.type == TerraformingType.BORDER) {
            BlockPos yy = world.func_175645_m(pos);
            while (!world.func_180495_p(yy.func_177977_b()).func_185914_p() && yy.func_177956_o() > 0) {
                yy = yy.func_177977_b();
            }
            if (old_biome.field_76752_A != biomeId.field_76752_A && world.func_180495_p(yy.func_177977_b()) == old_biome.field_76752_A) {
                world.func_175656_a(yy.func_177977_b(), biomeId.field_76752_A);
            }
            if (target_blocks != null) {
                int prev_height;
                int filter_size = 5;
                world.func_175726_f(pos.func_177982_a(-filter_size, 0, 0));
                world.func_175726_f(pos.func_177982_a(filter_size, 0, 0));
                world.func_175726_f(pos.func_177982_a(0, 0, -filter_size));
                world.func_175726_f(pos.func_177982_a(0, 0, filter_size));
                float heightsum = 0.0f;
                float num_samples = 0.0f;
                for (int x = -filter_size; x <= filter_size; ++x) {
                    for (int z = -filter_size; z <= filter_size; ++z) {
                        float w = 1.0f / (0.2f + (float)(x * x) + (float)(z * z));
                        heightsum += (float)BiomeHandler.get_height_blocks_only(world, pos.func_177982_a(x, 0, z)) * w;
                        num_samples += 1.0f * w;
                    }
                }
                int avg_height = Math.round(heightsum / num_samples);
                if (avg_height == (prev_height = BiomeHandler.get_height_blocks_only(world, pos))) {
                    return;
                }
                avg_height = Math.max(props.getSeaLevel(), avg_height);
                for (int i = 0; i < 256; ++i) {
                    IBlockState target = target_blocks[i];
                    if (i < avg_height && target == Blocks.field_150350_a.func_176223_P()) {
                        target = biomeId.field_76752_A;
                    }
                    if (i == avg_height) {
                        target = biomeId.field_76752_A;
                    }
                    if (i > avg_height) {
                        target = Blocks.field_150350_a.func_176223_P();
                    }
                    world.func_180501_a(new BlockPos(pos.func_177958_n(), i, pos.func_177952_p()), target, 2);
                }
                int new_height = BiomeHandler.get_height_blocks_only(world, pos);
                if (prev_height != new_height) {
                    DimensionProperties.proxylists.gethelper(props.getId()).register_height_change(pos);
                    DimensionProperties.proxylists.gethelper(props.getId()).add_position_to_queue(pos);
                } else {
                    DimensionProperties.proxylists.gethelper(props.getId()).check_next_border_chunk_fully_generated(cpos.field_77276_a, cpos.field_77275_b);
                }
            } else {
                DimensionProperties.proxylists.gethelper(props.getId()).check_next_border_chunk_fully_generated(cpos.field_77276_a, cpos.field_77275_b);
            }
        }
    }

    public static void do_decoration(World world, BlockPos pos, int dimId) {
        Biome biomeId = world.func_180494_b(pos);
        int inchunkx = (pos.func_177958_n() % 16 + 16) % 16;
        int inchunkz = (pos.func_177952_p() % 16 + 16) % 16;
        DimensionProperties props = DimensionManager.getInstance().getDimensionProperties(dimId);
        ChunkPos cpos = DimensionProperties.proxylists.gethelper(props.getId()).getChunkPosFromBlockPos(pos);
        int can_populate = DimensionProperties.proxylists.gethelper(props.getId()).can_populate(cpos.field_77276_a, cpos.field_77275_b);
        if (can_populate == -1) {
            DimensionProperties.proxylists.gethelper(props.getId()).getChunkFromList(cpos.field_77276_a, cpos.field_77275_b).set_position_decorated(inchunkx, inchunkz);
        }
        if (can_populate == 1 && !DimensionProperties.proxylists.gethelper((int)props.getId()).getChunkFromList((int)cpos.field_77276_a, (int)cpos.field_77275_b).fully_decorated[inchunkx][inchunkz]) {
            int treegen = biomeId.field_76760_I.field_76832_z;
            if (world.field_73012_v.nextInt(256) < treegen) {
                biomeId.func_150567_a(world.field_73012_v).func_180709_b(world, world.field_73012_v, world.func_175645_m(pos.func_177982_a(8, 0, 8)));
            }
            BlockPos yy = world.func_175645_m(pos);
            while (!world.func_180495_p(yy.func_177977_b()).func_185914_p() && yy.func_177956_o() > 0) {
                yy = yy.func_177977_b();
            }
            BiomeHandler.decorateBiome(world, yy, biomeId);
            DimensionProperties.proxylists.gethelper(props.getId()).getChunkFromList(cpos.field_77276_a, cpos.field_77275_b).set_position_decorated(inchunkx, inchunkz);
        }
    }

    public static void terraform_biomes(World world, Biome biomeId, BlockPos pos, int dimId) {
        Biome old_biome = world.func_180494_b(pos);
        BiomeHandler.changeBiome(world, biomeId, old_biome, pos);
        BiomeHandler.decorate_simple(world, biomeId, old_biome, pos);
        DimensionProperties props = DimensionManager.getInstance().getDimensionProperties(dimId);
        ChunkPos cpos = DimensionProperties.proxylists.gethelper(props.getId()).getChunkPosFromBlockPos(pos);
        chunkdata data = DimensionProperties.proxylists.gethelper(props.getId()).getChunkFromList(cpos.field_77276_a, cpos.field_77275_b);
        int inchunkx = (pos.func_177958_n() % 16 + 16) % 16;
        int inchunkz = (pos.func_177952_p() % 16 + 16) % 16;
        if (data == null) {
            DimensionProperties.proxylists.gethelper(props.getId()).generate_new_chunkdata(new ChunkPos(cpos.field_77276_a, cpos.field_77275_b));
            data = DimensionProperties.proxylists.gethelper(props.getId()).getChunkFromList(cpos.field_77276_a, cpos.field_77275_b);
        }
        data.set_position_biomechanged(inchunkx, inchunkz);
        Chunk chunk = world.func_175726_f(pos);
        PacketHandler.sendToNearby((BasePacket)new PacketBiomeIDChange(chunk, world, new HashedBlockPosition(pos)), (int)world.field_73011_w.getDimension(), (BlockPos)pos, (double)1024.0);
    }

    public static void terraform(World world, Biome biomeId, BlockPos pos, boolean was_biome_remote, int dimId) {
        Chunk chunk = world.func_175726_f(pos);
        if (biomeId == null) {
            return;
        }
        Biome old_biome = world.func_180494_b(pos);
        if (was_biome_remote) {
            BiomeHandler.changeBiome(world, biomeId, old_biome, pos);
            BiomeHandler.decorate_simple(world, biomeId, old_biome, pos);
            PacketHandler.sendToNearby((BasePacket)new PacketBiomeIDChange(chunk, world, new HashedBlockPosition(pos)), (int)world.field_73011_w.getDimension(), (BlockPos)pos, (double)1024.0);
        }
        if (!was_biome_remote) {
            BiomeHandler.do_heavy_terraforming(world, biomeId, old_biome, pos, dimId);
        }
    }

    private static void spawn_decoration_block(World world, BlockPos pos, IBlockState state, int p) {
        if (p < 0) {
            System.out.println("p should not be negative!!");
            return;
        }
        if (world.field_73012_v.nextInt(p) == 0 && world.func_175623_d(pos) && state.func_177230_c().func_176196_c(world, pos)) {
            world.func_175656_a(pos, state);
        }
    }

    private static void decorateBiome(World world, BlockPos pos, Biome biome) {
        Random rand = world.field_73012_v;
        BiomeDecorator decorator = biome.field_76760_I;
        int chunksize = 256;
        Block block_above_biome_topblock = world.func_180495_p(pos).func_177230_c();
        if (block_above_biome_topblock instanceof BlockTallGrass || block_above_biome_topblock instanceof BlockFlower || block_above_biome_topblock instanceof BlockCactus || block_above_biome_topblock instanceof BlockMushroom) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        IBlockState deadbush = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.DEAD_BUSH);
        IBlockState grass = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
        IBlockState fern = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN);
        if (decorator.field_76802_A > 0) {
            BiomeHandler.spawn_decoration_block(world, pos, biome.func_180623_a(rand, pos).func_176964_a().func_180346_a().func_176223_P(), chunksize / decorator.field_76802_A);
        }
        if (decorator.field_76804_C > 0) {
            BiomeHandler.spawn_decoration_block(world, pos, deadbush, chunksize / decorator.field_76804_C);
        }
        if (decorator.field_76803_B > 0) {
            int grass_rate = chunksize / decorator.field_76803_B;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
                BiomeHandler.spawn_decoration_block(world, pos, fern, grass_rate / 2);
                BiomeHandler.spawn_decoration_block(world, pos, grass, grass_rate / 2);
            } else {
                BiomeHandler.spawn_decoration_block(world, pos, fern, (int)((double)grass_rate / 0.2));
                BiomeHandler.spawn_decoration_block(world, pos, grass, (int)((double)grass_rate / 0.8));
            }
        }
        if (decorator.field_76798_D > 0) {
            IBlockState mushroom_b = Blocks.field_150338_P.func_176223_P();
            IBlockState mushroom_r = Blocks.field_150337_Q.func_176223_P();
            BiomeHandler.spawn_decoration_block(world, pos, mushroom_b, chunksize / decorator.field_76798_D / 2);
            BiomeHandler.spawn_decoration_block(world, pos, mushroom_r, chunksize / decorator.field_76798_D / 2);
        }
        if (decorator.field_76800_F > 0) {
            IBlockState cactus = Blocks.field_150434_aF.func_176223_P();
            BiomeHandler.spawn_decoration_block(world, pos, cactus, chunksize / decorator.field_76800_F);
        }
    }
}

