/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.station;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.network.PacketStationUpdate;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.world.provider.WorldProviderSpace;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ISliderBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.inventory.modules.ModuleSlider;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.IComparatorOverride;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileStationGravityController
extends TileEntity
implements IModularInventory,
ITickable,
INetworkMachine,
ISliderBar,
IButtonInventory,
IComparatorOverride {
    private static int minGravity = 10;
    private int progress;
    private ZUtils.RedstoneState state = ZUtils.RedstoneState.OFF;
    private ModuleText moduleGrav = new ModuleText(6, 15, LibVulpes.proxy.getLocalizedString("msg.stationgravctrl.alt"), 0xAA2020);
    private ModuleText maxGravBuildSpeed = new ModuleText(6, 25, LibVulpes.proxy.getLocalizedString("msg.stationgravctrl.maxaltrate"), 0xAA2020);
    private ModuleText targetGrav = new ModuleText(6, 35, LibVulpes.proxy.getLocalizedString("msg.stationgravctrl.tgtalt"), 0x202020);
    private ModuleRedstoneOutputButton redstoneControl = new ModuleRedstoneOutputButton(174, 4, -1, "", (IButtonInventory)this);

    public TileStationGravityController() {
        minGravity = ARConfiguration.getCurrentConfig().allowZeroGSpacestations ? 0 : 10;
    }

    public static int getMinGravity() {
        return minGravity;
    }

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)this.moduleGrav);
        modules.add((ModuleBase)this.maxGravBuildSpeed);
        modules.add((ModuleBase)this.redstoneControl);
        modules.add((ModuleBase)this.targetGrav);
        modules.add((ModuleBase)new ModuleSlider(6, 60, 0, TextureResources.doubleWarningSideBarIndicator, (ISliderBar)this));
        this.updateText();
        return modules;
    }

    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId != -1) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(buttonId + 100)));
        } else {
            this.state = this.redstoneControl.getState();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 2));
            this.func_70296_d();
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = this.func_189515_b(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    private void updateText() {
        ISpaceObject spaceObject;
        if (this.field_145850_b.field_72995_K && (spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)) != null) {
            this.moduleGrav.setText(String.format("%s%.2f", LibVulpes.proxy.getLocalizedString("msg.stationgravctrl.alt"), Float.valueOf(spaceObject.getProperties().getGravitationalMultiplier())));
            this.maxGravBuildSpeed.setText(String.format("%s%.1f", LibVulpes.proxy.getLocalizedString("msg.stationgravctrl.maxaltrate"), 7200.0 * spaceObject.getMaxRotationalAcceleration()));
            this.targetGrav.setText(String.format("%s%d", LibVulpes.proxy.getLocalizedString("msg.stationgravctrl.tgtalt"), ((SpaceStationObject)spaceObject).targetGravity));
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_73011_w instanceof WorldProviderSpace) {
            if (!this.field_145850_b.field_72995_K) {
                ISpaceObject spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c);
                if (spaceObject != null) {
                    if (this.redstoneControl.getState() == ZUtils.RedstoneState.ON) {
                        ((SpaceStationObject)spaceObject).targetGravity = this.field_145850_b.func_175676_y(this.field_174879_c) * 6 + 10;
                    } else if (this.redstoneControl.getState() == ZUtils.RedstoneState.INVERTED) {
                        ((SpaceStationObject)spaceObject).targetGravity = Math.abs(15 - this.field_145850_b.func_175676_y(this.field_174879_c)) * 6 + 10;
                    }
                    this.progress = ((SpaceStationObject)spaceObject).targetGravity - minGravity;
                    int targetMultiplier = ARConfiguration.getCurrentConfig().allowZeroGSpacestations ? ((SpaceStationObject)spaceObject).targetGravity : Math.max(10, ((SpaceStationObject)spaceObject).targetGravity);
                    double targetGravity = (double)targetMultiplier / 100.0;
                    double angVel = spaceObject.getProperties().getGravitationalMultiplier();
                    double acc = 0.001;
                    double difference = targetGravity - angVel;
                    if (Math.abs(difference) >= 0.001) {
                        double finalVel = angVel;
                        if (difference < 0.0) {
                            finalVel = angVel + Math.max(difference, -acc);
                        } else if (difference > 0.0) {
                            finalVel = angVel + Math.min(difference, acc);
                        }
                        spaceObject.getProperties().setGravitationalMultiplier((float)finalVel);
                        if (!this.field_145850_b.field_72995_K) {
                            PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(spaceObject, PacketStationUpdate.Type.DIM_PROPERTY_UPDATE));
                            this.func_70296_d();
                        } else {
                            this.updateText();
                        }
                    }
                }
            } else {
                this.updateText();
            }
        }
    }

    public String getModularInventoryName() {
        return AdvancedRocketryBlocks.blockGravityController.func_149732_F();
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 0) {
            out.writeShort(this.progress);
        } else if (id == 2) {
            out.writeByte(this.state.ordinal());
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 0) {
            this.setProgress(0, in.readShort());
        } else if (packetId == 2) {
            nbt.func_74774_a("state", in.readByte());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 2) {
            this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
            this.redstoneControl.setRedstoneState(this.state);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("redstoneState", (byte)this.state.ordinal());
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(this.state);
    }

    public float getNormallizedProgress(int id) {
        return (float)this.getProgress(0) / (float)this.getTotalProgress(0);
    }

    public void setProgress(int id, int progress) {
        this.progress = progress;
        if (SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c) != null) {
            ((SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords((BlockPos)this.field_174879_c)).targetGravity = progress + minGravity;
        }
    }

    public int getProgress(int id) {
        return this.progress;
    }

    public int getTotalProgress(int id) {
        return 100 - minGravity;
    }

    public void setTotalProgress(int id, int progress) {
    }

    public int getComparatorOverride() {
        ISpaceObject spaceObject;
        if (this.field_145850_b.field_73011_w instanceof WorldProviderSpace && !this.field_145850_b.field_72995_K && (spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)) != null) {
            return (int)(((double)((SpaceStationObject)spaceObject).getProperties().getGravitationalMultiplier() - 0.1) / 0.059);
        }
        return 0;
    }

    public void setProgressByUser(int id, int progress) {
        this.setProgress(id, progress);
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }
}

