/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.satellite;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.item.ItemOreScanner;
import zmaster587.advancedRocketry.item.ItemPlanetIdentificationChip;
import zmaster587.advancedRocketry.item.ItemSatellite;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.advancedRocketry.item.ItemStationChip;
import zmaster587.advancedRocketry.util.WeightEngine;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleOutputSlotArray;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleTexturedLimitedSlotArray;
import zmaster587.libVulpes.inventory.modules.ModuleTexturedSlotArray;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerConsumer;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileSatelliteBuilder
extends TileMultiPowerConsumer
implements IModularInventory,
IInventory,
IButtonInventory {
    public static final Object[][][] structure = new Object[][][]{{{Character.valueOf('c')}}, {{Character.valueOf('P')}}};
    private static final byte primaryFunctionSlot = 0;
    private static final byte modularFunctionSlotStart = 1;
    private static final byte modularFunctionSlotEnd = 6;
    private static final byte outputSlot = 7;
    private static final byte chipSlot = 8;
    private static final byte chipCopySlot = 9;
    private static final byte holdingSlot = 10;
    private static final byte chassisSlot = 11;
    EmbeddedInventory inventory = new EmbeddedInventory(5);

    public TileSatelliteBuilder() {
        this.powerPerTick = 10;
    }

    public Object[][][] getStructure() {
        return structure;
    }

    protected void processComplete() {
        super.processComplete();
        this.func_70299_a(7, this.func_70304_b(10));
    }

    public boolean canAssembleSatellite() {
        if (this.func_70301_a(11).func_190926_b()) {
            return false;
        }
        boolean hasPowerGeneration = false;
        for (int i = 0; i <= 6; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b() || SatelliteRegistry.getSatelliteProperty(stack) == null || SatelliteRegistry.getSatelliteProperty(stack).getPropertyFlag() != SatelliteProperties.Property.POWER_GEN.getFlag() || SatelliteRegistry.getSatelliteProperty(stack).getPowerGeneration() <= 0) continue;
            hasPowerGeneration = true;
        }
        if (this.func_70301_a(0).func_190926_b() || SatelliteRegistry.getSatelliteProperty(this.func_70301_a(0)) == null || !hasPowerGeneration) {
            return false;
        }
        if (!this.func_70301_a(10).func_190926_b() || !this.func_70301_a(7).func_190926_b()) {
            return false;
        }
        String satType = SatelliteRegistry.getSatelliteProperty(this.func_70301_a(0)).getSatelliteType();
        SatelliteBase sat = SatelliteRegistry.getNewSatellite(satType);
        return sat.isAcceptableControllerItemStack(this.func_70301_a(8));
    }

    public void assembleSatellite() {
        int powerStorage = 0;
        int powerGeneration = 0;
        int maxData = 0;
        float weight = 0.0f;
        String satType = SatelliteRegistry.getSatelliteProperty(this.func_70301_a(0)).getSatelliteType();
        SatelliteBase sat = SatelliteRegistry.getNewSatellite(satType);
        if (!this.field_145850_b.field_72995_K) {
            for (int currentSlotIndex = 1; currentSlotIndex <= 6; ++currentSlotIndex) {
                ItemStack stack = this.func_70301_a(currentSlotIndex);
                if (SatelliteRegistry.getSatelliteProperty(stack) != null) {
                    if (SatelliteRegistry.getSatelliteProperty(stack).getPropertyFlag() == SatelliteProperties.Property.BATTERY.getFlag()) {
                        powerStorage += SatelliteRegistry.getSatelliteProperty(this.func_70301_a(currentSlotIndex)).getPowerStorage();
                    }
                    if (SatelliteRegistry.getSatelliteProperty(stack).getPropertyFlag() == SatelliteProperties.Property.POWER_GEN.getFlag()) {
                        powerGeneration += SatelliteRegistry.getSatelliteProperty(this.func_70301_a(currentSlotIndex)).getPowerGeneration();
                    }
                    if (SatelliteRegistry.getSatelliteProperty(stack).getPropertyFlag() == SatelliteProperties.Property.DATA.getFlag()) {
                        maxData += SatelliteRegistry.getSatelliteProperty(this.func_70301_a(currentSlotIndex)).getMaxDataStorage();
                    }
                }
                weight += WeightEngine.INSTANCE.getWeight(stack);
            }
            SatelliteProperties properties = new SatelliteProperties(powerGeneration, powerStorage + 720, satType, maxData, weight);
            properties.setId(DimensionManager.getInstance().getNextSatelliteId());
            ItemSatellite satItem = (ItemSatellite)AdvancedRocketryItems.itemSatellite;
            ItemStack output = this.func_70301_a(11);
            satItem.setSatellite(output, properties);
            this.func_70299_a(11, ItemStack.field_190927_a);
            this.func_70299_a(8, sat.getControllerItemStack(this.func_70301_a(8), properties));
            this.func_70299_a(10, output);
        }
        this.completionTime = 100;
    }

    private boolean canCopy() {
        boolean chipsExist;
        ItemStack stack0 = this.func_70301_a(8);
        ItemStack stack1 = this.func_70301_a(9);
        this.func_70301_a(7);
        boolean bl = chipsExist = !stack0.func_190926_b() && !stack1.func_190926_b();
        if (!chipsExist) {
            return false;
        }
        boolean isSatellite = (stack0.func_77973_b() instanceof ItemSatellite || stack0.func_77973_b() instanceof ItemSatelliteIdentificationChip) && stack1.func_77973_b().equals(stack0.func_77973_b());
        boolean isStation = stack0.func_77973_b() instanceof ItemStationChip && ItemStationChip.getUUID(stack0) != 0 && stack1.func_77973_b() instanceof ItemStationChip;
        boolean isPlanet = stack0.func_77973_b() instanceof ItemPlanetIdentificationChip && stack1.func_77973_b() instanceof ItemPlanetIdentificationChip;
        boolean isOreScanner = stack0.func_77973_b() instanceof ItemOreScanner && stack1.func_77973_b() instanceof ItemOreScanner;
        return !(this.isRunning() || !this.func_70301_a(7).func_190926_b() || !isStation && !stack0.func_77942_o() || !isSatellite && !isStation && !isPlanet && !isOreScanner);
    }

    private void copyChip() {
        ItemStack slot0 = this.func_70301_a(8);
        ItemStack slot1 = this.func_70301_a(9);
        if (slot0.func_77973_b() instanceof ItemSatelliteIdentificationChip || slot0.func_77973_b() instanceof ItemOreScanner || slot0.func_77973_b() instanceof ItemPlanetIdentificationChip || slot0.func_77973_b() instanceof ItemStationChip) {
            this.func_70299_a(10, this.func_70301_a(8).func_77946_l());
        } else {
            ItemSatelliteIdentificationChip itemIdChip = (ItemSatelliteIdentificationChip)slot1.func_77973_b();
            itemIdChip.setSatellite(slot1, SatelliteRegistry.getSatelliteProperty(slot0));
            this.func_70299_a(10, slot1);
        }
        this.func_70298_a(9, 1);
        this.completionTime = 100;
        this.func_70296_d();
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        super.useNetworkData(player, side, id, nbt);
        this.onInventoryButtonPressed(id - 100);
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModulePower(18, 20, (IUniversalEnergy)this.getBatteries()));
        modules.add((ModuleBase)new ModuleTexturedLimitedSlotArray(152, 10, (IInventory)this, 0, 1, TextureResources.functionComponent));
        modules.add((ModuleBase)new ModuleTexturedLimitedSlotArray(116, 30, (IInventory)this, 1, 4, TextureResources.powercomponent));
        modules.add((ModuleBase)new ModuleTexturedLimitedSlotArray(116, 50, (IInventory)this, 4, 7, TextureResources.ioSlot));
        modules.add((ModuleBase)new ModuleTexturedLimitedSlotArray(38, 16, (IInventory)this, 11, 12, TextureResources.slotSatellite));
        modules.add((ModuleBase)new ModuleOutputSlotArray(58, 36, (IInventory)this, 7, 8));
        modules.add((ModuleBase)new ModuleTexturedSlotArray(58, 16, (IInventory)this, 8, 9, TextureResources.idChip));
        modules.add((ModuleBase)new ModuleTexturedSlotArray(82, 16, (IInventory)this, 9, 10, TextureResources.idChip));
        modules.add((ModuleBase)new ModuleProgress(75, 36, 0, new ProgressBarImage(217, 0, 17, 17, 234, 0, EnumFacing.DOWN, TextureResources.progressBars), (IProgressBar)this));
        modules.add((ModuleBase)new ModuleButton(40, 56, 0, "Build", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild));
        modules.add((ModuleBase)new ModuleButton(173, 3, 1, "", (IButtonInventory)this, TextureResources.buttonCopy, LibVulpes.proxy.getLocalizedString("msg.satbuilder.writesecondchip"), 24, 24));
        return modules;
    }

    public void onInventoryButtonPressed(int buttonId) {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(buttonId + 100)));
        }
        if (buttonId == 0) {
            if (this.canAssembleSatellite()) {
                this.assembleSatellite();
            }
        } else if (buttonId == 1 && this.canCopy()) {
            this.copyChip();
        }
    }

    public String getMachineName() {
        return AdvancedRocketryBlocks.blockSatelliteBuilder.func_149732_F();
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        if (slot < 7) {
            ItemStack chassis = this.func_70301_a(11);
            if (!chassis.func_190926_b() && chassis.func_77973_b() instanceof ItemSatellite) {
                EmbeddedInventory inv = ((ItemSatellite)chassis.func_77973_b()).readInvFromNBT(chassis);
                return inv.func_70301_a(slot);
            }
            return ItemStack.field_190927_a;
        }
        return this.inventory.func_70301_a(slot - 7);
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int amt) {
        if (slot < 7) {
            ItemStack chassis = this.func_70301_a(11);
            if (!chassis.func_190926_b() && chassis.func_77973_b() instanceof ItemSatellite) {
                EmbeddedInventory inv = ((ItemSatellite)chassis.func_77973_b()).readInvFromNBT(chassis);
                ItemStack stack = inv.func_70298_a(slot, amt);
                ((ItemSatellite)chassis.func_77973_b()).writeInvToNBT(chassis, inv);
                return stack;
            }
            return ItemStack.field_190927_a;
        }
        return this.inventory.func_70298_a(slot - 7, amt);
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        if (slot < 7) {
            ItemStack chassis = this.func_70301_a(11);
            if (!chassis.func_190926_b() && chassis.func_77973_b() instanceof ItemSatellite) {
                EmbeddedInventory inv = ((ItemSatellite)chassis.func_77973_b()).readInvFromNBT(chassis);
                inv.func_70299_a(slot, stack);
                ((ItemSatellite)chassis.func_77973_b()).writeInvToNBT(chassis, inv);
            }
            return;
        }
        this.inventory.func_70299_a(slot - 7, stack);
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_174818_b(this.field_174879_c) < 4192.0;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        if (slot < 7) {
            ItemStack chassis = this.func_70301_a(11);
            if (!chassis.func_190926_b() && chassis.func_77973_b() instanceof ItemSatellite) {
                EmbeddedInventory inv = ((ItemSatellite)chassis.func_77973_b()).readInvFromNBT(chassis);
                return inv.func_94041_b(slot, stack);
            }
            return false;
        }
        return this.inventory.func_94041_b(slot - 7, stack);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.inventory.writeToNBT(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventory.readFromNBT(nbt);
    }

    @Nullable
    public String func_70005_c_() {
        return null;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        if (index < 7) {
            ItemStack chassis = this.func_70301_a(11);
            if (!chassis.func_190926_b() && chassis.func_77973_b() instanceof ItemSatellite) {
                EmbeddedInventory inv = ((ItemSatellite)chassis.func_77973_b()).readInvFromNBT(chassis);
                ItemStack stack = inv.func_70304_b(index);
                ((ItemSatellite)chassis.func_77973_b()).writeInvToNBT(chassis, inv);
                return stack;
            }
            return ItemStack.field_190927_a;
        }
        return this.inventory.func_70304_b(index - 7);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }
}

